//
// C++ Interface: 
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFMYNETWORKWIDGET_H
#define KMFMYNETWORKWIDGET_H

#include "kmyfirewallmynetworkwidget.h"

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kprocess.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qguardedptr.h>
#include <quuid.h>
class KPopupMenu;
class QTextEdit;


namespace KMF {
class KMFHostWidget;
class KMFInterfaceWidget;
class KMFSystemSettingsLinux;
class KMFNetworkWidget;
class KMFNetZone;
class KMFNetwork;
class KMFTarget;
class KMFListViewItem;
class NetfilterObject;

class KMFMyNetworkWidget : public KMyFirewallMyNetworkWidget
{
  Q_OBJECT

public:
  KMFMyNetworkWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~KMFMyNetworkWidget();
  /*$PUBLIC_FUNCTIONS$*/
  void saveConfig();
	void setNetwork( KMFNetwork* );
  
public slots:
  /*$PUBLIC_SLOTS$*/
	void slotUpdateView();
	void slotUpdateView( NetfilterObject* );
signals:
	void sigActiveTargetChanged();

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
	void slotZoneRBM( QListViewItem*, const QPoint&, int );
	void slotNewItemSelected( QListViewItem* );
	void slotAddHost();
	void slotDelHost();
	void slotAddZone();
	void slotDelZone();
	void slotRenameItem( QListViewItem* item, int, const QString& name );
	void slotRenameZone();
	void slotRenameHost();
	void slotZoneChanged( KMFNetZone* );
	void slotTargetChanged();
	void slotSetActiveTarget();
	
	private:
		void setupPropertiesView();
		void loadIcons();
		KMFListViewItem* findItem( const QUuid& obj_id );
		
	private:
		KMFHostWidget *m_hostProperties;	
		KMFInterfaceWidget *m_hostInterfaces;	
		KMFSystemSettingsLinux *m_hostSettingsLinux;	
		
		QPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
		icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
		icon_target, icon_queue, icon_new, icon_copy, icon_move;
		
		
		// KMFNetZone *m_globalzone;
		// KMFTarget *m_localhost;
		
		QGuardedPtr<KMFNetwork> m_network;
		QGuardedPtr<KMFNetZone> m_zone;
		QGuardedPtr<KMFTarget> m_target;
		
		// QTextEdit* m_zone_desc;
		KMFNetworkWidget* m_network_widget; 
		// QWidget *ws_pageZoneProperties;
		KPopupMenu* m_contextMenu;
};
}
#endif

