//
// C++ Implementation: kmfrulesetdoc
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfrulesetdoc.h"


// QT includes
#include <qfile.h>
#include <qdom.h>


// KDE includes
#include <klocale.h>
#include <kdebug.h>

// Project Inclueds
#include "kmftarget.h"
#include "kmftargetconfig.h"
#include "kmfnetwork.h"
#include "kmfundoengine.h"
#include "kmferror.h"

namespace KMF {

KMFRulesetDoc::KMFRulesetDoc( KMFTarget* target )
{
	kdDebug() << "KMFRulesetDoc::KMFRulesetDoc( KMFTarget* target )" << endl;
	
	setTarget( target );
}


KMFRulesetDoc::~KMFRulesetDoc()
{
}

KMFTarget* KMFRulesetDoc::target() {
	return m_target;
}

void KMFRulesetDoc::setTarget( KMFTarget* target ) {
	m_target = target;
}

KMFNetwork* KMFRulesetDoc::network(){
	if ( ! m_target ) {
		kdDebug() << "ERROR: network() - target == 0 " <<  endl;
		return 0;
	}
	KMFNetwork *n = target()->network();
	if ( ! n ) {
		kdDebug() << "ERROR: network() - target()->network() == 0 " <<  endl;
		return 0;
	}
	return n;
}

KMFError* KMFRulesetDoc::createFirewallScript( const QString& fi ) {
	KMFError* m_err = new KMFError();
	QString file;
	file = fi;
	if ( file.isEmpty() ) {
		kdDebug() << "Cant open output file" << endl;
		m_err->setErrType( KMFError::NORMAL );
		const QString& msg = i18n( "Opening file for writing failed.\n"
		                           "Please make sure that you are logged in as root." );
		m_err->setErrMsg( msg );
		return m_err;

	}

	QFile f( file );
	f.remove();
	bool gotit = f.open( IO_ReadWrite );
	if ( ! gotit ) {
		m_err->setErrType( KMFError::NORMAL );
		const QString& msg = i18n( "Opening file for writing failed.\n"
		                           "Please make sure that you are logged in as root." );
		m_err->setErrMsg( msg );
		return m_err;
	}

	QTextStream ts( &f );
	QString s;
	kdDebug() << "########### start compiling ###########" << endl;
	ts << compile() << endl;
	kdDebug() << "########### Finished compiling ###########" << endl;
	f.flush();
	f.close();
	m_err->setErrType( KMFError::OK );
	const QString& msg = "";
	m_err->setErrMsg( msg );
	return m_err;
}

}
