/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/
#ifndef KMFKMFPROTOCOLLIBRARY_H
#define KMFKMFPROTOCOLLIBRARY_H

#include <qobject.h>
#include <qvaluelist.h>
#include <qstring.h>
#include <quuid.h>
#include <kurl.h>

namespace KMF {
class KMFError;
class KMFProtocol;
class KMFProtocolCategory;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/
class KMFProtocolLibrary : public QObject {
Q_OBJECT
/** Static Stuff **/
public:
	static KMFProtocolLibrary* instance();
	
private:
	static KMFProtocolLibrary* m_instance;
	
/** End Static stuff **/
public:
    ~KMFProtocolLibrary();


public: 
	// QPtrList<KMFProtocol>* protocolLibrary();
	KMFError* saveProtocolLibrary();
	void forceProtocolLibraryReload();
	void loadProtocolDefinitionsFromURL( const KURL&, KMFError* err );
	QValueList<KMFProtocolCategory*>& protocolCategories();
	QValueList<KMFProtocol*>& allProtocols();
	
	KMFProtocolCategory* findCategory( const QUuid& uuid );
 	KMFProtocol* findProtocolByName( const QString& name );
	KMFProtocol* findProtocolByUuid( const QUuid& uuid );
	KMFProtocol* findEquivalentProtocol( KMFProtocol* compare );

private: 
	QValueList< KMFProtocolCategory* > m_protocolCategories;
	QValueList< KMFProtocol* > m_protocols;


private: 
 	KMFProtocolLibrary( QObject* parent, const char* name );
	KMFProtocolLibrary();

	bool m_libraryLoaded;

};

}

#endif
