/***************************************************************************
 *   Copyright (C) 2004 by Spiros Georgaras                                *
 *   sngeorgaras@otenet.gr                                                 *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser Public License as published by   *
 *   the Free Software Foundation; either version 2.1 of the License, or   *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser Public License for more details.                           *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser Public License      *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KMHTMLARCHIVE_H
#define KMHTMLARCHIVE_H

#include "kmailconfig.h"

#include <kglobalsettings.h>
#include <qobject.h>
#include <qfile.h>
#include <qcstring.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextcodec.h>

class QDateTime;

//================================
class KmhtmlArchive: public QObject{
Q_OBJECT
public:
friend class KmhtmlEntry;
	//KmhtmlArchive();
	KmhtmlArchive(const QString &mhtArchive);
	~KmhtmlArchive();
	QString Type(){return type;};
	QString ContentType(){return contenttype;};
	bool open(int mode);
	long size(){return m_size;};
	void setFileName(const QString &fileName);
	void reset();
	QStringList entries(){return m_entries;};
	int status;
	//0	ok
	//1	input file open error
	//2	no boundary
	//3	no items
	//4	other
	//5	error extracting file
	//6	output file open error
	int count(){return outItems;};
	// file data return functions
	QString user()const {return m_user;};
	QString group()const {return m_group;};
	int date() const{return m_mtime;};
	QDateTime datetime() const;
	mode_t permissions() const{return m_permissions;};
	// message info
	QString Sender(){return mSender;};
	QString Recipient(){return mRecipient;};
	QString CopyTo(){return mCopyTo;};
	QString Subject(){return mSubject;};
	QString Date(){return mDate;};
	void setShowAttachments(bool showAtt){m_showAttachments=showAtt;};
	bool showAttachments(){return m_showAttachments;};
	void setShowInfo(bool showInfo){m_showInfo=showInfo;};
	bool showInfo(){return m_showInfo;};
signals:
	void archiveOpened();
	//void archiveCreated(QString warFileName);
	void errorAppeared(int errorNumber);
	//void fileExtraced(QString extractedFileName);
	void foundFilesInArchive(int numOfFiles);
private:
// 	int charsetCretiria;
// 	bool charsetCretiriaCalculated;
	bool readPartHeader(int it=-1);
	bool readItems();
	void fixFileName(const QByteArray &exC,int i);
	bool readItemsHeader(QCString* cont,int count=0);
	bool findLineEnd();
	void evalItemHeader(int id);
	QCString removeControlChars(const QCString &msg);
	QCString trim(const QCString &tmp);
	QString decodeRFC2047String(const QString &msg);
	QString decodeRFC2047Phrase(const QString &msg, bool removeLessGreater=TRUE);
	
	struct elm{
		uint start; // item start (header + data)
		uint end; // item end
		uint itStart; // data start
		uint encodedSize;
		uint decodedSize;
		
		QCString header;
		// these are read from the header
		QString contentLocation;
		QString contentID;
		QString contentDisposition;
		QString dispFileName;
		QString startPart;
		
		int encoding;
		//0	quoted printable
		//1	base64
		//2	uuencode
		//3	7-bit
		//4	8-bit
		QString charset;
		QString mimeType;
		QString base; // base URL
		// these are control fields
		bool hasExtension;
		bool fixed;
		bool isInvalid;
		int level;
		
		// these are the output fields
		QString name; // read from the file
		QString fixedName; // comes from name (calculated in fixFileName)
		QString alias; // name visible to the user
		QByteArray data;
	}*item;
	
	
	struct HEADER{
		uint start; // item start (header + data)
		uint end; // item end
		uint itStart; // data start
		QCString header;
		// these are read from the header
		QCString contenttype;
		QString contentLocation;
		QString type;
		QString charset;
		QCString boundary;
	}*partHeader;
	
	bool hasMarkup;
	bool isMarkupFromText;
	bool isEML;
	bool isSimple;
	QCString controlChars[3];
	QString type;
	QCString contenttype;
	QString mhtFileName;
	// This is the whole file (f)
	QCString f;
	QFile file;
	time_t m_mtime;
	QString m_user;
	QString m_group;
	long m_permissions;
	int items; // all the file in the mhtml file
	int outItems; // all the file in the mhtml file (after multipart/mixed fix)
	int parts; // all the mime parts in the mhtml file
	
	QStringList m_entries;
	long m_size;
	QCString header;
	int allocItems;
	bool isDOS;
	
	// message Info
	QString mSender;
	QString mRecipient;
	QString mCopyTo;
	QString mBlindCopyTo;
	QString mSubject;
	QString mDate;
	
	bool m_showInfo;
	bool m_showAttachments;
};

class KmhtmlEntry{
public:
	//KmhtmlEntry();
	KmhtmlEntry(KmhtmlArchive* arch,const QString &fileName);
	KmhtmlEntry(KmhtmlArchive* arch, int item);
	~KmhtmlEntry();
	
	bool exists(){return m_exists;};
	QString name(){return archive->item[it].alias;};
	QString originalName(){return archive->item[it].name;};
	QString mimeType(){return archive->item[it].mimeType;};
	QString contentID(){return archive->item[it].contentID;};
	QString contentLocation(){return archive->item[it].contentLocation;};
	QString charset(){return archive->item[it].charset;};
	QString baseURL(){return archive->item[it].base;};
	QString user()const {return archive->m_user;};
	QString group()const {return archive->m_group;};
	uint size(){return archive->item[it].decodedSize;};
	mode_t permissions() const{return archive->m_permissions;};
	int date() const{return archive->m_mtime;};
	int encoding(){return archive->item[it].encoding;}; 
	uint encodedSize(){return archive->item[it].encodedSize;};
	uint decodedSize(){return archive->item[it].decodedSize;};
	QString escapeString(const QString &str) const;
	QByteArray* data();
	QDateTime datetime() const;

private:
	KmhtmlArchive* archive;
	int it;
	QString fname;
	bool m_exists;
	bool findItemById();
	bool findItemByName();
	QString mailToHTML(const QString &msg);
	QString addressToHTML(const QString &msg);
	void calculateCharsetCretiria();
	QCString translateDate(QString mDate);
	QCString createEmlInfo();
	QString createEmlAttachments();
	QCString textForInfo(QString msg);
	QCString trForInfo(QString msg);
	int charsetCretiria;
	bool charsetCretiriaCalculated;
	struct GT_ELEMENTS{
		int start;
		int end;
		int level;
	}*gtEl;
	kmailConfig KC;
};
#endif
