//KMformat
//by Mickael Minarie
//this program is under GNU/GPL licence

/*! \file QFormatDLG.h
  \brief the dialog displaying
    
  This class is the main dialog
*/

#ifndef FINDDIALOG_H
#define FINDDIALOG_H

#include <QDialog>
#include "ListMountPoint.h"
#include "TstFileExist.h"

class QCheckBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QComboBox;
class QString;
class CDrive;
class QImage;

class KFormatDLG : public QDialog
{
  Q_OBJECT

    public:
  //!The constructor
  KFormatDLG (QString MPoint , bool floppy, QWidget *parent = 0);

  private slots:
  //!Execute CDrive::FullFormat() or CDrive::QuickFormat()
  void formatting();

  //!Display a window with help()
  void help();

  //!When the formatting is finished()
  void receivSig(int nb);

  //!When user change the vvalue of Combobox()
  void changeMP(int nb);	

  //!When user change the vvalue of Combobox()
  void changeMPs(int nb);

  //! Enter in What's This mode
  void EnterWThis();


 private:
  //all the things needed by the main dialog
  QLabel *labelTitle;
  QLabel *labelPix;
  QLabel *labelPix2;
  QLabel *label;
  QLabel *labelType;
  QLabel *labelfs;
  QLabel *labelVol;
  QLabel *labelSize;
  QLabel *labelFloppy;
  QComboBox *QWMountPoint;
  QLineEdit *leDiskLabel;
  QLineEdit *leDiskSize;
  QLineEdit *leTypeMedia;
  QComboBox *combofilesys;
  QComboBox *combosizefloppy;
  QCheckBox *FullFormatCheckBox;
  QCheckBox *CheckIntCheckBox;
  QPushButton *formatButton;
  QPushButton *closeButton;
  QPushButton *whatsThisButton;
  QPushButton *moreButton;
  QPushButton *helpButton;
  QWidget *extension;
  QPixmap *PixUnit;
  QPixmap *PixUnit2;
  QString DetectType(QString mountpoint);
  int DetectTypei(QString mountpoint);
  CDrive *drive;
  ListMountPoint lmp;
  TstFileExist tse;
  bool WarningTag;
  bool fl;
};

#endif
