/***************************************************************************
   faderwidget.h -  smoothly fades one widget to reveal a second
                    based on the Qt "Fade-Effects" demo; updated to use a 
                    QWidget source.

                             -------------------
    begin                : Wednesday 05 Jan 2011
    copyright            : (C) 2011 by Adam Goossens
    email                : adam.goossens@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FADERWIDGET_H
#define FADERWIDGET_H

#include <stdint.h>

#include <QWidget>
#include <QPixmap>
#include <QSize>

class QPaintEvent;
class QTimeLine;

/**
 * A Fader Widget will fade out one widget to reveal another.
 * 
 * It is (rather heavily) based on the Fade-Effects Qt demo, but updated to use
 * a QWidget source rather than a solid colour.
 * 
 * @author Adam Goossens (adam@kmess.org)
 */
class FaderWidget : public QWidget
{
  Q_OBJECT

  public:
    FaderWidget( QWidget *begin, QWidget *parent = 0 );

    void setDuration( uint16_t milliseconds );
    void start();
    void stop();

  protected:
    void paintEvent( QPaintEvent *event );
    
  private:
    QTimeLine *timeline_;
    QPixmap pixmap_;
};

#endif
