/***************************************************************************
                          passivepopup.cpp - KMess' Notification Popup
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "passivepopup.h"
#include "kdeversion.h"

#include <kdebug.h>



// Class constructor
PassivePopup::PassivePopup( QWidget *parent, PopupProperties props )
  : properties_(props)
{
  popup_ = new PassivePopupWidget( parent );
  viewWidget_ = new PassivePopupView( popup_, properties_.icon, properties_.message, properties_.status );

  popup_->setTimeout( properties_.timeout );

  popup_->setView( viewWidget_ );

  connect( popup_, SIGNAL( leftClicked()  ),
           this,     SLOT( leftClicked()  ) );
  connect( popup_, SIGNAL( rightClicked() ),
           this,     SLOT( rightClicked() ) );
  connect( popup_, SIGNAL( dying()        ),
           this,     SLOT( forwardDeath() ) );

}



// Change the popup's properties
bool PassivePopup::change( PopupProperties newProps )
{
  if( properties_.source != newProps.source )
  {
#ifdef KMESSDEBUG_PASSIVEPOPUP
    kdDebug() << "PassivePopup::change() - Tried to update a popup for " << newProps.source << ", but i'm made for " << properties_.source << "!" << endl;
#endif
    return false;
  }

  if( properties_.message != newProps.message )
  {
    properties_.message = newProps.message;
    viewWidget_->changeMessage( newProps.message );
  }
  if( properties_.icon != newProps.icon )
  {
    properties_.icon = newProps.icon;
    viewWidget_->changeIcon( newProps.icon );
  }
  if( properties_.status != newProps.status )
  {
    properties_.status = newProps.status;
    viewWidget_->changeStatusIcon( newProps.status );
  }


  return true;
}



// Obtain the current popup position
QPoint PassivePopup::getPosition()
{
  return popup_->pos();
}



// Display the popup
void PassivePopup::show()
{
  popup_->show();
#if KDE_IS_VERSION(3,5,0)
  popup_->setAnchor( properties_.position );
#endif
}



// Called when it's being destroyed, to remove the popup from the stack
void PassivePopup::forwardDeath()
{
  // Disconnect all signals which go from or to this object
  emit dying( properties_.source );

#ifdef KMESSDEBUG_PASSIVEPOPUP
  kdDebug() << "PassivePopup:forwardDeath() - killing popup for " << properties_.source << endl;
#endif
}



// Called when the popup gets left-clicked with the mouse; emits the activate() signal
void PassivePopup::leftClicked()
{
  emit activate( properties_.destMessages, properties_.destObject );

  popup_->hide();

#ifdef KMESSDEBUG_PASSIVEPOPUP
  kdDebug() << "PassivePopup::leftClicked() - activated popup for " << properties_.source << endl;
#endif
}



// Called when the popup gets right-clicked with the mouse; does no actions
void PassivePopup::rightClicked()
{
  popup_->hide();

#ifdef KMESSDEBUG_PASSIVEPOPUP
  kdDebug() << "PassivePopup::rightClicked() - hidden popup for " << properties_.source << endl;
#endif
}


#include "passivepopup.moc"
