/***************************************************************************
                          notificationmanager.h - manage the notifications
                            stack and updates them as needed
                             -------------------
    begin                : Thursday April 19 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTIFICATIONMANAGER_H
#define NOTIFICATIONMANAGER_H

#include <qdict.h>
#include "passivepopup.h"



/**
 * @brief Manages the notifications stack
 *
 * Notification balloons are handled as a vertical stack to avoid overlapping.
 *
 * @author Valerio Pilo <amroth@coldshock.net>
 */
class NotificationManager : public QObject
{
  Q_OBJECT

  public:  // Public methods
    // Class constructor
    NotificationManager();
    // Class destructor
    ~NotificationManager();

  public: // Public methods
    // Insert a new popup in the stack if needed, or change an existing one
    void                         notify( QObject *caller, PassivePopup::PopupProperties props );
    // Return the current tray widget object
    QWidget                     *getTrayWidget();
    // Set the tray widget object that will be used
    void                         setTrayWidget( QWidget *widget );

  public: // Public static methods
    // Return a singleton instance of the current account
    static NotificationManager  *instance();

  public slots:
    // Remove a timed out popup from the stack
    void                         remove( QString source );

  private: // Private static properties
    QDict<PassivePopup>           stack_;
    // The System Tray widget to which the popups will refer
    QWidget                      *trayWidget_;
    // The instance of the singleton manager
    static NotificationManager   *instance_;
};



#endif
