/***************************************************************************
                          notificationcontactonline.h -  notifies when a
                            contact goes online
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTIFICATIONCHAT_H
#define NOTIFICATIONCHAT_H

#include "passivepopup.h"
#include "notificationmanager.h"
#include "../chat/chatwindow.h"
#include "../chat/chatmessage.h"
#include "../contact/contactbase.h"



/**
  * @brief Notifies the user when a contact has sent him/her a message.
  *
  * Notification is made via a popup balloon and a sound (which can be customized)
  *
  * @author Valerio Pilo <amroth@coldshock.net>
  */
class NotificationChat : public QObject
{
  Q_OBJECT

  public:  // Public methods
    // Class constructor
    NotificationChat( NotificationManager* manager );
    // Enable or disable the chat notifications
    void                  setEnabled( bool enableChatStart, bool enableChatMessages );

  signals:
    // Start a chat with the contact who is calling us
    void                  startChat( QString contactHandle );
    // Raise an existing chat which received a message
    void                  raiseChat( ChatWindow *chatWindow, bool force );

  public slots:
    // Notify the user about this event (a contact has contacted the user)
    void                  notify( const ChatMessage &message, ChatWindow *chatWindow );

  private slots:
    // Trigger this event's action (Raise the chat window for the calling contact)
    void                  activate( QStringList stringList, QObject *object );

  private:  // Private properties
    // Notifications status for new chats
    bool                  enableChatStart_;
    // Notification status for subsequent chat messages
    bool                  enableChatMessages_;
    // The notification manager instance
    NotificationManager  *manager_;
    // The popup object which we'll be using until it disappears or gets clicked
    PassivePopup         *popup_;

};


#endif
