/***************************************************************************
                          p2pfragmenttracker.h -  description
                             -------------------
    begin                : Wed Dec 5 2007
    copyright            : (C) 2007 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef P2PFRAGMENTTRACKER_H
#define P2PFRAGMENTTRACKER_H

#include <qptrlist.h>
#include <kdebug.h>


/**
 * @brief  Utility class to track completed ranges of a transferred file.
 * @author Diederik van der Boor
 */
class P2PFragmentTracker
{
  public:
    // Constructor
                         P2PFragmentTracker();
    // Destructor
    virtual             ~P2PFragmentTracker();

    // Output for debugging
    QString              getDebugMap() const;
    // Return the message ID
    unsigned long        getMessageID() const;
    // Return the number of received bytwws
    unsigned long        getTransferredBytes() const;
    // Return whether the tracker is empty, no data added yet.
    bool                 isEmpty() const;
    // Return whether the tracker is initialized to receive a part for the given message ID.
    bool                 isInitialized( unsigned long messageID ) const;
    // Initialize to receive a new message
    void                 initialize( unsigned long messageID, unsigned long totalSize );
    // Return whether the fragment tracker is complete.
    bool                 isComplete();
    // Register the arrival of a new fragment.
    void                 registerFragment( unsigned long offset, unsigned long size );

  private:
    /**
     * Internal structure to track the byte ranges.
     */
    struct Range
    {
      unsigned long start;
      unsigned long end;
    };

    /// The identifier of the message being transferred
    unsigned long        messageID_;
    /// The total size of the message.
    unsigned long        totalSize_;
    /// The total number of bytes transferred.
    unsigned long        transferredBytes_;
    /// The list of transferred ranges.
    QPtrList<Range>      ranges_;
};


#endif
