/***************************************************************************
                          contactaction.cpp  -  description
                             -------------------
    begin                : Wed Jan 22 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactaction.h"

#include <kdebug.h>
#include <kpopupmenu.h>

#include "../contact/contact.h"
#include "../kmessdebug.h"

// The constructor
ContactAction::ContactAction(const Contact *contact, KPopupMenu *menu, QWidget *parent, const char *name )
 : KAction(parent,name),
   contact_(contact),
   inChat_(false),
   menu_(menu),
   plugged_(false)
{
#ifdef KMESSTEST
  ASSERT( menu_ != 0 );
  ASSERT( contact_ != 0 );
#endif
  // Connect the action to its own activated signal
  connect( this,     SIGNAL(           activated() ),
           this,     SLOT  (       slotActivated() ) );
  // Connect the contact
  connect( contact_, SIGNAL( changedFriendlyName() ),
           this,     SLOT  (          updateText() ) );
  connect( contact_, SIGNAL(       changedStatus() ),
           this,     SLOT  (    updateVisibility() ) );
  connect( contact_, SIGNAL(         changedList(Contact*) ),
           this,     SLOT  (    updateVisibility() ) );
  
  // Set default text and visibility
  updateText();
  updateVisibility();
}



// The destructor
ContactAction::~ContactAction()
{
}



// Return the contact's handle
const QString ContactAction::getHandle() const
{
  return contact_->getHandle();
}



// Set whether or not the contact is in the chat
void ContactAction::setInChat( bool inChat )
{
  inChat_ = inChat;
  updateVisibility();
}



//Inherit from KAction...
void ContactAction::slotActivated()
{
  emit activated( contact_->getHandle() );
}



// Update the text based on the contact's name
void ContactAction::updateText()
{
  setText( contact_->getFriendlyName() );
}



// Update the visibility of the action based on the contact's status, group, and list
void ContactAction::updateVisibility()
{
  bool  shouldBePlugged;

#ifdef KMESSDEBUG_CONTACTACTION
  kdDebug() << "ContactAction - Checking visibility for " << contact_->getHandle() << "." << endl;
#endif

  shouldBePlugged = ( ! inChat_ && contact_->isOnline() && contact_->isFriend() );

#ifdef KMESSDEBUG_CONTACTACTION
  kdDebug() << "ContactAction - Should be plugged = " << shouldBePlugged << "." << endl;
#endif

  // Plug the contact in if it should be plugged and it's not
  if ( shouldBePlugged && ! plugged_ )
  {
    plug( menu_ );
    plugged_ = true;
  }
  else if ( ! shouldBePlugged && plugged_ )
  { // Unplug the contact if it's plugged but shouldn't be
    unplug( menu_ );
    plugged_ = false;
  }
}

#include "contactaction.moc"
