/***************************************************************************
 *   Copyright (C) 2007 by xes                                             *
 *   xes@xesnet.fr                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mainWindow.h"

mainWindow::mainWindow ( QString confFileName, int num, QDialog *parent ) : QDialog ( parent )
{
	file = 0;
	fileWatch = 0;
	mouseX = -1;
	mouseY = -1;
	countBlink = 0;
	confPath = confFileName;
	eventEnable = false;

	//Initialisation de la fenetre
	setupUi ( this );
	installEventFilter ( this );
	connect ( this , SIGNAL ( rejected () ), SLOT ( this_rejected() ) );
	connect ( this , SIGNAL ( resize() ), SLOT ( this_resize() ) ) ;

	//Events
	timerBlink = new QTimer ( this );
	timerBlink->setInterval ( INTERVAL_BLINK );
	connect ( timerBlink, SIGNAL ( timeout() ), this, SLOT ( timerBlink_timeout() ) );

	//Chargement des proprietes de la fenetre
	numLog = num;
	loadConfig();
	setWindowTitle ( tr ( NAME_APP ) + " \"" + filePath + "\"" );

	file = new QFile ( filePath );
		
	//Verifie si le fichier existe et si il est accessible en lecture
	if ( !file->exists() || !fileWatch_fileChanged() )
		valid = false;
	else
	{
		valid = true;
		fileWatch = new QFileSystemWatcher ( );
		fileWatch->addPath ( filePath );
		connect ( fileWatch, SIGNAL ( fileChanged ( const QString & ) ), SLOT ( fileWatch_fileChanged () ) );
	}

	eventEnable = true;
}

mainWindow::~mainWindow ()
{
	delete fileWatch;
	delete file;
}

bool mainWindow::eventFilter ( QObject *obj, QEvent * event )
{
	if ( obj == this )
	{
		if ( event->type() == QEvent::Resize )
			emit resize();
		return ( false );
	}
	else
		return ( QObject::eventFilter ( obj, event ) );
}

void	mainWindow::mousePressEvent ( QMouseEvent *event )
{
	mouseX = event->x();
	mouseY = event->y();
}

void mainWindow::mouseReleaseEvent ( QMouseEvent *event )
{
	mouseX = -1;
	mouseY = -1;
}

void mainWindow::mouseMoveEvent ( QMouseEvent * event )
{
	QRect	rect;
	int		x;
	int		y;

	if ( ( mouseX != -1 ) && ( mouseY != -1 ) )
	{
		x = event->globalX() - mouseX;
		y = event->globalY() - mouseY;
		if ( x < 0 )
			x = 0;
		if ( y < 0 )
			y = 0;
		rect = geometry();
		rect.moveTo ( x , y );
		setGeometry ( rect );
	}
}

void	mainWindow::on_btnQuit_clicked()
{
	close();
}

void mainWindow::on_txtLog_textChanged ()
{
	txtLog->moveCursor ( QTextCursor::End );
}

void	mainWindow::loadConfig()
{
	QSettings	settings ( confPath, QSettings::IniFormat );

	//Titre de la fenetre
	filePath = settings.value ( LOG_FILE ( numLog ) ).toString();
	lblTitle->setText ( filePath + " ");

	//Parametres GENERAUX
	if ( !settings.value ( "decor", DEFAULT_DECOR ).toBool() )
		setWindowFlags ( Qt::FramelessWindowHint );
	if ( settings.value ( "select", DEFAULT_SELECT ).toBool() )
		txtLog->setTextInteractionFlags ( Qt::TextSelectableByMouse );
	if ( !settings.value ( "title", DEFAULT_TITLE ).toBool() )
	{
		lblTitle->setVisible(false);
		lblTitle1->setVisible(false);
		lblTitle2->setVisible(false);
		btnQuit->setVisible(false);
		delete(horizontalLayout);
	}
	if ( settings.value ( "scrollbar", DEFAULT_SCROLL ).toBool() )
		txtLog->setVerticalScrollBarPolicy ( Qt::ScrollBarAlwaysOn );
	eventWin = settings.value ( "eventWin", DEFAULT_ROOT ).toBool();
	countMax = ( settings.value ( "eventTime", DEFAULT_EVENTTIME ).toInt() * 1000 ) / INTERVAL_BLINK;
	setWindowOpacity ( ( double ) ( settings.value ( "opacity", DEFAULT_OPACITY ).toInt() ) / 100 );

	//Parametres de GEOMETRIE
	QRect	rect;
	rect.setX ( settings.value ( LOG_CONFIG ( numLog, "x" ), GEO_DEFAULT_X ).toInt() );
	rect.setY ( settings.value ( LOG_CONFIG ( numLog, "y" ), GEO_DEFAULT_Y ).toInt() );
	rect.setWidth ( settings.value ( LOG_CONFIG ( numLog, "width" ), GEO_DEFAULT_WIDTH ).toInt() );
	rect.setHeight ( settings.value ( LOG_CONFIG ( numLog, "height" ), GEO_DEFAULT_HEIGHT ).toInt() );

	setGeometry ( rect );

	//Parametres de COULEURS
	colorTextDefault = settings.value ( "textcolor", DEFAULT_TEXT_COLOR ).value<QColor>();

	QPalette palette = this->palette();

	palette.setColor ( QPalette::Window, colorBaseDefault );
	this->setPalette ( palette );

	palette = lblTitle->palette();
	palette.setColor ( QPalette::WindowText, colorTextDefault );
	lblTitle->setPalette ( palette );

	palette = txtLog->palette();
	palette.setColor ( QPalette::Text, colorTextDefault );
	txtLog->setPalette ( palette );

	palette = btnQuit->palette();
	palette.setColor ( QPalette::Button, colorBaseDefault );
	palette.setColor ( QPalette::ButtonText, colorTextDefault );
	
	btnQuit->setPalette ( palette );

	//Parametres de FONT
	txtLog->setCurrentFont ( settings.value ( "font", txtLog->font() ).value<QFont>() );
	lblTitle->setFont ( settings.value ( "font", txtLog->font() ).value<QFont>() );
	btnQuit->setFont ( settings.value ( "font", txtLog->font() ).value<QFont>() );
	
	//Force le titre en Bold et Italic
	QFont ft = lblTitle->font();
	ft.setBold(true);
	ft.setItalic(true);
	lblTitle->setFont(ft);
}

void mainWindow::saveConfig()
{
	QSettings	settings ( confPath, QSettings::IniFormat );

	QRect	rect = geometry();
	if ( settings.value ( LOG_FILE ( numLog ), NONE_VALUE ).toString() != NONE_VALUE )
	{
		settings.setValue ( LOG_CONFIG ( numLog, "x" ), rect.x() );
		settings.setValue ( LOG_CONFIG ( numLog, "y" ), rect.y() );
		settings.setValue ( LOG_CONFIG ( numLog, "width" ), rect.width() );
		settings.setValue ( LOG_CONFIG ( numLog, "height" ), rect.height() );
	}
}

bool mainWindow::fileWatch_fileChanged()
{
	QString temp;

	//Mettre a jour la zone de text
	if ( file->open ( QIODevice::ReadOnly | QIODevice::Text ) )
	{
		while ( !file->atEnd() )
		{
			char buf[1024];
			qint64 lineLength = file->readLine ( buf, sizeof ( buf ) );
			if ( lineLength != -1 )
				temp.append ( buf );
			else
				return ( false );
		}
		txtLog->setText ( temp );
		file->close();

		if ( eventWin && eventEnable )
			timerBlink->start();

		return ( true );
	}
	else
		return ( false );
}

void mainWindow::this_rejected()
{
	saveConfig();
}

void	mainWindow::this_resize()
{
	txtLog->moveCursor ( QTextCursor::End );
	make_gradient();
}

void	mainWindow::make_gradient(bool reverse)
{
	QSettings	settings ( confPath, QSettings::IniFormat );
	
	QPalette pal = palette();
	QLinearGradient gradient ( 1, 1, 1, geometry().height() );
	if (reverse == false)
	{
		gradient.setColorAt ( 0, settings.value ( "basecolor", DEFAULT_BACK_COLOR_TOP ).value<QColor>() );
		gradient.setColorAt ( 1, settings.value ( "basecolorGradient", DEFAULT_BACK_COLOR_BOTTOM ).value<QColor>() );
	}
	else
	{
		gradient.setColorAt ( 0, settings.value ( "basecolorGradient", DEFAULT_BACK_COLOR_BOTTOM ).value<QColor>() );
		gradient.setColorAt ( 1, settings.value ( "basecolor", DEFAULT_BACK_COLOR_TOP ).value<QColor>() );		
	}
	pal.setBrush ( QPalette::Window, QBrush ( gradient ) );
	setPalette ( pal );
}

bool mainWindow::isValid()
{
	return ( valid );
}

int mainWindow::getNum()
{
	return ( numLog );
}

QString mainWindow::getFilePath()
{
	return ( filePath );
}

void	mainWindow::timerBlink_timeout()
{
	if ( countBlink % 2 )
	{
		lblTitle1->setPixmap(QPixmap(IMG_TITLE1));
		lblTitle2->setPixmap(QPixmap(IMG_TITLE2));
	}
	else
	{
		lblTitle1->setPixmap(QPixmap(IMG_TITLE1_BIS));
		lblTitle2->setPixmap(QPixmap(IMG_TITLE2_BIS));
	}

	//Compteur
	if ( ++countBlink >= countMax )
	{
		countBlink = 0;
		timerBlink->stop();
	}
}
