/***************************************************************************
 *   Copyright (C) 2007 by xes                                             *
 *   pinon.pierre@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mainObj.h"

#include "klogshow.h"

mainObj::mainObj ( QString appFileName, QString confFileName, bool startByApp, QObject *parent ) : QObject ( parent )
{
	formconf = 0;
	confPath = confFileName;

	//Redemarre l'application en root si necessaire !
#ifdef UNIX
	if ( startByApp == false )
	{
		QSettings settings ( confPath, QSettings::IniFormat );
		if ( settings.value ( "root", DEFAULT_ROOT ).toBool() )
		{
			QStringList args;
			args << appFileName << "--" << PARAM_START_BY_APP << ( PARAM_CONF_FILENAME + confFileName );
			if ( QProcess::execute ( settings.value ( "appsu", DEFAULT_APPSU ).toString(), args ) )
			{
				QMessageBox::critical ( 0, settings.value ( "appsu", DEFAULT_APPSU ).toString(), tr ( "command not found !" ) );
			}
			else
				exit ( 1 );
		}
	}
#endif
	
	//Verification de la gestion du systray ...
	if ( !QSystemTrayIcon::isSystemTrayAvailable() )
	{
		QMessageBox::critical ( 0, tr ( "Systray" ), tr ( "I couldn't detect any system tray on this system." ) );
		exit ( 1 );
	}

	//Mise en place du systray
	systray = new QSystemTrayIcon ( QIcon ( ICON_APP ) );
	QMenu *menu = makeSystray();
	systray->setContextMenu ( menu );
	systray->show();

	//Lancement des fenetres de log
	startFormslog();
}

mainObj::~mainObj()
{
	delete systray;
	delete menu;
	delete formconf;
}

QWidgetAction*	mainObj::makeTitreMenu ( QString titre, QString icon, QWidget *parent )
{
	QFrame *titreFrame = new QFrame ( parent );
	titreFrame->setFrameStyle ( QFrame::Panel | QFrame::Raised );
	titreFrame->setLineWidth ( 1 );
	QLabel* titreIcon = new QLabel ( titreFrame );
	titreIcon->setPixmap ( QPixmap ( icon ) );
	QLabel *titreLabel = new QLabel ( titreFrame );
	QFont titreFont = titreLabel->font();
	titreFont.setBold ( true );
	titreLabel->setText ( titre );
	titreLabel->setFont ( titreFont );
	QHBoxLayout *titreHbox = new QHBoxLayout ( titreFrame );
	titreHbox->setMargin ( 3 );
	titreHbox->setSpacing ( 5 );
	titreHbox->insertWidget ( -1, titreIcon, 0 );
	titreHbox->insertWidget ( -1, titreLabel, 20 );
	QWidgetAction* titreAction = new QWidgetAction ( titreFrame );
	titreAction->setEnabled ( false );
	titreAction->setDefaultWidget ( titreFrame );
	return ( titreAction );
}

QMenu*	mainObj::makeSystray()
{
	menu = new QMenu ();

	//Titre du menu
	QWidgetAction* titreAction = makeTitreMenu ( tr ( NAME_APP ), ICON_APP, menu );
	menu->addAction ( titreAction );

	//Menu d'activation
	menuEnabled = new QMenu ( tr ( "&Log select" ), menu );
	menu->addMenu ( menuEnabled );

	//Bouton Configure
	menuConfig = new QAction ( tr ( "&Configure" ), menu );
	menu->addAction ( menuConfig );
	connect ( menuConfig, SIGNAL ( triggered() ), this, SLOT ( menuConfig_triggered() ) );

	menu->addSeparator();

	//Bouton About
	menuAbout = new QAction ( tr ( "&About" ), menu );
	menu->addAction ( menuAbout );
	connect ( menuAbout, SIGNAL ( triggered() ), this, SLOT ( menuAbout_triggered() ) );

	//Bouton AboutQt
	menuAboutQt = new QAction ( tr ( "About &Qt" ), menu );
	menu->addAction ( menuAboutQt );
	connect ( menuAboutQt, SIGNAL ( triggered() ), this, SLOT ( menuAboutQt_triggered() ) );

	menu->addSeparator();

	//Bouton Close
	menuQuit = new QAction ( tr ( "Clos&e" ), menu );
	menu->addAction ( menuQuit );
	connect ( menuQuit, SIGNAL ( triggered() ), this, SLOT ( menuQuit_triggered() ) );

	return ( menu );
}

bool mainObj::startFormlog ( mainWindow *form )
{
	int		num = form->getNum();
	QSettings	settings ( confPath, QSettings::IniFormat );

	if ( form->isValid() )
	{
		if ( settings.value ( LOG_CONFIG ( num, "activate" ), false ).toBool() )
		{
			form->show();
			return ( true );
		}
	}
	else
		activateCheck[num]->setEnabled ( false );

	return ( false );
}

void mainObj::startFormslog()
{
	menuEnabled->clear();
	nbrFormlog = 0;

	QWidgetAction* titreAction = makeTitreMenu ( tr ( "Log Files" ), ICON_APP, menuEnabled );
	menuEnabled->addAction ( titreAction );

	QSettings	settings ( confPath, QSettings::IniFormat );

	while ( 1 )
	{
		//Remplissage du menu d'activation
		QString	filelog = settings.value ( LOG_FILE ( nbrFormlog ), NONE_VALUE ).toString();
		if ( filelog == NONE_VALUE )
			break;
		activateCheck[nbrFormlog] = new QCheckBox ( settings.value ( LOG_FILE ( nbrFormlog ), NONE_VALUE ).toString(), menuEnabled );
		if ( settings.value ( LOG_CONFIG ( nbrFormlog, "activate" ), DEFAULT_ACTIVATE ).toBool() )
			activateCheck[nbrFormlog] ->setCheckState ( Qt::Checked );
		QWidgetAction	*activateAction = new QWidgetAction ( menuEnabled );
		activateAction->setDefaultWidget ( activateCheck[nbrFormlog] );
		menuEnabled->addAction ( activateAction );
		connect ( activateCheck[nbrFormlog], SIGNAL ( stateChanged ( int ) ), SLOT ( activateCheck_stateChanged() ) );

		//Lancement des fenetres de log
		formlog[nbrFormlog] = new mainWindow ( confPath, nbrFormlog );
		startFormlog ( formlog[nbrFormlog] );
		connect ( formlog[nbrFormlog], SIGNAL ( rejected() ), SLOT ( formlog_rejected() ) );

		nbrFormlog++;
	}
}

void mainObj::stopFormslog()
{
	for ( int num = 0; num < nbrFormlog; num++ )
	{
		formlog[num]->disconnect();
		formlog[num]->close();
		delete formlog[num];
	}
}

void	mainObj::menuConfig_triggered()
{
	//Lancement de la fenetre de log si elle n'est pas deja lancee
	if ( formconf != 0 )
		return;

	stopFormslog();

	formconf = new confWindow ( confPath );
	formconf->show();
	connect ( formconf , SIGNAL ( rejected () ), SLOT ( formconf_rejected() ) );
}

void	mainObj::menuAbout_triggered()
{
	QMessageBox::about ( 0, tr ( "About " ) + NAME_APP, ABOUT_TEXT );
}

void	mainObj::menuAboutQt_triggered()
{
	QMessageBox::aboutQt ( 0 );
}

void	mainObj::menuQuit_triggered()
{
	stopFormslog();
	exit ( 0 );
}

void mainObj::activateCheck_stateChanged()
{
	QCheckBox *c = qobject_cast<QCheckBox*> ( sender() );
	int	num;

	//Cherche le numero du log
	for ( num = 0; num < nbrFormlog; num++ )
		if ( c->text() == activateCheck[num]->text() )
			break;

	//Enregistrement dans le fichier de config
	QSettings settings ( confPath, QSettings::IniFormat );
	settings.setValue ( LOG_CONFIG ( num, "activate" ), ( c->checkState() == Qt::Checked ) );

	//Lancement ou fermeture des fenetres de log
	if ( c->checkState() == Qt::Checked )
		startFormlog ( formlog[num] );
	else
		formlog[num]->close();
}

void mainObj::formlog_rejected()
{
	mainWindow	*d = qobject_cast<mainWindow*> ( sender() );
	activateCheck[ d->getNum() ] ->setCheckState ( Qt::Unchecked );

	//Enregistrement dans le fichier de config
	QSettings settings ( confPath, QSettings::IniFormat );
	settings.setValue ( LOG_CONFIG ( d->getNum(), "activate" ), false );
}

void	mainObj::formconf_rejected()
{
	delete formconf;
	formconf = 0;

	startFormslog();
}

QString	mainObj::getConfPath()
{
	return confPath;
}
