/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@inwind.it                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GROUPLIST_H
#define GROUPLIST_H

#include "groupWidget.h"
#include <kiconloader.h>
#include <kpushbutton.h>
#include "newsgroup.h"
#include "globals.h"
#include <qstringlist.h>
#include "availablegroups.h"

struct Category {

	KListViewItem *listItem;
	uint childs; //Number of childs
	QString name; //Category name
	
};


class GroupList : public m_groupWidget
{
  Q_OBJECT

private:
   QDict<NewsGroup> groups;
   Db* groupDb;
   DbEnv* dbenv;
   QString dbPath;
   Servers *servers;
   
   QString groupsDbName;
   QDict<Category> categories;
   

   

public:
  enum Columns  {Name_Col=0, Unread_Col=1, Total_Col=2, Num_Col=3};
  GroupList(QString, DbEnv* , Servers*, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  GroupList(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~GroupList();
  Db* getGroupDb() {return groupDb;};
  void setDbEnv(DbEnv* dbe) {dbenv=dbe;};
  void loadGroups(DbEnv* dbe=0);
//   void closeGroups();
  void setDbPath(QString dbp) {dbPath=dbp;};
  void checkGroups();
  void enable(bool);
  void markAllGroupAsUpdating();
  void deleteGroup(NewsGroup*);
  void updateCurrent(NewsGroup *ng);
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
	void slotUpdateSelected();
	void slotUpdateSubscribed();
	void slotUpdateFinished(NewsGroup *);
	void slotAddGroup(Group*);
	void slotDeleteAllArticles(int);
	void slotGroupProperties();
	void slotModifyServerProperties(QStringList);
	void deleteAllArticles(NewsGroup*, int);
	void saveGroup(NewsGroup *ng);
	void slotAddCategory(QString);
	void slotRemoveCategory();
	uchar *getBinHeader(QString index, QString group);
	NewsGroup *getNg(QString group);
	void slotCompactDbs();
	void slotSaveSettings(NewsGroup*, bool, bool);
	void slotUpdateWOptions();
	void slotValidateGroup();

	
	
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
private slots:
	
	void slotExecuted(QListViewItem* item);
	void slotSelectionChanged();
	void slotGroupPopup(QListViewItem *, const QPoint&);
	void slotDeleteSelected();
	void slotZeroSelected();
	void slotNewGroup(QStringList, Group*);
	
signals:
	void openNewsGroup(NewsGroup*);
	void isSelected(bool);
	void updateNewsGroup(NewsGroup*, int);
	void popupMenu(const QPoint &);
	void popupCatMenu(const QPoint &);
	void activateNewsGroup(KMdiChildView*);
	void subscribed(Group *);
	void unsubscribe(QString);
	void sigHaveGroups(bool);
	void sigCloseView(KMdiChildView*);
	
	
	
			

};

#endif

