/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __FILEVIEWITEM_H
#define __FILEVIEWITEM_H

#include <qlistview.h>

class FileListView;
class SweepFileInfo;

class FileViewItem: public QCheckListItem
{
        protected:
		static const int ScoreW;
		static const int ScoreH;
		static const int ScoreTotalW;
		SweepFileInfo *finfo;
  		
		virtual void stateChange(bool);
        public:
                FileViewItem(FileListView *parent, SweepFileInfo *f);
		FileViewItem(FileViewItem *parent, SweepFileInfo *f);
                virtual ~FileViewItem();

		virtual void setColumns(int cols);
		SweepFileInfo* fileItem() const;
		
		virtual int compare(QListViewItem *i, int col, bool ascending) const;
		virtual int width(const QFontMetrics &fm, const QListView *lv, int c) const;
		virtual void paintCell(QPainter *p, const QColorGroup &cg, int col, int width, int align);
		virtual void paintFocus(QPainter *p, const QColorGroup &cg, const QRect &r);
};

#endif
