/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#include "hwlhandler.h"
#include "sendkey.h"
#include "hwlwidget.h"

HwlHandler::HwlHandler(sendKey * wire, QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	this->wire		= wire;
	this->topLayout		= new QHBoxLayout(this, 1);
	this->letterList	= new QPtrList<HwlWidget>();
	for (int i=0;i<=0;i++)
	{
		HwlWidget *letter	= new HwlWidget(this, "letter");
		this->topLayout->insertWidget(i, (QWidget*)letter, 0);
		this->letterList->append(letter);
	}
	this->topLayout->addStretch(10);
}


HwlHandler::~HwlHandler()
{
}


#include "hwlhandler.moc"
