/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kitten.h"
#include <kio/job.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kstandarddirs.h>

/*
	The kitten download module
*/

void Kitten::slotpercent (KIO::Job *, unsigned long prn) {
	state="downloading";
	percent=prn;
}

void Kitten::slotresult (KIO::Job *) {
	downloadfinished=1;
	state="downloaded";
	done=1;
}

/*
	Torrent mode
*/

void Kitten::downloaded(KProcess *pr) {
	done=1;
	state="downloaded";
}

void Kitten::stdout (KProcess *, char *buffer, int size)
{
	QString curline=QString::fromLocal8Bit(buffer, size);
	QStringList linesplits=QStringList::split("\n",curline,true);
	int counter=0;
	int tmppercent=0;
	for ( QStringList::Iterator it = linesplits.begin(); it != linesplits.end(); ++it ) {		
		curline=*it;
		if (*it==linesplits.first() ) {
			curline=inputcache+curline;
			inputcache="";
		} else if (*it==linesplits.last()) {
			inputcache=curline;
		} else {
			curline=curline.stripWhiteSpace();
			if (curline=="") { counter=0; } else { counter++; }
			if (counter==3)
			{
				QString attribute=curline.mid(curline.find(":")+1).stripWhiteSpace();
				if (attribute.find(".")>=0) {
					tmppercent=attribute.left(attribute.find(".")).toInt();
				} else {
					tmppercent=attribute.toInt();
				}
				if ((tmppercent>=percent) && (tmppercent<=100)) { percent=tmppercent; }
				if (percent>0) { state="downloading"; }
				if (percent==100) {
					done=1;
					state="downloaded";
					proc->kill();
				}
			}
		}
	}
}

QString stripProto(QString q) {
	if (q.left(7)=="file://") { q=q.mid(7); }
	return q;
}

void Kitten::cancel() {
	state="partial";
	done=1;
	if (mode=="torrent") {
		proc=0;
	}
	if (mode=="kio") {
		copyJob=0;
	}
}

Kitten::Kitten(KURL source,KURL destination,bool recover)
{
	percent=0;
	done=0;
	state="starting";
	downloadfinished=0;
	inputcache="";
	copyJob=0;
	proc=0;
	if (source.fileName().right(8)==".torrent") {
		/*
			is a bittorrent stuff?
		*/
		mode="torrent";
		/* is therethe bittorrent client? */
		QString pathexe;
		if (pathexe=KStandardDirs::findExe(kitty_globals::settings.bittorrent_client)) {
			proc = new KProcess;
			*proc << pathexe;
			*proc << "--save_as";
			*proc << stripProto(destination.url());
			*proc << source.url();
			connect(proc, SIGNAL(processExited(KProcess *)),
				this, SLOT(downloaded(KProcess *)));
			connect(proc,SIGNAL(receivedStdout (KProcess *, char *, int )),this,SLOT(stdout (KProcess *, char *, int )));
			proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);
		} else {
			
			done=1;
			percent=0;
			state="partial";
			KMessageBox::error(0,i18n("The Bittorrent client \"%1\" is missing or it can't be executed.\nPlease install the Bittorrent package.").arg(kitty_globals::settings.bittorrent_client));
		}
	} else {
		/*
			ok... try with kios!
		*/
		mode="kio";
		// @todo recover with kio is unknown... hwoto?
		recover=false;
		copyJob=new KIO::FileCopyJob(source,destination,-1,false,true,recover,false);
		connect(copyJob,SIGNAL(percent (KIO::Job *, unsigned long )),this,SLOT(slotpercent (KIO::Job *, unsigned long )));
		connect(copyJob,SIGNAL(result (KIO::Job *)),this,SLOT(slotresult (KIO::Job *)));
	}

}


Kitten::~Kitten()
{
}

int Kitten::getDone() {
	return done;
}

QString Kitten::getState() {
	return state;
}

int Kitten::getPercent() {
	return percent;
}



#include "kitten.moc"
