/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgethorloge.h"

#include <QtGui>

//50 secondes disponibles par dfaut
int WidgetHorloge::nb_sec=50;

WidgetHorloge::WidgetHorloge( QWidget *parent ) : QWidget( parent ) {
	subdivision = 50;	//nombre de subdivisions de la progress bar
	
	pbar = new QProgressBar( this );
	pbar->setRange( 0, subdivision );
	pbar->setValue( 0 );
	pbar->setTextVisible( false );	//pour ne pas afficher l'avancement en pourcentage
	
	pbar->setPalette( palette_orange );
	
	QHBoxLayout *hbLayout = new QHBoxLayout(this);
	hbLayout->setSpacing(0);
	hbLayout->setMargin(0);
	hbLayout->addWidget( pbar );
	
	timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(changeTemps()));
}

void WidgetHorloge::lance() {
	timer->start(1000*nb_sec/subdivision);
	unit_tps=0;
	pbar->setValue(unit_tps);
}

void WidgetHorloge::arrete() {
	timer->stop();
}

void WidgetHorloge::remise_a_zero() {
	pbar->setValue(0);
}

void WidgetHorloge::changeTemps() {
	unit_tps++;			//consommation d'une unit de temps
	pbar->setValue(unit_tps);
	
	//envoi d'un signal "Temps puis" lorsque le temps est coul
	if (unit_tps==subdivision) {
		timer->stop();
		emit TempsEpuise();
	}
}
