# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

class KitaHTMLPart < KDE::HTMLPart
  POPUP_WRITE_RES = 0
  POPUP_WRITE_RES_WITH_QUOTE = 1

  def set_view(view)
    @thread_view = view
  end

  def urlSelected(url, button, state, _target, args)
    if url[0..5] == "#write" then
      num = url[6..-1].to_i

      popup = KDE::PopupMenu.new
      popup.insertItem("Write Res", POPUP_WRITE_RES)
      popup.insertItem("Write Res with Quote", POPUP_WRITE_RES_WITH_QUOTE)

      case popup.exec(Qt::Cursor::pos())
      when POPUP_WRITE_RES
        @thread_view.show_write_dialog_with_str(">>" + num + "\n")
      when POPUP_WRITE_RES_WITH_QUOTE
        res = @thread_view.body(num)
        res = res.gsub(/(^|<br>)/, "\n> ")[1..-1]
        @thread_view.show_write_dialog_with_str(res)
      end
    else
      $app.invokeBrowser(url)
    end
  end
end
