/***************************************************************************
                          main.cpp  -  Mainapp
                             -------------------
    begin                : Son Dez 14 21:20:25 CET 2003
    copyright            : (C) 2003 by Stephan Gans
    email                : mephistoki@users.sourceforce.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kiso.h"
#include "dirops.h"

#include <stdlib.h>
#include <unistd.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kuniqueapplication.h>
#include <kapplication.h>

#include <qfile.h>
#include <qdir.h>

QString arg1;
QString arg2;

static const char *description =
	I18N_NOOP("KIso");

static KCmdLineOptions options[] =
{
  { "+File", I18N_NOOP("Open an image file"), 0 },
  { "virtualdrive [File .iso/.nrg]", I18N_NOOP("Mount a virtual drive"), 0 },
  { "delvirtualdrive [File .iso/.nrg]", I18N_NOOP("Unmount a virtual drive"), 0 },
  { "convert [File /.bin/.c2d/.cdi/.img/.mdf/.nrg]", I18N_NOOP("Convert an image"), 0 },
  { "information [File .iso/.nrg]", I18N_NOOP("Show image information"), 0 },
  { "hex [File]", I18N_NOOP("Open file in hexeditor"), 0 },
  { "make [Directory]", I18N_NOOP("Make an ISO image of a directory"), 0},
  { 0, 0, 0 }

};

int main(int argc, char *argv[])
{
  KAboutData aboutData( "kiso", I18N_NOOP("KIso"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2003-2005, Stephan Gans", 0, 0, "mephistoki@users.sourceforce.net");
  aboutData.addAuthor("Stephan Gans",0, "mephistoki@users.sourceforce.net");
   KCmdLineArgs::init( argc, argv, &aboutData );
   KCmdLineArgs::addCmdLineOptions( options );
   KUniqueApplication::addCmdLineOptions();
  
 //Verification that all necessary directorys exist
   QDir temp (QDir::homeDirPath() + "/.kisotmp");
  if ( !temp.exists() ) temp.mkdir( QDir::homeDirPath() + "/.kisotmp" );
  
  QDir iso (QDir::homeDirPath() + "/.kisotmp/");
  iso.mkdir( "ISO" );
  QDir mntpt (QDir::homeDirPath() + "/.kisotmp/");
  mntpt.mkdir( "Mount" );

  KUniqueApplication Kiso;
  KShellProcess *testmount = new KShellProcess();
  (*testmount)<< "sudo" << "/bin/mount" << "-o" << "loop*" << "-t" << "iso9660" << "Test.iso" << QDir::homeDirPath() + "/.kisotmp/Mount";
  testmount->start(KShellProcess::Block, KShellProcess::Stderr);
  if ( getuid() == 0 ){
    QString Status="No";
    QFile file( "/etc/sudoers" );
    if ( file.open( IO_ReadWrite ) ) {
     QTextStream stream( &file );
     QString entry;
     while ( !stream.atEnd() ) {
      entry = stream.readLine();
  if (entry=="ALL ALL=NOPASSWD:/bin/mount -o loop* -t iso9660* /home/*/.kisotmp/* ,/bin/umount /home/*/.kisotmp/*") Status="Yes";
  }
  if (Status=="No")stream << "ALL ALL=NOPASSWD:/bin/mount -o loop* -t iso9660* /home/*/.kisotmp/* ,/bin/umount /home/*/.kisotmp/*" << "\n";   
  }
  file.close(); 
  }

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  if (args->count()) arg1=args->arg(0);
  
  if (args->getOption("virtualdrive"))
  {
  
  arg2 = args->getOption("virtualdrive");
  QFileInfo virtfile( arg2 );
  QString virtname = virtfile.baseName();
  if (virtfile.exists()){
  QDir iso (QDir::homeDirPath() + "/.kisotmp/");
  iso.mkdir( virtname + ".kiso" );
  
  KShellProcess *mount = new KShellProcess();
    if (QFileInfo(virtfile).extension( false ).lower()=="iso") 
    (*mount)<< "sudo" << "/bin/mount" << "-o" << "loop" << "-t" << "iso9660" << "'" + arg2 + "'" << QDir::homeDirPath() + "/.kisotmp/" + virtname + ".kiso";
    if (QFileInfo(virtfile).extension( false ).lower()=="nrg") 
    (*mount)<< "sudo" << "/bin/mount" << "-o" << "loop,offset=307200" << "-t" << "iso9660" << "'" + arg2 + "'" << QDir::homeDirPath() + "/.kisotmp/" + virtname + ".kiso";
    mount->start(KShellProcess::Block, KShellProcess::Stderr);
    QFile file( QDir::homeDirPath() + "/Desktop/" + virtname + ".kiso" );
     if ( file.open( IO_WriteOnly ) ) {
     QTextStream stream( &file );
     stream << "[Desktop Entry]\n";
     stream << "Encoding=UTF-8\n";
     stream << "Icon=cdrom_unmount\n";
     stream << "Name=" + virtname + ".kiso\n";
     stream << "Type=Link\n";
     stream << "URL=$HOME/.kisotmp/" + virtname + ".kiso" + "\n";
     file.close();
    }
  }
  exit(0);
  }
  
  if (args->getOption("delvirtualdrive"))
  {
  arg2 = args->getOption("delvirtualdrive");
  QFileInfo virtfile( arg2 );
  QString virtname = virtfile.baseName();
  KShellProcess *rmdeskt = new KShellProcess();
    (*rmdeskt)<< "rm" << QDir::homeDirPath() + "/Desktop/" + virtname + ".kiso";
    rmdeskt->start(KShellProcess::Block);
    QDir uniso (QDir::homeDirPath() + "/.kisotmp/");
  KShellProcess *unmount = new KShellProcess();
    (*unmount)<< "sudo" << "/bin/umount" << QDir::homeDirPath() + "/.kisotmp/" + virtname + ".kiso";
    unmount->start(KShellProcess::Block, KShellProcess::Stderr);
  uniso.rmdir( virtname + ".kiso" );
  exit(0);
  }
  
  if (args->getOption("convert"))
  {
  arg2 = args->getOption("convert");
  if (QFileInfo(arg2).extension(false)=="CUE") arg2.replace("CUE","BIN");
  if (QFileInfo(arg2).extension(false)=="cue") arg2.replace("cue","bin");
  Convert(arg2,0);
  exit(0); 
  }
  if (args->getOption("information"))
  {
  arg2 = args->getOption("information");
  QString format=readoutheader(arg2, "format");
  QString systemid=readoutheader(arg2, "system");
  QString cdlabel = readoutheader(arg2, "label");
  QString publisher = readoutheader(arg2, "publish");
  QString preparer = readoutheader(arg2, "prepar");
  QString applicationid = readoutheader(arg2, "application");
  KMessageBox::information(0, i18n("Type: ") + format + "\n" + i18n("System Id: ") + systemid + "\n" + i18n("Volume Id: ") + cdlabel + "\n" + i18n("Publisher Id: ") + publisher + "\n" + i18n("Preparer Id: ") + preparer + "\n" + i18n("Application Id: " ) + applicationid ,i18n("Image information"));
  exit(0); 
  }
  
  if (args->getOption("hex"))
  {
  arg2 = args->getOption("hex");
  openhex(arg2);
  exit(0);
  }
  
  if (args->getOption("make"))
  {
  arg2 = args->getOption("make");
  CreateISO(QDir(arg2).absPath());
  exit(0);
  }
  
  if (!KUniqueApplication::start())
  exit(0);
  
if (testmount->exitStatus()!=1){
  Mainform *kiso = new Mainform(0,0,0,arg1);
  Kiso.setMainWidget(kiso);
  kiso->show();     
  return Kiso.exec();
  }
  KMessageBox::error(0, i18n("You have to start KIso as root first."),
    i18n("Setup"));
}
