#include <gtk/gtk.h>
#include <glib-object.h>

#include "kptraininglog.h"
#include "kipina-i18n.h"

#include "kpworkout.h"
#include "kpworkoutmodel.h"


GType
kp_workout_model_get_type ()
{
  static GType kp_workout_model_type = 0;

  if (!kp_workout_model_type) {
    static const GTypeInfo kp_workout_model_info = {
      sizeof (KPWorkoutModelIface),
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL
    };
    kp_workout_model_type = g_type_register_static (G_TYPE_INTERFACE,
                                                   "KPWorkoutModel",
                                                   &kp_workout_model_info,
                                                    0);
    g_type_interface_add_prerequisite (kp_workout_model_type, kp_workout_get_type ());
  }
  return kp_workout_model_type;
}


guint
kp_workout_model_get_duration (KPWorkoutModel *model)
{
  return KP_WORKOUT_MODEL_GET_CLASS (model)->get_duration (model);
}

gdouble
kp_workout_model_get_distance (KPWorkoutModel *model)
{
  return KP_WORKOUT_MODEL_GET_CLASS (model)->get_distance (model);
}

guint
kp_workout_model_get_pace (KPWorkoutModel *model)
{
  return KP_WORKOUT_MODEL_GET_CLASS (model)->get_pace (model);
}

gdouble
kp_workout_model_get_speed (KPWorkoutModel *model)
{
  return KP_WORKOUT_MODEL_GET_CLASS (model)->get_speed (model);
}


