#ifndef KP_RESULTS_H_
#define KP_RESULTS_H_

#include <libxml/tree.h>
#include <glib.h>
#include <glib-object.h>

#include "kpcalendarentry.h"

#define KP_TYPE_RESULTS (kp_results_get_type())
#define KP_RESULTS(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_RESULTS, KPResults))
#define KP_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_RESULTS, KPResultsClass))
#define KP_IS_RESULTS(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_RESULTS))
#define KP_IS_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_RESULTS))
#define KP_RESULTS_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_RESULTS, KPResultsClass))

typedef enum {
  KP_RESULT_TYPE_TIME,
  KP_RESULT_TYPE_RAW,
} KPResultType;

typedef enum {
  KP_RESULT_ORDER_ASC,
  KP_RESULT_ORDER_DESC,
} KPResultOrder;

typedef struct KPCompetitor_ {
  gchar         *name;
  gchar         *organization;
} KPCompetitor;

typedef struct KPResult_ {
  guint          result;
  KPCompetitor  *competitor;
  KPResultType   type;
  gchar         *comment;
} KPResult;

typedef struct KPResults_
{
  KPCalendarEntry    parent_instance;

  gchar             *name;
  gchar             *location;
  gchar             *unit;
  KPResultType       type;
  KPResultOrder      order;
  
  GList             *list;
} KPResults;

#define KP_RESULT(x) ((KPResult *) (x))

typedef struct KPResultsClass_ {
  KPCalendarEntryClass parent_class;

  /* Signals */
  void       (*result_added) (KPResults *, guint, KPResult *);
  void       (*result_removed) (KPResults *, guint, KPResult *);
} KPResultsClass;


GType             kp_results_get_type             (void);

KPResults        *kp_results_new                  (const gchar *name,
                                                   KPResultType type);
void              kp_results_set_title            (KPResults *res,
                                                   const gchar *name);
void              kp_results_set_location         (KPResults *res,
                                                   const gchar *location);
G_CONST_RETURN
gchar            *kp_results_get_title            (KPResults *res);
G_CONST_RETURN
gchar            *kp_results_get_location         (KPResults *res);

void              kp_results_add_competitor       (KPResults *res,
                                                   KPCompetitor *comp,
                                                   gint result);
void              kp_results_add_result           (KPResults *res,
                                                   KPResult *r);
void              kp_results_remove_result        (KPResults *res,
                                                   KPResult *r);
GList            *kp_results_get_list             (KPResults *res);
guint             kp_results_get_top_result       (KPResults *res);

void              kp_results_print                (KPResults *res);

KPResults        *kp_results_import               (xmlNodePtr ptr);
void              kp_results_export_as_xml        (KPResults *res,
                                                   xmlNodePtr parent);

#endif
