#ifndef KP_HTML_WRITER_H_
#define KP_HTML_WRITER_H_

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>

#include "../kplogstat.h"
#include "../kpcalendarentry.h"
#include "../kptraininglog.h"

typedef enum {
  KP_HTML_WRITER_FLAG_DAY_ENTRIES,
  KP_HTML_WRITER_FLAG_N
} KPHtmlWriterFlags;

#define KP_HTML_WRITER_ERROR  kp_html_writer_error_quark()

#define KP_TYPE_HTML_WRITER (kp_html_writer_get_type())
#define KP_HTML_WRITER(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_HTML_WRITER, KPHtmlWriter))
#define KP_HTML_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_HTML_WRITER, KPHtmlWriterClass))
#define KP_IS_HTML_WRITER(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_HTML_WRITER))
#define KP_IS_HTML_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_HTML_WRITER))
#define KP_HTML_WRITER_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_HTML_WRITER, KPHtmlWriterClass))

typedef struct KPHtmlWriter_
{
  KPCalendarEntry   parent_instance;

  gboolean          items[KP_HTML_WRITER_FLAG_N];

  gchar            *theme;
  KPLogStat        *stat;
  gchar            *dir;
  
  GString          *fnbuf;
  GString          *buf;

  KPTrainingLog    *log;
}
KPHtmlWriter;

typedef struct KPHtmlWriterClass_ {
  KPCalendarEntryClass parent_class;  
} KPHtmlWriterClass;

GQuark          kp_html_writer_error_quark          (void);
GType           kp_html_writer_get_type             (void);
KPHtmlWriter   *kp_html_writer_new                  (void);
gboolean        kp_html_writer_write                (KPHtmlWriter *writer,
                                                     KPTrainingLog *log, 
                                                     const gchar *dir,
                                                     GError **err);

GQuark          kp_html_writer_error_quark          (void);

FILE           *kp_html_writer_open                 (KPHtmlWriter *writer,
                                                     const gchar *file,
                                                     GError **error);
void            kp_html_writer_close                (FILE *fp);

#endif
