/*
 *  kipina.c
 *  (C) 2002,2003 Ville Kangas <ville@mirjami.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <locale.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <gconf/gconf.h>
#include <glade/glade.h>
#include <gtk/gtk.h>
#include "src/kipina-i18n.h"

#if HAS_LIBGNOME == 1
#include <libgnome/gnome-program.h>
#include <libgnome/libgnome.h>
#endif

#include "src/gui/kpentryviewmodel.h"
#include "src/gui/kpmainwindow.h"
#include "src/gui/kpguiutils.h"
#include "src/gui/kpcontexts.h"
#include "src/gui/kpentries.h"
#include "src/gui/kpgui.h"

#include "src/kpcalendarentry.h"
#include "src/kpsplitworkout.h"
#include "src/kppresetdata.h"
#include "src/kpsettings.h"
#include "src/kpworkout.h"
#include "src/kpresults.h"
#include "src/kpcomment.h"
#include "src/kpplugin.h"
#include "src/kputil.h"


#define MAX_CMD_LINE_LEN 15


/* Register these types to the system to be able to fetch
 * information about them */
static void
init_types (void)
{
  /* KPCalendarEntry derived types */
  (void) kp_entry_view_model_get_type ();

  g_object_unref (kp_split_workout_new ());
  g_object_unref (kp_comment_new (NULL, NULL));
  g_object_unref (kp_workout_new ());
  g_object_unref (kp_results_new (NULL, KP_RESULT_TYPE_TIME));
}


int
main (int argc, char **argv)
{
#if HAS_LIBGNOME == 1
  GnomeProgram *app;
#endif
  
  gchar *file = NULL;

  if (argc > 2) {
    fprintf (stderr, "Usage: ./%s [FILE]\n", argv[0]);
    return EXIT_FAILURE;
  }

  if (argc == 2)
    file = argv[1];

  bindtextdomain (GETTEXT_PACKAGE, KIPINA_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
  setlocale (LC_ALL, "");

  /* TODO: Fix gconf init without memory corruption */
  g_type_init ();

  kp_preset_data_init (NULL);
  kp_settings_init (NULL);
  
#ifdef BUILD_PLUGINS
  kp_plugin_scan (NULL);
#endif

  init_types ();
  /* KPContext must be inited after init_types ()*/
  kp_context_init ();
  kp_entries_init ();
  kp_conv_init ();

#if HAS_LIBGNOME == 1
  app = gnome_program_init (PACKAGE, VERSION, LIBGNOME_MODULE, 
                            argc, argv,  
                            GNOME_PARAM_APP_DATADIR, DESTDIR,
                            NULL); 
#endif

  kp_gui_init (&argc, &argv, file);
 
  return 0;
}

