/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include <qradiobutton.h>

#include "ksettingsgeneralwidget.h"


KSettingsGeneralWidget::KSettingsGeneralWidget(QWidget *parent, const char *name)
 : KSettingsGeneralWdgt(parent, name)
{
  connect(guessButton,SIGNAL(clicked()),this,SLOT(slotGuessKDEBaseClicked()));
  connect(selectPkgDirButton,SIGNAL(clicked()),this,SLOT(slotSelectStorageDirClicked()));
  connect(keepPackageCheckBox,SIGNAL(toggled(bool)),this,SLOT(slotKeepPackageToggled(bool)));
  connect(useCatCheckBox,SIGNAL(toggled(bool)),this,SLOT(slotUseCategoriesToggled(bool)));

  useCatCheckBox->hide();
  editCatButton->hide();
}


KSettingsGeneralWidget::~KSettingsGeneralWidget()
{
}


/*!
 */
void KSettingsGeneralWidget::setSettings(TInstallerSettings * settings)
{
  kdeDirEdit->setText(settings->KDEBase());
  pkgDirEdit->setText(settings->storageDir());
  keepPackageCheckBox->setChecked(settings->keepPackage());
  useCatCheckBox->setChecked(settings->useCategories());
}


/*!
 */
void KSettingsGeneralWidget::getSettings(TInstallerSettings * settings)
{
  settings->setKDEBase(kdeDirEdit->text());
  settings->setStorageDir(pkgDirEdit->text());
  settings->setKeepPackage(keepPackageCheckBox->isChecked());
  settings->setUseCategories(useCatCheckBox->isChecked());
}


/*!
 */
void KSettingsGeneralWidget::slotGuessKDEBaseClicked()
{
  QString str = kdeDirEdit->text();
  emit signalGuessKDEBaseClicked(str);
  kdeDirEdit->setText(str);
}


/*!
 */
void KSettingsGeneralWidget::slotSelectStorageDirClicked()
{
  QString str = pkgDirEdit->text();
  emit signalSelectStorageDirClicked(str);
  pkgDirEdit->setText(str);
}


/*!
 */
void KSettingsGeneralWidget::slotKeepPackageToggled(bool checked)
{
  useCatCheckBox->setEnabled(checked);
  slotUseCategoriesToggled(checked);
}


/*!
 */
void KSettingsGeneralWidget::slotUseCategoriesToggled(bool checked)
{
  bool tmp;
  
  
  if (checked && keepPackageCheckBox->isChecked() && useCatCheckBox->isChecked())
    tmp = true;
  else
    tmp = false;
  
  editCatButton->setEnabled(tmp);
}


#include "ksettingsgeneralwidget.moc"
