/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, http://www.stierand-linuxit.de   *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qcursor.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include <qradiobutton.h>

#include <kapp.h>
#include <klocale.h>

#include "kpkgtable.h"

#include "kinstallerview.h"



KInstallerView::KInstallerView(QWidget *parent)
    : KInstallerVw(parent)
{
  m_viewState = Ready;

  connect(sourceSelectButton,SIGNAL(clicked()),this,SLOT(slotSelectSourceClicked()));
  connect(installButton,SIGNAL(clicked()),this,SLOT(slotInstallClicked()));

  connect(deleteButton,SIGNAL(clicked()),this,SLOT(slotDeleteClicked()));
  connect(uninstallButton,SIGNAL(clicked()),this,SLOT(slotUninstallClicked()));

  connect(pkgTable,SIGNAL(selectedPackageChanged()),this,SLOT(slotSelectedPackageChanged()));
  
  slotSelectedPackageChanged();
}


KInstallerView::~KInstallerView()
{
}


/*!
 */
void KInstallerView::applySettings(TInstallerSettings * settings)
{
  bool tmp;
  
  
  if (settings->keepPackage() && settings->useCategories())
    tmp = true;
  else
    tmp = false;
  
  if (tmp)
    catGroupBox->show();
  else
    catGroupBox->hide();
}


QString KInstallerView::sourceURL()
{
  return(sourceEdit->text());
}


/*!
 */
void KInstallerView::setSourceURL(const QString & url)
{
  sourceEdit->setText(url);
}


/*!
 */
TPackageInfo * KInstallerView::uninstallPackage()
{
  return(pkgTable->selectedPackage());
}


/*!
 */
void KInstallerView::setUninstallPackage(TPackageInfo * package)
{
//  packageEdit->setText(name);
}


/*!
 */
bool KInstallerView::updatePackageInfos(TPackageInfoList * infoList)
{
  m_selectedInfo = 0;
  return(pkgTable->updatePackageInfos(infoList));
}


/*!
 */
TPackageInfo * KInstallerView::selectedPackageInfo()
{
  return(m_selectedInfo);
}



#define TEXT_INSTALL   i18n("Install")
#define TEXT_UNINSTALL i18n("Uninstall")
#define TEXT_CANCEL    i18n("Cancel")
#define TEXT_WAIT      i18n("Please wait ...")

/*!
 */
void KInstallerView::setViewState(KInstallerView::ViewState state)
{
  bool pkgEnabled;


  m_viewState = state;

  if (pkgTable->selectedPackage() == 0)
    pkgEnabled = false;
  else
    pkgEnabled = true;
  

  if (state == Ready)
  {
    unsetCursor();
    logEdit->unsetCursor();
    uninstallLogEdit->unsetCursor();
  }
  else
  {
    setCursor(QCursor(Qt::BusyCursor));
    logEdit->setCursor(QCursor(Qt::BusyCursor));
    uninstallLogEdit->setCursor(QCursor(Qt::BusyCursor));
  }

  if (state == Ready)
  {
    installButton->setText(TEXT_INSTALL);
    installButton->setEnabled(true);
    installFrame->setEnabled(true);
    uninstallFrame->setEnabled(true);
    uninstallButton->setText(TEXT_UNINSTALL);
    uninstallButton->setEnabled(pkgEnabled);
    deleteButton->setEnabled(pkgEnabled);
  }
  else if (state == Install)
  {
    installButton->setText(TEXT_CANCEL);
    installButton->setEnabled(true);
    installFrame->setEnabled(false);
    uninstallFrame->setEnabled(false);
    uninstallButton->setText(TEXT_UNINSTALL);
    uninstallButton->setEnabled(false);
    deleteButton->setEnabled(false);
  }
  else if (state == Uninstall)
  {
    installButton->setText(TEXT_INSTALL);
    installButton->setEnabled(false);
    installFrame->setEnabled(false);
    uninstallFrame->setEnabled(false);
    uninstallButton->setText(TEXT_CANCEL);
    uninstallButton->setEnabled(true);
    deleteButton->setEnabled(false);
  }
  else if (state == InstallCanceled)
  {
    installButton->setText(TEXT_WAIT);
    installButton->setEnabled(false);
    installFrame->setEnabled(false);
    uninstallFrame->setEnabled(false);
    uninstallButton->setText(TEXT_UNINSTALL);
    uninstallButton->setEnabled(false);
    deleteButton->setEnabled(false);
  }
  else if (state == UninstallCanceled)
  {
    installButton->setText(TEXT_INSTALL);
    installButton->setEnabled(false);
    installFrame->setEnabled(false);
    uninstallFrame->setEnabled(false);
    uninstallButton->setText(TEXT_WAIT);
    uninstallButton->setEnabled(false);
    deleteButton->setEnabled(false);
  }
}


/*!
 */
KInstallerView::ViewState KInstallerView::viewState()
{
  return(m_viewState);
}


/*!
 */
void KInstallerView::clearLogs()
{
  logEdit->setText("");
  uninstallLogEdit->setText("");
}


/*!
 */
void KInstallerView::appendInstallLog(const QString & text)
{
  logEdit->append(text);
}


/*!
 */
void KInstallerView::appendUninstallLog(const QString & text)
{
  uninstallLogEdit->append(text);
}


/*!
 */
void KInstallerView::slotSelectSourceClicked()
{
  emit signalSelectSourceClicked();
}


/*!
 */
void KInstallerView::slotSelectedPackageChanged()
{
  m_selectedInfo = pkgTable->selectedPackage();

  
  if (m_selectedInfo == 0)
  {
    packageLabel->setText(i18n("(no package selected)"));
  }
  else
  {
    packageLabel->setText(i18n("package: ")
        + m_selectedInfo->pkgName + "-" + m_selectedInfo->pkgVersion);
  }

  setViewState(m_viewState);
}


/*!
 */
void KInstallerView::slotInstallClicked()
{
  emit signalInstallClicked();
}


/*!
 */
void KInstallerView::slotDeleteClicked()
{
  emit signalDeleteClicked();
}


/*!
 */
void KInstallerView::slotUninstallClicked()
{
  emit signalUninstallClicked();
}


#include "kinstallerview.moc"
