/* $Id: we_protocols.c,v 1.1 2006/02/14 20:00:12 ekalin Exp $ */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gmodule.h>

#include "simocombobox.h"

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/


GtkWidget *
get_we_protocols_tab(GladeXML *gladexml)
{
  GtkWidget *panel;

  panel = glade_xml_get_widget(gladexml, "we_panel_protocols");

  return panel;
}


void
fill_we_protocols_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *rad;

  if (!world) {
    return;
  }

  if (world->mccp_behavior == MCCP_DISABLE) {
    rad = glade_xml_get_widget(gladexml, "radMCCPDisable");
  } else if (world->mccp_behavior == MCCP_ALWAYS) {
    rad = glade_xml_get_widget(gladexml, "radMCCPAlways");
  } else {
    rad = glade_xml_get_widget(gladexml, "radMCCPAfterConnect");
  }

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rad), TRUE);
}



void
update_we_protocols_parameters(World *world)
{
  GladeXML  *gladexml;
  GtkWidget *radMCCPAfterConnect;
  GtkWidget *radMCCPAlways;
  GtkWidget *radMCCPDisable;

  gladexml            = glade_get_widget_tree(world->dlgEditWorld);
  radMCCPAfterConnect = glade_xml_get_widget(gladexml, "radMCCPAfterConnect");
  radMCCPAlways       = glade_xml_get_widget(gladexml, "radMCCPAlways");
  radMCCPDisable      = glade_xml_get_widget(gladexml, "radMCCPDisable");

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radMCCPAfterConnect))) {
    world->mccp_behavior = MCCP_AFTER_CONNECT;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radMCCPAlways))) {
    world->mccp_behavior = MCCP_ALWAYS;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radMCCPDisable))) {
    world->mccp_behavior = MCCP_DISABLE;
  }
}
