/* $Id: log.c,v 1.12 2007/11/24 19:14:39 ekalin Exp $ */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <libintl.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "kildclient.h"
#include "perlscript.h"


/*************************
 * File global variables *
 *************************/


/***********************
 * Function prototypes *
 ***********************/



void
write_log_line(World *world, const char *line)
{
  int         len;
  static char timestr[MAX_TIME_STR];

  if (world->log_add_time) {
    time_t     currtime;
    struct tm *brokentime;

    currtime = time(NULL);
    brokentime = localtime(&currtime);
    strftime(timestr, MAX_TIME_STR,
             world->log_timeformat,
             brokentime);

    fprintf(world->log_file, "%s", timestr);
  }

  len = strlen(line);
  if (!len) {
    return;
  }

  fputs(line, world->log_file);

  /* Finish always with a NL character */
  if (line[len - 1] != '\n') {
    fputc('\n', world->log_file);
  }
}


gboolean
start_log(World *world, gchar **errmsg)
{
  time_t       curr_time;
  struct tm   *brokentime;
  static char  actualfile[PATH_MAX+1];
  static char  timestr[MAX_TIME_STR];

  if (!world->log_file_name) {
    *errmsg = g_strdup(_("File name not specified."));
    return FALSE;
  }

  /* Create file with possible date and time sequences. */
  time(&curr_time);
  brokentime = localtime(&curr_time);
  strftime(actualfile, PATH_MAX, world->log_file_name, brokentime);

  if ((world->log_file = fopen(actualfile, "a")) != NULL) {
    world->log_actual_file = g_strdup(actualfile);

    /* Use unbuffered output */
    setbuf(world->log_file, NULL);

    strcpy(timestr, ctime(&curr_time));
    /* Remove final nl */
    timestr[strlen(timestr) - 1] = '\0';
    fprintf(world->log_file, "*** LOG STARTED AT %s ***\n", timestr);

    return TRUE;
  } else {
    *errmsg = g_strdup(_("Could not open log file."));
    return FALSE;
  }
}


void
stop_log(World *world)
{
  time_t      curr_time;
  static char timestr[MAX_TIME_STR];

  if (world->log_file) {
    time(&curr_time);
    strcpy(timestr, ctime(&curr_time));
    /* Remove final nl */
    timestr[strlen(timestr) - 1] = '\0';
    fprintf(world->log_file, "\n*** LOG ENDED AT %s ***\n\n",
            timestr);
    fclose(world->log_file);
    world->log_file = NULL;
    g_free(world->log_actual_file);
    world->log_actual_file = NULL;
  }
}
