Name: kildclient
Version: 2.6.0
Release: 1aei
Summary: A powerful MUD client with a built-in Perl interpreter
Summary(pt_BR): Um poderoso cliente de MUD com um interpretador Perl embutido
License: GPL
Group: Games
Group(pt_BR): Jogos
Vendor: Eduardo M Kalinowski
URL: http://kildclient.sourceforge.net
Source: %{name}-%{version}.tar.gz
Packager: Alexandre Erwin Ittner <aittner@netuno.com.br>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: glib2 >= 2.10.0
Requires: gtk+2 >= 2.10.0
Requires: libglade2 >= 2.5.0
Requires: gtkspell >= 2.0.0
Requires: gnutls >= 1.0.0
Requires: perl >= 5.8.3
Requires: perl-gettext
BuildRequires: glib2-devel >= 2.10.0
BuildRequires: gtk+2-devel >= 2.10.0
BuildRequires: libglade2-devel >= 2.5.0
BuildRequires: gtkspell-devel >= 2.0.0
BuildRequires: gnutls-devel >= 1.0.0
BuildRequires: perl-devel >= 5.8.3
BuildRequires: gettext >= 0.14.5

%description
KildClient is a MUD Client written with the GTK+ windowing toolkit. It
supports many common features of other clients, such as triggers,
gags, aliases, macros, timers, and much more. But its main feature is
the built-in Perl interpreter. You can at any moment execute Perl
statements and functions to do things much more powerful than simply
sending text the the mud. Perl statements can also be run, for
example, as the action of a trigger, allowing you to do complex
things. Some built-in functions of KildClient allow interaction with
the world, such as sending commands to it.

KildClient's ANSI support is extensive: it supports not only the
common 16 colors, but also support underlined text (singly and
doubly), text in italics, text striked through, reverse video and
"hidden" text. It also supports vt100's line-drawing characters, and
xterm's escape sequences for a 256-color mode. All these features make
KildClient one of the clients with the most features for displaying
the mud output.

Kildclient supports the MCCP (Mud Client Compression Protocol)
protocol, versions 1 and 2, to reduce the necessary bandwidth.


%description -l pt_BR
KildClient  um cliente de MUD escrito com a biblioteca grfica GTK.
Ele suporta muitos recursos comuns aos outros clientes, como triggers,
gags, aliases, macros, temporizadores e muito mais. Mas seu principal
recurso  um interpretador Perl embutido. A qualquer momento, voc
pode executar declaraes Perl e funes para fazer coisas muito mais
poderosas que simplesmente enviar texto para o MUD. Declaraes Perl
podem tambm ser executadas, por exemplo, como ao de um trigger, lhe
permitindo fazer coisas mais complexas. Algumas funes nativas do
KildClient permitem interao com o mundo, como enviar comandos para
ele.

O suporte ANSI do KildClient  extenso: ele suporta no apenas as 16
cores comuns, mas tambm suporta texto sublinhado (simples e duplo),
texto em itlico, texto tachado, texto em vdeo reverso e texto
"escondido". Ele suporta os caracteres para desenho de linhas do
vt100, e as seqncias do xterm para um mode com 256 cores. Todos
esses recursos fazem o KildClient um dos cliente com mais recursos
para mostrar o texto do mud.

O KildClient suporta o protocolo MCCP (Mud Client Compression
Protocol, Protocolo de Compresso para Clientes de MUD), verses 1 e
2, para reduzir a banda necessria.

%prep
rm -rf %{buildroot}
%setup -q

%build
%configure
%{__make}

%install
%makeinstall

%clean
rm -rf %{buildroot}

%files
%defattr(-,root, root)
%{_bindir}/kildclient
%doc %{_datadir}/doc/%{name}/
%doc %{_mandir}/man1/kildclient.*
%{_datadir}/%{name}/*
%{_datadir}/locale/*/LC_MESSAGES/kildclient.mo


%changelog
* Wed Nov 28 2007 Eduardo M Kalinowski <ekalin@gmail.com>
- New version: 2.6.0.

* Mon May 21 2007 Eduardo M Kalinowski <ekalin@bol.com.br>
- New version: 2.5.1.

* Sat Aug 12 2006 Eduardo M Kalinowski <ekalin@bol.com.br>
- New version: 2.5.0.
- Requiring GTK+ version 2.8.X now.

* Sun Mar 26 2006 Eduardo M Kalinowski <ekalin@bol.com.br>
- New version: 2.4.1.

* Fri Feb 17 2006 Eduardo M Kalinowski <ekalin@bol.com.br>
- New version: 2.4.0.
- Added gtkspell requirement.

* Wed Dec 21 2005 Eduardo M Kalinowski <ekalin@bol.com.br)
- New version: 2.3.0.
- Added Requires and BuildRequires for libgnutls.
- Updated required version of gtk+ and libglade.

* Sat Oct 01 2005 Eduardo M Kalinowski <ekalin@bol.com.br)
- Updated version to 2.2.2.
- Removed intltool dependency.

* Tue Sep 20 2005 Eduardo M Kalinowski <ekalin@bol.com.br)
- Updated version to 2.2.1.

* Mon Sep 19 2005 Eduardo M Kalinowski <ekalin@bol.com.br)
- Updated version to 2.2.0.
- Changed the description to describe some new features.

* Thu Aug 25 2005 Eduardo M Kalinowski <ekalin@bol.com.br)
- Updated version to 2.1.0.

* Wed Jul 27 2005 Eduardo M Kalinowski <ekalin@bol.com.br)
- Updated version to 2.0.0.
- Removed dependency of libvte, which is not used anymore.

* Sun Jul 03 2005 Eduardo M Kalinowski <ekalin@bol.com.br>
- Updated version to 1.3.2.

* Tue May 31 2005 Eduardo M Kalinowski <ekalin@bol.com.br>
- Updated version to 1.3.1.
- Added a requirement for glib >= 2.6.0.

* Fri May 27 2005 Eduardo M Kalinowski <ekalin@bol.com.br>
- Updated for version 1.3.0 of the program.
- Added perl-gettext as a requirement.

* Wed Apr 20 2005 Eduardo M Kalinowski <ekalin@bol.com.br>
- Updated for version 1.2.0 of the program.
- Mentioned MCCP in the description.
- Added intltool to BuildRequires

* Fri Mar 25 2005 Eduardo M Kalinowski <ekalin@bol.com.br>
- Updated for version 1.1.2 of the program.

* Fri Mar 11 2005 Eduardo M Kalinowski <ekalin@bol.com.br>
- Updated for version 1.1.1 of the program.

* Mon Feb 28 2005 Eduardo M Kalinowski <ekalin@bol.com.br>
- Included man file in package

* Sun Feb 20 2005 Alexandre Erwin Ittner <aittner@netuno.com.br>
- New version: 1.1.0

* Thu Jan 13 2005 Alexandre Erwin Ittner <aittner@netuno.com.br>
- RPM for Conectiva 10 (but should work on any distro)
