/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QKIAXMAINWINDOW_H
#define QKIAXMAINWINDOW_H

#include <stdlib.h>

#include <qcombobox.h>
#include <qtabwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qdict.h>
#include <qaction.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qframe.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qpoint.h>
#include <qtooltip.h>
#include <qtextedit.h>
#include <qpopupmenu.h>
#include <qtranslator.h>
#include <qtextcodec.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qobject.h>
#include <qtooltip.h>
#include <qtoolbar.h>
#include <qmutex.h>
#include <qpopupmenu.h>
#include <qlayout.h>
#include <qframe.h>
#include "mainwindow.h"
#include "iaxwrapper.h"
#include "kiaxcalltab.h"
#include "kiaxprefs.h"
#include "kiaxprefswindow.h"
#include "kiaxaboutbox.h"
#include "kiaxcontactwindow.h"
#include "kiaxaddressbook.h"
#include "kiaxcontact.h"
#include "kiaxsystemtray.h"
#include "kiaxcallregister.h"
#include "kiaxlogwindow.h"
#include "kiaxaccountwizard.h"
#include "kiaxcontactlistitem.h"
#include "kiaxcallregisteritem.h"
#include "kiaxkeyfilter.h"
#include "qheader.h"

class KiaxRegistrationIndicator;

#include "kiaxregistrationindicator.h"

#define KIAX_VERSION "Kiax ver. 0.8.5 (Ariana)"

#ifndef ICONS_PATH
#define ICONS_PATH application->applicationDirPath()+"/icons/"
#endif

#ifndef I18N_DIRECTORY
#define I18N_DIRECTORY application->applicationDirPath()+"/i18n/"
#endif

class KiaxMainWindow : public KiaxMainWindowUi
{
  Q_OBJECT

public:
  KiaxMainWindow(QApplication* app, QWidget* parent, const char* name, WFlags fl, IaxWrapper* wrp);
  ~KiaxMainWindow();
  /*$PUBLIC_FUNCTIONS$*/
  void i18n();
  void i18n(QString localeStr);

public:
  IaxWrapper* wrapper;
  QLabel* statusIndicator;
  bool initOK;


public slots:
  
  /* GUI -> Wrapper */
    
  virtual void          fileConnectAction_activated();
  virtual void          fileDisconnectAction_activated();
  virtual void          dialButton_pressed();
  virtual void          callDialAction_activated(); // dial a number
  virtual void          answerButtonPressed(); // answer an incomming call when dialbutton pressed
  virtual void          hangupButtonPressed(); // interrupt call
  virtual void          digit0Pressed();
  virtual void          digit1Pressed();
  virtual void          digit2Pressed();
  virtual void          digit3Pressed();
  virtual void          digit4Pressed();
  virtual void          digit5Pressed();
  virtual void          digit6Pressed();
  virtual void          digit7Pressed();
  virtual void          digit8Pressed();
  virtual void          digit9Pressed();
  virtual void          digitPoundPressed(); 
  virtual void          digitStarPressed();
  virtual void          showStatistics(bool flag);
  virtual void		registerAccount(KiaxAccount* account);
  virtual void		unregisterAccount(KiaxAccount* account);

  /* Wrapper -> GUI */
  
  /* Client init, registration and destruction */
  virtual void          handleIaxWrapperEventRegistered();
  virtual void          handleIaxWrapperEventUnregistered();
  
  /* Events generated from Wrapper */
  virtual void          handleIaxWrapperEventCalling(int callNumber, QString status);
  virtual void          handleIaxWrapperEventAnsweredCall(int callNo);
  virtual void          handleIaxWrapperEventHoldCall(int callNo);
  virtual void          handleIaxWrapperEventResumedCall(int callNo);
  
  /* Audio and mic levels */
  virtual void          handleIaxWrapperEventLevels(int inValue, int outValue, int threshold);
  
  /* Call states */
  virtual void          handleIaxWrapperEventOutgoingRinging(int callNo);
  virtual void          handleIaxWrapperEventIncomingRinging(int callNo);
  virtual void          handleIaxWrapperEventComplete(int callNo);
  virtual void          handleIaxWrapperEventInactive(int callNo);
  virtual void          handleIaxWrapperEventRegistrationInactive(KiaxAccount* account);
  virtual void          handleIaxWrapperEventRegistrationConnecting(KiaxAccount* account);
  virtual void          handleIaxWrapperEventRegistrationRequested(KiaxAccount* account);
  virtual void          handleIaxWrapperEventRegistrationAccepted(KiaxAccount* account);
  virtual void          handleIaxWrapperEventRegistrationRejected(KiaxAccount* account);
  virtual void          handleIaxWrapperEventRegistrationTimeout(KiaxAccount* account);
  virtual void          updateCallDuration(int callNo, int hours, int minutes, int seconds);
  
  /* GUI -> GUI */
  virtual void          fileNewAccountAction_activated();
  virtual void          viewCall_RegisterAction_toggled(bool flag); // show/hide Call Register Tab
  virtual void          viewDialPadAction_toggled(bool flag); // show/hide Dial Tab
  virtual void          helpAboutAction_activated(); // show About Box
  virtual void          fileSettingsAction_activated(); // show the modal settings window
  virtual void          fileExitAction_activated(); // shutdown iaxclient and exit
  /* Contact List related*/
  virtual void          toolsAdd_ContactAction_activated(); // show a dialog to add user to 
  virtual void          contactsListBox_contextMenuRequested(QListViewItem* itm, const QPoint& location, int col);
  virtual void          contactListChangeAction_activated(); // change contact details using context menu
  virtual void          contactListDeleteAction_activated(); // delete contact using context menu
  virtual void          numberComboBox_textChanged(const QString& text); // enable/disable DialButton depending on the text in the combobox
  virtual void          contactsListBox_highlighted(QListViewItem* item); // enable DialButton to allow calling of the selected contact
  virtual void          callRegisterListBox_highlighted(int item); // enable DialButton to allow recalling of the selected record
  virtual void          numberComboBox_activated(const QString& dest); // dial when Enter pressed in numberComboBox
  virtual void          tabs_selected(const QString& newTab);
  
  virtual void          callRegisterAddUserAction_activated();
  virtual void          callRegisterListBox_contextMenuRequested(QListBoxItem* item,const QPoint& point);  
  virtual void          callRegisterCleanButton_pressed(); // delete call register entries
  virtual void          callRegisterCheckBox_toggled(bool status); // filter entries depending on the wished status
  virtual void          slotLogWindow(const char* logStr);
  virtual void          viewDialHangup_ButtonsAction_toggled(bool toggled);
  virtual void          viewAccountDial_CombosAction_toggled(bool toggled);
  virtual void          toolsLanguageBulgarianAction_activated();
  virtual void          toolsLanguageEnglishAction_activated();
  virtual void          toolsLanguageDeutschAction_activated();
  virtual void          toolsLanguageItalianoAction_activated();
  virtual void          toolsLanguageFrenchAction_activated();
  virtual void          toolsLanguagePortugueseAction_activated();
  virtual void          toolsLanguageMacedonianAction_activated();
  virtual void          toolsLanguagePolishAction_activated();
  virtual void          toolsLanguageHungarianAction_activated();
  virtual void          toolsLanguageSpanishAction_activated();
  virtual void          toolsLanguageCzechAction_activated();
  virtual void          toolsLanguageHebrewAction_activated();
  virtual void          toolsLanguageMalayAction_activated();
  virtual void          callHoldAction_activated();
  virtual void          callResumeAction_activated();
  virtual void          transferButton_pressed();
  virtual void          viewToolbarAction_toggled(bool flag);
  virtual void          updateAccounts();
  QString 			getIconsPath();

private:
  
  void setControls(); // set the widgets accoding to the state of the call
  void setControlsInitialState();
  void setControlsEnableDialing();
  void setControlsMaxCallsReached();
  void setControlsOutgoing();
  void setControlsIncoming();
  void digitPressed(char digit); // called by all digit buttons to send dtmf
  void addTab(int callNumber, QString callerStatus); // shows a call tab
  void removeTab(int &callNumber); // removes a calltab
  
  /* Define how call states disable and enable gui widgets */
  
  void setWidgetsRegistered(); // set widgets when user is REGISTERED
  void setWidgetsUnregistered(); // set widgets when user is UNREGISTERED
  
  /* Contact List and accounts related */ 
  void updateAccountsComboBox(QComboBox* comboBox); // insert available accounts in the accountsComboBox and select the default account
  void updateAccountsComboBox(QComboBox* comboBox, QString selectId); // insert available accounts in the accountsBox in the dialog for adding users and select contact's account
  void refreshContactsListBox(); // fills the contactListBox with entries from the addressBook
  void refreshCallRegisterListBox();  
  //void updateStatusMessage();
  void addRecordToCallRegisterListBox(KiaxCallRecord* record, int position);
  void addContactToContactsListBox(KiaxContact* contact, int position);
  KiaxContact * guessContact(QString remoteExtension);
  int getCallNumberFromActiveTab();
  
private:
  QApplication* application;
  QTranslator* appTranslator;
  QMap<int, KiaxCallTab*> callTabs;
  typedef QMap<QString, KiaxRegistrationIndicator*> RegistrationIndicatorsMap;
  typedef QMap<QString, KiaxContactListItem*> ContactListGroupsMap;
  RegistrationIndicatorsMap registrationIndicators;
  ContactListGroupsMap groups;
  QWidget* contactsPage;
  QWidget* dialpadPage;
  QWidget* callRegisterPage; 
  QWidget * currentPage; 
  QPopupMenu * contactListMenu;
  QPopupMenu * callRegisterMenu;
  KiaxAddressBook * addressBook;
  KiaxCallRegister * callRegister;
  KiaxSystemTray* systemTray;
  int registeredAccounts;
  bool docked;
  KiaxLogWindow * logWindow;
  QPixmap* holdPixmap;
  QPixmap* resumePixmap;
  QPixmap* dialPixmap;
  QPixmap* hangupPixmap;
  QMutex callTabsMutex;
  KiaxAccountWizard * accountWizard;
  QWidget * indicatorsFrame;
  QHBoxLayout* registrationIndicatorsContainer;

protected:

protected slots:

  void fatalError(QString errorMsg);  
    
};

#endif

