/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KIAXICONFACTORY_H
#define KIAXICONFACTORY_H
#include <qpixmap.h>
#include "kiaxaccount.h"
#include "kiaxcontact.h"

#ifndef  ICONS_PATH
#define ICONS_PATH "/usr/local/share/kiax/"
#endif

class KiaxIconFactory{

private:
    KiaxIconFactory();
    ~KiaxIconFactory();
    static void dimIcon(QPixmap& pixmap);
    static void crossIcon(QPixmap& pixmap);
    static void arrowIcon(QPixmap& pixmap);
    static void timeIcon(QPixmap& pixmap);

    static KiaxIconFactory* singleton;
    static QString iconsPath;

public:
    typedef enum KiaxIconType {CONTACT_ICON, GROUP_ICON, ACCOUNT_ICON, REGISTRATION_CONNECTING,
	REGISTRATION_REJECTED, REGISTRATION_ACCEPTED, REGISTRATION_TIMEOUT, REGISTRATION_INACTIVE};
    static QPixmap createIcon(KiaxIconType iconType, KiaxContact* contact);
    static QPixmap createIcon(KiaxIconType iconType, KiaxAccount* contact);
    static KiaxIconFactory* instance();
    static KiaxIconFactory* createInstance(QString pathName);
};

KiaxIconFactory* KiaxIconFactory::singleton = NULL;
QString KiaxIconFactory::iconsPath = QString(ICONS_PATH);

#endif
