/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "kiaxcalltab.h"

KiaxCallTab::KiaxCallTab(QWidget* parent, const char* name, WFlags fl, QString callerId, QString callerStatus)
: KiaxCallTabUi(parent,name,fl)
{
  setCallerId(callerId);
  setCallerStatus(callerStatus);
  this->micLevelIndicator->reset();
  this->audioLevelIndicator->reset();
  this->micLevelIndicator->setTotalSteps(100);
  this->audioLevelIndicator->setTotalSteps(100);
}

KiaxCallTab::~KiaxCallTab()
{
}

// Status: Calling, Ringing out, Ringing in, Active, Hangup
void KiaxCallTab::setCallerStatus(QString status) {
	this->callerStatus->setText(status);
}

void KiaxCallTab::setCallerId(QString callerId) {
	this->callerId->setText(callerId);
}

void KiaxCallTab::setMicLevel(int value, int threshold){
	micLevelIndicator->setProgress(micLevelIndicator->totalSteps()-value-threshold);
}

void KiaxCallTab::setAudioLevel(int value,int threshold ){
	audioLevelIndicator->setProgress(audioLevelIndicator->totalSteps()-value-threshold);
}

void KiaxCallTab::setCallNumber(int callNo) {
   callNumber = callNo;
}

int KiaxCallTab::getCallNumber() {
   return callNumber;
}
