/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kiaxaccount.h"

int KiaxAccount::nextAcc;

KiaxAccount::KiaxAccount(QString name)
    : QObject(0, (const char*)name)
{
  uint time = QDateTime::currentDateTime().toTime_t();
  if (!name) accId = QString::number(time) + QString::number(KiaxAccount::nextAcc);
  else accId = name;
  nextAcc++;
  accAlias = "Default";
  iaxServer = "";
  username = "";
  password = "";
  callerId = "Your Name";
  callerIdNumber = "12345678";
  codec = "gsm";
  registerAccount= true;
  accIcon = "contact.png";
}


KiaxAccount::~KiaxAccount()
{
}


void KiaxAccount::setKeys(QSettings * settings) {

  // address the account - a new
  accName = "/kiax/accounts/"+accId+"/";
  
  // set storage keys
  settings->setPath("kiax.org","kiax", QSettings::User);// userspace
  accAliasKey = accName+"alias";
  accServer = accName+"server";
  accUsername = accName+"username";
  accPassword = accName+"password";
  accCallerId = accName+"callerId";
  accCallerIdNumber = accName+"callerIdNumber";
  accCodec = accName+"codec";
  accRegisterAccount = accName+"registerAccount";
}

bool KiaxAccount::save()
{
  QSettings* settings = new QSettings();
  bool result = true;
  setKeys(settings);
  
  result &= settings->writeEntry(accAliasKey, accAlias);
  result &= settings->writeEntry(accServer, iaxServer);
  result &= settings->writeEntry(accUsername,username);
  result &= settings->writeEntry(accPassword,password);
  result &= settings->writeEntry(accCallerId,callerId);
  result &= settings->writeEntry(accCallerIdNumber,callerIdNumber);
  result &= settings->writeEntry(accCodec,codec);
  result &= settings->writeEntry(accRegisterAccount,registerAccount);
  
  delete settings;
  
  return result;
  
}

bool KiaxAccount::load()
{
  QSettings* settings = new QSettings();
  setKeys(settings);
  
  // default values;
  QString defServer="";
  QString defUsername="";
  QString defPassword="";
  QString defCallerId="";
  QString defCallerIdNumber="";
  QString defCodec="GSM";
  
  // read stored data
  accAlias = settings->readEntry(accAliasKey, "Default");
  iaxServer = settings->readEntry(accServer, defServer);
  username = settings->readEntry(accUsername, defUsername);
  password = settings->readEntry(accPassword, defPassword);
  callerId = settings->readEntry(accCallerId, defCallerId);
  callerIdNumber = settings->readEntry(accCallerIdNumber, defCallerIdNumber);
  codec = settings->readEntry(accCodec, defCodec);
  registerAccount = settings->readBoolEntry(accRegisterAccount, true);
  
  delete settings;
  
  return true;
  
}


void KiaxAccount::remove()
{
  QSettings* settings = new QSettings();
  setKeys(settings);
  
  settings->removeEntry(accAliasKey);
  settings->removeEntry(accServer);
  settings->removeEntry(accUsername);
  settings->removeEntry(accPassword);
  settings->removeEntry(accCallerId);
  settings->removeEntry(accCallerIdNumber);
  settings->removeEntry(accCodec);
  settings->removeEntry(accRegisterAccount);
  
  delete settings;
}

void KiaxAccount::setState(int state) {
   this->state = state;
   switch (state) {
	case ACCOUNT_INACTIVE : {
		emit signalRegistrationInactive(this);
		break;
	}
	case ACCOUNT_CONNECTING : {
		emit signalRegistrationConnecting(this);
		break;
	}
	case ACCOUNT_ACCEPTED : {
		emit signalRegistrationAccepted(this);
		break;
	}
	case ACCOUNT_REJECTED: {
		emit signalRegistrationRejected(this);
		break;
	}
	case ACCOUNT_TIMEOUT: {
		emit signalRegistrationTimeout(this);
		break;
	}
   }
}
