/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef CONTACTMENUBUTTONFILLER_H
#define CONTACTMENUBUTTONFILLER_H


// qt specific
#include <qstring.h>
// kde specific
#include <kabc/addressee.h>
// libs specific
#include <menubuttonfiller.h>

class StatusClientButtonProxy;

class ContactMenuButtonFiller : public MenuButtonFiller
{
public:
    ContactMenuButtonFiller( const KABC::Addressee C );
    virtual ~ContactMenuButtonFiller();

public: // MenuButtonFiller API
    // fills a menu button with pixmaps, tooltip and popupmenu
    virtual void fill( MenuButton *Button );
    // fills a menu button with pixmaps
    virtual void fillIcon( MenuButton *Button );

public:
    const KABC::Addressee &contact() const;
    MenuButton *button() const;

public:
    void updateImage();

protected:
    const KABC::Addressee Contact;
    MenuButton *Button;

    StatusClientButtonProxy *StatusProxy;
};

inline const KABC::Addressee &ContactMenuButtonFiller::contact() const { return Contact; }
inline MenuButton *ContactMenuButtonFiller::button() const { return Button; }

#endif
