/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// lib specific
#include "card.h"


namespace Khalkhi {

void Card::initiate()
{
    Data = QString::fromLatin1(
      "<html><body>"
      "<div align=\"center\">"
        "<table cellpadding=\"1\" cellspacing=\"0\">" );
}


void Card::finalize()
{
    Data += QString::fromLatin1(
        "</table>"
      "</div>"
      "</body></html>" );
}


void Card::appendHeader( const QString &ImageURL, const QString &RealName,
                                const QString &Role, const QString &Organization )
{
    const QString TableHeadTemplate = QString::fromLatin1(
        "<tr>"
          "<td align=\"right\" valign=\"top\">"
            "<img src=\"%1\" width=\"50\">"
          "</td>"
          "<td align=\"left\" valign=\"top\">"
            "<font size=\"+1\"><b>%2</b></font>%3"
          "</td>"
        "</tr>"
        "<tr><td>&nbsp;</td><td>&nbsp;</td></tr>" );
    const QString Break = QString::fromLatin1( "<br>" );
    QString RO;
    if( !Role.isEmpty() )
        RO += Break + Role;
    if( !Organization.isEmpty() )
        RO += Break + Organization;

    Data.append( TableHeadTemplate.arg(ImageURL,RealName,RO) );
}


void Card::appendItem( const QString &Name, const QString &Entry, const QString &Status )
{
    const QString TableRowTemplate = QString::fromLatin1(
      "<tr>"
        "<td align=\"right\" valign=\"top\">"
          "<b>%1</b>"
        "</td>"
        "<td align=\"left\" valign=\"top\">"
          "%2"
        "</td>"
      "</tr>" );

    QString E = Status.isEmpty() ? Entry :
         QString::fromLatin1( "%1<br><font size=\"-1\">%2</font>" ).arg( Entry, Status );

    Data.append( TableRowTemplate.arg(Name,E) );
}

}
