/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qpopupmenu.h>
// khalkhi core
#include <services.h>
#include <propertyadapter.h>
// lib specific
#include "propertyalldataactionservicemenufiller.h"

namespace Khalkhi {


PropertyAllDataActionServiceMenuFiller::PropertyAllDataActionServiceMenuFiller():Menu( 0 ) {}


void PropertyAllDataActionServiceMenuFiller::set( const KABC::Addressee& C, const QString &P, int I, QMimeSource *DS )
{
    Person = C; PropertyId = P; ItemIndex = I; DataSource = DS;
}

int PropertyAllDataActionServiceMenuFiller::itemIndex()     const              { return ItemIndex; }
QString PropertyAllDataActionServiceMenuFiller::propertyId() const             { return PropertyId; }
const KABC::Addressee& PropertyAllDataActionServiceMenuFiller::person() const { return Person; }
QMimeSource *PropertyAllDataActionServiceMenuFiller::dataSource() const        { return DataSource; }


void PropertyAllDataActionServiceMenuFiller::onAllDataActionServiceChange()
{ /*TODO: what to do? update menu*/}

void PropertyAllDataActionServiceMenuFiller::onDataActionServiceStateChange(
    const PropertyDataActionService &Service, int /*Change*/, int /*ItemIndex*/ )
{
    const QString &ServiceId = Service.id();

    // find menuid of action
    int MenuId = -1;
    int i = BaseMenuId;
    for ( QStringList::Iterator it = MenuServiceIds.begin(); it != MenuServiceIds.end(); ++it,++i )
        if( *it == ServiceId )
        {
            MenuId = i;
            break;
        }

    if( MenuId != -1 )
    {
        ServiceAction Action = Service.action( Person, ItemIndex, DataSource, 0 );

        QString Entry = Action.data( DisplayTextRole ).asString();
        QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
        bool Enabled = Action.data( EnabledRole ).asBool();

        Menu->changeItem( MenuId, IconSet, Entry );
        Menu->setItemEnabled( MenuId, Enabled );
    }
}


int PropertyAllDataActionServiceMenuFiller::fillMenu( QPopupMenu *M, int BMI )
{
    BaseMenuId = BMI;
    Menu = M;
    MenuServiceIds.clear();

    connect( Menu, SIGNAL(aboutToHide()), SLOT(onMenuDestruction()) );
    Services::self()->registerClient( this );

    PropertyManager *Manager = Services::self()->propertyManagers()[PropertyId];
    if( !Manager )
        return 0;

    const PropertyDataActionServiceList &Services = Manager->dataActionServices();

    int MenuId = 0;

    for( PropertyDataActionServiceList::ConstIterator ServiceIt = Services.begin(); ServiceIt != Services.end(); ++ServiceIt )
    {
        const PropertyDataActionService &Service = **ServiceIt;

        if( !Service.isAvailableFor(DataSource) )
            ;// TODO: 
        else if( Service.supports(DataSource,Person,ItemIndex) )
        {
            ServiceAction Action = Service.action( Person, ItemIndex, DataSource, 0 );

            QString Entry = Action.data( DisplayTextRole ).asString();
            QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
            bool Enabled = Action.data( EnabledRole ).asBool();

            Menu->insertItem( IconSet, Entry, this, SLOT(onMenuSelection(int)), 0, MenuId );
            if( !Enabled )
                Menu->setItemEnabled( MenuId, false );
            MenuServiceIds.append( Service.id() );
            ++MenuId;
        }
    }

    return MenuId - BaseMenuId;
}

void PropertyAllDataActionServiceMenuFiller::onMenuSelection( int MenuId )
{
    Services::self()->execute( Person, PropertyId, ItemIndex, MenuServiceIds[MenuId-BaseMenuId], DataSource );
}

void PropertyAllDataActionServiceMenuFiller::onMenuDestruction()
{
    Services::self()->unregisterClient( this );
}

PropertyAllDataActionServiceMenuFiller::~PropertyAllDataActionServiceMenuFiller() {}

}

#include "propertyalldataactionservicemenufiller.moc"
