/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qpopupmenu.h>
// khalkhi core
#include <services.h>
#include <propertyadapter.h>
#include <listpropertydataactionservice.h>
// lib specific
#include "listallpropertiesglobaldataactionservicemenufiller.h"

namespace Khalkhi {


const KABC::AddresseeList &ListAllPropertiesGlobalDataActionServiceMenuFiller::personList() const { return PersonList; }
QMimeSource *ListAllPropertiesGlobalDataActionServiceMenuFiller::dataSource() const        { return DataSource; }

void ListAllPropertiesGlobalDataActionServiceMenuFiller::onGlobalDataActionServiceSwitch( const QString &/*PropertyId*/ ) { /*TODO: what to do?*/}
void ListAllPropertiesGlobalDataActionServiceMenuFiller::onPropertyManagerChange() { /*TODO: what to do?*/}
#if 0
void ListAllPropertiesGlobalDataActionServiceMenuFiller::onDataActionServiceStateChange(
    const PropertyDataActionService &Service, int /*Change*/, int ItemIndex )
{
    const QString &ServiceId = ListService->id();

    int MaxItemIndex;
    if( ItemIndex == -1 )
    {
        ItemIndex = 0;
        MaxItemIndex = ListService->adapter()->numberOfItems( Person );
    }
    else
        MaxItemIndex = ItemIndex+1;

    for( ; ItemIndex<MaxItemIndex; ++ItemIndex )
    {
        // find menuid of action
        int Flags;
        int MenuId = IdActionMap.menuId( ListService->adapter()->id(), ItemIndex, ServiceId, &Flags );

        if( MenuId != -1 )
        {
            PropertyServiceAction Action = ListService->action( Person, ItemIndex, DataSource, Flags );

            QString Entry = Action.data( DisplayTextRole ).asString();
            QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
            bool Enabled = Action.data( EnabledRole ).asBool();

            Menu->changeItem( MenuId, IconSet, Entry );
            Menu->setItemEnabled( MenuId, Enabled );
        }
    }
}
#endif

int ListAllPropertiesGlobalDataActionServiceMenuFiller::fillMenu( QPopupMenu *M, int BaseMenuId )
{
    const PropertyManagerList &Managers = Services::self()->propertyManagers();

    Menu = M;
    connect( Menu, SIGNAL(aboutToHide()), SLOT(onMenuDestruction()) );
    Services::self()->registerClient( this );

    int MenuId = BaseMenuId;
    IdActionMap.prepare( Managers.size() );
    PropertyManagerList::ConstIterator ManagerIt = Managers.begin();
    for( ; ManagerIt != Managers.end(); ++ManagerIt )
    {
        const PropertyManager &Manager = **ManagerIt;

        const PropertyDataActionServiceList &Services = Manager.mainDataActionServices();
        if( Services.size() == 0 )
            continue;

        const PropertyAdapter *Adapter = Manager.propertyAdapter();
        if( !Adapter->haveProperty(PersonList) )
            continue;

        IdActionMap.addProperty( Adapter->id(), Services.size() );

        for( PropertyDataActionServiceList::ConstIterator ServiceIt = Services.begin(); ServiceIt != Services.end(); ++ServiceIt )
        {
            const ListPropertyDataActionService *ListService =
                ::qt_cast<ListPropertyDataActionService*>( *ServiceIt );
            if( !ListService )
                continue;

            if( !ListService->isAvailableFor(DataSource) )
                ;// TODO: 
            else
            {
                if( !ListService->supports(DataSource,PersonList) )
                    continue;

                const int Flags = PropertyService::Always;

                IdActionMap.addService( ListService->id(), 1 );

                IdActionMap.addItem( 0, MenuId, Flags );

                ServiceAction Action = ListService->action( PersonList, DataSource, Flags );

                QString Entry = Action.data( DisplayTextRole ).asString();
                QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
                bool Enabled = Action.data( EnabledRole ).asBool();

                Menu->insertItem( IconSet, Entry, this, SLOT(onMenuSelection(int)), 0, MenuId );
                if( !Enabled )
                    Menu->setItemEnabled( MenuId, false );
                ++MenuId;
            }
        }
    }

    return MenuId - BaseMenuId;
}


void ListAllPropertiesGlobalDataActionServiceMenuFiller::onMenuSelection( int Id )
{
    QString PropertyId;
    int ItemIndex;
    QString ServiceId;

    if( IdActionMap.remap(&PropertyId,&ItemIndex,&ServiceId, Id) )
        Services::self()->execute( PersonList, PropertyId, ServiceId, DataSource );
}


void ListAllPropertiesGlobalDataActionServiceMenuFiller::onMenuDestruction()
{
    Services::self()->unregisterClient( this );
}

ListAllPropertiesGlobalDataActionServiceMenuFiller::~ListAllPropertiesGlobalDataActionServiceMenuFiller() {}

}

#include "listallpropertiesglobaldataactionservicemenufiller.moc"
