/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qpopupmenu.h>
// khalkhi core
#include <services.h>
#include <propertyadapter.h>
#include <listpropertyactionservice.h>
// lib specific
#include "listallpropertiesglobalactionservicemenufiller.h"


namespace Khalkhi {

const KABC::AddresseeList &ListAllPropertiesGlobalActionServiceMenuFiller::personList() const { return PersonList; }

void ListAllPropertiesGlobalActionServiceMenuFiller::onGlobalActionServiceSwitch( const QString &/*PropertyId*/ ) { /*TODO: what to do?*/}
void ListAllPropertiesGlobalActionServiceMenuFiller::onPropertyManagerChange() { /*TODO: what to do?*/}
void ListAllPropertiesGlobalActionServiceMenuFiller::onActionServiceStateChange( const PropertyActionService &/*Service*/,
                                                                              int /*Change*/, int /*ItemIndex*/ )
{
#if 0
    const QString &ServiceId = Service.id();

    int MaxItemIndex;
    if( ItemIndex == -1 )
    {
        ItemIndex = 0;
        MaxItemIndex = Service.adapter()->numberOfItems( Person );
    }
    else
        MaxItemIndex = ItemIndex+1;

    for( ; ItemIndex<MaxItemIndex; ++ItemIndex )
    {
        // find menuid of action
        int Flags;
        int MenuId = IdActionMap.menuId( Service.adapter()->id(), ItemIndex, ServiceId, &Flags );

        if( MenuId != -1 )
        {
            // TODO: store (refer item) flag in IdActionMap
            ServiceAction Action = Service.action( Person, ItemIndex, Flags );

            QString Entry = Action.data( DisplayTextRole ).asString();
            QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
            bool Enabled = Action.data( EnabledRole ).asBool();

            Menu->changeItem( MenuId, IconSet, Entry );
            Menu->setItemEnabled( MenuId, Enabled );
        }
    }
#endif
}

int ListAllPropertiesGlobalActionServiceMenuFiller::fillMenu( QPopupMenu *M, int BaseMenuId )
{
    Menu = M;

    connect( Menu, SIGNAL(aboutToHide()), SLOT(onMenuDestruction()) );
    Services::self()->registerClient( this );

    const PropertyManagerList &Managers = Services::self()->propertyManagers();
    int MenuId = BaseMenuId;
    IdActionMap.prepare( Managers.size() );
    PropertyManagerList::ConstIterator ManagerIt = Managers.begin();
    for( ; ManagerIt != Managers.end(); ++ManagerIt )
    {
        const PropertyManager &Manager = **ManagerIt;

        const PropertyActionServiceList &Services = Manager.mainActionServices();
        if( Services.size() == 0 )
            continue;

        const PropertyAdapter *Adapter = Manager.propertyAdapter();
        if( !Adapter->haveProperty(PersonList) )
            continue;

        IdActionMap.addProperty( Adapter->id(), Services.size() );

        for( PropertyActionServiceList::ConstIterator ServiceIt = Services.begin(); ServiceIt != Services.end(); ++ServiceIt )
        {
            const ListPropertyActionService *ListService =
                ::qt_cast<ListPropertyActionService*>( *ServiceIt );
            if( !ListService )
                continue;

            if( !ListService->isAvailable() )
                ;// TODO: 
            else
            {
                if( !ListService->supports(PersonList) )
                    continue;

                const int Flags = PropertyService::Always;

                IdActionMap.addService( ListService->id(), 1 );

                // insert service action entries
                IdActionMap.addItem( 0, MenuId, Flags );

                ServiceAction Action = ListService->action( PersonList, Flags );

                QString Entry = Action.data( DisplayTextRole ).asString();
                QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
                bool Enabled = Action.data( EnabledRole ).asBool();

                Menu->insertItem( IconSet, Entry, this, SLOT(onMenuSelection(int)), 0, MenuId );
                if( !Enabled )
                    Menu->setItemEnabled( MenuId, false );
                ++MenuId;
            }
        }
    }

    return MenuId - BaseMenuId;
}


void ListAllPropertiesGlobalActionServiceMenuFiller::onMenuSelection( int MenuId )
{
    QString PropertyId;
    int ItemIndex;
    QString ServiceId;

    if( IdActionMap.remap(&PropertyId,&ItemIndex,&ServiceId, MenuId) )
        Services::self()->execute( PersonList, PropertyId, ServiceId );
}

void ListAllPropertiesGlobalActionServiceMenuFiller::onMenuDestruction()
{
    Menu = 0;
    Services::self()->unregisterClient( this );
}

ListAllPropertiesGlobalActionServiceMenuFiller::~ListAllPropertiesGlobalActionServiceMenuFiller() {}

}

#include "listallpropertiesglobalactionservicemenufiller.moc"
