/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef ACTIONSERVICEMENUFILLER_H
#define ACTIONSERVICEMENUFILLER_H


// qt specific
#include <qobject.h>
#include <qstringlist.h>
// kde specific
#include <kabc/addressee.h>
// khalkhi core
#include "actionserviceclient.h"

class QPopupMenu;


namespace Khalkhi {

class KDE_EXPORT ActionServiceMenuFiller : public QObject, public ActionServiceClient
{
    Q_OBJECT
public:
    ActionServiceMenuFiller();
    virtual ~ActionServiceMenuFiller();

public:
    void set( const KABC::Addressee &Person );
    void setContext( const char *Context );
public:
    int fillMenu( QPopupMenu *Menu, int BaseMenuId  );

public: // ActionServiceClient API
    virtual const KABC::Addressee &person() const;
    virtual void onActionServiceStateChange( const ActionService &Service, int Change );

protected slots:
    void onMenuSelection( int Id );
    void onMenuDestruction();

protected:
    QString Context;
    KABC::Addressee Person;

    QPopupMenu *Menu;
    int BaseMenuId;
    QStringList MenuServiceIds;
};

}

#endif
