/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// lib specific
#include "statusservice.h"


namespace Khalkhi {

StatusService::StatusService( QObject* Parent, const char* Name, const QStringList& Arguments )
 : Service( Parent, Name, Arguments )
{}


bool StatusService::isAvailable() const
{
    return true;
}


bool StatusService::isAvailableFor( const KABC::Addressee &Person ) const
{
    return supports(( Person )) && isAvailable();
}


bool StatusService::supports( const KABC::Addressee &/*Person*/ ) const
{
    return true;
}

bool StatusService::fitsIn( const QString &/*Context*/ ) const
{
    return true;
}

void StatusService::registerClient( StatusServiceClient* /*Client*/ ) {}
void StatusService::unregisterClient( StatusServiceClient* /*Client*/ ) {}

StatusService::~StatusService() {}

}

#include "statusservice.moc"
