/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef STATUSSERVICECLIENT_H
#define STATUSSERVICECLIENT_H


class QString;
namespace KABC { class Addressee; }


namespace Khalkhi {

class PropertyStatusService;
class Status;
class StatusChange;


class PropertyStatusServiceClient
{
public:
    PropertyStatusServiceClient();
    virtual ~PropertyStatusServiceClient();

public: // interface
    /** returns the person for which the services are requested */
    virtual const KABC::Addressee &person() const = 0;

public: // slots interface
    /** called if the service switched */
    virtual void onStateChange( const PropertyStatusService &Service, const StatusChange &Change,
                                const Status &NewStatus, int ItemIndex ) = 0;
    virtual void onPropertyManagerChange() = 0;
};


inline PropertyStatusServiceClient::PropertyStatusServiceClient() {}
inline PropertyStatusServiceClient::~PropertyStatusServiceClient() {}

typedef QValueList<PropertyStatusServiceClient*> PropertyStatusServiceClientList;

}

#endif
