/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// kde
#include <kabc/addresseelist.h>
// lib specific
#include "propertyadapter.h"


namespace Khalkhi {


PropertyAdapter::PropertyAdapter( QObject* /*Parent*/, const char* /*Name*/,
                                                       const QStringList& Arguments )
: Id( !Arguments.empty() ? Arguments[0] : QString::null ) {}

const QString &PropertyAdapter::id() const { return Id; }

bool PropertyAdapter::haveProperty( const KABC::AddresseeList &PersonList ) const
{
    bool Result = false;
    for( KABC::AddresseeList::ConstIterator it = PersonList.begin(); it != PersonList.end(); ++it )
        if( numberOfItems(*it) != 0 )
        {
            Result = true;
            break;
        }
    return Result;
}


PropertyAdapter::~PropertyAdapter() {}

}

#include "propertyadapter.moc"
