/*
    This file is part of the KDE project.
    Copyright (c) 2006-2007 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef KHALKHI_LISTDATAACTIONSERVICE_H
#define KHALKHI_LISTDATAACTIONSERVICE_H


// lib specific
#include "dataactionservice.h"

namespace KABC { class AddresseeList; }


namespace Khalkhi {

class ListDataActionServiceClient;


class KDE_EXPORT ListDataActionService : public DataActionService
{
    Q_OBJECT
public:
    ListDataActionService( QObject* Parent, const char* Name, const QStringList& Arguments );
    virtual ~ListDataActionService();

public: // interface
    virtual ServiceAction action( const KABC::AddresseeList &PersonList,
                                  QMimeSource *Data,  int Flags = NoFlags ) const = 0;
    using DataActionService::action;

    /** does the service */
    virtual void execute( const KABC::AddresseeList &PersonList, QMimeSource *Data ) = 0;
    using DataActionService::execute;

    /** @returns if the service is possible for the item; defaults to return true */
    virtual bool supports( QMimeSource *Data, const KABC::AddresseeList &PersonList ) const;
    using DataActionService::supports;

    /** @returns if the service is available currently for the item; defaults to return true */
    virtual bool isAvailableFor( QMimeSource *Data, const KABC::AddresseeList &PersonList ) const;
    using DataActionService::isAvailableFor;

    virtual void registerClient( ListDataActionServiceClient *Client );
    virtual void unregisterClient( ListDataActionServiceClient *Client );
    using DataActionService::registerClient;
    using DataActionService::unregisterClient;
};

}

#endif
