/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef UI_KGRUBEDITOR_H
#define UI_KGRUBEDITOR_H

//KDE
#include <kstatusbar.h>
#include <kaction.h>
#include <kmenu.h>
#include <kpagewidget.h>
#include <ktabwidget.h>

//Ui
#include "ui_mainwindow_entries.h"

#include "ui_mainwindow_general.h"
#include "ui_mainwindow_password.h"
#include "ui_mainwindow_background.h"
#include "ui_mainwindow_color.h"
#include "ui_mainwindow_map.h"

#include "ui_mainwindow_devices.h"

//KGRUBEditor
#include "grubcolorpreview.h"

class Ui_KGRUBEditor
{
public:
	Ui::mainwindow_entries ui_entries;

	Ui::mainwindow_general ui_general;
	Ui::mainwindow_password ui_password;
	Ui::mainwindow_background ui_background;
	Ui::mainwindow_color ui_color;
	Ui::mainwindow_map ui_map;

	Ui::mainwindow_devices ui_devices;
//GRUB Entries
	QWidget *entries;
//GRUB Settings
	QWidget *general;
	QWidget *password;
	QWidget *background;
	QWidget *color;
	QWidget *map;
		KPageWidget *settings;
//GRUB Device Naming
	QWidget *devices;
	KTabWidget *tabWidget;

	QMap<int, QString> colorMap;
	QLabel *label_status;
	QLabel *label_update;
	KAction *setDefaultAction;
	KAction *setFallbackAction;
		KMenu *menu_entry;

	void setupUi( KXmlGuiWindow *KGRUBEditor )
	{
		//background
		colorMap[0] = i18n( "Black" );
		colorMap[1] = i18n( "Blue" );
		colorMap[2] = i18n( "Green" );
		colorMap[3] = i18n( "Cyan" );
		colorMap[4] = i18n( "Red" );
		colorMap[5] = i18n( "Magenta" );
		colorMap[6] = i18n( "Brown" );
		colorMap[7] = i18n( "Light-Gray" );
		//foreground
		colorMap[8] = i18n( "Dark-Gray" );
		colorMap[9] = i18n( "Light-Blue" );
		colorMap[10] = i18n( "Light-Green" );
		colorMap[11] = i18n( "Light-Cyan" );
		colorMap[12] = i18n( "Light-Red" );
		colorMap[13] = i18n( "Light-Magenta" );
		colorMap[14] = i18n( "Yellow" );
		colorMap[15] = i18n( "White" );

		label_status = new QLabel;
		label_update = new QLabel;
		KGRUBEditor->statusBar()->addWidget( label_status, 1 );
		KGRUBEditor->statusBar()->addWidget( label_update, 0 );

		menu_entry = new KMenu;
//GRUB Entries
		entries = new QWidget;
		ui_entries.setupUi( entries );
//GRUB Settings
		general = new QWidget;
		ui_general.setupUi( general );

		password = new QWidget;
		ui_password.setupUi( password );
		ui_password.kpushbutton_create->setIcon( KIcon( "dialog-password" ) );
		ui_password.kpushbutton_edit->setIcon( KIcon( "document-properties" ) );
		ui_password.kpushbutton_delete->setIcon( KIcon( "edit-delete" ) );

		background = new QWidget;
		ui_background.setupUi( background );
		ui_background.kurlrequester_splash->lineEdit()->setReadOnly( true );
		ui_background.kpushbutton_create->setIcon( KIcon( "insert-image" ) );
		ui_background.kpushbutton_preview->setIcon( KIcon( "image-png" ) );
		ui_background.kpushbutton_clear_splash->setIcon( KIcon( "edit-clear-locationbar-ltr" ) );
		ui_background.kurlrequester_gfxmenu->lineEdit()->setReadOnly( true );
		ui_background.kpushbutton_clear_gfxmenu->setIcon( KIcon( "edit-clear-locationbar-ltr" ) );

		color = new QWidget;
		ui_color.setupUi( color );
		for ( int i = 0; i < 16; i++ )
		{
			if ( !( i >= 8 ) )
			{
				ui_color.comboBox_normalBackground->addItem( colorMap.value( i ) );
				ui_color.comboBox_highlightedBackground->addItem( colorMap.value( i ) );
			}
			ui_color.comboBox_normalForeground->addItem( colorMap.value( i ) );
			ui_color.comboBox_highlightedForeground->addItem( colorMap.value( i ) );
		}
		ui_color.comboBox_normalForeground->setCurrentIndex( 15 );
		ui_color.comboBox_highlightedForeground->setCurrentIndex( 15 );

		map = new QWidget;
		ui_map.setupUi( map );
		ui_map.kpushbutton_add->setIcon( KIcon( "list-add" ) );
		ui_map.kpushbutton_edit->setIcon( KIcon( "document-properties" ) );
		ui_map.kpushbutton_copy->setIcon( KIcon( "edit-copy" ) );
		ui_map.kpushbutton_remove->setIcon( KIcon( "list-remove" ) );

		settings = new KPageWidget;
		settings->addPage( general, i18n( "General" ) )->setIcon( KIcon( "preferences-other" ) );
		settings->addPage( password, i18n( "Password" ) )->setIcon( KIcon( "security-high" ) );
		settings->addPage( background, i18n( "Background" ) )->setIcon( KIcon( "preferences-desktop-wallpaper" ) );
		settings->addPage( color, i18n( "Color" ) )->setIcon( KIcon( "fill-color" ) );
		settings->addPage( map, i18n( "Maps" ) )->setIcon( KIcon( "drive-harddisk" ) );
//GRUB Device Naming
		devices = new QWidget;
		ui_devices.setupUi( devices );
		ui_devices.treeWidget_device->setColumnWidth( 0, 120 );
		ui_devices.treeWidget_device->setColumnWidth( 5, 300 );

		tabWidget = new KTabWidget;
		tabWidget->setTabPosition( QTabWidget::South );
		tabWidget->addTab( entries, i18n( "GRUB Entries" ) );
		tabWidget->addTab( settings, i18n( "GRUB Settings" ) );
		tabWidget->addTab( devices, i18n( "GRUB Device Naming" ) );
		KGRUBEditor->setCentralWidget( tabWidget );
	}
};

namespace Ui
{
    class KGRUBEditor : public Ui_KGRUBEditor {};
}

#endif
