/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "backup.h"

BackupAssistant::BackupAssistant( KUrl *source, KUrl *target, QWidget *parent ) : KAssistantDialog( parent )
{
//SETUP UI
	setCaption( i18n( "Backup Assistant" ) );
	setWindowIcon( KIcon( "document-save-all" ) );
	setAttribute( Qt::WA_DeleteOnClose );
	showButton( KDialog::Help, false );

	QWidget *intro = new QWidget;
	ui_intro.setupUi( intro );
	addPage( intro, i18n( "Introduction" ) );
	QWidget *step1 = new QWidget;
	ui_step1.setupUi( step1 );
	addPage( step1, i18n( "Step 1/2 - Source File" ) );
	QWidget *step2 = new QWidget;
	ui_step2.setupUi( step2 );
	addPage( step2, i18n( "Step 2/2 - Target File" ) );
	QWidget *summary = new QWidget;
	ui_summary.setupUi( summary );
	summaryPage = addPage( summary, i18n( "Summary" ) );
//PROPERTY SETUP
	m_source = source;
	m_target = target;
//SHOW MAP(IF ANY - ONLY USED IN EDIT MODE)
	ui_step1.kurlrequester->setUrl( *source );
	ui_step2.kurlrequester->setUrl( *target );
//SETUP CONNECTIONS
	connect( this, SIGNAL( user2Clicked() ), SLOT( nextClicked() ) );
	connect( this, SIGNAL( user1Clicked() ), SLOT( finishClicked() ) );
}

void BackupAssistant::nextClicked()
{
	if ( currentPage() == summaryPage )
	{
		ui_summary.label_source->setText( "<b>" + ui_step1.kurlrequester->url().path() + "</b>" );
		ui_summary.label_target->setText( "<b>" + ui_step2.kurlrequester->url().path() + "</b>" );
	}
}
void BackupAssistant::finishClicked()
{
	*m_source = ui_step1.kurlrequester->url().path();
	*m_target = ui_step2.kurlrequester->url().path();
}
