
#  _   _______                 _ _ _   _       _   _  __ _
# | | / /  __ \               (_) | \ | |     | | (_)/ _(_)
# | |/ /| |  \/_ __ ___   __ _ _| |  \| | ___ | |_ _| |_ _  ___ _ __
# |    \| | __| '_ ` _ \ / _` | | | . ` |/ _ \| __| |  _| |/ _ \ '__|
# | |\  \ |_\ \ | | | | | (_| | | | |\  | (_) | |_| | | | |  __/ |
# \_| \_/\____/_| |_| |_|\__,_|_|_\_| \_/\___/ \__|_|_| |_|\___|_|

############################################################################
#    Copyright (C) 2007 by Marcel Hasler                                   #
#    mahasler@gmail.com                                                    #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License version 2        #
#    as published by the Free Software Foundation.                         #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

from kdeui import KMainWindow, KURLLabel
from qt import *
from iconpaths import *

class PopupWindow(KMainWindow):
	def __init__(self,hoffset,voffset,languageHandler):
		KMainWindow.__init__(self, None, "KGmailNotifier", Qt.WType_TopLevel | Qt.WDestructiveClose | Qt.WX11BypassWM | Qt.WStyle_NoBorder)
		
		self.languageHandler = languageHandler
		
		# Set up the window
		self.desktop = QApplication.desktop()
		self.hOffset = hoffset
		self.vOffset = voffset
		self.itsWidth = 200
		self.itsHeight = 150
		self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - self.itsHeight,self.itsWidth,self.itsHeight)
		
		# Add the background image
		self.itsImage = QLabel(self,"GmailLabel")
		self.itsImage.setPaletteBackgroundPixmap(QPixmap(PIC_BACKGROUND))
		self.itsImage.setPixmap(QPixmap(PIC_BACKGROUND))
		self.itsImage.setGeometry(0,0,self.itsWidth,self.itsHeight)
		self.itsImage.show()
		
		# Add contents
		self.closeButton = QPushButton(QIconSet(QPixmap(ICON_CLOSE)), "", self.itsImage,"closeButton")
		self.closeButton.setGeometry(QRect(178,10,12,12))
		self.closeButton.setFlat(True)
		self.closeButton.setAutoDefault(False)
		self.closeButton.show()
		self.connect(self.closeButton,SIGNAL("clicked()"),self.Close)
		
		self.newMailLabel = KURLLabel(self.itsImage,"newMailLabel")
		self.newMailLabel.setGeometry(5,50,190,40)
		self.newMailLabel.setBackgroundOrigin(QWidget.ParentOrigin)
		self.newMailLabel.setAlignment(QLabel.WordBreak | QLabel.AlignHCenter | QLabel.AlignVCenter)
		self.newMailLabelFont = QFont()
		self.newMailLabelFont.setPixelSize(11)
		self.newMailLabel.setFont(self.newMailLabelFont)
		self.newMailLabel.setSelectedColor("blue")
		self.newMailLabel.setText(QString(self.languageHandler.Translate("No new mail")))
		self.newMailLabel.show()
		self.connect(self.newMailLabel, SIGNAL("leftClickedURL(const QString&)"), self.Close);
		
		self.unreadMsgCountLabel = QLabel(self.itsImage,"unreadMsgCountLabel")
		self.unreadMsgCountLabel.setGeometry(135,45,60,20)
		self.unreadMsgCountLabel.setBackgroundOrigin(QWidget.ParentOrigin)
		self.unreadMsgCountLabel.setAlignment(QLabel.WordBreak | QLabel.AlignHCenter | QLabel.AlignVCenter)
		self.unreadMsgCountLabelFont = QFont()
		self.unreadMsgCountLabelFont.setPixelSize(11)
		self.unreadMsgCountLabel.setFont(self.unreadMsgCountLabelFont)
		self.unreadMsgCountLabel.setPaletteForegroundColor(QColor("blue"))
		self.unreadMsgCountLabel.setText("")
		self.unreadMsgCountLabel.hide()
		
		self.senderLabel = QLabel(self.itsImage,"senderLabel")
		self.senderLabel.setGeometry(15,70,170,35)
		self.senderLabel.setBackgroundOrigin(QWidget.ParentOrigin)
		self.senderLabel.setAlignment(QLabel.WordBreak | QLabel.AlignLeft | QLabel.AlignTop)
		self.senderLabelFont = QFont()
		self.senderLabelFont.setPixelSize(11)
		self.senderLabel.setFont(self.senderLabelFont)
		self.senderLabel.setText(QString(""))
		self.senderLabel.hide()
		
		self.msgTitleLabel = QLabel(self.itsImage,"msgTitleLabel")
		self.msgTitleLabel.setGeometry(15,105,170,35)
		self.msgTitleLabel.setBackgroundOrigin(QWidget.ParentOrigin)
		self.msgTitleLabel.setAlignment(QLabel.WordBreak | QLabel.AlignLeft | QLabel.AlignTop)
		self.msgTitleLabelFont = QFont()
		self.msgTitleLabelFont.setPixelSize(11)
		self.msgTitleLabel.setFont(self.msgTitleLabelFont)
		self.msgTitleLabel.setText(QString(""))
		self.msgTitleLabel.hide()
		
		self.connectionFailedLabel = QLabel(self.itsImage,"connectionFailedLabel")
		self.connectionFailedLabel.setGeometry(5,50,190,40)
		self.connectionFailedLabel.setBackgroundOrigin(QWidget.ParentOrigin)
		self.connectionFailedLabel.setAlignment(QLabel.WordBreak | QLabel.AlignCenter | QLabel.AlignTop)
		self.connectionFailedLabelFont = QFont()
		self.connectionFailedLabelFont.setPixelSize(11)
		self.connectionFailedLabel.setFont(self.connectionFailedLabelFont)
		self.connectionFailedLabel.setText(QString(self.languageHandler.Translate("Connection failed!")))
		self.connectionFailedLabel.hide()

		# Set up popup timer
		self.itsTimer = QTimer(self)
		QObject.connect(self.itsTimer,SIGNAL("timeout()"),self.Close)

		# Set up animation timer
		self.itsPopupTimer = QTimer(self)
		QObject.connect(self.itsPopupTimer,SIGNAL("timeout()"),self.AnimatePopup)
		
		self.isAnimated = False
		self.popupIsUp = False


	def SetPopupTimeout(self, timeout):
		self.popupTimeout = timeout


	def SetAnimationDelay(self, delay):
		self.animationDelay = delay


	def SetPopupDirection(self,direction):
		self.popupDirection = direction


	def SetAnimationOn(self,animated):
		self.isAnimated = animated


	def SetPosition(self,hoffset,voffset):
		self.hOffset = hoffset
		self.vOffset = voffset
		self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - self.itsHeight,self.itsWidth,self.itsHeight)


	def Popup(self):
		if self.popupIsUp:
			self.itsTimer.start(self.popupTimeout*1000,True)
		else:
			if self.isAnimated:
				self.popupOpening = True # Popup window opening
				self.currentHeight = 0
				self.currentImagePos = 0
				self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - 	self.currentHeight,self.itsWidth,self.currentHeight)
				if self.popupDirection == "Down":
					self.currentImagePos = -self.itsImage.height()
					self.itsImage.move(0,self.currentImagePos)
				else:
					self.itsImage.move(0,0)
				self.itsPopupTimer.start(self.animationDelay,False)
			else:
				self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - 	self.itsHeight,self.itsWidth,self.itsHeight)	
				self.itsImage.move(0,0)
				self.show()
				self.itsTimer.start(self.popupTimeout*1000,True)
				self.popupIsUp = True


	def AnimatePopup(self):
		if self.popupOpening: #  Popup window opening
			if self.popupDirection == "Up":
				self.currentHeight = self.currentHeight + 2
				self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - self.currentHeight,self.itsWidth,self.currentHeight)
				self.show()
			else:
				self.currentHeight = self.currentHeight + 2
				self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - self.itsHeight,self.itsWidth,self.currentHeight)
				self.currentImagePos = self.currentImagePos + 2
				self.itsImage.move(0,self.currentImagePos)
				self.show()
		
			if self.currentHeight >= self.itsHeight:
				self.itsPopupTimer.stop()
				self.itsTimer.start(self.popupTimeout*1000,True)
				self.popupIsUp = True
				
		else: #  Popup window closing
			if self.popupDirection == "Up":
				self.currentHeight = self.currentHeight - 2
				self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - 	self.currentHeight,self.itsWidth,self.currentHeight)
				self.show()
			else:
				self.currentHeight = self.currentHeight - 2
				self.setGeometry(self.desktop.width() - self.hOffset - self.itsWidth,self.desktop.height() - self.vOffset - self.itsHeight,self.itsWidth,self.currentHeight)
				self.currentImagePos = self.currentImagePos - 2
				self.itsImage.move(0,self.currentImagePos)
				self.show()
		
			if self.currentHeight <= 0:
				self.itsPopupTimer.stop()
				self.hide()


	def Close(self):
		self.popupIsUp = False
		if self.isAnimated:
			self.popupOpening = False #  Popup window closing
			self.itsPopupTimer.start(self.animationDelay,False)
		else:
			self.hide()


	def SetUnreadMsgCount(self, number):
		if number == 0:
			self.connectionFailedLabel.hide()
			self.unreadMsgCountLabel.hide()
			self.senderLabel.hide()
			self.msgTitleLabel.hide()

			self.newMailLabel.setGeometry(5,50,190,40)
			self.newMailLabel.setAlignment(QLabel.WordBreak | QLabel.AlignHCenter | QLabel.AlignVCenter)
			self.newMailLabel.setText(self.languageHandler.Translate("No new mail"))
			self.newMailLabel.show()
		else:
			self.connectionFailedLabel.hide()
			
			self.newMailLabel.setGeometry(12,45,120,20)
			self.newMailLabel.setAlignment(QLabel.WordBreak | QLabel.AlignLeft | QLabel.AlignVCenter)
			self.newMailLabel.setText(self.languageHandler.Translate("You have new mail"))
			self.newMailLabel.show()
			
			self.unreadMsgCountText = "(%s total)" % number
			self.unreadMsgCountLabel.setText(self.unreadMsgCountText)
			self.unreadMsgCountLabel.show()


	def SetConnectionFailed(self):
		self.newMailLabel.hide()
		self.unreadMsgCountLabel.hide()
		self.senderLabel.hide()
		self.msgTitleLabel.hide()
		self.newMailLabel.hide()
		
		self.connectionFailedLabel.show()


	def SetSenderAddress(self, sender):
		if sender == "":
			self.senderLabel.hide()
		else:
			self.senderText = "<b>%s</b><br>%s" % (self.languageHandler.Translate("From:"),sender)
			self.senderLabel.setText(QString(self.senderText))
			self.senderLabel.show()


	def SetMsgTitle(self, title):
		if title == "":
			self.msgTitleLabel.hide()
		else:
			self.msgTitleText = "<b>%s</b><br> %s" % (self.languageHandler.Translate("Subject:"),title)
			self.msgTitleLabel.setText(QString(self.msgTitleText))
			self.msgTitleLabel.show()

