#ifdef ENABLE_TRACING
#include <qapplication.h>
#include <qtextedit.h>
#include <qfile.h>
#include <stdio.h>

static QTextEdit *tracer = NULL;

void TRACER(QtMsgType, const char *msg)
{
  tracer->append(&msg[*msg == '~' ? 1 : 0]);
  if (msg[0] != '~')
  {
    fprintf(stderr, msg);
    fprintf(stderr, "\r\n");
  }
}

void INIT_TRACE()
{
  if (tracer) return;     // de javu
  tracer = new QTextEdit();
  tracer->setTextFormat(Qt::LogText);
  tracer->setMaxLogLines(10000);
  tracer->resize(750, 300);
  qInstallMsgHandler(TRACER);
}

void SHOW_TRACE()
{
  tracer->show();
}

void DUMP_TRACE(const char *f)
{
  QFile file(f); // Write the text to a file
  if (file.open(IO_WriteOnly))
  {
    QTextStream stream(&file);
    stream << tracer->text();
  }
}

#endif // ENABLE_TRACER
