/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _FFPARSER_H
#define _FFPARSER_H

#include <qvaluestack.h>
#include <qxml.h>

class QString;
class QStringList;
class DItem;
class DDataControl;
/**
 * This class handles the code for importing freemind (.mm) files
 *
 * @short Freemind import filter
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class FFParser : public QXmlDefaultHandler
{
	public:
		FFParser(DDataControl*d);

		bool startDocument();
		bool startElement( const QString&, const QString&, const QString&, const QXmlAttributes& );
		bool endElement( const QString&, const QString&, const QString& );

		bool characters( const QString& s);

	private:

		bool m_inItem;

		int m_id;
		int m_docversion;

		QString m_str;
		QString m_tmpstr;

		DDataControl* m_datacontrol;
		QValueStack<int> m_ancestors;
		int m_lastid;
};

#endif // _FFPARSER_H

