//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Runtime.InteropServices;
	using System.Text;
	using System.Collections.Generic;

	/// <remarks>
	///  </remarks>		<short> A namespace for KIO globals.</short>

	[SmokeClass("KIO")]
	public class KIO : Object {
		protected SmokeInvocation interceptor = null;

		/// <remarks>
		///  The base class for all jobs.
		///  For all jobs created in an application, the code looks like
		///  <pre>
		///    KIO.Job  job = KIO.Someoperation( some parameters );
		///    connect( job, SIGNAL("result( KJob  )"),
		///             this, SLOT("slotResult( KJob  )") );
		///  </pre>
		///    (other connects, specific to the job)
		///  And slotResult is usually at least:
		///  <pre>
		///   if ( job.Error() )
		///       job.Ui().ShowErrorDialog();
		///  </pre>
		///  See <see cref="IJobSignals"></see> for signals emitted by Job
		/// </remarks>		<short>    The base class for all jobs.</short>
		/// 		<see> Scheduler</see>

		[SmokeClass("KIO::Job")]
		public class Job : KCompositeJob, IDisposable {
	 		protected Job(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(Job), this);
			}
			// KIO::Job* Job(KIO::JobPrivate& arg1); >>>> NOT CONVERTED
			[SmokeMethod("start()")]
			public override void Start() {
				interceptor.Invoke("start", "start()", typeof(void));
			}
			/// <remarks>
			///  Retrieves the UI delegate of this job.
			///  This method is basically a convenience for static_cast<KIO.JobUiDelegate>(uiDelegate()).
			/// </remarks>		<return> the delegate used by the job to communicate with the UI
			///          </return>
			/// 		<short>    Retrieves the UI delegate of this job.</short>
			public KIO.JobUiDelegate Ui() {
				return (KIO.JobUiDelegate) interceptor.Invoke("ui", "ui() const", typeof(KIO.JobUiDelegate));
			}
			/// <remarks>
			///  Converts an error code and a non-i18n error message into an
			///  error message in the current language. The low level (non-i18n)
			///  error message (usually a url) is put into the translated error
			///  message using %1.
			///  Example for errid == ERR_CANNOT_OPEN_FOR_READING:
			///  <pre>
			///    i18n( "Could not read\n%1" ).arg( errortext );
			///  </pre>
			///  Use this to display the error yourself, but for a dialog box
			///  use Job.ShowErrorDialog. Do not call it if error()
			///  is not 0.
			/// </remarks>		<return> the error message and if there is no error, a message
			///          telling the user that the app is broken, so check with
			///          error() whether there is an error
			///          </return>
			/// 		<short>    Converts an error code and a non-i18n error message into an  error message in the current language.</short>
			[SmokeMethod("errorString() const")]
			public override string ErrorString() {
				return (string) interceptor.Invoke("errorString", "errorString() const", typeof(string));
			}
			/// <remarks>
			///  Converts an error code and a non-i18n error message into i18n
			///  strings suitable for presentation in a detailed error message box.
			/// <param> name="reqUrl" the request URL that generated this error message
			/// </param><param> name="method" the method that generated this error message
			///  (unimplemented)
			/// </param></remarks>		<return> the following strings: caption, error + description,
			///          causes+solutions
			///          </return>
			/// 		<short>    Converts an error code and a non-i18n error message into i18n  strings suitable for presentation in a detailed error message box.</short>
			public List<string> DetailedErrorStrings(KUrl reqUrl, int method) {
				return (List<string>) interceptor.Invoke("detailedErrorStrings#$", "detailedErrorStrings(const KUrl*, int) const", typeof(List<string>), typeof(KUrl), reqUrl, typeof(int), method);
			}
			public List<string> DetailedErrorStrings(KUrl reqUrl) {
				return (List<string>) interceptor.Invoke("detailedErrorStrings#", "detailedErrorStrings(const KUrl*) const", typeof(List<string>), typeof(KUrl), reqUrl);
			}
			public List<string> DetailedErrorStrings() {
				return (List<string>) interceptor.Invoke("detailedErrorStrings", "detailedErrorStrings() const", typeof(List<string>));
			}
			/// <remarks>
			///  Returns whether message display is enabled or disabled.
			///  See also setInteractive .
			/// </remarks>		<return> true if message display is enabled
			/// </return>
			/// 		<short>    Returns whether message display is enabled or disabled.</short>
			/// 		<see> setInteractive</see>
			public bool IsInteractive() {
				return (bool) interceptor.Invoke("isInteractive", "isInteractive() const", typeof(bool));
			}
			/// <remarks>
			///  Set the parent Job.
			///  One example use of this is when FileCopyJob calls RenameDialog.Open,
			///  it must pass the correct progress ID of the parent CopyJob
			///  (to hide the progress dialog).
			///  You can set the parent job only once. By default a job does not
			///  have a parent job.
			/// <param> name="parentJob" the new parent job
			///          </param></remarks>		<short>    Set the parent Job.</short>
			public void SetParentJob(KIO.Job parentJob) {
				interceptor.Invoke("setParentJob#", "setParentJob(KIO::Job*)", typeof(void), typeof(KIO.Job), parentJob);
			}
			/// <remarks>
			///  Returns the parent job, if there is one.
			/// </remarks>		<return> the parent job, or 0 if there is none
			/// </return>
			/// 		<short>    Returns the parent job, if there is one.</short>
			/// 		<see> setParentJob</see>
			public KIO.Job ParentJob() {
				return (KIO.Job) interceptor.Invoke("parentJob", "parentJob() const", typeof(KIO.Job));
			}
			/// <remarks>
			///  Set meta data to be sent to the slave, replacing existing
			///  meta data.
			/// <param> name="metaData" the meta data to set
			/// </param></remarks>		<short>    Set meta data to be sent to the slave, replacing existing  meta data.</short>
			/// 		<see> addMetaData</see>
			/// 		<see> mergeMetaData</see>
			public void SetMetaData(KIO.MetaData metaData) {
				interceptor.Invoke("setMetaData#", "setMetaData(const KIO::MetaData&)", typeof(void), typeof(KIO.MetaData), metaData);
			}
			/// <remarks>
			///  Add key/value pair to the meta data that is sent to the slave.
			/// <param> name="key" the key of the meta data
			/// </param><param> name="value" the value of the meta data
			/// </param></remarks>		<short>    Add key/value pair to the meta data that is sent to the slave.</short>
			/// 		<see> setMetaData</see>
			/// 		<see> mergeMetaData</see>
			public void AddMetaData(string key, string value) {
				interceptor.Invoke("addMetaData$$", "addMetaData(const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), value);
			}
			/// <remarks>
			///  Add key/value pairs to the meta data that is sent to the slave.
			///  If a certain key already existed, it will be overridden.
			/// <param> name="values" the meta data to add
			/// </param></remarks>		<short>    Add key/value pairs to the meta data that is sent to the slave.</short>
			/// 		<see> setMetaData</see>
			/// 		<see> mergeMetaData</see>
			public void AddMetaData(Dictionary<string, string> values) {
				interceptor.Invoke("addMetaData?", "addMetaData(const QMap<QString, QString>&)", typeof(void), typeof(Dictionary<string, string>), values);
			}
			/// <remarks>
			///  Add key/value pairs to the meta data that is sent to the slave.
			///  If a certain key already existed, it will remain unchanged.
			/// <param> name="values" the meta data to merge
			/// </param></remarks>		<short>    Add key/value pairs to the meta data that is sent to the slave.</short>
			/// 		<see> setMetaData</see>
			/// 		<see> addMetaData</see>
			public void MergeMetaData(Dictionary<string, string> values) {
				interceptor.Invoke("mergeMetaData?", "mergeMetaData(const QMap<QString, QString>&)", typeof(void), typeof(Dictionary<string, string>), values);
			}
			/// <remarks>
			///          </remarks>		<short>   </short>
			public KIO.MetaData OutgoingMetaData() {
				return (KIO.MetaData) interceptor.Invoke("outgoingMetaData", "outgoingMetaData() const", typeof(KIO.MetaData));
			}
			/// <remarks>
			///  Get meta data received from the slave.
			///  (Valid when first data is received and/or slave is finished)
			/// </remarks>		<return> the job's meta data
			///          </return>
			/// 		<short>    Get meta data received from the slave.</short>
			public KIO.MetaData MetaData() {
				return (KIO.MetaData) interceptor.Invoke("metaData", "metaData() const", typeof(KIO.MetaData));
			}
			/// <remarks>
			///  Query meta data received from the slave.
			///  (Valid when first data is received and/or slave is finished)
			/// <param> name="key" the key of the meta data to retrieve
			/// </param></remarks>		<return> the value of the meta data, or string() if the
			///          <code>key</code> does not exist
			///          </return>
			/// 		<short>    Query meta data received from the slave.</short>
			public string QueryMetaData(string key) {
				return (string) interceptor.Invoke("queryMetaData$", "queryMetaData(const QString&)", typeof(string), typeof(string), key);
			}
			public Job() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("Job", "Job()", typeof(void));
			}
			/// <remarks>
			///  Abort this job.
			///  This kills all subjobs and deletes the job.
			///          </remarks>		<short>    Abort this job.</short>
			[SmokeMethod("doKill()")]
			protected override bool DoKill() {
				return (bool) interceptor.Invoke("doKill", "doKill()", typeof(bool));
			}
			/// <remarks>
			///  Suspend this job
			/// </remarks>		<short>    Suspend this job </short>
			/// 		<see> resume</see>
			[SmokeMethod("doSuspend()")]
			protected override bool DoSuspend() {
				return (bool) interceptor.Invoke("doSuspend", "doSuspend()", typeof(bool));
			}
			/// <remarks>
			///  Resume this job
			/// </remarks>		<short>    Resume this job </short>
			/// 		<see> suspend</see>
			[SmokeMethod("doResume()")]
			protected override bool DoResume() {
				return (bool) interceptor.Invoke("doResume", "doResume()", typeof(bool));
			}
			/// <remarks>
			///  Add a job that has to be finished before a result
			///  is emitted. This has obviously to be called before
			///  the finish signal is emitted by the slave.
			/// <param> name="job" the subjob to add
			/// </param><param> name="inheritMetaData" if true, the subjob will
			///  inherit the meta data from this job.
			///          </param></remarks>		<short>    Add a job that has to be finished before a result  is emitted.</short>
			[SmokeMethod("addSubjob(KIO::Job*, bool)")]
			protected virtual void AddSubjob(KIO.Job job, bool inheritMetaData) {
				interceptor.Invoke("addSubjob#$", "addSubjob(KIO::Job*, bool)", typeof(void), typeof(KIO.Job), job, typeof(bool), inheritMetaData);
			}
			[SmokeMethod("addSubjob(KIO::Job*)")]
			protected virtual void AddSubjob(KIO.Job job) {
				interceptor.Invoke("addSubjob#", "addSubjob(KIO::Job*)", typeof(void), typeof(KIO.Job), job);
			}
			/// <remarks>
			///  Mark a sub job as being done.
			///  KDE4 change: this doesn't terminate the parent job anymore, call emitResult to do that.
			/// <param> name="job" the subjob to remove
			/// </param><param> name="mergeMetaData" if set, the metadata received by the subjob is
			///                       merged into this job.
			///          </param></remarks>		<short>    Mark a sub job as being done.</short>
			protected bool RemoveSubjob(KJob job, bool mergeMetaData) {
				return (bool) interceptor.Invoke("removeSubjob#$", "removeSubjob(KJob*, bool)", typeof(bool), typeof(KJob), job, typeof(bool), mergeMetaData);
			}
			[SmokeMethod("removeSubjob(KJob*)")]
			protected override bool RemoveSubjob(KJob job) {
				return (bool) interceptor.Invoke("removeSubjob#", "removeSubjob(KJob*)", typeof(bool), typeof(KJob), job);
			}
			~Job() {
				interceptor.Invoke("~Job", "~Job()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~Job", "~Job()", typeof(void));
			}
			protected new IJobSignals Emit {
				get { return (IJobSignals) Q_EMIT; }
			}
		}

		public interface IJobSignals : IKCompositeJobSignals {
		/// <remarks>
		///  Emitted when the slave successfully connected to the host.
		///  There is no guarantee the slave will send this, and this is
		///  currently unused (in the applications).
		/// <param> name="job" the job that emitted this signal
		///          </param></remarks>		<short>    Emitted when the slave successfully connected to the host.</short>
		[Q_SIGNAL("void connected(KIO::Job*)")]
		void Connected(KIO.Job job);
		}

		/// <remarks>
		///  CopyJob is used to move, copy or symlink files and directories.
		///  Don't create the job directly, but use KIO.Copy(),
		///  KIO.Move(), KIO.Link() and friends.
		///  See <see cref="ICopyJobSignals"></see> for signals emitted by CopyJob
		/// </remarks>		<short>    CopyJob is used to move, copy or symlink files and directories.</short>
		/// 		<see> copy</see>
		/// 		<see> copyAs</see>
		/// 		<see> move</see>
		/// 		<see> moveAs</see>
		/// 		<see> link</see>
		/// 		<see> linkAs</see>

		[SmokeClass("KIO::CopyJob")]
		public class CopyJob : KIO.Job {
	 		protected CopyJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(CopyJob), this);
			}
			// KIO::CopyJob* CopyJob(KIO::CopyJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Returns the list of source URLs.
			/// </remarks>		<return> the list of source URLs.
			/// 	 </return>
			/// 		<short>    Returns the list of source URLs.</short>
			public List<KUrl> SrcUrls() {
				return (List<KUrl>) interceptor.Invoke("srcUrls", "srcUrls() const", typeof(List<KUrl>));
			}
			/// <remarks>
			///  Returns the destination URL.
			/// </remarks>		<return> the destination URL
			/// 	 </return>
			/// 		<short>    Returns the destination URL.</short>
			public KUrl DestUrl() {
				return (KUrl) interceptor.Invoke("destUrl", "destUrl() const", typeof(KUrl));
			}
			/// <remarks>
			///  By default the permissions of the copied files will be those of the source files.
			///  But when copying "template" files to "new" files, people prefer the umask
			///  to apply, rather than the template's permissions.
			///  For that case, call setDefaultPermissions(true)
			///          </remarks>		<short>    By default the permissions of the copied files will be those of the source files.</short>
			public void SetDefaultPermissions(bool b) {
				interceptor.Invoke("setDefaultPermissions$", "setDefaultPermissions(bool)", typeof(void), typeof(bool), b);
			}
			/// <remarks>
			///  Reimplemented for internal reasons
			///          </remarks>		<short>    Reimplemented for internal reasons          </short>
			[SmokeMethod("doSuspend()")]
			public new virtual bool DoSuspend() {
				return (bool) interceptor.Invoke("doSuspend", "doSuspend()", typeof(bool));
			}
			[Q_SLOT("void slotResult(KJob*)")]
			[SmokeMethod("slotResult(KJob*)")]
			protected override void SlotResult(KJob job) {
				interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
			}
			protected new ICopyJobSignals Emit {
				get { return (ICopyJobSignals) Q_EMIT; }
			}
		}

		public interface ICopyJobSignals : KIO.IJobSignals {
		/// <remarks>
		///  Emitted when the total number of files is known.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="files" the total number of files
		/// 	 </param></remarks>		<short>    Emitted when the total number of files is known.</short>
		[Q_SIGNAL("void totalFiles(KJob*, unsigned long)")]
		void TotalFiles(KJob job, ulong files);
		/// <remarks>
		///  Emitted when the toal number of direcotries is known.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="dirs" the total number of directories
		/// 	 </param></remarks>		<short>    Emitted when the toal number of direcotries is known.</short>
		[Q_SIGNAL("void totalDirs(KJob*, unsigned long)")]
		void TotalDirs(KJob job, ulong dirs);
		// void aboutToCreate(KIO::Job* arg1,const QList<KIO::CopyInfo>& arg2); >>>> NOT CONVERTED
		/// <remarks>
		///  Sends the number of processed files.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="files" the number of processed files
		/// 	 </param></remarks>		<short>    Sends the number of processed files.</short>
		[Q_SIGNAL("void processedFiles(KIO::Job*, unsigned long)")]
		void ProcessedFiles(KIO.Job job, ulong files);
		/// <remarks>
		///  Sends the number of processed directories.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="dirs" the number of processed dirs
		/// 	 </param></remarks>		<short>    Sends the number of processed directories.</short>
		[Q_SIGNAL("void processedDirs(KIO::Job*, unsigned long)")]
		void ProcessedDirs(KIO.Job job, ulong dirs);
		/// <remarks>
		///  The job is copying a file or directory.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="src" the URL of the file or directory that is currently
		///              being copied
		/// </param><param> name="dest" the destination of the current operation
		///          </param></remarks>		<short>    The job is copying a file or directory.</short>
		[Q_SIGNAL("void copying(KIO::Job*, const KUrl&, const KUrl&)")]
		void Copying(KIO.Job job, KUrl src, KUrl dest);
		/// <remarks>
		///  The job is creating a symbolic link.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="target" the URL of the file or directory that is currently
		///              being linked
		/// </param><param> name="to" the destination of the current operation
		///          </param></remarks>		<short>    The job is creating a symbolic link.</short>
		[Q_SIGNAL("void linking(KIO::Job*, const QString&, const KUrl&)")]
		void Linking(KIO.Job job, string target, KUrl to);
		/// <remarks>
		///  The job is moving a file or directory.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="from" the URL of the file or directory that is currently
		///              being moved
		/// </param><param> name="to" the destination of the current operation
		///          </param></remarks>		<short>    The job is moving a file or directory.</short>
		[Q_SIGNAL("void moving(KIO::Job*, const KUrl&, const KUrl&)")]
		void Moving(KIO.Job job, KUrl from, KUrl to);
		/// <remarks>
		///  The job is creating the directory <code>dir.</code>
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="dir" the directory that is currently being created
		///          </param></remarks>		<short>    The job is creating the directory <code>dir.</code></short>
		[Q_SIGNAL("void creatingDir(KIO::Job*, const KUrl&)")]
		void CreatingDir(KIO.Job job, KUrl dir);
		/// <remarks>
		///  The user chose to rename <code>from</code> to <code>to.</code>
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="from" the original name
		/// </param><param> name="to" the new name
		///          </param></remarks>		<short>    The user chose to rename <code>from</code> to <code>to.</code></short>
		[Q_SIGNAL("void renamed(KIO::Job*, const KUrl&, const KUrl&)")]
		void Renamed(KIO.Job job, KUrl from, KUrl to);
		/// <remarks>
		///  The job emits this signal when copying or moving a file or directory successfully finished.
		///  This signal is mainly for the Undo feature.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="from" the source URL
		/// </param><param> name="to" the destination URL
		/// </param><param> name="mtime" the modification time of the source file, hopefully set on the destination file
		///  too (when the kioslave supports it).
		/// </param><param> name="directory" indicates whether a file or directory was successfully copied/moved.
		///                   true for a directory, false for file
		/// </param><param> name="renamed" indicates that the destination URL was created using a
		///  rename operation (i.e. fast directory moving). true if is has been renamed
		///          </param></remarks>		<short>    The job emits this signal when copying or moving a file or directory successfully finished.</short>
		[Q_SIGNAL("void copyingDone(KIO::Job*, const KUrl&, const KUrl&, time_t, bool, bool)")]
		void CopyingDone(KIO.Job job, KUrl from, KUrl to, int mtime, bool directory, bool renamed);
		/// <remarks>
		///  The job is copying or moving a symbolic link, that points to target.
		///  The new link is created in <code>to.</code> The existing one is/was in <code>from.</code>
		///  This signal is mainly for the Undo feature.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="from" the source URL
		/// </param><param> name="target" the target
		/// </param><param> name="to" the destination URL
		///          </param></remarks>		<short>    The job is copying or moving a symbolic link, that points to target.</short>
		[Q_SIGNAL("void copyingLinkDone(KIO::Job*, const KUrl&, const QString&, const KUrl&)")]
		void CopyingLinkDone(KIO.Job job, KUrl from, string target, KUrl to);
		}

		/// <remarks>
		///  A more complex Job to delete files and directories.
		///  Don't create the job directly, but use KIO.Del() instead.
		///  See <see cref="IDeleteJobSignals"></see> for signals emitted by DeleteJob
		/// </remarks>		<short>    A more complex Job to delete files and directories.</short>
		/// 		<see> del</see>

		[SmokeClass("KIO::DeleteJob")]
		public class DeleteJob : KIO.Job, IDisposable {
	 		protected DeleteJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(DeleteJob), this);
			}
			// KIO::DeleteJob* DeleteJob(KIO::DeleteJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Returns the list of URLs.
			/// </remarks>		<return> the list of URLs.
			/// 	 </return>
			/// 		<short>    Returns the list of URLs.</short>
			public List<KUrl> Urls() {
				return (List<KUrl>) interceptor.Invoke("urls", "urls() const", typeof(List<KUrl>));
			}
			[Q_SLOT("void slotResult(KJob*)")]
			[SmokeMethod("slotResult(KJob*)")]
			protected override void SlotResult(KJob job) {
				interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
			}
			~DeleteJob() {
				interceptor.Invoke("~DeleteJob", "~DeleteJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~DeleteJob", "~DeleteJob()", typeof(void));
			}
			protected new IDeleteJobSignals Emit {
				get { return (IDeleteJobSignals) Q_EMIT; }
			}
		}

		public interface IDeleteJobSignals : KIO.IJobSignals {
		/// <remarks>
		///  Emitted when the total number of files is known.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="files" the total number of files
		/// 	 </param></remarks>		<short>    Emitted when the total number of files is known.</short>
		[Q_SIGNAL("void totalFiles(KJob*, unsigned long)")]
		void TotalFiles(KJob job, ulong files);
		/// <remarks>
		///  Emitted when the toal number of direcotries is known.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="dirs" the total number of directories
		/// 	 </param></remarks>		<short>    Emitted when the toal number of direcotries is known.</short>
		[Q_SIGNAL("void totalDirs(KJob*, unsigned long)")]
		void TotalDirs(KJob job, ulong dirs);
		/// <remarks>
		///  Sends the number of processed files.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="files" the number of processed files
		/// 	 </param></remarks>		<short>    Sends the number of processed files.</short>
		[Q_SIGNAL("void processedFiles(KIO::Job*, unsigned long)")]
		void ProcessedFiles(KIO.Job job, ulong files);
		/// <remarks>
		///  Sends the number of processed directories.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="dirs" the number of processed dirs
		/// 	 </param></remarks>		<short>    Sends the number of processed directories.</short>
		[Q_SIGNAL("void processedDirs(KIO::Job*, unsigned long)")]
		void ProcessedDirs(KIO.Job job, ulong dirs);
		/// <remarks>
		///  Sends the URL of the file that is currently being deleted.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="file" the URL of the file or directory that is being
		///         deleted
		/// 	 </param></remarks>		<short>    Sends the URL of the file that is currently being deleted.</short>
		[Q_SIGNAL("void deleting(KIO::Job*, const KUrl&)")]
		void Deleting(KIO.Job job, KUrl file);
		}

		/// <remarks>
		///  @private
		///  This class provides a way to obtaining KIO.Connection connections.
		///       See <see cref="IConnectionServerSignals"></see> for signals emitted by ConnectionServer
		/// </remarks>		<short>    @private </short>

		[SmokeClass("KIO::ConnectionServer")]
		public class ConnectionServer : QObject, IDisposable {
	 		protected ConnectionServer(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ConnectionServer), this);
			}
			public ConnectionServer(QObject parent) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ConnectionServer#", "ConnectionServer(QObject*)", typeof(void), typeof(QObject), parent);
			}
			public ConnectionServer() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ConnectionServer", "ConnectionServer()", typeof(void));
			}
			/// <remarks>
			///  Sets this connection to listen mode. Use address() to obtain the
			///  address this is listening on.
			///          </remarks>		<short>    Sets this connection to listen mode.</short>
			public void ListenForRemote() {
				interceptor.Invoke("listenForRemote", "listenForRemote()", typeof(void));
			}
			public bool IsListening() {
				return (bool) interceptor.Invoke("isListening", "isListening() const", typeof(bool));
			}
			public void Close() {
				interceptor.Invoke("close", "close()", typeof(void));
			}
			/// <remarks>
			///  Returns the address for this connection if it is listening, an empty
			///  string if not.
			///          </remarks>		<short>    Returns the address for this connection if it is listening, an empty  string if not.</short>
			public string Address() {
				return (string) interceptor.Invoke("address", "address() const", typeof(string));
			}
			public KIO.Connection NextPendingConnection() {
				return (KIO.Connection) interceptor.Invoke("nextPendingConnection", "nextPendingConnection()", typeof(KIO.Connection));
			}
			public void SetNextPendingConnection(KIO.Connection conn) {
				interceptor.Invoke("setNextPendingConnection#", "setNextPendingConnection(KIO::Connection*)", typeof(void), typeof(KIO.Connection), conn);
			}
			~ConnectionServer() {
				interceptor.Invoke("~ConnectionServer", "~ConnectionServer()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~ConnectionServer", "~ConnectionServer()", typeof(void));
			}
			protected new IConnectionServerSignals Emit {
				get { return (IConnectionServerSignals) Q_EMIT; }
			}
		}

		public interface IConnectionServerSignals : IQObjectSignals {
		[Q_SIGNAL("void newConnection()")]
		void NewConnection();
		}

		/// <remarks>
		///  @private
		///  This class provides a simple means for IPC between two applications
		///  via a pipe.
		///  It handles a queue of commands to be sent which makes it possible to
		///  queue data before an actual connection has been established.
		///       See <see cref="IConnectionSignals"></see> for signals emitted by Connection
		/// </remarks>		<short>    @private </short>

		[SmokeClass("KIO::Connection")]
		public class Connection : QObject, IDisposable {
	 		protected Connection(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(Connection), this);
			}
			/// <remarks>
			///  Creates a new connection.
			/// </remarks>		<short>    Creates a new connection.</short>
			/// 		<see> connectToRemote</see>
			/// 		<see> listenForRemote</see>
			public Connection(QObject parent) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("Connection#", "Connection(QObject*)", typeof(void), typeof(QObject), parent);
			}
			public Connection() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("Connection", "Connection()", typeof(void));
			}
			/// <remarks>
			///  Connects to the remote address.
			///          </remarks>		<short>    Connects to the remote address.</short>
			public void ConnectToRemote(string address) {
				interceptor.Invoke("connectToRemote$", "connectToRemote(const QString&)", typeof(void), typeof(string), address);
			}
			public void Close() {
				interceptor.Invoke("close", "close()", typeof(void));
			}
			public string ErrorString() {
				return (string) interceptor.Invoke("errorString", "errorString() const", typeof(string));
			}
			public bool IsConnected() {
				return (bool) interceptor.Invoke("isConnected", "isConnected() const", typeof(bool));
			}
			/// <remarks>
			///  Checks whether the connection has been initialized.
			/// </remarks>		<return> true if the initialized
			/// </return>
			/// 		<short>    Checks whether the connection has been initialized.</short>
			/// 		<see> init</see>
			public bool Inited() {
				return (bool) interceptor.Invoke("inited", "inited() const", typeof(bool));
			}
			/// <remarks>
			///  Sends/queues the given command to be sent.
			/// <param> name="cmd" the command to set
			/// </param><param> name="arr" the bytes to send
			/// </param></remarks>		<return> true if successful, false otherwise
			/// 	 </return>
			/// 		<short>    Sends/queues the given command to be sent.</short>
			public bool Send(int cmd, QByteArray arr) {
				return (bool) interceptor.Invoke("send$#", "send(int, const QByteArray&)", typeof(bool), typeof(int), cmd, typeof(QByteArray), arr);
			}
			public bool Send(int cmd) {
				return (bool) interceptor.Invoke("send$", "send(int)", typeof(bool), typeof(int), cmd);
			}
			/// <remarks>
			///  Sends the given command immediately.
			/// <param> name="_cmd" the command to set
			/// </param><param> name="data" the bytes to send
			/// </param></remarks>		<return> true if successful, false otherwise
			/// 	 </return>
			/// 		<short>    Sends the given command immediately.</short>
			public bool Sendnow(int _cmd, QByteArray data) {
				return (bool) interceptor.Invoke("sendnow$#", "sendnow(int, const QByteArray&)", typeof(bool), typeof(int), _cmd, typeof(QByteArray), data);
			}
			/// <remarks>
			///  Returns true if there are packets to be read immediately,
			///  false if waitForIncomingTask must be called before more data
			///  is available.
			///          </remarks>		<short>    Returns true if there are packets to be read immediately,  false if waitForIncomingTask must be called before more data  is available.</short>
			public bool HasTaskAvailable() {
				return (bool) interceptor.Invoke("hasTaskAvailable", "hasTaskAvailable() const", typeof(bool));
			}
			/// <remarks>
			///  Waits for one more command to be handled and ready.
			/// <param> name="ms" the time to wait in milliseconds
			/// </param></remarks>		<return> true if one command can be read, false if we timed out
			///          </return>
			/// 		<short>    Waits for one more command to be handled and ready.</short>
			public bool WaitForIncomingTask(int ms) {
				return (bool) interceptor.Invoke("waitForIncomingTask$", "waitForIncomingTask(int)", typeof(bool), typeof(int), ms);
			}
			public bool WaitForIncomingTask() {
				return (bool) interceptor.Invoke("waitForIncomingTask", "waitForIncomingTask()", typeof(bool));
			}
			/// <remarks>
			///  Receive data.
			/// <param> name="_cmd" the received command will be written here
			/// </param><param> name="data" the received data will be written here
			/// </param></remarks>		<return> >=0 indicates the received data size upon success
			///          -1  indicates error
			/// 	 </return>
			/// 		<short>    Receive data.</short>
			public int Read(ref int _cmd, QByteArray data) {
				StackItem[] stack = new StackItem[3];
				stack[1].s_int = _cmd;
	#if DEBUG
				stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(data);
	#else
				stack[2].s_class = (IntPtr) GCHandle.Alloc(data);
	#endif
				interceptor.Invoke("read$#", "read(int*, QByteArray&)", stack);
				_cmd = stack[1].s_int;
	#if DEBUG
				DebugGCHandle.Free((GCHandle) stack[2].s_class);
	#else
				((GCHandle) stack[2].s_class).Free();
	#endif
				return stack[0].s_int;
			}
			/// <remarks>
			///  Don't handle incoming data until resumed.
			///          </remarks>		<short>    Don't handle incoming data until resumed.</short>
			public void Suspend() {
				interceptor.Invoke("suspend", "suspend()", typeof(void));
			}
			/// <remarks>
			///  Resume handling of incoming data.
			///          </remarks>		<short>    Resume handling of incoming data.</short>
			public void Resume() {
				interceptor.Invoke("resume", "resume()", typeof(void));
			}
			/// <remarks>
			///  Returns status of connection.
			/// </remarks>		<return> true if suspended, false otherwise
			///          </return>
			/// 		<short>    Returns status of connection.</short>
			public bool Suspended() {
				return (bool) interceptor.Invoke("suspended", "suspended() const", typeof(bool));
			}
			~Connection() {
				interceptor.Invoke("~Connection", "~Connection()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~Connection", "~Connection()", typeof(void));
			}
			protected new IConnectionSignals Emit {
				get { return (IConnectionSignals) Q_EMIT; }
			}
		}

		public interface IConnectionSignals : IQObjectSignals {
		[Q_SIGNAL("void readyRead()")]
		void ReadyRead();
		}

		/// <remarks>
		///  There are two classes that specifies the protocol between application
		///  ( KIO.Job) and kioslave. SlaveInterface is the class to use on the application
		///  end, SlaveBase is the one to use on the slave end.
		///  A call to foo() results in a call to slotFoo() on the other end.
		///   See <see cref="ISlaveInterfaceSignals"></see> for signals emitted by SlaveInterface
		/// </remarks>		<short>    There are two classes that specifies the protocol between application  ( KIO.Job) and kioslave.</short>

		[SmokeClass("KIO::SlaveInterface")]
		public class SlaveInterface : QObject {
	 		protected SlaveInterface(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(SlaveInterface), this);
			}
			// void setOffset(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// KIO::filesize_t offset(); >>>> NOT CONVERTED
			public void SetConnection(KIO.Connection connection) {
				interceptor.Invoke("setConnection#", "setConnection(KIO::Connection*)", typeof(void), typeof(KIO.Connection), connection);
			}
			public KIO.Connection Connection() {
				return (KIO.Connection) interceptor.Invoke("connection", "connection() const", typeof(KIO.Connection));
			}
			public void SendResumeAnswer(bool resume) {
				interceptor.Invoke("sendResumeAnswer$", "sendResumeAnswer(bool)", typeof(void), typeof(bool), resume);
			}
			[SmokeMethod("dispatch()")]
			protected virtual bool Dispatch() {
				return (bool) interceptor.Invoke("dispatch", "dispatch()", typeof(bool));
			}
			[SmokeMethod("dispatch(int, const QByteArray&)")]
			protected virtual bool Dispatch(int _cmd, QByteArray data) {
				return (bool) interceptor.Invoke("dispatch$#", "dispatch(int, const QByteArray&)", typeof(bool), typeof(int), _cmd, typeof(QByteArray), data);
			}
			protected void MessageBox(int type, string text, string caption, string buttonYes, string buttonNo) {
				interceptor.Invoke("messageBox$$$$$", "messageBox(int, const QString&, const QString&, const QString&, const QString&)", typeof(void), typeof(int), type, typeof(string), text, typeof(string), caption, typeof(string), buttonYes, typeof(string), buttonNo);
			}
			protected void MessageBox(int type, string text, string caption, string buttonYes, string buttonNo, string dontAskAgainName) {
				interceptor.Invoke("messageBox$$$$$$", "messageBox(int, const QString&, const QString&, const QString&, const QString&, const QString&)", typeof(void), typeof(int), type, typeof(string), text, typeof(string), caption, typeof(string), buttonYes, typeof(string), buttonNo, typeof(string), dontAskAgainName);
			}
			protected void RequestNetwork(string arg1, string arg2) {
				interceptor.Invoke("requestNetwork$$", "requestNetwork(const QString&, const QString&)", typeof(void), typeof(string), arg1, typeof(string), arg2);
			}
			protected void DropNetwork(string arg1, string arg2) {
				interceptor.Invoke("dropNetwork$$", "dropNetwork(const QString&, const QString&)", typeof(void), typeof(string), arg1, typeof(string), arg2);
			}
			[Q_SLOT("void calcSpeed()")]
			protected void CalcSpeed() {
				interceptor.Invoke("calcSpeed", "calcSpeed()", typeof(void));
			}
			protected new ISlaveInterfaceSignals Emit {
				get { return (ISlaveInterfaceSignals) Q_EMIT; }
			}
		}

		public interface ISlaveInterfaceSignals : IQObjectSignals {
		[Q_SIGNAL("void data(const QByteArray&)")]
		void Data(QByteArray arg1);
		[Q_SIGNAL("void dataReq()")]
		void DataReq();
		[Q_SIGNAL("void error(int, const QString&)")]
		void Error(int arg1, string arg2);
		[Q_SIGNAL("void connected()")]
		void Connected();
		[Q_SIGNAL("void finished()")]
		void Finished();
		[Q_SIGNAL("void slaveStatus(pid_t, const QByteArray&, const QString&, bool)")]
		void SlaveStatus(int arg1, QByteArray arg2, string arg3, bool arg4);
		// void listEntries(const KIO::UDSEntryList& arg1); >>>> NOT CONVERTED
		[Q_SIGNAL("void statEntry(const KIO::UDSEntry&)")]
		void StatEntry(KIO.UDSEntry arg1);
		[Q_SIGNAL("void needSubUrlData()")]
		void NeedSubUrlData();
		// void canResume(KIO::filesize_t arg1); >>>> NOT CONVERTED
		[Q_SIGNAL("void open()")]
		void Open();
		// void written(KIO::filesize_t arg1); >>>> NOT CONVERTED
		[Q_SIGNAL("void metaData(const KIO::MetaData&)")]
		void MetaData(KIO.MetaData arg1);
		// void totalSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
		// void processedSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
		[Q_SIGNAL("void redirection(const KUrl&)")]
		void Redirection(KUrl arg1);
		// void position(KIO::filesize_t arg1); >>>> NOT CONVERTED
		[Q_SIGNAL("void speed(long)")]
		void Speed(long arg1);
		[Q_SIGNAL("void errorPage()")]
		void ErrorPage();
		[Q_SIGNAL("void mimeType(const QString&)")]
		void MimeType(string arg1);
		[Q_SIGNAL("void warning(const QString&)")]
		void Warning(string arg1);
		[Q_SIGNAL("void infoMessage(const QString&)")]
		void InfoMessage(string arg1);
		[Q_SIGNAL("void connectFinished()")]
		void ConnectFinished();
		}

		/// <remarks> See <see cref="ISlaveSignals"></see> for signals emitted by Slave
		/// </remarks>

		[SmokeClass("KIO::Slave")]
		public class Slave : KIO.SlaveInterface {
	 		protected Slave(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(Slave), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static Slave() {
				staticInterceptor = new SmokeInvocation(typeof(Slave), null);
			}
			public Slave(string protocol, QObject parent) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("Slave$#", "Slave(const QString&, QObject*)", typeof(void), typeof(string), protocol, typeof(QObject), parent);
			}
			public Slave(string protocol) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("Slave$", "Slave(const QString&)", typeof(void), typeof(string), protocol);
			}
			public void SetPID(int arg1) {
				interceptor.Invoke("setPID$", "setPID(pid_t)", typeof(void), typeof(int), arg1);
			}
			public int Slave_pid() {
				return (int) interceptor.Invoke("slave_pid", "slave_pid()", typeof(int));
			}
			/// <remarks>
			///  Force termination
			/// 	 </remarks>		<short>    Force termination 	 </short>
			public void Kill() {
				interceptor.Invoke("kill", "kill()", typeof(void));
			}
			/// <remarks>
			/// </remarks>		<return> true if the slave survived the last mission.
			///          </return>
			/// 		<short>   </short>
			public bool IsAlive() {
				return (bool) interceptor.Invoke("isAlive", "isAlive()", typeof(bool));
			}
			/// <remarks>
			///  Set host for url
			/// <param> name="host" to connect to.
			/// </param><param> name="port" to connect to.
			/// </param><param> name="user" to login as
			/// </param><param> name="passwd" to login with
			///          </param></remarks>		<short>    Set host for url </short>
			[SmokeMethod("setHost(const QString&, quint16, const QString&, const QString&)")]
			public virtual void SetHost(string host, ushort port, string user, string passwd) {
				interceptor.Invoke("setHost$$$$", "setHost(const QString&, quint16, const QString&, const QString&)", typeof(void), typeof(string), host, typeof(ushort), port, typeof(string), user, typeof(string), passwd);
			}
			/// <remarks>
			///  Clear host info.
			///          </remarks>		<short>    Clear host info.</short>
			public void ResetHost() {
				interceptor.Invoke("resetHost", "resetHost()", typeof(void));
			}
			/// <remarks>
			///  Configure slave
			///          </remarks>		<short>    Configure slave          </short>
			[SmokeMethod("setConfig(const KIO::MetaData&)")]
			public virtual void SetConfig(KIO.MetaData config) {
				interceptor.Invoke("setConfig#", "setConfig(const KIO::MetaData&)", typeof(void), typeof(KIO.MetaData), config);
			}
			/// <remarks>
			///  The protocol this slave handles.
			/// </remarks>		<return> name of protocol handled by this slave, as seen by the user
			///          </return>
			/// 		<short>    The protocol this slave handles.</short>
			public string Protocol() {
				return (string) interceptor.Invoke("protocol", "protocol()", typeof(string));
			}
			public void SetProtocol(string protocol) {
				interceptor.Invoke("setProtocol$", "setProtocol(const QString&)", typeof(void), typeof(string), protocol);
			}
			/// <remarks>
			///  The actual protocol used to handle the request.
			///  This method will return a different protocol than
			///  the one obtained by using protocol() if a
			///  proxy-server is used for the given protocol.  This
			///  usually means that this method will return "http"
			///  when the actuall request was to retrieve a resource
			///  from an "ftp" server by going through a proxy server.
			/// </remarks>		<return> the actual protocol (io-slave) that handled the request
			///          </return>
			/// 		<short>    The actual protocol used to handle the request.</short>
			public string SlaveProtocol() {
				return (string) interceptor.Invoke("slaveProtocol", "slaveProtocol()", typeof(string));
			}
			/// <remarks>
			/// </remarks>		<return> Host this slave is (was?) connected to
			///          </return>
			/// 		<short>   </short>
			public string Host() {
				return (string) interceptor.Invoke("host", "host()", typeof(string));
			}
			/// <remarks>
			/// </remarks>		<return> port this slave is (was?) connected to
			///          </return>
			/// 		<short>   </short>
			public ushort Port() {
				return (ushort) interceptor.Invoke("port", "port()", typeof(ushort));
			}
			/// <remarks>
			/// </remarks>		<return> User this slave is (was?) logged in as
			///          </return>
			/// 		<short>   </short>
			public string User() {
				return (string) interceptor.Invoke("user", "user()", typeof(string));
			}
			/// <remarks>
			/// </remarks>		<return> Passwd used to log in
			///          </return>
			/// 		<short>   </short>
			public string Passwd() {
				return (string) interceptor.Invoke("passwd", "passwd()", typeof(string));
			}
			/// <remarks>
			///  Suspends the operation of the attached kioslave.
			/// 	 </remarks>		<short>    Suspends the operation of the attached kioslave.</short>
			[SmokeMethod("suspend()")]
			public virtual void Suspend() {
				interceptor.Invoke("suspend", "suspend()", typeof(void));
			}
			/// <remarks>
			///  Resumes the operation of the attached kioslave.
			/// 	 </remarks>		<short>    Resumes the operation of the attached kioslave.</short>
			[SmokeMethod("resume()")]
			public virtual void Resume() {
				interceptor.Invoke("resume", "resume()", typeof(void));
			}
			/// <remarks>
			///  Tells wether the kioslave is suspended.
			/// </remarks>		<return> true if the kioslave is suspended.
			/// 	 </return>
			/// 		<short>    Tells wether the kioslave is suspended.</short>
			[SmokeMethod("suspended()")]
			public virtual bool Suspended() {
				return (bool) interceptor.Invoke("suspended", "suspended()", typeof(bool));
			}
			/// <remarks>
			///  Sends the given command to the kioslave.
			/// <param> name="cmd" command id
			/// </param><param> name="arr" byte array containing data
			/// 	 </param></remarks>		<short>    Sends the given command to the kioslave.</short>
			[SmokeMethod("send(int, const QByteArray&)")]
			public virtual void Send(int cmd, QByteArray arr) {
				interceptor.Invoke("send$#", "send(int, const QByteArray&)", typeof(void), typeof(int), cmd, typeof(QByteArray), arr);
			}
			[SmokeMethod("send(int)")]
			public virtual void Send(int cmd) {
				interceptor.Invoke("send$", "send(int)", typeof(void), typeof(int), cmd);
			}
			/// <remarks>
			///  Puts the kioslave associated with <code>url</code> at halt.
			/// 	 </remarks>		<short>    Puts the kioslave associated with <code>url</code> at halt.</short>
			[SmokeMethod("hold(const KUrl&)")]
			public virtual void Hold(KUrl url) {
				interceptor.Invoke("hold#", "hold(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			/// </remarks>		<return> The time this slave has been idle.
			/// 	 </return>
			/// 		<short>   </short>
			public int IdleTime() {
				return (int) interceptor.Invoke("idleTime", "idleTime()", typeof(int));
			}
			/// <remarks>
			///  Marks this slave as idle.
			/// 	 </remarks>		<short>    Marks this slave as idle.</short>
			public void SetIdle() {
				interceptor.Invoke("setIdle", "setIdle()", typeof(void));
			}
			public bool IsConnected() {
				return (bool) interceptor.Invoke("isConnected", "isConnected()", typeof(bool));
			}
			public void SetConnected(bool c) {
				interceptor.Invoke("setConnected$", "setConnected(bool)", typeof(void), typeof(bool), c);
			}
			public void Ref() {
				interceptor.Invoke("ref", "ref()", typeof(void));
			}
			public void Deref() {
				interceptor.Invoke("deref", "deref()", typeof(void));
			}
			[Q_SLOT("void accept()")]
			public void Accept() {
				interceptor.Invoke("accept", "accept()", typeof(void));
			}
			[Q_SLOT("void gotInput()")]
			public void GotInput() {
				interceptor.Invoke("gotInput", "gotInput()", typeof(void));
			}
			[Q_SLOT("void timeout()")]
			public void Timeout() {
				interceptor.Invoke("timeout", "timeout()", typeof(void));
			}
			/// <remarks>
			///  Creates a new slave.
			/// <param> name="protocol" the protocol
			/// </param><param> name="url" is the url
			/// </param><param> name="error" is the error code on failure and undefined else.
			/// </param><param> name="error_text" is the error text on failure and undefined else.
			/// </param></remarks>		<return> 0 on failure, or a pointer to a slave otherwise.
			/// 	 </return>
			/// 		<short>    Creates a new slave.</short>
			public static KIO.Slave CreateSlave(string protocol, KUrl url, ref int error, StringBuilder error_text) {
				StackItem[] stack = new StackItem[5];
	#if DEBUG
				stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(protocol);
	#else
				stack[1].s_class = (IntPtr) GCHandle.Alloc(protocol);
	#endif
	#if DEBUG
				stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(url);
	#else
				stack[2].s_class = (IntPtr) GCHandle.Alloc(url);
	#endif
				stack[3].s_int = error;
	#if DEBUG
				stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(error_text);
	#else
				stack[4].s_class = (IntPtr) GCHandle.Alloc(error_text);
	#endif
				staticInterceptor.Invoke("createSlave$#$$", "createSlave(const QString&, const KUrl&, int&, QString&)", stack);
	#if DEBUG
				DebugGCHandle.Free((GCHandle) stack[1].s_class);
	#else
				((GCHandle) stack[1].s_class).Free();
	#endif
	#if DEBUG
				DebugGCHandle.Free((GCHandle) stack[2].s_class);
	#else
				((GCHandle) stack[2].s_class).Free();
	#endif
				error = stack[3].s_int;
	#if DEBUG
				DebugGCHandle.Free((GCHandle) stack[4].s_class);
	#else
				((GCHandle) stack[4].s_class).Free();
	#endif
				return (KIO.Slave) Enum.ToObject(typeof(KIO.Slave), stack[0].s_int);
			}
			public static KIO.Slave HoldSlave(string protocol, KUrl url) {
				return (KIO.Slave) staticInterceptor.Invoke("holdSlave$#", "holdSlave(const QString&, const KUrl&)", typeof(KIO.Slave), typeof(string), protocol, typeof(KUrl), url);
			}
			protected new ISlaveSignals Emit {
				get { return (ISlaveSignals) Q_EMIT; }
			}
		}

		public interface ISlaveSignals : KIO.ISlaveInterfaceSignals {
		[Q_SIGNAL("void slaveDied(KIO::Slave*)")]
		void SlaveDied(KIO.Slave slave);
		}

		/// <remarks>
		///  SlaveConfig
		///  This class manages the configuration for io-slaves based on protocol
		///  and host. The Scheduler makes use of this class to configure the slave
		///  whenever it has to connect to a new host.
		///  You only need to use this class if you want to override specific
		///  configuration items of an io-slave when the io-slave is used by
		///  your application. 
		///  Normally io-slaves are being configured by "kio_<protocol>rc" 
		///  configuration files. Groups defined in such files are treated as host 
		///  or domain specification. Configuration items defined in a group are 
		///  only applied when the slave is connecting with a host that matches with 
		///  the host and/or domain specified by the group.
		///       See <see cref="ISlaveConfigSignals"></see> for signals emitted by SlaveConfig
		/// </remarks>		<short>    SlaveConfig </short>

		[SmokeClass("KIO::SlaveConfig")]
		public class SlaveConfig : QObject {
	 		protected SlaveConfig(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(SlaveConfig), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static SlaveConfig() {
				staticInterceptor = new SmokeInvocation(typeof(SlaveConfig), null);
			}
			/// <remarks>
			///  Configure slaves of type <code>protocol</code> by setting <code>key</code> to <code>value.</code>
			///  If <code>host</code> is specified the configuration only applies when dealing
			///  with <code>host.</code>
			///  Changes made to the slave configuration only apply to slaves
			///  used by the current process.
			///          </remarks>		<short>    Configure slaves of type <code>protocol</code> by setting <code>key</code> to <code>value.</code></short>
			public void SetConfigData(string protocol, string host, string key, string value) {
				interceptor.Invoke("setConfigData$$$$", "setConfigData(const QString&, const QString&, const QString&, const QString&)", typeof(void), typeof(string), protocol, typeof(string), host, typeof(string), key, typeof(string), value);
			}
			/// <remarks>
			///  Configure slaves of type <code>protocol</code> with <code>config.</code>
			///  If <code>host</code> is specified the configuration only applies when dealing
			///  with <code>host.</code>
			///  Changes made to the slave configuration only apply to slaves
			///  used by the current process.
			///          </remarks>		<short>    Configure slaves of type <code>protocol</code> with <code>config.</code></short>
			public void SetConfigData(string protocol, string host, KIO.MetaData config) {
				interceptor.Invoke("setConfigData$$#", "setConfigData(const QString&, const QString&, const KIO::MetaData&)", typeof(void), typeof(string), protocol, typeof(string), host, typeof(KIO.MetaData), config);
			}
			/// <remarks>
			///  Query slave configuration for slaves of type <code>protocol</code> when
			///  dealing with <code>host.</code>
			///          </remarks>		<short>    Query slave configuration for slaves of type <code>protocol</code> when  dealing with <code>host.</code></short>
			public KIO.MetaData ConfigData(string protocol, string host) {
				return (KIO.MetaData) interceptor.Invoke("configData$$", "configData(const QString&, const QString&)", typeof(KIO.MetaData), typeof(string), protocol, typeof(string), host);
			}
			/// <remarks>
			///  Query a specific configuration key for slaves of type <code>protocol</code> when
			///  dealing with <code>host.</code>
			///          </remarks>		<short>    Query a specific configuration key for slaves of type <code>protocol</code> when  dealing with <code>host.</code></short>
			public string ConfigData(string protocol, string host, string key) {
				return (string) interceptor.Invoke("configData$$$", "configData(const QString&, const QString&, const QString&)", typeof(string), typeof(string), protocol, typeof(string), host, typeof(string), key);
			}
			/// <remarks>
			///  Undo any changes made by calls to setConfigData.
			///          </remarks>		<short>    Undo any changes made by calls to setConfigData.</short>
			public void Reset() {
				interceptor.Invoke("reset", "reset()", typeof(void));
			}
			public SlaveConfig() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("SlaveConfig", "SlaveConfig()", typeof(void));
			}
			public static KIO.SlaveConfig Self() {
				return (KIO.SlaveConfig) staticInterceptor.Invoke("self", "self()", typeof(KIO.SlaveConfig));
			}
			protected new ISlaveConfigSignals Emit {
				get { return (ISlaveConfigSignals) Q_EMIT; }
			}
		}

		public interface ISlaveConfigSignals : IQObjectSignals {
		/// <remarks>
		///  This signal is raised when a slave of type <code>protocol</code> deals
		///  with <code>host</code> for the first time.
		///  Your application can use this signal to make some last minute
		///  configuration changes with setConfigData based on the
		///  host.
		///          </remarks>		<short>    This signal is raised when a slave of type <code>protocol</code> deals  with <code>host</code> for the first time.</short>
		[Q_SIGNAL("void configNeeded(const QString&, const QString&)")]
		void ConfigNeeded(string protocol, string host);
		}

		/// <remarks>
		///  </remarks>		<short>   </short>

		[SmokeClass("KIO::SessionData")]
		public class SessionData : QObject, IDisposable {
	 		protected SessionData(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(SessionData), this);
			}
			public SessionData() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("SessionData", "SessionData()", typeof(void));
			}
			[SmokeMethod("configDataFor(KIO::MetaData&, const QString&, const QString&)")]
			public virtual void ConfigDataFor(KIO.MetaData configData, string proto, string host) {
				interceptor.Invoke("configDataFor#$$", "configDataFor(KIO::MetaData&, const QString&, const QString&)", typeof(void), typeof(KIO.MetaData), configData, typeof(string), proto, typeof(string), host);
			}
			[SmokeMethod("reset()")]
			public virtual void Reset() {
				interceptor.Invoke("reset", "reset()", typeof(void));
			}
			~SessionData() {
				interceptor.Invoke("~SessionData", "~SessionData()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~SessionData", "~SessionData()", typeof(void));
			}
			protected new ISessionDataSignals Emit {
				get { return (ISessionDataSignals) Q_EMIT; }
			}
		}

		public interface ISessionDataSignals : IQObjectSignals {
		}

		/// <remarks>
		///  MetaData is a simple map of key/value strings.
		///  </remarks>		<short>    MetaData is a simple map of key/value strings.</short>

		[SmokeClass("KIO::MetaData")]
		public class MetaData : Object, IDisposable {
			protected SmokeInvocation interceptor = null;
			private IntPtr smokeObject;
			protected MetaData(Type dummy) {}
			protected void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(MetaData), this);
			}
			/// <remarks>
			///  Creates an empty meta data map.
			///    </remarks>		<short>    Creates an empty meta data map.</short>
			public MetaData() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaData", "MetaData()", typeof(void));
			}
			/// <remarks>
			///  Copy constructor.
			///    </remarks>		<short>    Copy constructor.</short>
			public MetaData(Dictionary<string, string> metaData) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaData?", "MetaData(const QMap<QString, QString>&)", typeof(void), typeof(Dictionary<string, string>), metaData);
			}
			~MetaData() {
				interceptor.Invoke("~MetaData", "~MetaData()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~MetaData", "~MetaData()", typeof(void));
			}
		}

		/// <remarks>
		///  Net Transparency.
		///  NetAccess allows you to do simple file operation (load, save,
		///  copy, delete...) without working with KIO.Job directly.
		///  Whereas a KIO.Job is asynchronous, meaning that the
		///  developer has to connect slots for it, KIO.NetAccess provides
		///  synchronous downloads and uploads, as well as temporary file
		///  creation and removal. The functions appear to be blocking,
		///  but the Qt event loop continues running while the operations
		///  are handled. This means that the GUI will not freeze.
		///  This class isn't meant to be used as a class but only as a simple
		///  namespace for static functions, though an instance of the class
		///  is built for internal purposes.
		///  Port to kio done by David Faure, faure@kde.org
		/// </remarks>		<short> Provides an easy, synchronous interface to KIO file operations.    </short>

		[SmokeClass("KIO::NetAccess")]
		public class NetAccess : QObject {
	 		protected NetAccess(Type dummy) : base((Type) null) {}
			private static SmokeInvocation staticInterceptor = null;
			static NetAccess() {
				staticInterceptor = new SmokeInvocation(typeof(NetAccess), null);
			}
			// bool exists(const KUrl& arg1,KIO::NetAccess::StatSide arg2,QWidget* arg3); >>>> NOT CONVERTED
			/// <remarks>
			///  Downloads a file from an arbitrary URL (<code>src</code>) to a
			///  temporary file on the local filesystem (<code>target</code>).
			///  If the argument
			///  for <code>target</code> is an empty string, download will generate a
			///  unique temporary filename in /tmp. Since <code>target</code> is a reference
			///  to string you can access this filename easily. Download will
			///  return true if the download was successful, otherwise false.
			///  Special case:
			///  If the URL is of kind file:, then no downloading is
			///  processed but the full filename is returned in <code>target.</code>
			///  That means you <b>have</b> to take care about the <code>target</code> argument.
			///  (This is very easy to do, please see the example below.)
			///  Download is synchronous. That means you can use it like
			///  this, (assuming <code>u</code> is a string which represents a URL and your
			///  application has a loadFile() function):
			///  <pre>
			///  string tmpFile;
			///  if( KIO.NetAccess.Download( u, tmpFile, window ) )
			///  {
			///    loadFile( tmpFile );
			///    KIO.NetAccess.RemoveTempFile( tmpFile );
			///  } else {
			///    KMessageBox.Error(this, KIO.NetAccess.LastErrorString() );
			///  }
			///  </pre>
			///  Of course, your user interface will still process exposure/repaint
			///  events during the download.
			///  If the download fails, lastError() and lastErrorString() will be set.
			/// <param> name="src" URL Reference to the file to download.
			/// </param><param> name="target" String containing the final local location of the
			///                file.  If you insert an empty string, it will
			///                return a location in a temporary spot. <B>Note:</B>
			///                you are responsible for the removal of this file when
			///                you are finished reading it using removeTempFile.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param></remarks>		<return> true if successful, false for failure.  Use lastErrorString() to
			///          get the reason it failed.
			/// </return>
			/// 		<short>    Downloads a file from an arbitrary URL (<code>src</code>) to a  temporary file on the local filesystem (<code>target</code>).</short>
			/// 		<see> lastErrorString</see>
			public static bool Download(KUrl src, StringBuilder target, QWidget window) {
				return (bool) staticInterceptor.Invoke("download#$#", "download(const KUrl&, QString&, QWidget*)", typeof(bool), typeof(KUrl), src, typeof(StringBuilder), target, typeof(QWidget), window);
			}
			/// <remarks>
			///  Removes the specified file if and only if it was created
			///  by KIO.NetAccess as a temporary file for a former download.
			///  Note: This means that if you created your temporary with KTempFile,
			///  use KTempFile.Unlink() or KTempFile.SetAutoDelete() to have
			///  it removed.
			/// <param> name="name" Path to temporary file to remove.  May not be
			///              empty.
			///      </param></remarks>		<short>    Removes the specified file if and only if it was created  by KIO.NetAccess as a temporary file for a former download.</short>
			public static void RemoveTempFile(string name) {
				staticInterceptor.Invoke("removeTempFile$", "removeTempFile(const QString&)", typeof(void), typeof(string), name);
			}
			/// <remarks>
			///  Uploads file <code>src</code> to URL <code>target.</code>
			///  Both must be specified, unlike download.
			///  Note that this is assumed to be used for saving a file over
			///  the network, so overwriting is set to true. This is not the
			///  case with copy.
			/// <param> name="src" URL Referencing the file to upload.
			/// </param><param> name="target" URL containing the final location of the file.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be cached
			///                only for a short duration after which the user will again be
			///                prompted for passwords as needed.
			/// </param></remarks>		<return> true if successful, false for failure
			///      </return>
			/// 		<short>    Uploads file <code>src</code> to URL <code>target.</code></short>
			public static bool Upload(string src, KUrl target, QWidget window) {
				return (bool) staticInterceptor.Invoke("upload$##", "upload(const QString&, const KUrl&, QWidget*)", typeof(bool), typeof(string), src, typeof(KUrl), target, typeof(QWidget), window);
			}
			/// <remarks>
			///  Alternative to upload for copying over the network.
			///  Overwrite is false, so this will fail if <code>target</code> exists.
			///  This one takes two URLs and is a direct equivalent of KIO.File_copy.
			/// <param> name="src" URL Referencing the file to upload.
			/// </param><param> name="target" URL containing the final location of the file.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be cached
			///                only for a short duration after which the user will again be
			///                prompted for passwords as needed.
			/// </param></remarks>		<return> true if successful, false for failure
			///      </return>
			/// 		<short>    Alternative to upload for copying over the network.</short>
			public static bool File_copy(KUrl src, KUrl target, QWidget window) {
				return (bool) staticInterceptor.Invoke("file_copy###", "file_copy(const KUrl&, const KUrl&, QWidget*)", typeof(bool), typeof(KUrl), src, typeof(KUrl), target, typeof(QWidget), window);
			}
			public static bool File_copy(KUrl src, KUrl target) {
				return (bool) staticInterceptor.Invoke("file_copy##", "file_copy(const KUrl&, const KUrl&)", typeof(bool), typeof(KUrl), src, typeof(KUrl), target);
			}
			/// <remarks>
			///  Alternative method for copying over the network.
			///  This one takes two URLs and is a direct equivalent
			///  of KIO.Copy!.
			///  This means that it can copy files and directories alike
			///  (it should have been named copy()).
			///  This method will bring up a dialog if the destination already exists.
			/// <param> name="src" URL Referencing the file to upload.
			/// </param><param> name="target" URL containing the final location of the
			///                file.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be cached
			///                only for a short duration after which the user will again be
			///                prompted for passwords as needed.
			/// </param></remarks>		<return> true if successful, false for failure
			///      </return>
			/// 		<short>    Alternative method for copying over the network.</short>
			public static bool Dircopy(KUrl src, KUrl target, QWidget window) {
				return (bool) staticInterceptor.Invoke("dircopy###", "dircopy(const KUrl&, const KUrl&, QWidget*)", typeof(bool), typeof(KUrl), src, typeof(KUrl), target, typeof(QWidget), window);
			}
			/// <remarks>
			///  Overloaded method, which takes a list of source URLs
			///      </remarks>		<short>    Overloaded method, which takes a list of source URLs      </short>
			public static bool Dircopy(List<KUrl> src, KUrl target, QWidget window) {
				return (bool) staticInterceptor.Invoke("dircopy?##", "dircopy(const KUrl::List&, const KUrl&, QWidget*)", typeof(bool), typeof(List<KUrl>), src, typeof(KUrl), target, typeof(QWidget), window);
			}
			public static bool Dircopy(List<KUrl> src, KUrl target) {
				return (bool) staticInterceptor.Invoke("dircopy?#", "dircopy(const KUrl::List&, const KUrl&)", typeof(bool), typeof(List<KUrl>), src, typeof(KUrl), target);
			}
			/// <remarks>
			///  Tests whether a URL exists.
			/// <param> name="url" the URL we are testing
			/// </param><param> name="statSide" determines if we want to read or write.
			///  IMPORTANT: see documentation for KIO.Stat for more details about this.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param></remarks>		<return> true if the URL exists and we can do the operation specified by
			///               <code>source</code>, false otherwise
			///      </return>
			/// 		<short>    Tests whether a URL exists.</short>
			/// <remarks>
			///  Tests whether a URL exists and return information on it.
			///  This is a convenience function for KIO.Stat
			///  (it saves creating a slot and testing for the job result).
			/// <param> name="url" The URL we are testing.
			/// </param><param> name="entry" The result of the stat. Iterate over the list
			///  of atoms to get hold of name, type, size, etc., or use KFileItem.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param></remarks>		<return> true if successful, false for failure
			///      </return>
			/// 		<short>    Tests whether a URL exists and return information on it.</short>
			public static bool Stat(KUrl url, KIO.UDSEntry entry, QWidget window) {
				return (bool) staticInterceptor.Invoke("stat###", "stat(const KUrl&, KIO::UDSEntry&, QWidget*)", typeof(bool), typeof(KUrl), url, typeof(KIO.UDSEntry), entry, typeof(QWidget), window);
			}
			/// <remarks>
			///  Tries to map a local URL for the given URL.
			///  This is a convenience function for KIO.Stat + parsing the
			///  resulting UDSEntry.
			/// <param> name="url" The URL we are testing.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param></remarks>		<return> a local URL corresponding to the same ressource than the
			///          original URL, or the original URL if no local URL can be mapped
			///      </return>
			/// 		<short>    Tries to map a local URL for the given URL.</short>
			public static KUrl MostLocalUrl(KUrl url, QWidget window) {
				return (KUrl) staticInterceptor.Invoke("mostLocalUrl##", "mostLocalUrl(const KUrl&, QWidget*)", typeof(KUrl), typeof(KUrl), url, typeof(QWidget), window);
			}
			/// <remarks>
			///  Deletes a file or a directory in a synchronous way.
			///  This is a convenience function for KIO.Del
			///  (it saves creating a slot and testing for the job result).
			/// <param> name="url" The file or directory to delete.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param></remarks>		<return> true on success, false on failure.
			///      </return>
			/// 		<short>    Deletes a file or a directory in a synchronous way.</short>
			public static bool Del(KUrl url, QWidget window) {
				return (bool) staticInterceptor.Invoke("del##", "del(const KUrl&, QWidget*)", typeof(bool), typeof(KUrl), url, typeof(QWidget), window);
			}
			/// <remarks>
			///  Creates a directory in a synchronous way.
			///  This is a convenience function for <code>KIO</code>.Mkdir
			///  (it saves creating a slot and testing for the job result).
			/// <param> name="url" The directory to create.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param><param> name="permissions" directory permissions.
			/// </param></remarks>		<return> true on success, false on failure.
			///      </return>
			/// 		<short>    Creates a directory in a synchronous way.</short>
			public static bool Mkdir(KUrl url, QWidget window, int permissions) {
				return (bool) staticInterceptor.Invoke("mkdir##$", "mkdir(const KUrl&, QWidget*, int)", typeof(bool), typeof(KUrl), url, typeof(QWidget), window, typeof(int), permissions);
			}
			public static bool Mkdir(KUrl url, QWidget window) {
				return (bool) staticInterceptor.Invoke("mkdir##", "mkdir(const KUrl&, QWidget*)", typeof(bool), typeof(KUrl), url, typeof(QWidget), window);
			}
			/// <remarks>
			///  Executes a remote process via the fish ioslave in a synchronous way.
			/// <param> name="url" The remote machine where the command should be executed.
			///             e.g. fish://someuser\@somehost:sshport/
			///             some special cases exist.
			///             fish://someuser\@localhost/
			///             will use su instead of ssh to connect and execute the command.
			///             fish://someuser\@localhost:port/
			///             will use ssh to connect and execute the command.
			/// </param><param> name="command" The command to be executed.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param></remarks>		<return> The resulting output of the <code>command</code> that is executed.
			///      </return>
			/// 		<short>    Executes a remote process via the fish ioslave in a synchronous way.</short>
			public static string Fish_execute(KUrl url, string command, QWidget window) {
				return (string) staticInterceptor.Invoke("fish_execute#$#", "fish_execute(const KUrl&, const QString&, QWidget*)", typeof(string), typeof(KUrl), url, typeof(string), command, typeof(QWidget), window);
			}
			/// <remarks>
			///  This function executes a job in a synchronous way.
			///  If a job fetches some data, pass a QByteArray pointer as data parameter to this function
			///  and after the function returns it will contain all the data fetched by this job.
			///  @code
			///  KIO.Job job = KIO.Get( url );
			///  QMap<string, string> metaData;
			///  metaData.insert( "PropagateHttpHeader", "true" );
			///  if ( NetAccess.SynchronousRun( job, 0, &data, &url, &metaData ) ) {
			///    string responseHeaders = metaData[ "HTTP-Headers" ];
			///    kDebug()<<"Response header = "<< responseHeaders;
			///  }
			///  @endcode
			/// <param> name="job" job which the function will run. Note that after this function
			///             finishes running, job is deleted and you can't access it anymore!
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param><param> name="data" if passed and relevant to this job then it will contain the data
			///                that was fetched by the job
			/// </param><param> name="finalURL" if passed will contain the final url of this job (it might differ
			///                  from the one it was created with if there was a redirection)
			/// </param><param> name="metaData" you can pass a pointer to the map with meta data you wish to
			///                  set on the job. After the job finishes this map will hold all the
			///                  meta data from the job.
			/// </param></remarks>		<return> true on success, false on failure.
			///      </return>
			/// 		<short>    This function executes a job in a synchronous way.</short>
			public static bool SynchronousRun(KIO.Job job, QWidget window, QByteArray data, KUrl finalURL, StringBuilder metaData) {
				return (bool) staticInterceptor.Invoke("synchronousRun####?", "synchronousRun(KIO::Job*, QWidget*, QByteArray*, KUrl*, QMap<QString, QString>*)", typeof(bool), typeof(KIO.Job), job, typeof(QWidget), window, typeof(QByteArray), data, typeof(KUrl), finalURL, typeof(StringBuilder), metaData);
			}
			public static bool SynchronousRun(KIO.Job job, QWidget window, QByteArray data, KUrl finalURL) {
				return (bool) staticInterceptor.Invoke("synchronousRun####", "synchronousRun(KIO::Job*, QWidget*, QByteArray*, KUrl*)", typeof(bool), typeof(KIO.Job), job, typeof(QWidget), window, typeof(QByteArray), data, typeof(KUrl), finalURL);
			}
			public static bool SynchronousRun(KIO.Job job, QWidget window, QByteArray data) {
				return (bool) staticInterceptor.Invoke("synchronousRun###", "synchronousRun(KIO::Job*, QWidget*, QByteArray*)", typeof(bool), typeof(KIO.Job), job, typeof(QWidget), window, typeof(QByteArray), data);
			}
			public static bool SynchronousRun(KIO.Job job, QWidget window) {
				return (bool) staticInterceptor.Invoke("synchronousRun##", "synchronousRun(KIO::Job*, QWidget*)", typeof(bool), typeof(KIO.Job), job, typeof(QWidget), window);
			}
			/// <remarks>
			///  Determines the mimetype of a given URL.
			///  This is a convenience function for KIO.Mimetype.  You
			///  should call this only when really necessary.
			///  KMimeType.FindByUrl can determine extension a lot faster, but
			///  less reliably for remote files. Only when findByUrl() returns
			///  unknown (application/octet-stream) then this one should be
			///  used.
			/// <param> name="url" The URL whose mimetype we are interested in.
			/// </param><param> name="window" main window associated with this job. This is used to
			///                automatically cache and discard authentication information
			///                as needed. If NULL, authentication information will be
			///                cached only for a short duration after which the user will
			///                again be prompted for passwords as needed.
			/// </param></remarks>		<return> The mimetype name.
			///      </return>
			/// 		<short>    Determines the mimetype of a given URL.</short>
			public static string Mimetype(KUrl url, QWidget window) {
				return (string) staticInterceptor.Invoke("mimetype##", "mimetype(const KUrl&, QWidget*)", typeof(string), typeof(KUrl), url, typeof(QWidget), window);
			}
			/// <remarks>
			///  Returns the error string for the last job, in case it failed.
			///  Note that this is already translated.
			/// </remarks>		<return> the last error string, or string()
			///      </return>
			/// 		<short>    Returns the error string for the last job, in case it failed.</short>
			public static string LastErrorString() {
				return (string) staticInterceptor.Invoke("lastErrorString", "lastErrorString()", typeof(string));
			}
			/// <remarks>
			///  Returns the error code for the last job, in case it failed.
			/// </remarks>		<return> the last error code
			///      </return>
			/// 		<short>    Returns the error code for the last job, in case it failed.</short>
			public static int LastError() {
				return (int) staticInterceptor.Invoke("lastError", "lastError()", typeof(int));
			}
			protected new INetAccessSignals Emit {
				get { return (INetAccessSignals) Q_EMIT; }
			}
		}

		public interface INetAccessSignals : IQObjectSignals {
		}

		/// <remarks>
		///   The file-job is an asynchronious version of normal file handling.
		///   It allows block-wise reading and writing, and allows seeking. Results are returned through signals.
		///   Should always be created using KIO.Open(KUrl&)
		///   See <see cref="IFileJobSignals"></see> for signals emitted by FileJob
		/// </remarks>		<short>     The file-job is an asynchronious version of normal file handling.</short>

		[SmokeClass("KIO::FileJob")]
		public class FileJob : KIO.SimpleJob, IDisposable {
	 		protected FileJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(FileJob), this);
			}
			// void read(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void seek(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// KIO::filesize_t size(); >>>> NOT CONVERTED
			// KIO::FileJob* FileJob(KIO::FileJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Read block
			///  The slave emits the data through data().
			/// <param> name="size" the requested amount of data
			///      </param></remarks>		<short>    Read block </short>
			/// <remarks>
			///  Write block
			/// <param> name="data" the data to write
			///      </param></remarks>		<short>    Write block </short>
			public void Write(QByteArray data) {
				interceptor.Invoke("write#", "write(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Close
			///  Closes the file-slave
			///      </remarks>		<short>    Close </short>
			public void Close() {
				interceptor.Invoke("close", "close()", typeof(void));
			}
			/// <remarks>
			///  Seek
			///  The slave emits position()
			/// <param> name="offset" the position from start to go to
			///      </param></remarks>		<short>    Seek </short>
			/// <remarks>
			///  Size
			/// </remarks>		<return> the file size
			///      </return>
			/// 		<short>    Size </short>
			~FileJob() {
				interceptor.Invoke("~FileJob", "~FileJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~FileJob", "~FileJob()", typeof(void));
			}
			protected new IFileJobSignals Emit {
				get { return (IFileJobSignals) Q_EMIT; }
			}
		}

		public interface IFileJobSignals : KIO.ISimpleJobSignals {
		/// <remarks>
		///  Data from the slave has arrived.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="data" data received from the slave.
		///      </param></remarks>		<short>    Data from the slave has arrived.</short>
		[Q_SIGNAL("void data(KIO::Job*, const QByteArray&)")]
		void Data(KIO.Job job, QByteArray data);
		/// <remarks>
		///  Signals the file is a redirection.
		///  Follow this url manually to reach data
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="url" the new URL
		///      </param></remarks>		<short>    Signals the file is a redirection.</short>
		[Q_SIGNAL("void redirection(KIO::Job*, const KUrl&)")]
		void Redirection(KIO.Job job, KUrl url);
		/// <remarks>
		///  Mimetype determined.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="type" the mime type
		///      </param></remarks>		<short>    Mimetype determined.</short>
		[Q_SIGNAL("void mimetype(KIO::Job*, const QString&)")]
		void Mimetype(KIO.Job job, string type);
		/// <remarks>
		///  File is open, metadata has been determined and the
		///  file-slave is ready to receive commands.
		/// <param> name="job" the job that emitted this signal
		///      </param></remarks>		<short>    File is open, metadata has been determined and the  file-slave is ready to receive commands.</short>
		[Q_SIGNAL("void open(KIO::Job*)")]
		void Open(KIO.Job job);
		// void written(KIO::Job* arg1,KIO::filesize_t arg2); >>>> NOT CONVERTED
		/// <remarks>
		///  File is closed and will accept no more commands
		/// <param> name="job" the job that emitted this signal
		///      </param></remarks>		<short>    File is closed and will accept no more commands </short>
		[Q_SIGNAL("void close(KIO::Job*)")]
		void Close(KIO.Job job);
		// void position(KIO::Job* arg1,KIO::filesize_t arg2); >>>> NOT CONVERTED
		}

		/// <remarks>
		///  The KIO.Scheduler manages io-slaves for the application.
		///  It also queues jobs and assigns the job to a slave when one
		///  becomes available.
		///  There are 3 possible ways for a job to get a slave:
		///  <h3>1. Direct</h3>
		///  This is the default. When you create a job the
		///  KIO.Scheduler will be notified and will find either an existing
		///  slave that is idle or it will create a new slave for the job.
		///  Example:
		///  <pre>
		///     TransferJob job = KIO.Get(KUrl("http://www.kde.org"));
		///  </pre>
		///  <h3>2. Scheduled</h3>
		///  If you create a lot of jobs, you might want not want to have a
		///  slave for each job. If you schedule a job, a maximum number
		///  of slaves will be created. When more jobs arrive, they will be
		///  queued. When a slave is finished with a job, it will be assigned
		///  a job from the queue.
		///  Example:
		///  <pre>
		///     TransferJob job = KIO.Get(KUrl("http://www.kde.org"));
		///     KIO.Scheduler.ScheduleJob(job);
		///  </pre>
		///  <h3>3. Connection Oriented</h3>
		///  For some operations it is important that multiple jobs use
		///  the same connection. This can only be ensured if all these jobs
		///  use the same slave.
		///  You can ask the scheduler to open a slave for connection oriented
		///  operations. You can then use the scheduler to assign jobs to this
		///  slave. The jobs will be queued and the slave will handle these jobs
		///  one after the other.
		///  Example:
		///  <pre>
		///     Slave slave = KIO.Scheduler.GetConnectedSlave(
		///             KUrl("pop3://bastian:password@mail.kde.org"));
		///     TransferJob job1 = KIO.Get(
		///             KUrl("pop3://bastian:password@mail.kde.org/msg1"));
		///     KIO.Scheduler.AssignJobToSlave(slave, job1);
		///     TransferJob job2 = KIO.Get(
		///             KUrl("pop3://bastian:password@mail.kde.org/msg2"));
		///     KIO.Scheduler.AssignJobToSlave(slave, job2);
		///     TransferJob job3 = KIO.Get(
		///             KUrl("pop3://bastian:password@mail.kde.org/msg3"));
		///     KIO.Scheduler.AssignJobToSlave(slave, job3);
		///     // ... Wait for jobs to finish...
		///     KIO.Scheduler.DisconnectSlave(slave);
		///  </pre>
		///  Note that you need to explicitly disconnect the slave when the
		///  connection goes down, so your error handler should contain:
		///  <pre>
		///     if (error == KIO.ERR_CONNECTION_BROKEN)
		///         KIO.Scheduler.DisconnectSlave(slave);
		///  </pre>
		/// </remarks>		<short>    The KIO.Scheduler manages io-slaves for the application.</short>
		/// 		<see> Slave</see>
		/// 		<see> Job</see>

		[SmokeClass("KIO::Scheduler")]
		public class Scheduler : QObject {
	 		protected Scheduler(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(Scheduler), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static Scheduler() {
				staticInterceptor = new SmokeInvocation(typeof(Scheduler), null);
			}
			public bool Connect(QObject sender, string signal, string member) {
				return (bool) interceptor.Invoke("connect#$$", "connect(const QObject*, const char*, const char*)", typeof(bool), typeof(QObject), sender, typeof(string), signal, typeof(string), member);
			}
			/// <remarks>
			///  Register <code>job</code> with the scheduler.
			///  The default is to create a new slave for the job if no slave
			///  is available. This can be changed by calling scheduleJob.
			/// <param> name="job" the job to register
			///          </param></remarks>		<short>    Register <code>job</code> with the scheduler.</short>
			public static void DoJob(KIO.SimpleJob job) {
				staticInterceptor.Invoke("doJob#", "doJob(KIO::SimpleJob*)", typeof(void), typeof(KIO.SimpleJob), job);
			}
			/// <remarks>
			///  Calling ths function makes that <code>job</code> gets scheduled for later
			///  execution, if multiple jobs are registered it might wait for
			///  other jobs to finish.
			/// <param> name="job" the job to schedule
			///          </param></remarks>		<short>    Calling ths function makes that <code>job</code> gets scheduled for later  execution, if multiple jobs are registered it might wait for  other jobs to finish.</short>
			public static void ScheduleJob(KIO.SimpleJob job) {
				staticInterceptor.Invoke("scheduleJob#", "scheduleJob(KIO::SimpleJob*)", typeof(void), typeof(KIO.SimpleJob), job);
			}
			/// <remarks>
			///  Stop the execution of a job.
			/// <param> name="job" the job to cancel
			///          </param></remarks>		<short>    Stop the execution of a job.</short>
			public static void CancelJob(KIO.SimpleJob job) {
				staticInterceptor.Invoke("cancelJob#", "cancelJob(KIO::SimpleJob*)", typeof(void), typeof(KIO.SimpleJob), job);
			}
			/// <remarks>
			///  Called when a job is done.
			/// <param> name="job" the finished job
			/// </param><param> name="slave" the slave that executed the <code>job</code>
			///          </param></remarks>		<short>    Called when a job is done.</short>
			public static void JobFinished(KIO.SimpleJob job, KIO.Slave slave) {
				staticInterceptor.Invoke("jobFinished##", "jobFinished(KIO::SimpleJob*, KIO::Slave*)", typeof(void), typeof(KIO.SimpleJob), job, typeof(KIO.Slave), slave);
			}
			/// <remarks>
			///  Puts a slave on notice. A next job may reuse this slave if it
			///  requests the same URL.
			///  A job can be put on hold after it has emit'ed its mimetype.
			///  Based on the mimetype, the program can give control to another
			///  component in the same process which can then resume the job
			///  by simply asking for the same URL again.
			/// <param> name="job" the job that should be stopped
			/// </param><param> name="url" the URL that is handled by the <code>url</code>
			///          </param></remarks>		<short>    Puts a slave on notice.</short>
			public static void PutSlaveOnHold(KIO.SimpleJob job, KUrl url) {
				staticInterceptor.Invoke("putSlaveOnHold##", "putSlaveOnHold(KIO::SimpleJob*, const KUrl&)", typeof(void), typeof(KIO.SimpleJob), job, typeof(KUrl), url);
			}
			/// <remarks>
			///  Removes any slave that might have been put on hold. If a slave
			///  was put on hold it will be killed.
			///          </remarks>		<short>    Removes any slave that might have been put on hold.</short>
			public static void RemoveSlaveOnHold() {
				staticInterceptor.Invoke("removeSlaveOnHold", "removeSlaveOnHold()", typeof(void));
			}
			/// <remarks>
			///  Send the slave that was put on hold back to KLauncher. This
			///  allows another process to take over the slave and resume the job
			///  that was started.
			///          </remarks>		<short>    Send the slave that was put on hold back to KLauncher.</short>
			public static void PublishSlaveOnHold() {
				staticInterceptor.Invoke("publishSlaveOnHold", "publishSlaveOnHold()", typeof(void));
			}
			/// <remarks>
			///  Requests a slave for use in connection-oriented mode.
			/// <param> name="url" This defines the username,password,host & port to
			///             connect with.
			/// </param><param> name="config" Configuration data for the slave.
			/// </param></remarks>		<return> A pointer to a connected slave or 0 if an error occurred.
			/// </return>
			/// 		<short>    Requests a slave for use in connection-oriented mode.</short>
			/// 		<see> assignJobToSlave</see>
			/// 		<see> disconnectSlave</see>
			public static KIO.Slave GetConnectedSlave(KUrl url, KIO.MetaData config) {
				return (KIO.Slave) staticInterceptor.Invoke("getConnectedSlave##", "getConnectedSlave(const KUrl&, const KIO::MetaData&)", typeof(KIO.Slave), typeof(KUrl), url, typeof(KIO.MetaData), config);
			}
			public static KIO.Slave GetConnectedSlave(KUrl url) {
				return (KIO.Slave) staticInterceptor.Invoke("getConnectedSlave#", "getConnectedSlave(const KUrl&)", typeof(KIO.Slave), typeof(KUrl), url);
			}
			public static bool AssignJobToSlave(KIO.Slave slave, KIO.SimpleJob job) {
				return (bool) staticInterceptor.Invoke("assignJobToSlave##", "assignJobToSlave(KIO::Slave*, KIO::SimpleJob*)", typeof(bool), typeof(KIO.Slave), slave, typeof(KIO.SimpleJob), job);
			}
			public static bool DisconnectSlave(KIO.Slave slave) {
				return (bool) staticInterceptor.Invoke("disconnectSlave#", "disconnectSlave(KIO::Slave*)", typeof(bool), typeof(KIO.Slave), slave);
			}
			/// <remarks>
			///  Send the slave that was put on hold back to KLauncher. This
			///  allows another process to take over the slave and resume the job
			///  the that was started.
			///  Register the mainwindow <code>wid</code> with the KIO subsystem
			///  Do not call this, it is called automatically from
			///  void KIO.Job.SetWindow(QWidget).
			/// <param> name="wid" the window to register
			///          </param></remarks>		<short>    Send the slave that was put on hold back to KLauncher.</short>
			public static void RegisterWindow(QWidget wid) {
				staticInterceptor.Invoke("registerWindow#", "registerWindow(QWidget*)", typeof(void), typeof(QWidget), wid);
			}
			/// <remarks>
			///  Unregisters the window registered by registerWindow().
			///          </remarks>		<short>   </short>
			public static void UnregisterWindow(QObject wid) {
				staticInterceptor.Invoke("unregisterWindow#", "unregisterWindow(QObject*)", typeof(void), typeof(QObject), wid);
			}
			/// <remarks>
			///  Function to connect signals emitted by the scheduler.
			/// </remarks>		<short>    Function to connect signals emitted by the scheduler.</short>
			/// 		<see> slaveConnected</see>
			/// 		<see> slaveError</see>
			public static bool Connect(string signal, QObject receiver, string member) {
				return (bool) staticInterceptor.Invoke("connect$#$", "connect(const char*, const QObject*, const char*)", typeof(bool), typeof(string), signal, typeof(QObject), receiver, typeof(string), member);
			}
			public static new bool Connect(QObject sender, string signal, QObject receiver, string member) {
				return (bool) staticInterceptor.Invoke("connect#$#$", "connect(const QObject*, const char*, const QObject*, const char*)", typeof(bool), typeof(QObject), sender, typeof(string), signal, typeof(QObject), receiver, typeof(string), member);
			}
			public static new bool Disconnect(QObject sender, string signal, QObject receiver, string member) {
				return (bool) staticInterceptor.Invoke("disconnect#$#$", "disconnect(const QObject*, const char*, const QObject*, const char*)", typeof(bool), typeof(QObject), sender, typeof(string), signal, typeof(QObject), receiver, typeof(string), member);
			}
			/// <remarks>
			///  When true, the next job will check whether KLauncher has a slave
			///  on hold that is suitable for the job.
			/// <param> name="b" true when KLauncher has a job on hold
			///          </param></remarks>		<short>    When true, the next job will check whether KLauncher has a slave  on hold that is suitable for the job.</short>
			public static void CheckSlaveOnHold(bool b) {
				staticInterceptor.Invoke("checkSlaveOnHold$", "checkSlaveOnHold(bool)", typeof(void), typeof(bool), b);
			}
			public static void EmitReparseSlaveConfiguration() {
				staticInterceptor.Invoke("emitReparseSlaveConfiguration", "emitReparseSlaveConfiguration()", typeof(void));
			}
			protected new ISchedulerSignals Emit {
				get { return (ISchedulerSignals) Q_EMIT; }
			}
		}

		public interface ISchedulerSignals : IQObjectSignals {
		}

		/// <remarks>
		///  A UI delegate tuned to be used with KIO Jobs.
		///  It uses KIO.Observer to do the tracking.
		///  </remarks>		<short>    A UI delegate tuned to be used with KIO Jobs.</short>

		[SmokeClass("KIO::JobUiDelegate")]
		public class JobUiDelegate : KDialogJobUiDelegate, IDisposable {
	 		protected JobUiDelegate(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(JobUiDelegate), this);
			}
			// KIO::RenameDialog_Result askFileRename(KJob* arg1,const QString& arg2,const QString& arg3,const QString& arg4,KIO::RenameDialog_Mode arg5,QString& arg6,KIO::filesize_t arg7,KIO::filesize_t arg8,time_t arg9,time_t arg10,time_t arg11,time_t arg12); >>>> NOT CONVERTED
			// KIO::RenameDialog_Result askFileRename(KJob* arg1,const QString& arg2,const QString& arg3,const QString& arg4,KIO::RenameDialog_Mode arg5,QString& arg6,KIO::filesize_t arg7,KIO::filesize_t arg8,time_t arg9,time_t arg10,time_t arg11); >>>> NOT CONVERTED
			// KIO::RenameDialog_Result askFileRename(KJob* arg1,const QString& arg2,const QString& arg3,const QString& arg4,KIO::RenameDialog_Mode arg5,QString& arg6,KIO::filesize_t arg7,KIO::filesize_t arg8,time_t arg9,time_t arg10); >>>> NOT CONVERTED
			// KIO::RenameDialog_Result askFileRename(KJob* arg1,const QString& arg2,const QString& arg3,const QString& arg4,KIO::RenameDialog_Mode arg5,QString& arg6,KIO::filesize_t arg7,KIO::filesize_t arg8,time_t arg9); >>>> NOT CONVERTED
			// KIO::RenameDialog_Result askFileRename(KJob* arg1,const QString& arg2,const QString& arg3,const QString& arg4,KIO::RenameDialog_Mode arg5,QString& arg6,KIO::filesize_t arg7,KIO::filesize_t arg8); >>>> NOT CONVERTED
			// KIO::RenameDialog_Result askFileRename(KJob* arg1,const QString& arg2,const QString& arg3,const QString& arg4,KIO::RenameDialog_Mode arg5,QString& arg6,KIO::filesize_t arg7); >>>> NOT CONVERTED
			/// <remarks>
			///  Constructs a new KIO Job UI delegate.
			///      </remarks>		<short>    Constructs a new KIO Job UI delegate.</short>
			public JobUiDelegate() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("JobUiDelegate", "JobUiDelegate()", typeof(void));
			}
			/// <remarks>
			///  Associate this job with a window given by <code>window.</code>
			/// <param> name="window" the window to associate to
			/// </param></remarks>		<short>    Associate this job with a window given by <code>window.</code></short>
			/// 		<see> window</see>
			[SmokeMethod("setWindow(QWidget*)")]
			public override void SetWindow(QWidget window) {
				interceptor.Invoke("setWindow#", "setWindow(QWidget*)", typeof(void), typeof(QWidget), window);
			}
			/// <remarks>
			///  <see cref="KIO.RenameDialog"></see>
			///  Construct a modal, parent-less "rename" dialog, and return
			///  a result code, as well as the new dest. Much easier to use than the
			///  class RenameDialog directly.
			/// <param> name="caption" the caption for the dialog box
			/// </param><param> name="src" the URL of the file/dir we're trying to copy, as it's part of the text message
			/// </param><param> name="dest" the URL of the destination file/dir, i.e. the one that already exists
			/// </param><param> name="mode" parameters for the dialog (which buttons to show...),
			///              see RenameDialog_Mode
			/// </param><param> name="newDestPath" the new destination path, valid if R_RENAME was returned.
			/// </param><param> name="sizeSrc" size of source file
			/// </param><param> name="sizeDest" size of destination file
			/// </param><param> name="ctimeSrc" creation time of source file
			/// </param><param> name="ctimeDest" creation time of destination file
			/// </param><param> name="mtimeSrc" modification time of source file
			/// </param><param> name="mtimeDest" modification time of destination file
			/// </param></remarks>		<return> the result
			///      </return>
			/// 		<short>    <see cref="KIO.RenameDialog"></see>  Construct a modal, parent-less "rename" dialog, and return  a result code, as well as the new dest.</short>
			[SmokeMethod("askFileRename(KJob*, const QString&, const QString&, const QString&, KIO::RenameDialog_Mode, QString&)")]
			public virtual KIO.RenameDialog_Result AskFileRename(KJob job, string caption, string src, string dest, KIO.RenameDialog_Mode mode, StringBuilder newDest) {
				return (KIO.RenameDialog_Result) interceptor.Invoke("askFileRename#$$$$$", "askFileRename(KJob*, const QString&, const QString&, const QString&, KIO::RenameDialog_Mode, QString&)", typeof(KIO.RenameDialog_Result), typeof(KJob), job, typeof(string), caption, typeof(string), src, typeof(string), dest, typeof(KIO.RenameDialog_Mode), mode, typeof(StringBuilder), newDest);
			}
			/// <remarks>
			///  See skipdialog.h
			///      </remarks>		<short>   </short>
			[SmokeMethod("askSkip(KJob*, bool, const QString&)")]
			public virtual KIO.SkipDialog_Result AskSkip(KJob job, bool multi, string error_text) {
				return (KIO.SkipDialog_Result) interceptor.Invoke("askSkip#$$", "askSkip(KJob*, bool, const QString&)", typeof(KIO.SkipDialog_Result), typeof(KJob), job, typeof(bool), multi, typeof(string), error_text);
			}
			~JobUiDelegate() {
				interceptor.Invoke("~JobUiDelegate", "~JobUiDelegate()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~JobUiDelegate", "~JobUiDelegate()", typeof(void));
			}
			protected new IJobUiDelegateSignals Emit {
				get { return (IJobUiDelegateSignals) Q_EMIT; }
			}
		}

		public interface IJobUiDelegateSignals : IKDialogJobUiDelegateSignals {
		}

		/// <remarks>
		///  A simple job (one url and one command).
		///  This is the base class for all jobs that are scheduled.
		///  Other jobs are high-level jobs (CopyJob, DeleteJob, FileCopyJob...)
		///  that manage subjobs but aren't scheduled directly.
		///      </remarks>		<short>    A simple job (one url and one command).</short>

		[SmokeClass("KIO::SimpleJob")]
		public class SimpleJob : KIO.Job, IDisposable {
	 		protected SimpleJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(SimpleJob), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static SimpleJob() {
				staticInterceptor = new SmokeInvocation(typeof(SimpleJob), null);
			}
			// KIO::SimpleJob* SimpleJob(KIO::SimpleJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Returns the SimpleJob's URL
			/// </remarks>		<return> the url
			/// 	 </return>
			/// 		<short>    Returns the SimpleJob's URL </short>
			public KUrl Url() {
				return (KUrl) interceptor.Invoke("url", "url() const", typeof(KUrl));
			}
			/// <remarks>
			///  Abort job.
			///  Suspends slave to be reused by another job for the same request.
			///          </remarks>		<short>    Abort job.</short>
			[SmokeMethod("putOnHold()")]
			public virtual void PutOnHold() {
				interceptor.Invoke("putOnHold", "putOnHold()", typeof(void));
			}
			/// <remarks>
			///  Called on a slave's error.
			///  Made public for the scheduler.
			///          </remarks>		<short>   </short>
			[Q_SLOT("void slotError(int, const QString&)")]
			public void SlotError(int arg1, string arg2) {
				interceptor.Invoke("slotError$$", "slotError(int, const QString&)", typeof(void), typeof(int), arg1, typeof(string), arg2);
			}
			/// <remarks>
			///  Suspend this job
			/// </remarks>		<short>    Suspend this job </short>
			/// 		<see> resume</see>
			[SmokeMethod("doSuspend()")]
			protected override bool DoSuspend() {
				return (bool) interceptor.Invoke("doSuspend", "doSuspend()", typeof(bool));
			}
			/// <remarks>
			///  Resume this job
			/// </remarks>		<short>    Resume this job </short>
			/// 		<see> suspend</see>
			[SmokeMethod("doResume()")]
			protected override bool DoResume() {
				return (bool) interceptor.Invoke("doResume", "doResume()", typeof(bool));
			}
			/// <remarks>
			///  Abort job.
			///  This kills all subjobs and deletes the job.
			///          </remarks>		<short>    Abort job.</short>
			[SmokeMethod("doKill()")]
			protected override bool DoKill() {
				return (bool) interceptor.Invoke("doKill", "doKill()", typeof(bool));
			}
			protected void StoreSSLSessionFromJob(KUrl m_redirectionURL) {
				interceptor.Invoke("storeSSLSessionFromJob#", "storeSSLSessionFromJob(const KUrl&)", typeof(void), typeof(KUrl), m_redirectionURL);
			}
			/// <remarks>
			///  Creates a new simple job. You don't need to use this constructor,
			///  unless you create a new job that inherits from SimpleJob.
			/// 	 </remarks>		<short>    Creates a new simple job.</short>
			/// <remarks>
			///  Called when the slave marks the job
			///  as finished.
			///          </remarks>		<short>    Called when the slave marks the job  as finished.</short>
			[Q_SLOT("void slotFinished()")]
			[SmokeMethod("slotFinished()")]
			protected virtual void SlotFinished() {
				interceptor.Invoke("slotFinished", "slotFinished()", typeof(void));
			}
			/// <remarks>
			///  Called on a slave's warning.
			///          </remarks>		<short>   </short>
			[Q_SLOT("void slotWarning(const QString&)")]
			[SmokeMethod("slotWarning(const QString&)")]
			protected virtual void SlotWarning(string arg1) {
				interceptor.Invoke("slotWarning$", "slotWarning(const QString&)", typeof(void), typeof(string), arg1);
			}
			/// <remarks>
			///  Called on a slave's info message.
			/// <param> name="s" the info message
			/// </param></remarks>		<short>    Called on a slave's info message.</short>
			/// 		<see> infoMessage</see>
			[Q_SLOT("void slotInfoMessage(const QString&)")]
			[SmokeMethod("slotInfoMessage(const QString&)")]
			protected virtual void SlotInfoMessage(string s) {
				interceptor.Invoke("slotInfoMessage$", "slotInfoMessage(const QString&)", typeof(void), typeof(string), s);
			}
			/// <remarks>
			///  MetaData from the slave is received.
			/// <param> name="_metaData" the meta data
			/// </param></remarks>		<short>    MetaData from the slave is received.</short>
			/// 		<see> metaData</see>
			[Q_SLOT("void slotMetaData(const KIO::MetaData&)")]
			[SmokeMethod("slotMetaData(const KIO::MetaData&)")]
			protected virtual void SlotMetaData(KIO.MetaData _metaData) {
				interceptor.Invoke("slotMetaData#", "slotMetaData(const KIO::MetaData&)", typeof(void), typeof(KIO.MetaData), _metaData);
			}
			~SimpleJob() {
				interceptor.Invoke("~SimpleJob", "~SimpleJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~SimpleJob", "~SimpleJob()", typeof(void));
			}
			/// <remarks>
			///  Discard suspended slave.
			///          </remarks>		<short>    Discard suspended slave.</short>
			public static void RemoveOnHold() {
				staticInterceptor.Invoke("removeOnHold", "removeOnHold()", typeof(void));
			}
			protected new ISimpleJobSignals Emit {
				get { return (ISimpleJobSignals) Q_EMIT; }
			}
		}

		public interface ISimpleJobSignals : KIO.IJobSignals {
		}

		/// <remarks>
		///  A KIO job that retrieves information about a file or directory.
		///  See <see cref="IStatJobSignals"></see> for signals emitted by StatJob
		/// </remarks>		<short>    A KIO job that retrieves information about a file or directory.</short>
		/// 		<see> stat</see>

		[SmokeClass("KIO::StatJob")]
		public class StatJob : KIO.SimpleJob, IDisposable {
	 		protected StatJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(StatJob), this);
			}
			// void setSide(KIO::StatJob::StatSide arg1); >>>> NOT CONVERTED
			// KIO::StatJob* StatJob(KIO::StatJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  A stat() can have two meanings. Either we want to read from this URL,
			///  or to check if we can write to it. First case is "source", second is "dest".
			///  It is necessary to know what the StatJob is for, to tune the kioslave's behavior
			///  (e.g. with FTP).
			/// <param> name="side" SourceSide or DestinationSide
			///          </param></remarks>		<short>    A stat() can have two meanings.</short>
			/// <remarks>
			///  Selects the level of <code>details</code> we want.
			///  By default this is 2 (all details wanted, including modification time, size, etc.),
			///  setDetails(1) is used when deleting: we don't need all the information if it takes
			///  too much time, no need to follow symlinks etc.
			///  setDetails(0) is used for very simple probing: we'll only get the answer
			///  "it's a file or a directory, or it doesn't exist". This is used by KRun.
			/// <param> name="details" 2 for all details, 1 for simple, 0 for very simple
			///          </param></remarks>		<short>    Selects the level of <code>details</code> we want.</short>
			public void SetDetails(short details) {
				interceptor.Invoke("setDetails$", "setDetails(short int)", typeof(void), typeof(short), details);
			}
			/// <remarks>
			///  Call this in the slot connected to result,
			///  and only after making sure no error happened.
			/// </remarks>		<return> the result of the stat
			///          </return>
			/// 		<short>    Call this in the slot connected to result,  and only after making sure no error happened.</short>
			public KIO.UDSEntry StatResult() {
				return (KIO.UDSEntry) interceptor.Invoke("statResult", "statResult() const", typeof(KIO.UDSEntry));
			}
			[Q_SLOT("void slotFinished()")]
			[SmokeMethod("slotFinished()")]
			protected override void SlotFinished() {
				interceptor.Invoke("slotFinished", "slotFinished()", typeof(void));
			}
			[Q_SLOT("void slotMetaData(const KIO::MetaData&)")]
			[SmokeMethod("slotMetaData(const KIO::MetaData&)")]
			protected override void SlotMetaData(KIO.MetaData _metaData) {
				interceptor.Invoke("slotMetaData#", "slotMetaData(const KIO::MetaData&)", typeof(void), typeof(KIO.MetaData), _metaData);
			}
			~StatJob() {
				interceptor.Invoke("~StatJob", "~StatJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~StatJob", "~StatJob()", typeof(void));
			}
			protected new IStatJobSignals Emit {
				get { return (IStatJobSignals) Q_EMIT; }
			}
		}

		public interface IStatJobSignals : KIO.ISimpleJobSignals {
		/// <remarks>
		///  Signals a redirection.
		///  Use to update the URL shown to the user.
		///  The redirection itself is handled internally.
		/// <param> name="job" the job that is redirected
		/// </param><param> name="url" the new url
		///          </param></remarks>		<short>    Signals a redirection.</short>
		[Q_SIGNAL("void redirection(KIO::Job*, const KUrl&)")]
		void Redirection(KIO.Job job, KUrl url);
		/// <remarks>
		///  Signals a permanent redirection.
		///  The redirection itself is handled internally.
		/// <param> name="job" the job that is redirected
		/// </param><param> name="fromUrl" the original URL
		/// </param><param> name="toUrl" the new URL
		///          </param></remarks>		<short>    Signals a permanent redirection.</short>
		[Q_SIGNAL("void permanentRedirection(KIO::Job*, const KUrl&, const KUrl&)")]
		void PermanentRedirection(KIO.Job job, KUrl fromUrl, KUrl toUrl);
		}

		/// <remarks>
		///  The transfer job pumps data into and/or out of a Slave.
		///  Data is sent to the slave on request of the slave ( dataReq).
		///  If data coming from the slave can not be handled, the
		///  reading of data from the slave should be suspended.
		///       See <see cref="ITransferJobSignals"></see> for signals emitted by TransferJob
		/// </remarks>		<short>    The transfer job pumps data into and/or out of a Slave.</short>

		[SmokeClass("KIO::TransferJob")]
		public class TransferJob : KIO.SimpleJob, IDisposable {
	 		protected TransferJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(TransferJob), this);
			}
			// KIO::TransferJob* TransferJob(KIO::TransferJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Sets the modification time of the file to be created (by KIO.Put)
			///  Note that some kioslaves might ignore this.
			///          </remarks>		<short>    Sets the modification time of the file to be created (by KIO.Put)  Note that some kioslaves might ignore this.</short>
			public void SetModificationTime(QDateTime mtime) {
				interceptor.Invoke("setModificationTime#", "setModificationTime(const QDateTime&)", typeof(void), typeof(QDateTime), mtime);
			}
			/// <remarks>
			///  Checks whether we got an error page. This currently only happens
			///  with HTTP urls. Call this from your slot connected to result().
			/// </remarks>		<return> true if we got an (HTML) error page from the server
			///  instead of what we asked for.
			///          </return>
			/// 		<short>    Checks whether we got an error page.</short>
			public bool IsErrorPage() {
				return (bool) interceptor.Invoke("isErrorPage", "isErrorPage() const", typeof(bool));
			}
			/// <remarks>
			///  Enable the async data mode.
			///  When async data is enabled, data should be provided to the job by
			///  calling sendAsyncData() instead of returning data in the
			///  dataReq() signal.
			///          </remarks>		<short>    Enable the async data mode.</short>
			public void SetAsyncDataEnabled(bool enabled) {
				interceptor.Invoke("setAsyncDataEnabled$", "setAsyncDataEnabled(bool)", typeof(void), typeof(bool), enabled);
			}
			/// <remarks>
			///  Provide data to the job when async data is enabled.
			///  Should be called exactly once after receiving a dataReq signal
			///  Sending an empty block indicates end of data.
			///          </remarks>		<short>    Provide data to the job when async data is enabled.</short>
			public void SendAsyncData(QByteArray data) {
				interceptor.Invoke("sendAsyncData#", "sendAsyncData(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  When enabled, the job reports the amount of data that has been sent,
			///  instead of the amount of data that that has been received.
			/// </remarks>		<short>    When enabled, the job reports the amount of data that has been sent,  instead of the amount of data that that has been received.</short>
			/// 		<see> slotProcessedSize</see>
			/// 		<see> slotSpeed</see>
			public void SetReportDataSent(bool enabled) {
				interceptor.Invoke("setReportDataSent$", "setReportDataSent(bool)", typeof(void), typeof(bool), enabled);
			}
			/// <remarks>
			///   Returns whether the job reports the amount of data that has been
			///   sent (true), or whether the job reports the amount of data that
			///  has been received (false)
			///          </remarks>		<short>     Returns whether the job reports the amount of data that has been   sent (true), or whether the job reports the amount of data that  has been received (false)          </short>
			public bool ReportDataSent() {
				return (bool) interceptor.Invoke("reportDataSent", "reportDataSent() const", typeof(bool));
			}
			/// <remarks>
			///  Call this in the slot connected to result,
			///  and only after making sure no error happened.
			/// </remarks>		<return> the mimetype of the URL
			///          </return>
			/// 		<short>    Call this in the slot connected to result,  and only after making sure no error happened.</short>
			public string Mimetype() {
				return (string) interceptor.Invoke("mimetype", "mimetype() const", typeof(string));
			}
			/// <remarks>
			///  Called when m_subJob finishes.
			/// <param> name="job" the job that finished
			///          </param></remarks>		<short>    Called when m_subJob finishes.</short>
			[SmokeMethod("slotResult(KJob*)")]
			protected override void SlotResult(KJob job) {
				interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
			}
			/// <remarks>
			///  Reimplemented for internal reasons
			///          </remarks>		<short>    Reimplemented for internal reasons          </short>
			[SmokeMethod("doResume()")]
			protected override bool DoResume() {
				return (bool) interceptor.Invoke("doResume", "doResume()", typeof(bool));
			}
			[Q_SLOT("void slotRedirection(const KUrl&)")]
			[SmokeMethod("slotRedirection(const KUrl&)")]
			protected virtual void SlotRedirection(KUrl url) {
				interceptor.Invoke("slotRedirection#", "slotRedirection(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			[Q_SLOT("void slotFinished()")]
			[SmokeMethod("slotFinished()")]
			protected override void SlotFinished() {
				interceptor.Invoke("slotFinished", "slotFinished()", typeof(void));
			}
			[Q_SLOT("void slotData(const QByteArray&)")]
			[SmokeMethod("slotData(const QByteArray&)")]
			protected virtual void SlotData(QByteArray data) {
				interceptor.Invoke("slotData#", "slotData(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			[Q_SLOT("void slotDataReq()")]
			[SmokeMethod("slotDataReq()")]
			protected virtual void SlotDataReq() {
				interceptor.Invoke("slotDataReq", "slotDataReq()", typeof(void));
			}
			[Q_SLOT("void slotMimetype(const QString&)")]
			[SmokeMethod("slotMimetype(const QString&)")]
			protected virtual void SlotMimetype(string mimetype) {
				interceptor.Invoke("slotMimetype$", "slotMimetype(const QString&)", typeof(void), typeof(string), mimetype);
			}
			[Q_SLOT("void slotMetaData(const KIO::MetaData&)")]
			[SmokeMethod("slotMetaData(const KIO::MetaData&)")]
			protected override void SlotMetaData(KIO.MetaData _metaData) {
				interceptor.Invoke("slotMetaData#", "slotMetaData(const KIO::MetaData&)", typeof(void), typeof(KIO.MetaData), _metaData);
			}
			~TransferJob() {
				interceptor.Invoke("~TransferJob", "~TransferJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~TransferJob", "~TransferJob()", typeof(void));
			}
			protected new ITransferJobSignals Emit {
				get { return (ITransferJobSignals) Q_EMIT; }
			}
		}

		public interface ITransferJobSignals : KIO.ISimpleJobSignals {
		/// <remarks>
		///  Data from the slave has arrived.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="data" data received from the slave.
		/// </param> End of data (EOD) has been reached if data.size() == 0, however, you
		///  should not be certain of data.size() == 0 ever happening (e.g. in case
		///  of an error), so you should rely on result() instead.
		///          </remarks>		<short>    Data from the slave has arrived.</short>
		[Q_SIGNAL("void data(KIO::Job*, const QByteArray&)")]
		void Data(KIO.Job job, QByteArray data);
		/// <remarks>
		///  Request for data.
		///  Please note, that you shouldn't put too large chunks
		///  of data in it as this requires copies within the frame
		///  work, so you should rather split the data you want
		///  to pass here in reasonable chunks (about 1MB maximum)
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="data" buffer to fill with data to send to the
		///  slave. An empty buffer indicates end of data. (EOD)
		///          </param></remarks>		<short>    Request for data.</short>
		[Q_SIGNAL("void dataReq(KIO::Job*, QByteArray&)")]
		void DataReq(KIO.Job job, QByteArray data);
		/// <remarks>
		///  Signals a redirection.
		///  Use to update the URL shown to the user.
		///  The redirection itself is handled internally.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="url" the new URL
		///          </param></remarks>		<short>    Signals a redirection.</short>
		[Q_SIGNAL("void redirection(KIO::Job*, const KUrl&)")]
		void Redirection(KIO.Job job, KUrl url);
		/// <remarks>
		///  Signals a permanent redirection.
		///  The redirection itself is handled internally.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="fromUrl" the original URL
		/// </param><param> name="toUrl" the new URL
		///          </param></remarks>		<short>    Signals a permanent redirection.</short>
		[Q_SIGNAL("void permanentRedirection(KIO::Job*, const KUrl&, const KUrl&)")]
		void PermanentRedirection(KIO.Job job, KUrl fromUrl, KUrl toUrl);
		/// <remarks>
		///  Mimetype determined.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="type" the mime type
		///          </param></remarks>		<short>    Mimetype determined.</short>
		[Q_SIGNAL("void mimetype(KIO::Job*, const QString&)")]
		void Mimetype(KIO.Job job, string type);
		// void canResume(KIO::Job* arg1,KIO::filesize_t arg2); >>>> NOT CONVERTED
		}

		/// <remarks>
		///  StoredTransferJob is a TransferJob (for downloading or uploading data) that
		///  also stores a QByteArray with the data, making it simpler to use than the
		///  standard TransferJob.
		///  For KIO.StoredGet it puts the data into the member QByteArray, so the user
		///  of this class can get hold of the whole data at once by calling data()
		///  when the result signal is emitted.
		///  You should only use StoredTransferJob to download data if you cannot
		///  process the data by chunks while it's being downloaded, since storing
		///  everything in a QByteArray can potentially require a lot of memory.
		///  For KIO.StoredPut the user of this class simply provides the bytearray from
		///  the start, and the job takes care of uploading it.
		///  You should only use StoredTransferJob to upload data if you cannot
		///  provide the in chunks while it's being uploaded, since storing
		///  everything in a QByteArray can potentially require a lot of memory.
		///      </remarks>		<short>    StoredTransferJob is a TransferJob (for downloading or uploading data) that  also stores a QByteArray with the data, making it simpler to use than the  standard TransferJob.</short>

		[SmokeClass("KIO::StoredTransferJob")]
		public class StoredTransferJob : KIO.TransferJob, IDisposable {
	 		protected StoredTransferJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(StoredTransferJob), this);
			}
			// KIO::StoredTransferJob* StoredTransferJob(KIO::StoredTransferJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Set data to be uploaded. This is for put jobs.
			///  Automatically called by KIO.StoredPut(QByteArray, ...),
			///  do not call this yourself.
			///          </remarks>		<short>    Set data to be uploaded.</short>
			public void SetData(QByteArray arr) {
				interceptor.Invoke("setData#", "setData(const QByteArray&)", typeof(void), typeof(QByteArray), arr);
			}
			/// <remarks>
			///  Get hold of the downloaded data. This is for get jobs.
			///  You're supposed to call this only from the slot connected to the result() signal.
			///          </remarks>		<short>    Get hold of the downloaded data.</short>
			public QByteArray Data() {
				return (QByteArray) interceptor.Invoke("data", "data() const", typeof(QByteArray));
			}
			~StoredTransferJob() {
				interceptor.Invoke("~StoredTransferJob", "~StoredTransferJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~StoredTransferJob", "~StoredTransferJob()", typeof(void));
			}
			protected new IStoredTransferJobSignals Emit {
				get { return (IStoredTransferJobSignals) Q_EMIT; }
			}
		}

		public interface IStoredTransferJobSignals : KIO.ITransferJobSignals {
		}

		/// <remarks>
		///  The MultiGetJob is a TransferJob that allows you to get
		///  several files from a single server. Don't create directly,
		///  but use KIO.Multi_get() instead.
		///  See <see cref="IMultiGetJobSignals"></see> for signals emitted by MultiGetJob
		/// </remarks>		<short>    The MultiGetJob is a TransferJob that allows you to get  several files from a single server.</short>
		/// 		<see> multi_get</see>

		[SmokeClass("KIO::MultiGetJob")]
		public class MultiGetJob : KIO.TransferJob, IDisposable {
	 		protected MultiGetJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(MultiGetJob), this);
			}
			// KIO::MultiGetJob* MultiGetJob(KIO::MultiGetJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Get an additional file.
			/// <param> name="id" the id of the file
			/// </param><param> name="url" the url of the file to get
			/// </param><param> name="metaData" the meta data for this request
			/// 	 </param></remarks>		<short>    Get an additional file.</short>
			public void Get(long id, KUrl url, KIO.MetaData metaData) {
				interceptor.Invoke("get$##", "get(long, const KUrl&, const KIO::MetaData&)", typeof(void), typeof(long), id, typeof(KUrl), url, typeof(KIO.MetaData), metaData);
			}
			[Q_SLOT("void slotRedirection(const KUrl&)")]
			[SmokeMethod("slotRedirection(const KUrl&)")]
			protected override void SlotRedirection(KUrl url) {
				interceptor.Invoke("slotRedirection#", "slotRedirection(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			[Q_SLOT("void slotFinished()")]
			[SmokeMethod("slotFinished()")]
			protected override void SlotFinished() {
				interceptor.Invoke("slotFinished", "slotFinished()", typeof(void));
			}
			[Q_SLOT("void slotData(const QByteArray&)")]
			[SmokeMethod("slotData(const QByteArray&)")]
			protected override void SlotData(QByteArray data) {
				interceptor.Invoke("slotData#", "slotData(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			[Q_SLOT("void slotMimetype(const QString&)")]
			[SmokeMethod("slotMimetype(const QString&)")]
			protected override void SlotMimetype(string mimetype) {
				interceptor.Invoke("slotMimetype$", "slotMimetype(const QString&)", typeof(void), typeof(string), mimetype);
			}
			~MultiGetJob() {
				interceptor.Invoke("~MultiGetJob", "~MultiGetJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~MultiGetJob", "~MultiGetJob()", typeof(void));
			}
			protected new IMultiGetJobSignals Emit {
				get { return (IMultiGetJobSignals) Q_EMIT; }
			}
		}

		public interface IMultiGetJobSignals : KIO.ITransferJobSignals {
		/// <remarks>
		///  Data from the slave has arrived.
		/// <param> name="id" the id of the request
		/// </param><param> name="data" data received from the slave.
		///  End of data (EOD) has been reached if data.size() == 0
		///          </param></remarks>		<short>    Data from the slave has arrived.</short>
		[Q_SIGNAL("void data(long, const QByteArray&)")]
		void Data(long id, QByteArray data);
		/// <remarks>
		///  Mimetype determined
		/// <param> name="id" the id of the request
		/// </param><param> name="type" the mime type
		///          </param></remarks>		<short>    Mimetype determined </short>
		[Q_SIGNAL("void mimetype(long, const QString&)")]
		void Mimetype(long id, string type);
		/// <remarks>
		///  File transfer completed.
		///  When all files have been processed, result(KJob ) gets
		///  emitted.
		/// <param> name="id" the id of the request
		///          </param></remarks>		<short>    File transfer completed.</short>
		[Q_SIGNAL("void result(long)")]
		void Result(long id);
		}

		/// <remarks>
		///  A MimetypeJob is a TransferJob that  allows you to get
		///  the mime type of an URL. Don't create directly,
		///  but use KIO.Mimetype() instead.
		/// </remarks>		<short>    A MimetypeJob is a TransferJob that  allows you to get  the mime type of an URL.</short>
		/// 		<see> mimetype</see>

		[SmokeClass("KIO::MimetypeJob")]
		public class MimetypeJob : KIO.TransferJob, IDisposable {
	 		protected MimetypeJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(MimetypeJob), this);
			}
			// KIO::MimetypeJob* MimetypeJob(KIO::MimetypeJobPrivate& arg1); >>>> NOT CONVERTED
			[Q_SLOT("void slotFinished()")]
			[SmokeMethod("slotFinished()")]
			protected override void SlotFinished() {
				interceptor.Invoke("slotFinished", "slotFinished()", typeof(void));
			}
			~MimetypeJob() {
				interceptor.Invoke("~MimetypeJob", "~MimetypeJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~MimetypeJob", "~MimetypeJob()", typeof(void));
			}
			protected new IMimetypeJobSignals Emit {
				get { return (IMimetypeJobSignals) Q_EMIT; }
			}
		}

		public interface IMimetypeJobSignals : KIO.ITransferJobSignals {
		}

		/// <remarks>
		///  The FileCopyJob copies data from one place to another.
		///  See <see cref="IFileCopyJobSignals"></see> for signals emitted by FileCopyJob
		/// </remarks>		<short>    The FileCopyJob copies data from one place to another.</short>
		/// 		<see> file_copy</see>
		/// 		<see> file_move</see>

		[SmokeClass("KIO::FileCopyJob")]
		public class FileCopyJob : KIO.Job {
	 		protected FileCopyJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(FileCopyJob), this);
			}
			// void setSourceSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// KIO::FileCopyJob* FileCopyJob(KIO::FileCopyJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  If you know the size of the source file, call this method
			///  to inform this job. It will be displayed in the "resume" dialog.
			/// <param> name="size" the size of the source file
			///          </param></remarks>		<short>    If you know the size of the source file, call this method  to inform this job.</short>
			/// <remarks>
			///  Sets the modification time of the file
			///  Note that this is ignored if a direct copy (SlaveBase.Copy) can be done,
			///  in which case the mtime of the source is applied to the destination (if the protocol
			///  supports the concept).
			///          </remarks>		<short>    Sets the modification time of the file </short>
			public void SetModificationTime(QDateTime mtime) {
				interceptor.Invoke("setModificationTime#", "setModificationTime(const QDateTime&)", typeof(void), typeof(QDateTime), mtime);
			}
			/// <remarks>
			///  Returns the source URL.
			/// </remarks>		<return> the source URL
			/// 	 </return>
			/// 		<short>    Returns the source URL.</short>
			public KUrl SrcUrl() {
				return (KUrl) interceptor.Invoke("srcUrl", "srcUrl() const", typeof(KUrl));
			}
			/// <remarks>
			///  Returns the destination URL.
			/// </remarks>		<return> the destination URL
			/// 	 </return>
			/// 		<short>    Returns the destination URL.</short>
			public KUrl DestUrl() {
				return (KUrl) interceptor.Invoke("destUrl", "destUrl() const", typeof(KUrl));
			}
			[SmokeMethod("doSuspend()")]
			public new virtual bool DoSuspend() {
				return (bool) interceptor.Invoke("doSuspend", "doSuspend()", typeof(bool));
			}
			[SmokeMethod("doResume()")]
			public new virtual bool DoResume() {
				return (bool) interceptor.Invoke("doResume", "doResume()", typeof(bool));
			}
			/// <remarks>
			///  Called whenever a subjob finishes.
			/// <param> name="job" the job that emitted this signal
			///          </param></remarks>		<short>    Called whenever a subjob finishes.</short>
			[Q_SLOT("void slotResult(KJob*)")]
			[SmokeMethod("slotResult(KJob*)")]
			protected override void SlotResult(KJob job) {
				interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
			}
			protected new IFileCopyJobSignals Emit {
				get { return (IFileCopyJobSignals) Q_EMIT; }
			}
		}

		public interface IFileCopyJobSignals : KIO.IJobSignals {
		/// <remarks>
		///  Mimetype determined during a file copy.
		///  This is never emitted during a move, and might not be emitted during
		///  a file copy, depending on the slave. But when a get and a put are
		///  being used (which is the common case), this signal forwards the
		///  mimetype information from the get job.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="type" the mime type
		///          </param></remarks>		<short>    Mimetype determined during a file copy.</short>
		[Q_SIGNAL("void mimetype(KIO::Job*, const QString&)")]
		void Mimetype(KIO.Job job, string type);
		}

		/// <remarks>
		///  A ListJob is allows you to get the get the content of a directory.
		///  Don't create the job directly, but use KIO.ListRecursive() or
		///  KIO.ListDir() instead.
		///  See <see cref="IListJobSignals"></see> for signals emitted by ListJob
		/// </remarks>		<short>    A ListJob is allows you to get the get the content of a directory.</short>
		/// 		<see> listRecursive</see>
		/// 		<see> listDir</see>

		[SmokeClass("KIO::ListJob")]
		public class ListJob : KIO.SimpleJob, IDisposable {
	 		protected ListJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ListJob), this);
			}
			// KIO::ListJob* ListJob(KIO::ListJobPrivate& arg1); >>>> NOT CONVERTED
			/// <remarks>
			///  Returns the ListJob's redirection URL. This will be invalid if there
			///  was no redirection.
			/// </remarks>		<return> the redirection url
			///          </return>
			/// 		<short>    Returns the ListJob's redirection URL.</short>
			public KUrl RedirectionUrl() {
				return (KUrl) interceptor.Invoke("redirectionUrl", "redirectionUrl() const", typeof(KUrl));
			}
			/// <remarks>
			///  Do not apply any KIOSK restrictions to this job.
			///          </remarks>		<short>    Do not apply any KIOSK restrictions to this job.</short>
			public void SetUnrestricted(bool unrestricted) {
				interceptor.Invoke("setUnrestricted$", "setUnrestricted(bool)", typeof(void), typeof(bool), unrestricted);
			}
			[Q_SLOT("void slotFinished()")]
			[SmokeMethod("slotFinished()")]
			protected override void SlotFinished() {
				interceptor.Invoke("slotFinished", "slotFinished()", typeof(void));
			}
			[Q_SLOT("void slotMetaData(const KIO::MetaData&)")]
			[SmokeMethod("slotMetaData(const KIO::MetaData&)")]
			protected override void SlotMetaData(KIO.MetaData _metaData) {
				interceptor.Invoke("slotMetaData#", "slotMetaData(const KIO::MetaData&)", typeof(void), typeof(KIO.MetaData), _metaData);
			}
			[Q_SLOT("void slotResult(KJob*)")]
			[SmokeMethod("slotResult(KJob*)")]
			protected override void SlotResult(KJob job) {
				interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
			}
			~ListJob() {
				interceptor.Invoke("~ListJob", "~ListJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~ListJob", "~ListJob()", typeof(void));
			}
			protected new IListJobSignals Emit {
				get { return (IListJobSignals) Q_EMIT; }
			}
		}

		public interface IListJobSignals : KIO.ISimpleJobSignals {
		// void entries(KIO::Job* arg1,const KIO::UDSEntryList& arg2); >>>> NOT CONVERTED
		/// <remarks>
		///  Signals a redirection.
		///  Use to update the URL shown to the user.
		///  The redirection itself is handled internally.
		/// <param> name="job" the job that is redirected
		/// </param><param> name="url" the new url
		///          </param></remarks>		<short>    Signals a redirection.</short>
		[Q_SIGNAL("void redirection(KIO::Job*, const KUrl&)")]
		void Redirection(KIO.Job job, KUrl url);
		/// <remarks>
		///  Signals a permanent redirection.
		///  The redirection itself is handled internally.
		/// <param> name="job" the job that emitted this signal
		/// </param><param> name="fromUrl" the original URL
		/// </param><param> name="toUrl" the new URL
		///          </param></remarks>		<short>    Signals a permanent redirection.</short>
		[Q_SIGNAL("void permanentRedirection(KIO::Job*, const KUrl&, const KUrl&)")]
		void PermanentRedirection(KIO.Job job, KUrl fromUrl, KUrl toUrl);
		}

		/// <remarks>
		///  A class that sends a special command to an ioslave.
		///  This allows you to send a binary blob to an ioslave and handle
		///  its responses. The ioslave will receive the binary data as an
		///  argument to the "special" function (inherited from SlaveBase.Special()).
		///  Use this only on ioslaves that belong to your application. Sending
		///  special commands to other ioslaves may cause unexpected behaviour.
		/// </remarks>		<short>    A class that sends a special command to an ioslave.</short>
		/// 		<see> special</see>

		[SmokeClass("KIO::SpecialJob")]
		public class SpecialJob : KIO.TransferJob, IDisposable {
	 		protected SpecialJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(SpecialJob), this);
			}
			/// <remarks>
			///  Creates a KIO.SpecialJob.
			/// <param> name="url" the URL to be passed to the ioslave
			/// </param><param> name="data" the data to be sent to the SlaveBase.Special() function.
			///          </param></remarks>		<short>    Creates a KIO.SpecialJob.</short>
			public SpecialJob(KUrl url, QByteArray data) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("SpecialJob##", "SpecialJob(const KUrl&, const QByteArray&)", typeof(void), typeof(KUrl), url, typeof(QByteArray), data);
			}
			public SpecialJob(KUrl url) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("SpecialJob#", "SpecialJob(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  Sets the QByteArray that is passed to SlaveBase.Special() on
			///  the ioslave.
			///          </remarks>		<short>    Sets the QByteArray that is passed to SlaveBase.Special() on  the ioslave.</short>
			public void SetArguments(QByteArray data) {
				interceptor.Invoke("setArguments#", "setArguments(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Returns the QByteArray data that will be sent (or has been sent) to the
			///  ioslave.
			///          </remarks>		<short>    Returns the QByteArray data that will be sent (or has been sent) to the  ioslave.</short>
			public QByteArray Arguments() {
				return (QByteArray) interceptor.Invoke("arguments", "arguments() const", typeof(QByteArray));
			}
			~SpecialJob() {
				interceptor.Invoke("~SpecialJob", "~SpecialJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~SpecialJob", "~SpecialJob()", typeof(void));
			}
			protected new ISpecialJobSignals Emit {
				get { return (ISpecialJobSignals) Q_EMIT; }
			}
		}

		public interface ISpecialJobSignals : KIO.ITransferJobSignals {
		}

		public interface ISlaveBase {
		void Exit();
		void DispatchLoop();
		void SetConnection(KIO.Connection connection);
		KIO.Connection Connection();
		void Data(QByteArray data);
		void DataReq();
		void Opened();
		void error(int _errid, string _text);
		void Connected();
		void Finished();
		void NeedSubUrlData();
		void SlaveStatus(string host, bool connected);
		void StatEntry(KIO.UDSEntry _entry);
		void ProcessedPercent(float percent);
		void Speed(ulong _bytes_per_second);
		void Redirection(KUrl _url);
		void ErrorPage();
		void MimeType(string _type);
		void Warning(string msg);
		void InfoMessage(string msg);
		void SetMetaData(string key, string value);
		bool HasMetaData(string key);
		string MetaData(string key);
		KIO.MetaData AllMetaData();
		KConfigGroup Config();
		KRemoteEncoding RemoteEncoding();
		void SetHost(string host, ushort port, string user, string pass);
		void SetSubUrl(KUrl url);
		void OpenConnection();
		void CloseConnection();
		void Get(KUrl url);
		void Open(KUrl url, uint mode);
		void Write(QByteArray data);
		void Close();
		void Put(KUrl url, int permissions, uint flags);
		void Stat(KUrl url);
		void Mimetype(KUrl url);
		void ListDir(KUrl url);
		void Mkdir(KUrl url, int permissions);
		void Rename(KUrl src, KUrl dest, uint flags);
		void Symlink(string target, KUrl dest, uint flags);
		void Chmod(KUrl url, int permissions);
		void Chown(KUrl url, string owner, string group);
		void SetModificationTime(KUrl url, QDateTime mtime);
		void Copy(KUrl src, KUrl dest, int permissions, uint flags);
		void Del(KUrl url, bool isfile);
		void SetLinkDest(KUrl url, string target);
		void Special(QByteArray data);
		void MultiGet(QByteArray data);
		void Slave_status();
		void ReparseConfiguration();
		int ConnectTimeout();
		int ProxyConnectTimeout();
		int ResponseTimeout();
		int ReadTimeout();
		void SetTimeoutSpecialCommand(int timeout, QByteArray data);
		void SetTimeoutSpecialCommand(int timeout);
		void Dispatch(int command, QByteArray data);
		void DispatchOpenCommand(int command, QByteArray data);
		int ReadData(QByteArray buffer);
		void ListEntry(KIO.UDSEntry _entry, bool ready);
		void ConnectSlave(string path);
		void DisconnectSlave();
		bool OpenPasswordDialog(KIO.AuthInfo info, string errorMsg);
		bool OpenPasswordDialog(KIO.AuthInfo info);
		bool RequestNetwork(string host);
		bool RequestNetwork();
		void DropNetwork(string host);
		void DropNetwork();
		int WaitForAnswer(int expected1, int expected2, QByteArray data, ref int pCmd);
		int WaitForAnswer(int expected1, int expected2, QByteArray data);
		void SendMetaData();
		bool WasKilled();
		void SetKillFlag();
		}

		/// <remarks>
		///  There are two classes that specifies the protocol between application (job)
		///  and kioslave. SlaveInterface is the class to use on the application end,
		///  SlaveBase is the one to use on the slave end.
		///  Slave implementations should simply inherit SlaveBase
		///  A call to foo() results in a call to slotFoo() on the other end.
		///  </remarks>		<short>    There are two classes that specifies the protocol between application (job)  and kioslave.</short>

		[SmokeClass("KIO::SlaveBase")]
		public class SlaveBase : Object, ISlaveBase {
			protected SmokeInvocation interceptor = null;
			private IntPtr smokeObject;
			protected SlaveBase(Type dummy) {}
			protected void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(SlaveBase), this);
			}
			// void listEntries(const KIO::UDSEntryList& arg1); >>>> NOT CONVERTED
			// bool canResume(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void totalSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void processedSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void position(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void written(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2,const QString& arg3,const QString& arg4,const QString& arg5); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2,const QString& arg3,const QString& arg4); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2,const QString& arg3); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3,const QString& arg4,const QString& arg5,const QString& arg6); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3,const QString& arg4,const QString& arg5); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3,const QString& arg4); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2); >>>> NOT CONVERTED
			// void read(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void seek(KIO::filesize_t arg1); >>>> NOT CONVERTED
			public SlaveBase(QByteArray protocol, QByteArray pool_socket, QByteArray app_socket) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("SlaveBase###", "SlaveBase(const QByteArray&, const QByteArray&, const QByteArray&)", typeof(void), typeof(QByteArray), protocol, typeof(QByteArray), pool_socket, typeof(QByteArray), app_socket);
			}
			/// <remarks>
			///  Terminate the slave by calling the destructor and then .Exit()
			///      </remarks>		<short>   </short>
			public void Exit() {
				interceptor.Invoke("exit", "exit()", typeof(void));
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			public void DispatchLoop() {
				interceptor.Invoke("dispatchLoop", "dispatchLoop()", typeof(void));
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			public void SetConnection(KIO.Connection connection) {
				interceptor.Invoke("setConnection#", "setConnection(KIO::Connection*)", typeof(void), typeof(KIO.Connection), connection);
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			public KIO.Connection Connection() {
				return (KIO.Connection) interceptor.Invoke("connection", "connection() const", typeof(KIO.Connection));
			}
			/// <remarks>
			///  Sends data in the slave to the job (i.e. in get).
			///  To signal end of data, simply send an empty
			///  QByteArray().
			/// <param> name="data" the data read by the slave
			///      </param></remarks>		<short>    Sends data in the slave to the job (i.</short>
			public void Data(QByteArray data) {
				interceptor.Invoke("data#", "data(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Asks for data from the job.
			/// </remarks>		<short>    Asks for data from the job.</short>
			/// 		<see> readData</see>
			public void DataReq() {
				interceptor.Invoke("dataReq", "dataReq()", typeof(void));
			}
			/// <remarks>
			///  open succedes
			/// </remarks>		<short>    open succedes </short>
			/// 		<see> open</see>
			public void Opened() {
				interceptor.Invoke("opened", "opened()", typeof(void));
			}
			/// <remarks>
			///  Call to signal an error.
			///  This also finishes the job, no need to call finished.
			///  If the Error code is KIO.ERR_SLAVE_DEFINED then the
			///  _text should contain the complete translated text of
			///  of the error message.  This message will be displayed
			///  in an KTextBrowser which allows rich text complete
			///  with hyper links.  Email links will call the default
			///  mailer, "exec:/command arg1 arg2" will be forked and
			///  all other links will call the default browser.
			/// <param> name="_errid" the error code from KIO.Error
			/// </param><param> name="_text" the rich text error message
			///      </param></remarks>		<short>    Call to signal an error.</short>
			/// 		<see> Error</see>
			/// 		<see> KTextBrowser</see>
			public void error(int _errid, string _text) {
				interceptor.Invoke("error$$", "error(int, const QString&)", typeof(void), typeof(int), _errid, typeof(string), _text);
			}
			/// <remarks>
			///  Call in openConnection, if you reimplement it, when you're done.
			///      </remarks>		<short>    Call in openConnection, if you reimplement it, when you're done.</short>
			public void Connected() {
				interceptor.Invoke("connected", "connected()", typeof(void));
			}
			/// <remarks>
			///  Call to signal successful completion of any command
			///  (besides openConnection and closeConnection)
			///      </remarks>		<short>    Call to signal successful completion of any command  (besides openConnection and closeConnection)      </short>
			public void Finished() {
				interceptor.Invoke("finished", "finished()", typeof(void));
			}
			/// <remarks>
			///  Call to signal that data from the sub-URL is needed
			///      </remarks>		<short>    Call to signal that data from the sub-URL is needed      </short>
			public void NeedSubUrlData() {
				interceptor.Invoke("needSubUrlData", "needSubUrlData()", typeof(void));
			}
			/// <remarks>
			///  Used to report the status of the slave.
			/// <param> name="host" the slave is currently connected to. (Should be
			///         empty if not connected)
			/// </param><param> name="connected" Whether an actual network connection exists.
			/// </param></remarks>		<short>    Used to report the status of the slave.</short>
			public void SlaveStatus(string host, bool connected) {
				interceptor.Invoke("slaveStatus$$", "slaveStatus(const QString&, bool)", typeof(void), typeof(string), host, typeof(bool), connected);
			}
			/// <remarks>
			///  Call this from stat() to express details about an object, the
			///  UDSEntry customarily contains the atoms describing file name, size,
			///  mimetype, etc.
			/// <param> name="_entry" The UDSEntry containing all of the object attributes.
			///      </param></remarks>		<short>    Call this from stat() to express details about an object, the  UDSEntry customarily contains the atoms describing file name, size,  mimetype, etc.</short>
			public void StatEntry(KIO.UDSEntry _entry) {
				interceptor.Invoke("statEntry#", "statEntry(const KIO::UDSEntry&)", typeof(void), typeof(KIO.UDSEntry), _entry);
			}
			/// <remarks>
			///  Call this in listDir, each time you have a bunch of entries
			///  to report.
			/// <param> name="_entry" The UDSEntry containing all of the object attributes.
			///      </param></remarks>		<short>    Call this in listDir, each time you have a bunch of entries  to report.</short>
			/// <remarks>
			///  Call this at the beginning of put(), to give the size of the existing
			///  partial file, if there is one. The <code>offset</code> argument notifies the
			///  other job (the one that gets the data) about the offset to use.
			///  In this case, the boolean returns whether we can indeed resume or not
			///  (we can't if the protocol doing the get() doesn't support setting an offset)
			///      </remarks>		<short>    Call this at the beginning of put(), to give the size of the existing  partial file, if there is one.</short>
			/// <remarks>
			///  Call this in get and copy, to give the total size
			///  of the file
			///  Call in listDir too, when you know the total number of items.
			///      </remarks>		<short>    Call this in get and copy, to give the total size  of the file  Call in listDir too, when you know the total number of items.</short>
			/// <remarks>
			///  Call this during get and copy, once in a while,
			///  to give some info about the current state.
			///  Don't emit it in listDir, listEntries speaks for itself.
			///      </remarks>		<short>    Call this during get and copy, once in a while,  to give some info about the current state.</short>
			/// <remarks>
			///  Only use this if you can't know in advance the size of the
			///  copied data. For example, if you're doing variable bitrate
			///  compression of the source.
			///  STUB ! Currently unimplemented. Here now for binary compatibility.
			///  Call this during get and copy, once in a while,
			///  to give some info about the current state.
			///  Don't emit it in listDir, listEntries speaks for itself.
			///      </remarks>		<short>    Only use this if you can't know in advance the size of the  copied data.</short>
			public void ProcessedPercent(float percent) {
				interceptor.Invoke("processedPercent$", "processedPercent(float)", typeof(void), typeof(float), percent);
			}
			/// <remarks>
			///  Call this in get and copy, to give the current transfer
			///  speed, but only if it can't be calculated out of the size you
			///  passed to processedSize (in most cases you don't want to call it)
			///      </remarks>		<short>    Call this in get and copy, to give the current transfer  speed, but only if it can't be calculated out of the size you  passed to processedSize (in most cases you don't want to call it)      </short>
			public void Speed(ulong _bytes_per_second) {
				interceptor.Invoke("speed$", "speed(unsigned long)", typeof(void), typeof(ulong), _bytes_per_second);
			}
			/// <remarks>
			///  Call this to signal a redirection
			///  The job will take care of going to that url.
			///      </remarks>		<short>    Call this to signal a redirection  The job will take care of going to that url.</short>
			public void Redirection(KUrl _url) {
				interceptor.Invoke("redirection#", "redirection(const KUrl&)", typeof(void), typeof(KUrl), _url);
			}
			/// <remarks>
			///  Tell that we will only get an error page here.
			///  This means: the data you'll get isn't the data you requested,
			///  but an error page (usually HTML) that describes an error.
			///      </remarks>		<short>    Tell that we will only get an error page here.</short>
			public void ErrorPage() {
				interceptor.Invoke("errorPage", "errorPage()", typeof(void));
			}
			/// <remarks>
			///  Call this in mimetype() and in get(), when you know the mimetype.
			///  See mimetype about other ways to implement it.
			///      </remarks>		<short>    Call this in mimetype() and in get(), when you know the mimetype.</short>
			public void MimeType(string _type) {
				interceptor.Invoke("mimeType$", "mimeType(const QString&)", typeof(void), typeof(string), _type);
			}
			/// <remarks>
			///  Call to signal a warning, to be displayed in a dialog box.
			///      </remarks>		<short>    Call to signal a warning, to be displayed in a dialog box.</short>
			public void Warning(string msg) {
				interceptor.Invoke("warning$", "warning(const QString&)", typeof(void), typeof(string), msg);
			}
			/// <remarks>
			///  Call to signal a message, to be displayed if the application wants to,
			///  for instance in a status bar. Usual examples are "connecting to host xyz", etc.
			///      </remarks>		<short>    Call to signal a message, to be displayed if the application wants to,  for instance in a status bar.</short>
			public void InfoMessage(string msg) {
				interceptor.Invoke("infoMessage$", "infoMessage(const QString&)", typeof(void), typeof(string), msg);
			}
			/// <remarks>
			///  Call this to show a message box from the slave
			/// <param> name="type" type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
			/// </param><param> name="text" Message string. May contain newlines.
			/// </param><param> name="caption" Message box title.
			/// </param><param> name="buttonYes" The text for the first button.
			///                   The default is i18n("&Yes").
			/// </param><param> name="buttonNo" The text for the second button.
			///                   The default is i18n("&No").
			///  Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
			///        and for Information, none is used.
			/// </param></remarks>		<return> a button code, as defined in KMessageBox, or 0 on communication error.
			///      </return>
			/// 		<short>    Call this to show a message box from the slave </short>
			/// <remarks>
			///  Call this to show a message box from the slave
			/// <param> name="text" Message string. May contain newlines.
			/// </param><param> name="type" type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
			/// </param><param> name="caption" Message box title.
			/// </param><param> name="buttonYes" The text for the first button.
			///                   The default is i18n("&Yes").
			/// </param><param> name="buttonNo" The text for the second button.
			///                   The default is i18n("&No").
			///  Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
			///        and for Information, none is used.
			/// </param><param> name="dontAskAgainName" A checkbox is added with which further confirmation can be turned off.
			///         The string is used to lookup and store the setting in kioslaverc.
			/// </param></remarks>		<return> a button code, as defined in KMessageBox, or 0 on communication error.
			///      </return>
			/// 		<short>    Call this to show a message box from the slave </short>
			/// <remarks>
			///  Sets meta-data to be send to the application before the first
			///  data() or finished() signal.
			///      </remarks>		<short>    Sets meta-data to be send to the application before the first  data() or finished() signal.</short>
			public void SetMetaData(string key, string value) {
				interceptor.Invoke("setMetaData$$", "setMetaData(const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), value);
			}
			/// <remarks>
			///  Queries for the existence of a certain config/meta-data entry
			///  send by the application to the slave.
			///      </remarks>		<short>    Queries for the existence of a certain config/meta-data entry  send by the application to the slave.</short>
			public bool HasMetaData(string key) {
				return (bool) interceptor.Invoke("hasMetaData$", "hasMetaData(const QString&) const", typeof(bool), typeof(string), key);
			}
			/// <remarks>
			///  Queries for config/meta-data send by the application to the slave.
			///      </remarks>		<short>    Queries for config/meta-data send by the application to the slave.</short>
			public string MetaData(string key) {
				return (string) interceptor.Invoke("metaData$", "metaData(const QString&) const", typeof(string), typeof(string), key);
			}
			/// <remarks>
			///  Contains all metadata (but no config) sent by the application to the slave.
			///      </remarks>		<short>   </short>
			public KIO.MetaData AllMetaData() {
				return (KIO.MetaData) interceptor.Invoke("allMetaData", "allMetaData() const", typeof(KIO.MetaData));
			}
			/// <remarks>
			///  Returns a configuration object to query config/meta-data information
			///  from.
			///  The application provides the slave with all configuration information
			///  relevant for the current protocol and host.
			///      </remarks>		<short>    Returns a configuration object to query config/meta-data information  from.</short>
			public KConfigGroup Config() {
				return (KConfigGroup) interceptor.Invoke("config", "config()", typeof(KConfigGroup));
			}
			/// <remarks>
			///  Returns an object that can translate remote filenames into proper
			///  Unicode forms. This encoding can be set by the user.
			///      </remarks>		<short>    Returns an object that can translate remote filenames into proper  Unicode forms.</short>
			public KRemoteEncoding RemoteEncoding() {
				return (KRemoteEncoding) interceptor.Invoke("remoteEncoding", "remoteEncoding()", typeof(KRemoteEncoding));
			}
			/// <remarks>
			///  Set the host
			/// <param> name="pass"  Called directly by createSlave, this is why there is no equivalent in
			///  SlaveInterface, unlike the other methods.
			/// </param> This method is called whenever a change in host, port or user occurs.
			///      </remarks>		<short>    Set the host </short>
			[SmokeMethod("setHost(const QString&, quint16, const QString&, const QString&)")]
			public virtual void SetHost(string host, ushort port, string user, string pass) {
				interceptor.Invoke("setHost$$$$", "setHost(const QString&, quint16, const QString&, const QString&)", typeof(void), typeof(string), host, typeof(ushort), port, typeof(string), user, typeof(string), pass);
			}
			/// <remarks>
			///  Prepare slave for streaming operation
			///      </remarks>		<short>    Prepare slave for streaming operation      </short>
			[SmokeMethod("setSubUrl(const KUrl&)")]
			public virtual void SetSubUrl(KUrl url) {
				interceptor.Invoke("setSubUrl#", "setSubUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  Opens the connection (forced)
			///  When this function gets called the slave is operating in
			///  connection-oriented mode.
			///  When a connection gets lost while the slave operates in
			///  connection oriented mode, the slave should report
			///  ERR_CONNECTION_BROKEN instead of reconnecting. The user is
			///  expected to disconnect the slave in the error handler.
			///      </remarks>		<short>    Opens the connection (forced)  When this function gets called the slave is operating in  connection-oriented mode.</short>
			[SmokeMethod("openConnection()")]
			public virtual void OpenConnection() {
				interceptor.Invoke("openConnection", "openConnection()", typeof(void));
			}
			/// <remarks>
			///  Closes the connection (forced)
			///  Called when the application disconnects the slave to close
			///  any open network connections.
			///  When the slave was operating in connection-oriented mode,
			///  it should reset itself to connectionless (default) mode.
			///      </remarks>		<short>    Closes the connection (forced)  Called when the application disconnects the slave to close  any open network connections.</short>
			[SmokeMethod("closeConnection()")]
			public virtual void CloseConnection() {
				interceptor.Invoke("closeConnection", "closeConnection()", typeof(void));
			}
			/// <remarks>
			///  get, aka read.
			/// <param> name="url" the full url for this request. Host, port and user of the URL
			///         can be assumed to be the same as in the last setHost() call.
			///  The slave emits the data through data
			///      </param></remarks>		<short>    get, aka read.</short>
			[SmokeMethod("get(const KUrl&)")]
			public virtual void Get(KUrl url) {
				interceptor.Invoke("get#", "get(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  open.
			/// <param> name="url" the full url for this request. Host, port and user of the URL
			///         can be assumed to be the same as in the last setHost() call.
			/// </param><param> name="mode" see \ref QIODevice.OpenMode
			///      </param></remarks>		<short>    open.</short>
			[SmokeMethod("open(const KUrl&, QIODevice::OpenMode)")]
			public virtual void Open(KUrl url, uint mode) {
				interceptor.Invoke("open#$", "open(const KUrl&, QIODevice::OpenMode)", typeof(void), typeof(KUrl), url, typeof(uint), mode);
			}
			[SmokeMethod("write(const QByteArray&)")]
			public virtual void Write(QByteArray data) {
				interceptor.Invoke("write#", "write(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			[SmokeMethod("close()")]
			public virtual void Close() {
				interceptor.Invoke("close", "close()", typeof(void));
			}
			/// <remarks>
			///  put, i.e. write data into a file.
			/// <param> name="url" where to write the file
			/// </param><param> name="permissions" may be -1. In this case no special permission mode is set.
			/// </param><param> name="flags" : We support Overwrite here. Hopefully, we're going to
			///  support Resume in the future, too.
			///  If the file indeed already exists, the slave should NOT apply the
			///  permissions change to it.
			///  The support for resuming using .part files is done by calling canResume().
			/// </param> IMPORTANT: Use the "modified" metadata in order to set the modification time of the file.
			/// </remarks>		<short>    put, i.</short>
			/// 		<see> canResume</see>
			[SmokeMethod("put(const KUrl&, int, KIO::JobFlags)")]
			public virtual void Put(KUrl url, int permissions, uint flags) {
				interceptor.Invoke("put#$$", "put(const KUrl&, int, KIO::JobFlags)", typeof(void), typeof(KUrl), url, typeof(int), permissions, typeof(uint), flags);
			}
			/// <remarks>
			///  Finds all details for one file or directory.
			///  The information returned is the same as what listDir returns,
			///  but only for one file or directory.
			///      </remarks>		<short>    Finds all details for one file or directory.</short>
			[SmokeMethod("stat(const KUrl&)")]
			public virtual void Stat(KUrl url) {
				interceptor.Invoke("stat#", "stat(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  Finds mimetype for one file or directory.
			///  This method should either emit 'mimeType' or it
			///  should send a block of data big enough to be able
			///  to determine the mimetype.
			///  If the slave doesn't reimplement it, a get will
			///  be issued, i.e. the whole file will be downloaded before
			///  determining the mimetype on it - this is obviously not a
			///  good thing in most cases.
			///      </remarks>		<short>    Finds mimetype for one file or directory.</short>
			[SmokeMethod("mimetype(const KUrl&)")]
			public virtual void Mimetype(KUrl url) {
				interceptor.Invoke("mimetype#", "mimetype(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  Lists the contents of <code>url.</code>
			///  The slave should emit ERR_CANNOT_ENTER_DIRECTORY if it doesn't exist,
			///  if we don't have enough permissions, or if it is a file
			///  It should also emit totalFiles as soon as it knows how many
			///  files it will list.
			///      </remarks>		<short>    Lists the contents of <code>url.</code></short>
			[SmokeMethod("listDir(const KUrl&)")]
			public virtual void ListDir(KUrl url) {
				interceptor.Invoke("listDir#", "listDir(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  Create a directory
			/// <param> name="url" path to the directory to create
			/// </param><param> name="permissions" the permissions to set after creating the directory
			///  (-1 if no permissions to be set)
			///  The slave emits ERR_COULD_NOT_MKDIR if failure.
			///      </param></remarks>		<short>    Create a directory </short>
			[SmokeMethod("mkdir(const KUrl&, int)")]
			public virtual void Mkdir(KUrl url, int permissions) {
				interceptor.Invoke("mkdir#$", "mkdir(const KUrl&, int)", typeof(void), typeof(KUrl), url, typeof(int), permissions);
			}
			/// <remarks>
			///  Rename <code>oldname</code> into <code>newname.</code>
			///  If the slave returns an error ERR_UNSUPPORTED_ACTION, the job will
			///  ask for copy + del instead.
			/// <param> name="src" where to move the file from
			/// </param><param> name="dest" where to move the file to
			/// </param><param> name="flags" : We support Overwrite here
			///      </param></remarks>		<short>    Rename <code>oldname</code> into <code>newname.</code></short>
			[SmokeMethod("rename(const KUrl&, const KUrl&, KIO::JobFlags)")]
			public virtual void Rename(KUrl src, KUrl dest, uint flags) {
				interceptor.Invoke("rename##$", "rename(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(void), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
			}
			/// <remarks>
			///  Creates a symbolic link named <code>dest</code>, pointing to <code>target</code>, which
			///  may be a relative or an absolute path.
			/// <param> name="target" The string that will become the "target" of the link (can be relative)
			/// </param><param> name="dest" The symlink to create.
			/// </param><param> name="flags" : We support Overwrite here
			///      </param></remarks>		<short>    Creates a symbolic link named <code>dest</code>, pointing to <code>target</code>, which  may be a relative or an absolute path.</short>
			[SmokeMethod("symlink(const QString&, const KUrl&, KIO::JobFlags)")]
			public virtual void Symlink(string target, KUrl dest, uint flags) {
				interceptor.Invoke("symlink$#$", "symlink(const QString&, const KUrl&, KIO::JobFlags)", typeof(void), typeof(string), target, typeof(KUrl), dest, typeof(uint), flags);
			}
			/// <remarks>
			///  Change permissions on <code>url</code>
			///  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHMOD
			///      </remarks>		<short>    Change permissions on <code>url</code>  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHMOD      </short>
			[SmokeMethod("chmod(const KUrl&, int)")]
			public virtual void Chmod(KUrl url, int permissions) {
				interceptor.Invoke("chmod#$", "chmod(const KUrl&, int)", typeof(void), typeof(KUrl), url, typeof(int), permissions);
			}
			/// <remarks>
			///  Change ownership of <code>url</code>
			///  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHOWN
			///      </remarks>		<short>    Change ownership of <code>url</code>  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHOWN      </short>
			[SmokeMethod("chown(const KUrl&, const QString&, const QString&)")]
			public virtual void Chown(KUrl url, string owner, string group) {
				interceptor.Invoke("chown#$$", "chown(const KUrl&, const QString&, const QString&)", typeof(void), typeof(KUrl), url, typeof(string), owner, typeof(string), group);
			}
			/// <remarks>
			///  Sets the modification time for @url
			///  For instance this is what CopyJob uses to set mtime on dirs at the end of a copy.
			///  It could also be used to set the mtime on any file, in theory.
			///  The usual implementation on unix is to call utime(path, &myutimbuf).
			///  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_SETTIME
			///      </remarks>		<short>    Sets the modification time for @url  For instance this is what CopyJob uses to set mtime on dirs at the end of a copy.</short>
			[SmokeMethod("setModificationTime(const KUrl&, const QDateTime&)")]
			public virtual void SetModificationTime(KUrl url, QDateTime mtime) {
				interceptor.Invoke("setModificationTime##", "setModificationTime(const KUrl&, const QDateTime&)", typeof(void), typeof(KUrl), url, typeof(QDateTime), mtime);
			}
			/// <remarks>
			///  Copy <code>src</code> into <code>dest.</code>
			///  If the slave returns an error ERR_UNSUPPORTED_ACTION, the job will
			///  ask for get + put instead.
			/// <param> name="src" where to copy the file from (decoded)
			/// </param><param> name="dest" where to copy the file to (decoded)
			/// </param><param> name="permissions" may be -1. In this case no special permission mode is set.
			/// </param><param> name="flags" : We support Overwrite here
			/// </param> Don't forget to set the modification time of <code>dest</code> to be the modification time of <code>src.</code>
			///      </remarks>		<short>    Copy <code>src</code> into <code>dest.</code></short>
			[SmokeMethod("copy(const KUrl&, const KUrl&, int, KIO::JobFlags)")]
			public virtual void Copy(KUrl src, KUrl dest, int permissions, uint flags) {
				interceptor.Invoke("copy##$$", "copy(const KUrl&, const KUrl&, int, KIO::JobFlags)", typeof(void), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions, typeof(uint), flags);
			}
			/// <remarks>
			///  Delete a file or directory.
			/// <param> name="url" file/directory to delete
			/// </param><param> name="isfile" if true, a file should be deleted.
			///                if false, a directory should be deleted.
			///      </param></remarks>		<short>    Delete a file or directory.</short>
			[SmokeMethod("del(const KUrl&, bool)")]
			public virtual void Del(KUrl url, bool isfile) {
				interceptor.Invoke("del#$", "del(const KUrl&, bool)", typeof(void), typeof(KUrl), url, typeof(bool), isfile);
			}
			/// <remarks>
			///  Change the destination of a symlink
			/// <param> name="url" the url of the symlink to modify
			/// </param><param> name="target" the new destination (target) of the symlink
			///      </param></remarks>		<short>    Change the destination of a symlink </short>
			[SmokeMethod("setLinkDest(const KUrl&, const QString&)")]
			public virtual void SetLinkDest(KUrl url, string target) {
				interceptor.Invoke("setLinkDest#$", "setLinkDest(const KUrl&, const QString&)", typeof(void), typeof(KUrl), url, typeof(string), target);
			}
			/// <remarks>
			///  Used for any command that is specific to this slave (protocol)
			///  Examples are : HTTP POST, mount and unmount (kio_file)
			/// <param> name="data" packed data; the meaning is completely dependent on the
			///         slave, but usually starts with an int for the command number.
			///  Document your slave's commands, at least in its header file.
			///      </param></remarks>		<short>    Used for any command that is specific to this slave (protocol)  Examples are : HTTP POST, mount and unmount (kio_file) </short>
			[SmokeMethod("special(const QByteArray&)")]
			public virtual void Special(QByteArray data) {
				interceptor.Invoke("special#", "special(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Used for multiple get. Currently only used foir HTTP pielining
			///  support.
			/// <param> name="data" packed data; Contains number of URLs to fetch, and for
			///  each URL the URL itself and its associated MetaData.
			///      </param></remarks>		<short>    Used for multiple get.</short>
			[SmokeMethod("multiGet(const QByteArray&)")]
			public virtual void MultiGet(QByteArray data) {
				interceptor.Invoke("multiGet#", "multiGet(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Called to get the status of the slave. Slave should respond
			///  by calling slaveStatus(...)
			///      </remarks>		<short>    Called to get the status of the slave.</short>
			[SmokeMethod("slave_status()")]
			public virtual void Slave_status() {
				interceptor.Invoke("slave_status", "slave_status()", typeof(void));
			}
			/// <remarks>
			///  Called by the scheduler to tell the slave that the configuration
			///  changed (i.e. proxy settings) .
			///      </remarks>		<short>    Called by the scheduler to tell the slave that the configuration  changed (i.</short>
			[SmokeMethod("reparseConfiguration()")]
			public virtual void ReparseConfiguration() {
				interceptor.Invoke("reparseConfiguration", "reparseConfiguration()", typeof(void));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for connecting to remote host.
			///      </return>
			/// 		<short>   </short>
			public int ConnectTimeout() {
				return (int) interceptor.Invoke("connectTimeout", "connectTimeout()", typeof(int));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for connecting to proxy in secs.
			///      </return>
			/// 		<short>   </short>
			public int ProxyConnectTimeout() {
				return (int) interceptor.Invoke("proxyConnectTimeout", "proxyConnectTimeout()", typeof(int));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for read from first data from
			///  remote host in seconds.
			///      </return>
			/// 		<short>   </short>
			public int ResponseTimeout() {
				return (int) interceptor.Invoke("responseTimeout", "responseTimeout()", typeof(int));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for read from subsequent data from
			///  remote host in secs.
			///      </return>
			/// 		<short>   </short>
			public int ReadTimeout() {
				return (int) interceptor.Invoke("readTimeout", "readTimeout()", typeof(int));
			}
			/// <remarks>
			///  This function sets a timeout of <code>timeout</code> seconds and calls
			///  special(data) when the timeout occurs as if it was called by the
			///  application.
			///  A timeout can only occur when the slave is waiting for a command
			///  from the application.
			///  Specifying a negative timeout cancels a pending timeout.
			///  Only one timeout at a time is supported, setting a timeout
			///  cancels any pending timeout.
			///      </remarks>		<short>    This function sets a timeout of <code>timeout</code> seconds and calls  special(data) when the timeout occurs as if it was called by the  application.</short>
			public void SetTimeoutSpecialCommand(int timeout, QByteArray data) {
				interceptor.Invoke("setTimeoutSpecialCommand$#", "setTimeoutSpecialCommand(int, const QByteArray&)", typeof(void), typeof(int), timeout, typeof(QByteArray), data);
			}
			public void SetTimeoutSpecialCommand(int timeout) {
				interceptor.Invoke("setTimeoutSpecialCommand$", "setTimeoutSpecialCommand(int)", typeof(void), typeof(int), timeout);
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			[SmokeMethod("dispatch(int, const QByteArray&)")]
			public virtual void Dispatch(int command, QByteArray data) {
				interceptor.Invoke("dispatch$#", "dispatch(int, const QByteArray&)", typeof(void), typeof(int), command, typeof(QByteArray), data);
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			[SmokeMethod("dispatchOpenCommand(int, const QByteArray&)")]
			public virtual void DispatchOpenCommand(int command, QByteArray data) {
				interceptor.Invoke("dispatchOpenCommand$#", "dispatchOpenCommand(int, const QByteArray&)", typeof(void), typeof(int), command, typeof(QByteArray), data);
			}
			/// <remarks>
			///  Read data send by the job, after a dataReq
			/// <param> name="buffer" buffer where data is stored
			/// </param></remarks>		<return> 0 on end of data,
			///          > 0 bytes read
			///          < 0 error
			/// </return>
			/// 		<short>    Read data send by the job, after a dataReq </short>
			public int ReadData(QByteArray buffer) {
				return (int) interceptor.Invoke("readData#", "readData(QByteArray&)", typeof(int), typeof(QByteArray), buffer);
			}
			/// <remarks>
			///  internal function to be called by the slave.
			///  It collects entries and emits them via listEntries
			///  when enough of them are there or a certain time
			///  frame exceeded (to make sure the app gets some
			///  items in time but not too many items one by one
			///  as this will cause a drastic performance penalty)
			/// <param> name="_entry" The UDSEntry containing all of the object attributes.
			/// </param><param> name="ready" set to true after emitting all items. <code>_entry</code> is not
			///         used in this case
			///      </param></remarks>		<short>    internal function to be called by the slave.</short>
			public void ListEntry(KIO.UDSEntry _entry, bool ready) {
				interceptor.Invoke("listEntry#$", "listEntry(const KIO::UDSEntry&, bool)", typeof(void), typeof(KIO.UDSEntry), _entry, typeof(bool), ready);
			}
			/// <remarks>
			///  internal function to connect a slave to/ disconnect from
			///  either the slave pool or the application
			///      </remarks>		<short>    internal function to connect a slave to/ disconnect from  either the slave pool or the application      </short>
			public void ConnectSlave(string path) {
				interceptor.Invoke("connectSlave$", "connectSlave(const QString&)", typeof(void), typeof(string), path);
			}
			public void DisconnectSlave() {
				interceptor.Invoke("disconnectSlave", "disconnectSlave()", typeof(void));
			}
			/// <remarks>
			///  Prompt the user for Authorization info (login & password).
			///  Use this function to request authorization information from
			///  the end user. You can also pass an error message which explains
			///  why a previous authorization attempt failed. Here is a very
			///  simple example:
			///  <pre>
			///  KIO.AuthInfo authInfo;
			///  if ( openPasswordDialog( authInfo ) )
			///  {
			///     kDebug() << QLatin1String("User: ")
			///               << authInfo.username << endl;
			///     kDebug() << QLatin1String("Password: ")
			///               << QLatin1String("Not displayed here!") << endl;
			///  }
			///  </pre>
			///  You can also preset some values like the username, caption or
			///  comment as follows:
			///  <pre>
			///  KIO.AuthInfo authInfo;
			///  authInfo.caption= "Acme Password Dialog";
			///  authInfo.username= "Wile E. Coyote";
			///  string errorMsg = "You entered an incorrect password.";
			///  if ( openPasswordDialog( authInfo, errorMsg ) )
			///  {
			///     kDebug() << QLatin1String("User: ")
			///               << authInfo.username << endl;
			///     kDebug() << QLatin1String("Password: ")
			///               << QLatin1String("Not displayed here!") << endl;
			///  }
			///  </pre>
			///  <b>Note:<> You should consider using checkCachedAuthentication() to
			///  see if the password is available in kpasswdserver before calling
			///  this function.
			///  <b>Note:<> A call to this function can fail and return <code>false</code>,
			///  if the UIServer could not be started for whatever reason.
			/// <param> name="info" See AuthInfo.
			/// </param><param> name="errorMsg" Error message to show
			/// </param></remarks>		<return> <code>true</code> if user clicks on "OK", <code>false</code> otherwsie.
			///      </return>
			/// 		<short>    Prompt the user for Authorization info (login & password).</short>
			/// 		<see> checkCachedAuthentication</see>
			public bool OpenPasswordDialog(KIO.AuthInfo info, string errorMsg) {
				return (bool) interceptor.Invoke("openPasswordDialog#$", "openPasswordDialog(KIO::AuthInfo&, const QString&)", typeof(bool), typeof(KIO.AuthInfo), info, typeof(string), errorMsg);
			}
			public bool OpenPasswordDialog(KIO.AuthInfo info) {
				return (bool) interceptor.Invoke("openPasswordDialog#", "openPasswordDialog(KIO::AuthInfo&)", typeof(bool), typeof(KIO.AuthInfo), info);
			}
			/// <remarks>
			///  Used by the slave to check if it can connect
			///  to a given host. This should be called where the slave is ready
			///  to do a .Connect() on a socket. For each call to
			///  requestNetwork must exist a matching call to
			///  dropNetwork, or the system will stay online until
			///  KNetMgr gets closed (or the SlaveBase gets destructed)!
			///  If KNetMgr is not running, then this is a no-op and returns true
			/// <param> name="host" tells the netmgr the host the slave wants to connect
			///              to. As this could also be a proxy, we can't just take
			///              the host currenctly connected to (but that's the default
			///              value)
			/// </param></remarks>		<return> true in theorie, the host is reachable
			///          false the system is offline and the host is in a remote network.
			///      </return>
			/// 		<short>    Used by the slave to check if it can connect  to a given host.</short>
			public bool RequestNetwork(string host) {
				return (bool) interceptor.Invoke("requestNetwork$", "requestNetwork(const QString&)", typeof(bool), typeof(string), host);
			}
			public bool RequestNetwork() {
				return (bool) interceptor.Invoke("requestNetwork", "requestNetwork()", typeof(bool));
			}
			/// <remarks>
			///  Used by the slave to withdraw a connection requested by
			///  requestNetwork. This function cancels the last call to
			///  requestNetwork. If a client uses more than one internet
			///  connection, it must use dropNetwork(host) to
			///  stop each request.
			///  If KNetMgr is not running, then this is a no-op.
			/// <param> name="host" the host passed to requestNetwork
			/// </param> A slave should call this function every time it disconnect from a host.
			///  </remarks>		<short>    Used by the slave to withdraw a connection requested by  requestNetwork.</short>
			public void DropNetwork(string host) {
				interceptor.Invoke("dropNetwork$", "dropNetwork(const QString&)", typeof(void), typeof(string), host);
			}
			public void DropNetwork() {
				interceptor.Invoke("dropNetwork", "dropNetwork()", typeof(void));
			}
			/// <remarks>
			///  Wait for an answer to our request, until we get <code>expected1</code> or <code>expected2</code>
			/// </remarks>		<return> the result from readData, as well as the cmd in *pCmd if set, and the data in <code>data</code>
			///      </return>
			/// 		<short>    Wait for an answer to our request, until we get <code>expected1</code> or <code>expected2</code> </short>
			public int WaitForAnswer(int expected1, int expected2, QByteArray data, ref int pCmd) {
				StackItem[] stack = new StackItem[5];
				stack[1].s_int = expected1;
				stack[2].s_int = expected2;
	#if DEBUG
				stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(data);
	#else
				stack[3].s_class = (IntPtr) GCHandle.Alloc(data);
	#endif
				stack[4].s_int = pCmd;
				interceptor.Invoke("waitForAnswer$$#$", "waitForAnswer(int, int, QByteArray&, int*)", stack);
	#if DEBUG
				DebugGCHandle.Free((GCHandle) stack[3].s_class);
	#else
				((GCHandle) stack[3].s_class).Free();
	#endif
				pCmd = stack[4].s_int;
				return stack[0].s_int;
			}
			public int WaitForAnswer(int expected1, int expected2, QByteArray data) {
				return (int) interceptor.Invoke("waitForAnswer$$#", "waitForAnswer(int, int, QByteArray&)", typeof(int), typeof(int), expected1, typeof(int), expected2, typeof(QByteArray), data);
			}
			/// <remarks>
			///  Internal function to transmit meta data to the application.
			///      </remarks>		<short>    Internal function to transmit meta data to the application.</short>
			public void SendMetaData() {
				interceptor.Invoke("sendMetaData", "sendMetaData()", typeof(void));
			}
			/// <remarks> If your ioslave was killed by a signal, wasKilled() returns true.
			///      Check it regularly in lengthy functions (e.g. in get();) and return
			///      as fast as possible from this function if wasKilled() returns true.
			///      This will ensure that your slave destructor will be called correctly.
			///      </remarks>		<short>   If your ioslave was killed by a signal, wasKilled() returns true.</short>
			public bool WasKilled() {
				return (bool) interceptor.Invoke("wasKilled", "wasKilled() const", typeof(bool));
			}
			/// <remarks> Internally used.
			///      </remarks>		<short>   Internally used.</short>
			public void SetKillFlag() {
				interceptor.Invoke("setKillFlag", "setKillFlag()", typeof(void));
			}
		}

		/// <remarks>
		///  There are two classes that specifies the protocol between application (job)
		///  and kioslave. SlaveInterface is the class to use on the application end,
		///  SlaveBase is the one to use on the slave end.
		///  Slave implementations should simply inherit SlaveBase
		///  A call to foo() results in a call to slotFoo() on the other end.
		///  </remarks>		<short>    There are two classes that specifies the protocol between application (job)  and kioslave.</short>

		[SmokeClass("KIO::TCPSlaveBase")]
		public class TCPSlaveBase : KIO.SlaveBase {
	 		protected TCPSlaveBase(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(TCPSlaveBase), this);
			}
			public TCPSlaveBase(ushort defaultPort, QByteArray protocol, QByteArray poolSocket, QByteArray appSocket, bool useSSL) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("TCPSlaveBase$###$", "TCPSlaveBase(unsigned short int, const QByteArray&, const QByteArray&, const QByteArray&, bool)", typeof(void), typeof(ushort), defaultPort, typeof(QByteArray), protocol, typeof(QByteArray), poolSocket, typeof(QByteArray), appSocket, typeof(bool), useSSL);
			}
			public TCPSlaveBase(ushort defaultPort, QByteArray protocol, QByteArray poolSocket, QByteArray appSocket) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("TCPSlaveBase$###", "TCPSlaveBase(unsigned short int, const QByteArray&, const QByteArray&, const QByteArray&)", typeof(void), typeof(ushort), defaultPort, typeof(QByteArray), protocol, typeof(QByteArray), poolSocket, typeof(QByteArray), appSocket);
			}
			/// <remarks>
			///  This function acts like standard write function call
			///  except it is also capable of making SSL or SOCKS
			///  connections.
			/// <param> name="data" info to be sent to remote machine
			/// </param><param> name="len" the length of the data to be sent
			/// </param></remarks>		<return> the actual size of the data that was sent
			///      </return>
			/// 		<short>    This function acts like standard write function call  except it is also capable of making SSL or SOCKS  connections.</short>
			protected int Write(string data, int len) {
				return (int) interceptor.Invoke("write$?", "write(const char*, ssize_t)", typeof(int), typeof(string), data, typeof(int), len);
			}
			/// <remarks>
			///  This function acts like standard read function call
			///  except it is also capable of deciphering SSL data as
			///  well as handling data over SOCKSified connections.
			/// <param> name="data" storage for the info read from server
			/// </param><param> name="len" length of the info to read from the server
			/// </param></remarks>		<return> the actual size of data that was obtained
			///      </return>
			/// 		<short>    This function acts like standard read function call  except it is also capable of deciphering SSL data as  well as handling data over SOCKSified connections.</short>
			protected int Read(string data, int len) {
				return (int) interceptor.Invoke("read$?", "read(char*, ssize_t)", typeof(int), typeof(string), data, typeof(int), len);
			}
			/// <remarks>
			///  Same as above except it reads data one line at a time.
			///      </remarks>		<short>    Same as above except it reads data one line at a time.</short>
			protected int ReadLine(string data, int len) {
				return (int) interceptor.Invoke("readLine$?", "readLine(char*, ssize_t)", typeof(int), typeof(string), data, typeof(int), len);
			}
			/// <remarks>
			///  Sets the maximum size of blocks read in during calls to readLine().
			///  This allows a slave to optimize for the protocol which it implements.
			///  Ideally this should be (common_line_length+1) or so.
			///  Making this too large will have adverse effects on performance.
			///  Initial/default value is 256(bytes)
			///      </remarks>		<short>    Sets the maximum size of blocks read in during calls to readLine().</short>
			protected void SetBlockSize(int sz) {
				interceptor.Invoke("setBlockSize$", "setBlockSize(int)", typeof(void), typeof(int), sz);
			}
			/// <remarks>
			///  Performs the initial TCP connection stuff and/or
			///  SSL handshaking as necessary.
			///  Please note that unlike its deprecated counterpart, this
			///  function allows you to disable any error message from being
			///  sent back to the calling application!  You can then use the
			///  connectResult() function to determine the result of the
			///  request for connection.
			/// <param> name="protocol" the protocol being used
			/// </param><param> name="host" hostname
			/// </param><param> name="port" port number
			/// </param><param> name="sendError" if true sends error message to calling app.
			/// </param></remarks>		<return> on succes, true is returned.
			///          on failure, false is returned and an appropriate
			///          error message is send to the application.
			///      </return>
			/// 		<short>    Performs the initial TCP connection stuff and/or  SSL handshaking as necessary.</short>
			protected bool ConnectToHost(string protocol, string host, ushort port, bool sendError) {
				return (bool) interceptor.Invoke("connectToHost$$$$", "connectToHost(const QString&, const QString&, quint16, bool)", typeof(bool), typeof(string), protocol, typeof(string), host, typeof(ushort), port, typeof(bool), sendError);
			}
			protected bool ConnectToHost(string protocol, string host, ushort port) {
				return (bool) interceptor.Invoke("connectToHost$$$", "connectToHost(const QString&, const QString&, quint16)", typeof(bool), typeof(string), protocol, typeof(string), host, typeof(ushort), port);
			}
			/// <remarks>
			///  set the default port for this service
			///      </remarks>		<short>    set the default port for this service </short>
			protected void SetDefaultPort(ushort port) {
				interceptor.Invoke("setDefaultPort$", "setDefaultPort(quint16)", typeof(void), typeof(ushort), port);
			}
			/// <remarks>
			///  the current default port for this service
			///      </remarks>		<short>    the current default port for this service </short>
			protected ushort DefaultPort() {
				return (ushort) interceptor.Invoke("defaultPort", "defaultPort() const", typeof(ushort));
			}
			/// <remarks>
			///  the current port for this service
			///      </remarks>		<short>    the current port for this service </short>
			protected ushort Port() {
				return (ushort) interceptor.Invoke("port", "port() const", typeof(ushort));
			}
			/// <remarks>
			///  Are we using SSL?
			/// </remarks>		<return> if so, true is returned.
			///          if not, true isn't returned.
			///      </return>
			/// 		<short>    Are we using SSL? </short>
			protected bool UsingSSL() {
				return (bool) interceptor.Invoke("usingSSL", "usingSSL() const", typeof(bool));
			}
			/// <remarks>
			///  Are we using TLS?
			/// </remarks>		<return> if so, true is returned.
			///          if not, true isn't returned.
			///      </return>
			/// 		<short>    Are we using TLS? </short>
			protected bool UsingTLS() {
				return (bool) interceptor.Invoke("usingTLS", "usingTLS() const", typeof(bool));
			}
			/// <remarks>
			///  Can we use TLS?
			/// </remarks>		<return> if so, true is returned.
			///          if not, true isn't returned.
			///      </return>
			/// 		<short>    Can we use TLS? </short>
			protected bool CanUseTLS() {
				return (bool) interceptor.Invoke("canUseTLS", "canUseTLS() const", typeof(bool));
			}
			/// <remarks>
			///  Start using TLS on the connection.
			/// </remarks>		<return> on success, 1 is returned.
			///          on failure, 0 is returned.
			///          on TLS init failure, -1 is returned.
			///          on connect failure, -2 is returned.
			///          on certificate failure, -3 is returned.
			///      </return>
			/// 		<short>    Start using TLS on the connection.</short>
			protected int StartTLS() {
				return (int) interceptor.Invoke("startTLS", "startTLS()", typeof(int));
			}
			/// <remarks>
			///  Stop using TLS on the connection.
			///      </remarks>		<short>    Stop using TLS on the connection.</short>
			protected void StopTLS() {
				interceptor.Invoke("stopTLS", "stopTLS()", typeof(void));
			}
			/// <remarks>
			///  Closes the current file descriptor.
			///  Call this function to properly close up the socket
			///  since it also takes care to prroperly close the stdio
			///  fstream stuff, as well as sets the socket back to -1
			///      </remarks>		<short>    Closes the current file descriptor.</short>
			protected void CloseDescriptor() {
				interceptor.Invoke("closeDescriptor", "closeDescriptor()", typeof(void));
			}
			/// <remarks>
			///  Returns true when end of data is reached
			///      </remarks>		<short>    Returns true when end of data is reached      </short>
			protected bool AtEnd() {
				return (bool) interceptor.Invoke("atEnd", "atEnd() const", typeof(bool));
			}
			/// <remarks>
			///  Call this if you use persistent connections and want all the
			///  metadata restored.  This is particularly important for SSL
			///  sessions since the app needs to know the state of connection,
			///  certificates, etc.
			///      </remarks>		<short>    Call this if you use persistent connections and want all the  metadata restored.</short>
			protected void SetSSLMetaData() {
				interceptor.Invoke("setSSLMetaData", "setSSLMetaData()", typeof(void));
			}
			/// <remarks>
			///  Initializs all SSL variables
			///      </remarks>		<short>    Initializs all SSL variables      </short>
			protected bool InitializeSSL() {
				return (bool) interceptor.Invoke("initializeSSL", "initializeSSL()", typeof(bool));
			}
			/// <remarks>
			///  Cleans up all SSL settings.
			///      </remarks>		<short>    Cleans up all SSL settings.</short>
			protected void CleanSSL() {
				interceptor.Invoke("cleanSSL", "cleanSSL()", typeof(void));
			}
			/// <remarks>
			///  Determines whether or not we are still connected
			///  to the remote machine.
			///  This method may fail to detect a closed SSL connection.
			///  return <code>true</code> if the socket is still active or
			///            false otherwise.
			///      </remarks>		<short>    Determines whether or not we are still connected  to the remote machine.</short>
			protected bool IsConnectionValid() {
				return (bool) interceptor.Invoke("isConnectionValid", "isConnectionValid()", typeof(bool));
			}
			/// <remarks>
			///  Returns the status of the connection.
			///  This function allows you to invoke ConnectToHost
			///  with the <code>sendError</code> flag set to false so that you
			///  can send the appropriate error message back to the
			///  calling io-slave.
			/// </remarks>		<return> the error code after the connection
			///      </return>
			/// 		<short>    Returns the status of the connection.</short>
			protected int ConnectResult() {
				return (int) interceptor.Invoke("connectResult", "connectResult()", typeof(int));
			}
			/// <remarks>
			///  Wait for some type of activity on the socket
			///  for the period specified by <code>t.</code>
			/// <param> name="t" length of time in seconds that we should monitor the
			///            socket before timing out.
			/// </param></remarks>		<return> true if any activity was seen on the socket before the
			///               timeout value was reached, false otherwise.
			///      </return>
			/// 		<short>    Wait for some type of activity on the socket  for the period specified by <code>t.</code></short>
			protected bool WaitForResponse(int t) {
				return (bool) interceptor.Invoke("waitForResponse$", "waitForResponse(int)", typeof(bool), typeof(int), t);
			}
			/// <remarks>
			///  Sets the mode of the connection to blocking or non-blocking.
			///  Be sure to call this function before calling connectToHost.
			///  Otherwise, this setting will not have any effect until the next
			///  <code>connectToHost.</code>
			/// <param> name="b" true to make the connection a blocking one, false otherwise.
			///      </param></remarks>		<short>    Sets the mode of the connection to blocking or non-blocking.</short>
			protected void SetBlockConnection(bool b) {
				interceptor.Invoke("setBlockConnection$", "setBlockConnection(bool)", typeof(void), typeof(bool), b);
			}
			/// <remarks>
			///  Sets how long to wait for orignally connecting to
			///  the requested before timinig out.
			///  Be sure to call this function before calling ConnectToHost,
			///  otherwise the setting will not take effect until the next call
			///  to <code>ConnectToHost.</code>
			/// <param> name="t" timeout value
			///      </param></remarks>		<short>    Sets how long to wait for orignally connecting to  the requested before timinig out.</short>
			protected void SetConnectTimeout(int t) {
				interceptor.Invoke("setConnectTimeout$", "setConnectTimeout(int)", typeof(void), typeof(int), t);
			}
			/// <remarks>
			///  Returns true if SSL tunneling is enabled.
			/// </remarks>		<short>    Returns true if SSL tunneling is enabled.</short>
			/// 		<see> setEnableSSlTunnel</see>
			protected bool IsSSLTunnelEnabled() {
				return (bool) interceptor.Invoke("isSSLTunnelEnabled", "isSSLTunnelEnabled() const", typeof(bool));
			}
			/// <remarks>
			///  Set up SSL tunneling mode.
			///  Calling this function with a <code>true</code> argument will allow
			///  you to temprarly ignore the <code>m_bIsSSL</code> flag setting and
			///  make a non-SSL connection.  It is mostly useful for making
			///  connections to SSL sites through a non-transparent proxy
			///  server (i.e. most proxy servers out there).
			///  Note that once you have successfully "tunneled" through the
			///  proxy server you must call this function with its argument
			///  set to false to properly connect to the SSL site.
			/// <param> name="enable" if true SSL Tunneling will be enabled
			///      </param></remarks>		<short>    Set up SSL tunneling mode.</short>
			protected void SetEnableSSLTunnel(bool enable) {
				interceptor.Invoke("setEnableSSLTunnel$", "setEnableSSLTunnel(bool)", typeof(void), typeof(bool), enable);
			}
			/// <remarks>
			///  Sets up the the real hostname for an SSL connection
			///  that goes through a proxy server.
			///  This function is essential in making sure that the
			///  real hostname is used for validating certificates from
			///  SSL sites!
			/// <param> name="realHost" the actual host name we are connecting to
			///      </param></remarks>		<short>    Sets up the the real hostname for an SSL connection  that goes through a proxy server.</short>
			protected void SetRealHost(string realHost) {
				interceptor.Invoke("setRealHost$", "setRealHost(const QString&)", typeof(void), typeof(string), realHost);
			}
			protected int VerifyCertificate() {
				return (int) interceptor.Invoke("verifyCertificate", "verifyCertificate()", typeof(int));
			}
			protected void CertificatePrompt() {
				interceptor.Invoke("certificatePrompt", "certificatePrompt()", typeof(void));
			}
			protected bool UserAborted() {
				return (bool) interceptor.Invoke("userAborted", "userAborted() const", typeof(bool));
			}
			/// <remarks>
			///  Return the socket object, if the class ever needs to do anything to it
			///      </remarks>		<short>    Return the socket object, if the class ever needs to do anything to it      </short>
			protected QIODevice Socket() {
				return (QIODevice) interceptor.Invoke("socket", "socket() const", typeof(QIODevice));
			}
		}

		/// <remarks>
		///  This class should be used as a base for ioslaves acting as a
		///  forwarder to other ioslaves. It has been designed to support only
		///  local filesystem like ioslaves.
		///  If the resulting ioslave should be a simple proxy, you only need
		///  to implement the ForwardingSlaveBase.RewriteUrl() method.
		///  For more advanced behavior, the classic ioslave methods should
		///  be reimplemented, because their default behavior in this class
		///  is to forward using the ForwardingSlaveBase.RewriteUrl() method.
		///  A possible code snippet for an advanced stat() behavior would look
		///  like this in the child class:
		///  <pre>
		///      void ChildProtocol.Stat(KUrlurl)
		///      {
		///          bool is_special = false;
		///          // Process the URL to see if it should have
		///          // a special treatment
		///          if ( is_special )
		///          {
		///              // Handle the URL ourselves
		///              KIO.UDSEntry entry;
		///              // Fill entry with UDSAtom instances
		///              statEntry(entry);
		///              finished();
		///          }
		///          else
		///          {
		///              // Setup the ioslave internal state if
		///              // required by ChildProtocol.RewriteUrl()
		///              ForwardingSlaveBase.Stat(url);
		///          }
		///      }
		///  </pre>
		///  Of course in this case, you surely need to reimplement listDir()
		///  and get() accordingly.
		///  If you want view on directories to be correctly refreshed when
		///  something changes on a forwarded URL, you'll need a companion kded
		///  module to emit the KDirNotify Files() D-Bus signals.
		///  This class was initially used for media:/ ioslave. This ioslave code
		///  and the MediaDirNotify class of its companion kded module can be a
		///  good source of inspiration.
		/// </remarks>		<author> Kevin Ottens <ervin@ipsquad.net>
		///  </author>
		/// 		<short>    This class should be used as a base for ioslaves acting as a  forwarder to other ioslaves.</short>
		/// 		<see> ForwardingSlaveBase.RewriteUrl</see>

		[SmokeClass("KIO::ForwardingSlaveBase")]
		public abstract class ForwardingSlaveBase : QObject, KIO.ISlaveBase {
	 		protected ForwardingSlaveBase(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(ForwardingSlaveBase), this);
			}
			// void listEntries(const KIO::UDSEntryList& arg1); >>>> NOT CONVERTED
			// bool canResume(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void totalSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void processedSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void position(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void written(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2,const QString& arg3,const QString& arg4,const QString& arg5); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2,const QString& arg3,const QString& arg4); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2,const QString& arg3); >>>> NOT CONVERTED
			// int messageBox(KIO::SlaveBase::MessageBoxType arg1,const QString& arg2); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3,const QString& arg4,const QString& arg5,const QString& arg6); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3,const QString& arg4,const QString& arg5); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3,const QString& arg4); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2,const QString& arg3); >>>> NOT CONVERTED
			// int messageBox(const QString& arg1,KIO::SlaveBase::MessageBoxType arg2); >>>> NOT CONVERTED
			// void read(KIO::filesize_t arg1); >>>> NOT CONVERTED
			// void seek(KIO::filesize_t arg1); >>>> NOT CONVERTED
			public ForwardingSlaveBase(QByteArray protocol, QByteArray poolSocket, QByteArray appSocket) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("ForwardingSlaveBase###", "ForwardingSlaveBase(const QByteArray&, const QByteArray&, const QByteArray&)", typeof(void), typeof(QByteArray), protocol, typeof(QByteArray), poolSocket, typeof(QByteArray), appSocket);
			}
			[SmokeMethod("get(const KUrl&)")]
			public virtual void Get(KUrl url) {
				interceptor.Invoke("get#", "get(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			[SmokeMethod("put(const KUrl&, int, KIO::JobFlags)")]
			public virtual void Put(KUrl url, int permissions, uint flags) {
				interceptor.Invoke("put#$$", "put(const KUrl&, int, KIO::JobFlags)", typeof(void), typeof(KUrl), url, typeof(int), permissions, typeof(uint), flags);
			}
			[SmokeMethod("stat(const KUrl&)")]
			public virtual void Stat(KUrl url) {
				interceptor.Invoke("stat#", "stat(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			[SmokeMethod("mimetype(const KUrl&)")]
			public virtual void Mimetype(KUrl url) {
				interceptor.Invoke("mimetype#", "mimetype(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			[SmokeMethod("listDir(const KUrl&)")]
			public virtual void ListDir(KUrl url) {
				interceptor.Invoke("listDir#", "listDir(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			[SmokeMethod("mkdir(const KUrl&, int)")]
			public virtual void Mkdir(KUrl url, int permissions) {
				interceptor.Invoke("mkdir#$", "mkdir(const KUrl&, int)", typeof(void), typeof(KUrl), url, typeof(int), permissions);
			}
			[SmokeMethod("rename(const KUrl&, const KUrl&, KIO::JobFlags)")]
			public virtual void Rename(KUrl src, KUrl dest, uint flags) {
				interceptor.Invoke("rename##$", "rename(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(void), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
			}
			[SmokeMethod("symlink(const QString&, const KUrl&, KIO::JobFlags)")]
			public virtual void Symlink(string target, KUrl dest, uint flags) {
				interceptor.Invoke("symlink$#$", "symlink(const QString&, const KUrl&, KIO::JobFlags)", typeof(void), typeof(string), target, typeof(KUrl), dest, typeof(uint), flags);
			}
			[SmokeMethod("chmod(const KUrl&, int)")]
			public virtual void Chmod(KUrl url, int permissions) {
				interceptor.Invoke("chmod#$", "chmod(const KUrl&, int)", typeof(void), typeof(KUrl), url, typeof(int), permissions);
			}
			[SmokeMethod("setModificationTime(const KUrl&, const QDateTime&)")]
			public virtual void SetModificationTime(KUrl url, QDateTime mtime) {
				interceptor.Invoke("setModificationTime##", "setModificationTime(const KUrl&, const QDateTime&)", typeof(void), typeof(KUrl), url, typeof(QDateTime), mtime);
			}
			[SmokeMethod("copy(const KUrl&, const KUrl&, int, KIO::JobFlags)")]
			public virtual void Copy(KUrl src, KUrl dest, int permissions, uint flags) {
				interceptor.Invoke("copy##$$", "copy(const KUrl&, const KUrl&, int, KIO::JobFlags)", typeof(void), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions, typeof(uint), flags);
			}
			[SmokeMethod("del(const KUrl&, bool)")]
			public virtual void Del(KUrl url, bool isfile) {
				interceptor.Invoke("del#$", "del(const KUrl&, bool)", typeof(void), typeof(KUrl), url, typeof(bool), isfile);
			}
			/// <remarks>
			///  Rewrite an url to it's forwarded counterpart. It should return
			///  true if everything was ok, and false otherwise.
			///  If a problem is detected it's up to this method to trigger error()
			///  before returning. Returning false silently cancel the current
			///  slave operation.
			/// <param> name="url" The URL as given during the slave call
			/// </param><param> name="newURL" The new URL to forward the slave call to
			/// </param></remarks>		<return> true if the given url could be correctly rewritten
			///      </return>
			/// 		<short>    Rewrite an url to it's forwarded counterpart.</short>
			[SmokeMethod("rewriteUrl(const KUrl&, KUrl&)")]
			protected abstract bool RewriteUrl(KUrl url, KUrl newURL);
			/// <remarks>
			///  Allow to modify a UDSEntry before it's sent to the ioslave enpoint.
			///  This is the default implementation working in most case, but sometimes
			///  you could make use of more forwarding black magic (for example
			///  dynamically transform any desktop file into a fake directory...)
			/// <param> name="entry" the UDSEntry to post-process
			/// </param><param> name="listing" indicate if this entry it created during a listDir
			///                 operation
			///      </param></remarks>		<short>    Allow to modify a UDSEntry before it's sent to the ioslave enpoint.</short>
			[SmokeMethod("prepareUDSEntry(KIO::UDSEntry&, bool) const")]
			protected virtual void PrepareUDSEntry(KIO.UDSEntry entry, bool listing) {
				interceptor.Invoke("prepareUDSEntry#$", "prepareUDSEntry(KIO::UDSEntry&, bool) const", typeof(void), typeof(KIO.UDSEntry), entry, typeof(bool), listing);
			}
			[SmokeMethod("prepareUDSEntry(KIO::UDSEntry&) const")]
			protected virtual void PrepareUDSEntry(KIO.UDSEntry entry) {
				interceptor.Invoke("prepareUDSEntry#", "prepareUDSEntry(KIO::UDSEntry&) const", typeof(void), typeof(KIO.UDSEntry), entry);
			}
			/// <remarks>
			///  Return the URL being processed by the ioslave
			///  Only access it inside prepareUDSEntry()
			///      </remarks>		<short>    Return the URL being processed by the ioslave  Only access it inside prepareUDSEntry()      </short>
			protected KUrl ProcessedUrl() {
				return (KUrl) interceptor.Invoke("processedUrl", "processedUrl() const", typeof(KUrl));
			}
			/// <remarks>
			///  Return the URL asked to the ioslave
			///  Only access it inside prepareUDSEntry()
			///      </remarks>		<short>    Return the URL asked to the ioslave  Only access it inside prepareUDSEntry()      </short>
			protected KUrl RequestedUrl() {
				return (KUrl) interceptor.Invoke("requestedUrl", "requestedUrl() const", typeof(KUrl));
			}
			/// <remarks>
			///  Terminate the slave by calling the destructor and then .Exit()
			///      </remarks>		<short>   </short>
			public void Exit() {
				interceptor.Invoke("exit", "exit()", typeof(void));
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			public void DispatchLoop() {
				interceptor.Invoke("dispatchLoop", "dispatchLoop()", typeof(void));
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			public void SetConnection(KIO.Connection connection) {
				interceptor.Invoke("setConnection#", "setConnection(KIO::Connection*)", typeof(void), typeof(KIO.Connection), connection);
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			public KIO.Connection Connection() {
				return (KIO.Connection) interceptor.Invoke("connection", "connection() const", typeof(KIO.Connection));
			}
			/// <remarks>
			///  Sends data in the slave to the job (i.e. in get).
			///  To signal end of data, simply send an empty
			///  QByteArray().
			/// <param> name="data" the data read by the slave
			///      </param></remarks>		<short>    Sends data in the slave to the job (i.</short>
			public void Data(QByteArray data) {
				interceptor.Invoke("data#", "data(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Asks for data from the job.
			/// </remarks>		<short>    Asks for data from the job.</short>
			/// 		<see> readData</see>
			public void DataReq() {
				interceptor.Invoke("dataReq", "dataReq()", typeof(void));
			}
			/// <remarks>
			///  open succedes
			/// </remarks>		<short>    open succedes </short>
			/// 		<see> open</see>
			public void Opened() {
				interceptor.Invoke("opened", "opened()", typeof(void));
			}
			/// <remarks>
			///  Call to signal an error.
			///  This also finishes the job, no need to call finished.
			///  If the Error code is KIO.ERR_SLAVE_DEFINED then the
			///  _text should contain the complete translated text of
			///  of the error message.  This message will be displayed
			///  in an KTextBrowser which allows rich text complete
			///  with hyper links.  Email links will call the default
			///  mailer, "exec:/command arg1 arg2" will be forked and
			///  all other links will call the default browser.
			/// <param> name="_errid" the error code from KIO.Error
			/// </param><param> name="_text" the rich text error message
			///      </param></remarks>		<short>    Call to signal an error.</short>
			/// 		<see> Error</see>
			/// 		<see> KTextBrowser</see>
			public void error(int _errid, string _text) {
				interceptor.Invoke("error$$", "error(int, const QString&)", typeof(void), typeof(int), _errid, typeof(string), _text);
			}
			/// <remarks>
			///  Call in openConnection, if you reimplement it, when you're done.
			///      </remarks>		<short>    Call in openConnection, if you reimplement it, when you're done.</short>
			public void Connected() {
				interceptor.Invoke("connected", "connected()", typeof(void));
			}
			/// <remarks>
			///  Call to signal successful completion of any command
			///  (besides openConnection and closeConnection)
			///      </remarks>		<short>    Call to signal successful completion of any command  (besides openConnection and closeConnection)      </short>
			public void Finished() {
				interceptor.Invoke("finished", "finished()", typeof(void));
			}
			/// <remarks>
			///  Call to signal that data from the sub-URL is needed
			///      </remarks>		<short>    Call to signal that data from the sub-URL is needed      </short>
			public void NeedSubUrlData() {
				interceptor.Invoke("needSubUrlData", "needSubUrlData()", typeof(void));
			}
			/// <remarks>
			///  Used to report the status of the slave.
			/// <param> name="host" the slave is currently connected to. (Should be
			///         empty if not connected)
			/// </param><param> name="connected" Whether an actual network connection exists.
			/// </param></remarks>		<short>    Used to report the status of the slave.</short>
			public void SlaveStatus(string host, bool connected) {
				interceptor.Invoke("slaveStatus$$", "slaveStatus(const QString&, bool)", typeof(void), typeof(string), host, typeof(bool), connected);
			}
			/// <remarks>
			///  Call this from stat() to express details about an object, the
			///  UDSEntry customarily contains the atoms describing file name, size,
			///  mimetype, etc.
			/// <param> name="_entry" The UDSEntry containing all of the object attributes.
			///      </param></remarks>		<short>    Call this from stat() to express details about an object, the  UDSEntry customarily contains the atoms describing file name, size,  mimetype, etc.</short>
			public void StatEntry(KIO.UDSEntry _entry) {
				interceptor.Invoke("statEntry#", "statEntry(const KIO::UDSEntry&)", typeof(void), typeof(KIO.UDSEntry), _entry);
			}
			/// <remarks>
			///  Call this in listDir, each time you have a bunch of entries
			///  to report.
			/// <param> name="_entry" The UDSEntry containing all of the object attributes.
			///      </param></remarks>		<short>    Call this in listDir, each time you have a bunch of entries  to report.</short>
			/// <remarks>
			///  Call this at the beginning of put(), to give the size of the existing
			///  partial file, if there is one. The <code>offset</code> argument notifies the
			///  other job (the one that gets the data) about the offset to use.
			///  In this case, the boolean returns whether we can indeed resume or not
			///  (we can't if the protocol doing the get() doesn't support setting an offset)
			///      </remarks>		<short>    Call this at the beginning of put(), to give the size of the existing  partial file, if there is one.</short>
			/// <remarks>
			///  Call this in get and copy, to give the total size
			///  of the file
			///  Call in listDir too, when you know the total number of items.
			///      </remarks>		<short>    Call this in get and copy, to give the total size  of the file  Call in listDir too, when you know the total number of items.</short>
			/// <remarks>
			///  Call this during get and copy, once in a while,
			///  to give some info about the current state.
			///  Don't emit it in listDir, listEntries speaks for itself.
			///      </remarks>		<short>    Call this during get and copy, once in a while,  to give some info about the current state.</short>
			/// <remarks>
			///  Only use this if you can't know in advance the size of the
			///  copied data. For example, if you're doing variable bitrate
			///  compression of the source.
			///  STUB ! Currently unimplemented. Here now for binary compatibility.
			///  Call this during get and copy, once in a while,
			///  to give some info about the current state.
			///  Don't emit it in listDir, listEntries speaks for itself.
			///      </remarks>		<short>    Only use this if you can't know in advance the size of the  copied data.</short>
			public void ProcessedPercent(float percent) {
				interceptor.Invoke("processedPercent$", "processedPercent(float)", typeof(void), typeof(float), percent);
			}
			/// <remarks>
			///  Call this in get and copy, to give the current transfer
			///  speed, but only if it can't be calculated out of the size you
			///  passed to processedSize (in most cases you don't want to call it)
			///      </remarks>		<short>    Call this in get and copy, to give the current transfer  speed, but only if it can't be calculated out of the size you  passed to processedSize (in most cases you don't want to call it)      </short>
			public void Speed(ulong _bytes_per_second) {
				interceptor.Invoke("speed$", "speed(unsigned long)", typeof(void), typeof(ulong), _bytes_per_second);
			}
			/// <remarks>
			///  Call this to signal a redirection
			///  The job will take care of going to that url.
			///      </remarks>		<short>    Call this to signal a redirection  The job will take care of going to that url.</short>
			public void Redirection(KUrl _url) {
				interceptor.Invoke("redirection#", "redirection(const KUrl&)", typeof(void), typeof(KUrl), _url);
			}
			/// <remarks>
			///  Tell that we will only get an error page here.
			///  This means: the data you'll get isn't the data you requested,
			///  but an error page (usually HTML) that describes an error.
			///      </remarks>		<short>    Tell that we will only get an error page here.</short>
			public void ErrorPage() {
				interceptor.Invoke("errorPage", "errorPage()", typeof(void));
			}
			/// <remarks>
			///  Call this in mimetype() and in get(), when you know the mimetype.
			///  See mimetype about other ways to implement it.
			///      </remarks>		<short>    Call this in mimetype() and in get(), when you know the mimetype.</short>
			public void MimeType(string _type) {
				interceptor.Invoke("mimeType$", "mimeType(const QString&)", typeof(void), typeof(string), _type);
			}
			/// <remarks>
			///  Call to signal a warning, to be displayed in a dialog box.
			///      </remarks>		<short>    Call to signal a warning, to be displayed in a dialog box.</short>
			public void Warning(string msg) {
				interceptor.Invoke("warning$", "warning(const QString&)", typeof(void), typeof(string), msg);
			}
			/// <remarks>
			///  Call to signal a message, to be displayed if the application wants to,
			///  for instance in a status bar. Usual examples are "connecting to host xyz", etc.
			///      </remarks>		<short>    Call to signal a message, to be displayed if the application wants to,  for instance in a status bar.</short>
			public void InfoMessage(string msg) {
				interceptor.Invoke("infoMessage$", "infoMessage(const QString&)", typeof(void), typeof(string), msg);
			}
			/// <remarks>
			///  Call this to show a message box from the slave
			/// <param> name="type" type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
			/// </param><param> name="text" Message string. May contain newlines.
			/// </param><param> name="caption" Message box title.
			/// </param><param> name="buttonYes" The text for the first button.
			///                   The default is i18n("&Yes").
			/// </param><param> name="buttonNo" The text for the second button.
			///                   The default is i18n("&No").
			///  Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
			///        and for Information, none is used.
			/// </param></remarks>		<return> a button code, as defined in KMessageBox, or 0 on communication error.
			///      </return>
			/// 		<short>    Call this to show a message box from the slave </short>
			/// <remarks>
			///  Call this to show a message box from the slave
			/// <param> name="text" Message string. May contain newlines.
			/// </param><param> name="type" type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
			/// </param><param> name="caption" Message box title.
			/// </param><param> name="buttonYes" The text for the first button.
			///                   The default is i18n("&Yes").
			/// </param><param> name="buttonNo" The text for the second button.
			///                   The default is i18n("&No").
			///  Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
			///        and for Information, none is used.
			/// </param><param> name="dontAskAgainName" A checkbox is added with which further confirmation can be turned off.
			///         The string is used to lookup and store the setting in kioslaverc.
			/// </param></remarks>		<return> a button code, as defined in KMessageBox, or 0 on communication error.
			///      </return>
			/// 		<short>    Call this to show a message box from the slave </short>
			/// <remarks>
			///  Sets meta-data to be send to the application before the first
			///  data() or finished() signal.
			///      </remarks>		<short>    Sets meta-data to be send to the application before the first  data() or finished() signal.</short>
			public void SetMetaData(string key, string value) {
				interceptor.Invoke("setMetaData$$", "setMetaData(const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), value);
			}
			/// <remarks>
			///  Queries for the existence of a certain config/meta-data entry
			///  send by the application to the slave.
			///      </remarks>		<short>    Queries for the existence of a certain config/meta-data entry  send by the application to the slave.</short>
			public bool HasMetaData(string key) {
				return (bool) interceptor.Invoke("hasMetaData$", "hasMetaData(const QString&) const", typeof(bool), typeof(string), key);
			}
			/// <remarks>
			///  Queries for config/meta-data send by the application to the slave.
			///      </remarks>		<short>    Queries for config/meta-data send by the application to the slave.</short>
			public string MetaData(string key) {
				return (string) interceptor.Invoke("metaData$", "metaData(const QString&) const", typeof(string), typeof(string), key);
			}
			/// <remarks>
			///  Contains all metadata (but no config) sent by the application to the slave.
			///      </remarks>		<short>   </short>
			public KIO.MetaData AllMetaData() {
				return (KIO.MetaData) interceptor.Invoke("allMetaData", "allMetaData() const", typeof(KIO.MetaData));
			}
			/// <remarks>
			///  Returns a configuration object to query config/meta-data information
			///  from.
			///  The application provides the slave with all configuration information
			///  relevant for the current protocol and host.
			///      </remarks>		<short>    Returns a configuration object to query config/meta-data information  from.</short>
			public KConfigGroup Config() {
				return (KConfigGroup) interceptor.Invoke("config", "config()", typeof(KConfigGroup));
			}
			/// <remarks>
			///  Returns an object that can translate remote filenames into proper
			///  Unicode forms. This encoding can be set by the user.
			///      </remarks>		<short>    Returns an object that can translate remote filenames into proper  Unicode forms.</short>
			public KRemoteEncoding RemoteEncoding() {
				return (KRemoteEncoding) interceptor.Invoke("remoteEncoding", "remoteEncoding()", typeof(KRemoteEncoding));
			}
			/// <remarks>
			///  Set the host
			/// <param> name="pass"  Called directly by createSlave, this is why there is no equivalent in
			///  SlaveInterface, unlike the other methods.
			/// </param> This method is called whenever a change in host, port or user occurs.
			///      </remarks>		<short>    Set the host </short>
			[SmokeMethod("setHost(const QString&, quint16, const QString&, const QString&)")]
			public virtual void SetHost(string host, ushort port, string user, string pass) {
				interceptor.Invoke("setHost$$$$", "setHost(const QString&, quint16, const QString&, const QString&)", typeof(void), typeof(string), host, typeof(ushort), port, typeof(string), user, typeof(string), pass);
			}
			/// <remarks>
			///  Prepare slave for streaming operation
			///      </remarks>		<short>    Prepare slave for streaming operation      </short>
			[SmokeMethod("setSubUrl(const KUrl&)")]
			public virtual void SetSubUrl(KUrl url) {
				interceptor.Invoke("setSubUrl#", "setSubUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  Opens the connection (forced)
			///  When this function gets called the slave is operating in
			///  connection-oriented mode.
			///  When a connection gets lost while the slave operates in
			///  connection oriented mode, the slave should report
			///  ERR_CONNECTION_BROKEN instead of reconnecting. The user is
			///  expected to disconnect the slave in the error handler.
			///      </remarks>		<short>    Opens the connection (forced)  When this function gets called the slave is operating in  connection-oriented mode.</short>
			[SmokeMethod("openConnection()")]
			public virtual void OpenConnection() {
				interceptor.Invoke("openConnection", "openConnection()", typeof(void));
			}
			/// <remarks>
			///  Closes the connection (forced)
			///  Called when the application disconnects the slave to close
			///  any open network connections.
			///  When the slave was operating in connection-oriented mode,
			///  it should reset itself to connectionless (default) mode.
			///      </remarks>		<short>    Closes the connection (forced)  Called when the application disconnects the slave to close  any open network connections.</short>
			[SmokeMethod("closeConnection()")]
			public virtual void CloseConnection() {
				interceptor.Invoke("closeConnection", "closeConnection()", typeof(void));
			}
			/// <remarks>
			///  open.
			/// <param> name="url" the full url for this request. Host, port and user of the URL
			///         can be assumed to be the same as in the last setHost() call.
			/// </param><param> name="mode" see \ref QIODevice.OpenMode
			///      </param></remarks>		<short>    open.</short>
			[SmokeMethod("open(const KUrl&, QIODevice::OpenMode)")]
			public virtual void Open(KUrl url, uint mode) {
				interceptor.Invoke("open#$", "open(const KUrl&, QIODevice::OpenMode)", typeof(void), typeof(KUrl), url, typeof(uint), mode);
			}
			[SmokeMethod("write(const QByteArray&)")]
			public virtual void Write(QByteArray data) {
				interceptor.Invoke("write#", "write(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			[SmokeMethod("close()")]
			public virtual void Close() {
				interceptor.Invoke("close", "close()", typeof(void));
			}
			/// <remarks>
			///  Change ownership of <code>url</code>
			///  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHOWN
			///      </remarks>		<short>    Change ownership of <code>url</code>  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHOWN      </short>
			[SmokeMethod("chown(const KUrl&, const QString&, const QString&)")]
			public virtual void Chown(KUrl url, string owner, string group) {
				interceptor.Invoke("chown#$$", "chown(const KUrl&, const QString&, const QString&)", typeof(void), typeof(KUrl), url, typeof(string), owner, typeof(string), group);
			}
			/// <remarks>
			///  Change the destination of a symlink
			/// <param> name="url" the url of the symlink to modify
			/// </param><param> name="target" the new destination (target) of the symlink
			///      </param></remarks>		<short>    Change the destination of a symlink </short>
			[SmokeMethod("setLinkDest(const KUrl&, const QString&)")]
			public virtual void SetLinkDest(KUrl url, string target) {
				interceptor.Invoke("setLinkDest#$", "setLinkDest(const KUrl&, const QString&)", typeof(void), typeof(KUrl), url, typeof(string), target);
			}
			/// <remarks>
			///  Used for any command that is specific to this slave (protocol)
			///  Examples are : HTTP POST, mount and unmount (kio_file)
			/// <param> name="data" packed data; the meaning is completely dependent on the
			///         slave, but usually starts with an int for the command number.
			///  Document your slave's commands, at least in its header file.
			///      </param></remarks>		<short>    Used for any command that is specific to this slave (protocol)  Examples are : HTTP POST, mount and unmount (kio_file) </short>
			[SmokeMethod("special(const QByteArray&)")]
			public virtual void Special(QByteArray data) {
				interceptor.Invoke("special#", "special(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Used for multiple get. Currently only used foir HTTP pielining
			///  support.
			/// <param> name="data" packed data; Contains number of URLs to fetch, and for
			///  each URL the URL itself and its associated MetaData.
			///      </param></remarks>		<short>    Used for multiple get.</short>
			[SmokeMethod("multiGet(const QByteArray&)")]
			public virtual void MultiGet(QByteArray data) {
				interceptor.Invoke("multiGet#", "multiGet(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			/// <remarks>
			///  Called to get the status of the slave. Slave should respond
			///  by calling slaveStatus(...)
			///      </remarks>		<short>    Called to get the status of the slave.</short>
			[SmokeMethod("slave_status()")]
			public virtual void Slave_status() {
				interceptor.Invoke("slave_status", "slave_status()", typeof(void));
			}
			/// <remarks>
			///  Called by the scheduler to tell the slave that the configuration
			///  changed (i.e. proxy settings) .
			///      </remarks>		<short>    Called by the scheduler to tell the slave that the configuration  changed (i.</short>
			[SmokeMethod("reparseConfiguration()")]
			public virtual void ReparseConfiguration() {
				interceptor.Invoke("reparseConfiguration", "reparseConfiguration()", typeof(void));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for connecting to remote host.
			///      </return>
			/// 		<short>   </short>
			public int ConnectTimeout() {
				return (int) interceptor.Invoke("connectTimeout", "connectTimeout()", typeof(int));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for connecting to proxy in secs.
			///      </return>
			/// 		<short>   </short>
			public int ProxyConnectTimeout() {
				return (int) interceptor.Invoke("proxyConnectTimeout", "proxyConnectTimeout()", typeof(int));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for read from first data from
			///  remote host in seconds.
			///      </return>
			/// 		<short>   </short>
			public int ResponseTimeout() {
				return (int) interceptor.Invoke("responseTimeout", "responseTimeout()", typeof(int));
			}
			/// <remarks>
			/// </remarks>		<return> timeout value for read from subsequent data from
			///  remote host in secs.
			///      </return>
			/// 		<short>   </short>
			public int ReadTimeout() {
				return (int) interceptor.Invoke("readTimeout", "readTimeout()", typeof(int));
			}
			/// <remarks>
			///  This function sets a timeout of <code>timeout</code> seconds and calls
			///  special(data) when the timeout occurs as if it was called by the
			///  application.
			///  A timeout can only occur when the slave is waiting for a command
			///  from the application.
			///  Specifying a negative timeout cancels a pending timeout.
			///  Only one timeout at a time is supported, setting a timeout
			///  cancels any pending timeout.
			///      </remarks>		<short>    This function sets a timeout of <code>timeout</code> seconds and calls  special(data) when the timeout occurs as if it was called by the  application.</short>
			public void SetTimeoutSpecialCommand(int timeout, QByteArray data) {
				interceptor.Invoke("setTimeoutSpecialCommand$#", "setTimeoutSpecialCommand(int, const QByteArray&)", typeof(void), typeof(int), timeout, typeof(QByteArray), data);
			}
			public void SetTimeoutSpecialCommand(int timeout) {
				interceptor.Invoke("setTimeoutSpecialCommand$", "setTimeoutSpecialCommand(int)", typeof(void), typeof(int), timeout);
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			[SmokeMethod("dispatch(int, const QByteArray&)")]
			public virtual void Dispatch(int command, QByteArray data) {
				interceptor.Invoke("dispatch$#", "dispatch(int, const QByteArray&)", typeof(void), typeof(int), command, typeof(QByteArray), data);
			}
			/// <remarks>
			///      </remarks>		<short>   </short>
			[SmokeMethod("dispatchOpenCommand(int, const QByteArray&)")]
			public virtual void DispatchOpenCommand(int command, QByteArray data) {
				interceptor.Invoke("dispatchOpenCommand$#", "dispatchOpenCommand(int, const QByteArray&)", typeof(void), typeof(int), command, typeof(QByteArray), data);
			}
			/// <remarks>
			///  Read data send by the job, after a dataReq
			/// <param> name="buffer" buffer where data is stored
			/// </param></remarks>		<return> 0 on end of data,
			///          > 0 bytes read
			///          < 0 error
			/// </return>
			/// 		<short>    Read data send by the job, after a dataReq </short>
			public int ReadData(QByteArray buffer) {
				return (int) interceptor.Invoke("readData#", "readData(QByteArray&)", typeof(int), typeof(QByteArray), buffer);
			}
			/// <remarks>
			///  internal function to be called by the slave.
			///  It collects entries and emits them via listEntries
			///  when enough of them are there or a certain time
			///  frame exceeded (to make sure the app gets some
			///  items in time but not too many items one by one
			///  as this will cause a drastic performance penalty)
			/// <param> name="_entry" The UDSEntry containing all of the object attributes.
			/// </param><param> name="ready" set to true after emitting all items. <code>_entry</code> is not
			///         used in this case
			///      </param></remarks>		<short>    internal function to be called by the slave.</short>
			public void ListEntry(KIO.UDSEntry _entry, bool ready) {
				interceptor.Invoke("listEntry#$", "listEntry(const KIO::UDSEntry&, bool)", typeof(void), typeof(KIO.UDSEntry), _entry, typeof(bool), ready);
			}
			/// <remarks>
			///  internal function to connect a slave to/ disconnect from
			///  either the slave pool or the application
			///      </remarks>		<short>    internal function to connect a slave to/ disconnect from  either the slave pool or the application      </short>
			public void ConnectSlave(string path) {
				interceptor.Invoke("connectSlave$", "connectSlave(const QString&)", typeof(void), typeof(string), path);
			}
			public void DisconnectSlave() {
				interceptor.Invoke("disconnectSlave", "disconnectSlave()", typeof(void));
			}
			/// <remarks>
			///  Prompt the user for Authorization info (login & password).
			///  Use this function to request authorization information from
			///  the end user. You can also pass an error message which explains
			///  why a previous authorization attempt failed. Here is a very
			///  simple example:
			///  <pre>
			///  KIO.AuthInfo authInfo;
			///  if ( openPasswordDialog( authInfo ) )
			///  {
			///     kDebug() << QLatin1String("User: ")
			///               << authInfo.username << endl;
			///     kDebug() << QLatin1String("Password: ")
			///               << QLatin1String("Not displayed here!") << endl;
			///  }
			///  </pre>
			///  You can also preset some values like the username, caption or
			///  comment as follows:
			///  <pre>
			///  KIO.AuthInfo authInfo;
			///  authInfo.caption= "Acme Password Dialog";
			///  authInfo.username= "Wile E. Coyote";
			///  string errorMsg = "You entered an incorrect password.";
			///  if ( openPasswordDialog( authInfo, errorMsg ) )
			///  {
			///     kDebug() << QLatin1String("User: ")
			///               << authInfo.username << endl;
			///     kDebug() << QLatin1String("Password: ")
			///               << QLatin1String("Not displayed here!") << endl;
			///  }
			///  </pre>
			///  <b>Note:<> You should consider using checkCachedAuthentication() to
			///  see if the password is available in kpasswdserver before calling
			///  this function.
			///  <b>Note:<> A call to this function can fail and return <code>false</code>,
			///  if the UIServer could not be started for whatever reason.
			/// <param> name="info" See AuthInfo.
			/// </param><param> name="errorMsg" Error message to show
			/// </param></remarks>		<return> <code>true</code> if user clicks on "OK", <code>false</code> otherwsie.
			///      </return>
			/// 		<short>    Prompt the user for Authorization info (login & password).</short>
			/// 		<see> checkCachedAuthentication</see>
			public bool OpenPasswordDialog(KIO.AuthInfo info, string errorMsg) {
				return (bool) interceptor.Invoke("openPasswordDialog#$", "openPasswordDialog(KIO::AuthInfo&, const QString&)", typeof(bool), typeof(KIO.AuthInfo), info, typeof(string), errorMsg);
			}
			public bool OpenPasswordDialog(KIO.AuthInfo info) {
				return (bool) interceptor.Invoke("openPasswordDialog#", "openPasswordDialog(KIO::AuthInfo&)", typeof(bool), typeof(KIO.AuthInfo), info);
			}
			/// <remarks>
			///  Used by the slave to check if it can connect
			///  to a given host. This should be called where the slave is ready
			///  to do a .Connect() on a socket. For each call to
			///  requestNetwork must exist a matching call to
			///  dropNetwork, or the system will stay online until
			///  KNetMgr gets closed (or the SlaveBase gets destructed)!
			///  If KNetMgr is not running, then this is a no-op and returns true
			/// <param> name="host" tells the netmgr the host the slave wants to connect
			///              to. As this could also be a proxy, we can't just take
			///              the host currenctly connected to (but that's the default
			///              value)
			/// </param></remarks>		<return> true in theorie, the host is reachable
			///          false the system is offline and the host is in a remote network.
			///      </return>
			/// 		<short>    Used by the slave to check if it can connect  to a given host.</short>
			public bool RequestNetwork(string host) {
				return (bool) interceptor.Invoke("requestNetwork$", "requestNetwork(const QString&)", typeof(bool), typeof(string), host);
			}
			public bool RequestNetwork() {
				return (bool) interceptor.Invoke("requestNetwork", "requestNetwork()", typeof(bool));
			}
			/// <remarks>
			///  Used by the slave to withdraw a connection requested by
			///  requestNetwork. This function cancels the last call to
			///  requestNetwork. If a client uses more than one internet
			///  connection, it must use dropNetwork(host) to
			///  stop each request.
			///  If KNetMgr is not running, then this is a no-op.
			/// <param> name="host" the host passed to requestNetwork
			/// </param> A slave should call this function every time it disconnect from a host.
			///  </remarks>		<short>    Used by the slave to withdraw a connection requested by  requestNetwork.</short>
			public void DropNetwork(string host) {
				interceptor.Invoke("dropNetwork$", "dropNetwork(const QString&)", typeof(void), typeof(string), host);
			}
			public void DropNetwork() {
				interceptor.Invoke("dropNetwork", "dropNetwork()", typeof(void));
			}
			/// <remarks>
			///  Wait for an answer to our request, until we get <code>expected1</code> or <code>expected2</code>
			/// </remarks>		<return> the result from readData, as well as the cmd in *pCmd if set, and the data in <code>data</code>
			///      </return>
			/// 		<short>    Wait for an answer to our request, until we get <code>expected1</code> or <code>expected2</code> </short>
			public int WaitForAnswer(int expected1, int expected2, QByteArray data, ref int pCmd) {
				StackItem[] stack = new StackItem[5];
				stack[1].s_int = expected1;
				stack[2].s_int = expected2;
	#if DEBUG
				stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(data);
	#else
				stack[3].s_class = (IntPtr) GCHandle.Alloc(data);
	#endif
				stack[4].s_int = pCmd;
				interceptor.Invoke("waitForAnswer$$#$", "waitForAnswer(int, int, QByteArray&, int*)", stack);
	#if DEBUG
				DebugGCHandle.Free((GCHandle) stack[3].s_class);
	#else
				((GCHandle) stack[3].s_class).Free();
	#endif
				pCmd = stack[4].s_int;
				return stack[0].s_int;
			}
			public int WaitForAnswer(int expected1, int expected2, QByteArray data) {
				return (int) interceptor.Invoke("waitForAnswer$$#", "waitForAnswer(int, int, QByteArray&)", typeof(int), typeof(int), expected1, typeof(int), expected2, typeof(QByteArray), data);
			}
			/// <remarks>
			///  Internal function to transmit meta data to the application.
			///      </remarks>		<short>    Internal function to transmit meta data to the application.</short>
			public void SendMetaData() {
				interceptor.Invoke("sendMetaData", "sendMetaData()", typeof(void));
			}
			/// <remarks> If your ioslave was killed by a signal, wasKilled() returns true.
			///      Check it regularly in lengthy functions (e.g. in get();) and return
			///      as fast as possible from this function if wasKilled() returns true.
			///      This will ensure that your slave destructor will be called correctly.
			///      </remarks>		<short>   If your ioslave was killed by a signal, wasKilled() returns true.</short>
			public bool WasKilled() {
				return (bool) interceptor.Invoke("wasKilled", "wasKilled() const", typeof(bool));
			}
			/// <remarks> Internally used.
			///      </remarks>		<short>   Internally used.</short>
			public void SetKillFlag() {
				interceptor.Invoke("setKillFlag", "setKillFlag()", typeof(void));
			}
			protected new IForwardingSlaveBaseSignals Emit {
				get { return (IForwardingSlaveBaseSignals) Q_EMIT; }
			}
		}

		public interface IForwardingSlaveBaseSignals : IQObjectSignals {
		}

		/// <remarks>
		///  This class is intended to make it easier to prompt for, cache
		///  and retrieve authorization information.
		///  When using this class to cache, retrieve or prompt authentication
		///  information, you only need to set the necessary attributes. For
		///  example, to check whether a password is already cached, the only
		///  required information is the URL of the resource and optionally
		///  whether or not a path match should be performed.  Similarly, to
		///  prompt for password you only need to optionally set the prompt,
		///  username (if already supplied), comment and commentLabel fields.
		///  <em>SPECIAL NOTE:</em> If you extend this class to add additional
		///  parameters do not forget to overload the stream insertion and
		///  extraction operators ("<<" and ">>") so that the added data can
		///  be correctly serialzed.
		/// </remarks>		<author> Dawit Alemayehu <adawit@kde.org>
		///  </author>
		/// 		<short> A two way messaging class for passing authentication information. </short>

		[SmokeClass("KIO::AuthInfo")]
		public class AuthInfo : Object, IDisposable {
			protected SmokeInvocation interceptor = null;
			private IntPtr smokeObject;
			protected AuthInfo(Type dummy) {}
			protected void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(AuthInfo), this);
			}
			/// <remarks>
			///  Default constructor.
			///     </remarks>		<short>    Default constructor.</short>
			public AuthInfo() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("AuthInfo", "AuthInfo()", typeof(void));
			}
			/// <remarks>
			///  Copy constructor.
			///     </remarks>		<short>    Copy constructor.</short>
			public AuthInfo(KIO.AuthInfo info) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("AuthInfo#", "AuthInfo(const KIO::AuthInfo&)", typeof(void), typeof(KIO.AuthInfo), info);
			}
			/// <remarks>
			///  Use this method to check if the object was modified.
			/// </remarks>		<return> true if the object has been modified
			///     </return>
			/// 		<short>    Use this method to check if the object was modified.</short>
			public bool IsModified() {
				return (bool) interceptor.Invoke("isModified", "isModified() const", typeof(bool));
			}
			/// <remarks>
			///  Use this method to indicate that this object has been modified.
			/// <param> name="flag" true to mark the object as modified, false to clear
			///     </param></remarks>		<short>    Use this method to indicate that this object has been modified.</short>
			public void SetModified(bool flag) {
				interceptor.Invoke("setModified$", "setModified(bool)", typeof(void), typeof(bool), flag);
			}
			~AuthInfo() {
				interceptor.Invoke("~AuthInfo", "~AuthInfo()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~AuthInfo", "~AuthInfo()", typeof(void));
			}
		}

		/// <remarks>
		///  A Singleton class that provides access to passwords
		///  stored in .netrc files for automatic login purposes.
		///  This is only meant to address backward compatability
		///  with old automated ftp client style logins...
		/// </remarks>		<author> Dawit Alemayehu <adawit@kde.org>
		///  </author>
		/// 		<short> An interface to the ftp .netrc files.</short>

		[SmokeClass("KIO::NetRC")]
		public class NetRC : Object {
			protected SmokeInvocation interceptor = null;
			private IntPtr smokeObject;
			protected NetRC(Type dummy) {}
			protected void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(NetRC), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static NetRC() {
				staticInterceptor = new SmokeInvocation(typeof(NetRC), null);
			}
			// bool lookup(const KUrl& arg1,KIO::NetRC::AutoLogin& arg2,bool arg3,const QString& arg4,LookUpMode mode | arg5); >>>> NOT CONVERTED
			// bool lookup(const KUrl& arg1,KIO::NetRC::AutoLogin& arg2,bool arg3,const QString& arg4); >>>> NOT CONVERTED
			// bool lookup(const KUrl& arg1,KIO::NetRC::AutoLogin& arg2,bool arg3); >>>> NOT CONVERTED
			// bool lookup(const KUrl& arg1,KIO::NetRC::AutoLogin& arg2); >>>> NOT CONVERTED
			/// <remarks>
			///  Looks up the <code>login</code> information for the given <code>url.</code>
			/// <param> name="url" the url whose login information will be checked
			/// </param><param> name="login" the login information will be writte here
			/// </param><param> name="userealnetrc" if true, use $HOME/.netrc fle
			/// </param><param> name="type" the type of the login. If null, the <code>url</code>'s protocol
			///         will be taken
			/// </param><param> name="mode" the LookUpMode flags (ORed) for the query
			///    </param></remarks>		<short>    Looks up the <code>login</code> information for the given <code>url.</code></short>
			/// <remarks>
			///  Reloads the auto login information.
			///    </remarks>		<short>    Reloads the auto login information.</short>
			public void Reload() {
				interceptor.Invoke("reload", "reload()", typeof(void));
			}
			/// <remarks>
			///  A reference to the instance of the class.
			/// </remarks>		<return> the class
			///    </return>
			/// 		<short>    A reference to the instance of the class.</short>
			public static KIO.NetRC Self() {
				return (KIO.NetRC) staticInterceptor.Invoke("self", "self()", typeof(KIO.NetRC));
			}
		}

		/// <remarks> See <see cref="IPreviewJobSignals"></see> for signals emitted by PreviewJob
		/// </remarks>

		[SmokeClass("KIO::PreviewJob")]
		public class PreviewJob : KIO.Job, IDisposable {
	 		protected PreviewJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(PreviewJob), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static PreviewJob() {
				staticInterceptor = new SmokeInvocation(typeof(PreviewJob), null);
			}
			/// <remarks>
			///  Creates a new PreviewJob.
			/// <param> name="items" a list of files to create previews for
			/// </param><param> name="width" the desired width
			/// </param><param> name="height" the desired height, 0 to use the <code>width</code>
			/// </param><param> name="iconSize" the size of the mimetype icon to overlay over the
			///  preview or zero to not overlay an icon. This has no effect if the
			///  preview plugin that will be used doesn't use icon overlays.
			/// </param><param> name="iconAlpha" transparency to use for the icon overlay
			/// </param><param> name="scale" if the image is to be scaled to the requested size or
			///  returned in its original size
			/// </param><param> name="save" if the image should be cached for later use
			/// </param><param> name="enabledPlugins" if non-zero, this points to a list containing
			///  the names of the plugins that may be used.
			/// 	 </param></remarks>		<short>    Creates a new PreviewJob.</short>
			public PreviewJob(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save, List<string> enabledPlugins) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("PreviewJob#$$$$$$?", "PreviewJob(const KFileItemList&, int, int, int, int, bool, bool, const QStringList*)", typeof(void), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save, typeof(List<string>), enabledPlugins);
			}
			/// <remarks>
			///  Removes an item from preview processing. Use this if you passed
			///  an item to filePreview and want to delete it now.
			/// <param> name="url" the url of the item that should be removed from the preview queue
			///          </param></remarks>		<short>    Removes an item from preview processing.</short>
			public void RemoveItem(KUrl url) {
				interceptor.Invoke("removeItem#", "removeItem(const KUrl&)", typeof(void), typeof(KUrl), url);
			}
			/// <remarks>
			///  If <code>ignoreSize</code> is true, then the preview is always
			///  generated regardless of the settings
			/// </remarks>		<short>    If <code>ignoreSize</code> is true, then the preview is always  generated regardless of the settings </short>
			public void SetIgnoreMaximumSize(bool ignoreSize) {
				interceptor.Invoke("setIgnoreMaximumSize$", "setIgnoreMaximumSize(bool)", typeof(void), typeof(bool), ignoreSize);
			}
			public void SetIgnoreMaximumSize() {
				interceptor.Invoke("setIgnoreMaximumSize", "setIgnoreMaximumSize()", typeof(void));
			}
			[Q_SLOT("void slotResult(KJob*)")]
			[SmokeMethod("slotResult(KJob*)")]
			protected override void SlotResult(KJob job) {
				interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
			}
			~PreviewJob() {
				interceptor.Invoke("~PreviewJob", "~PreviewJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~PreviewJob", "~PreviewJob()", typeof(void));
			}
			/// <remarks>
			///  Returns a list of all available preview plugins. The list
			///  contains the basenames of the plugins' .desktop files (no path,
			///  no .desktop).
			/// </remarks>		<return> the list of plugins
			///          </return>
			/// 		<short>    Returns a list of all available preview plugins.</short>
			public static List<string> AvailablePlugins() {
				return (List<string>) staticInterceptor.Invoke("availablePlugins", "availablePlugins()", typeof(List<string>));
			}
			/// <remarks>
			///  Returns a list of all supported MIME types. The list can
			///  contain entries like text/  (without the space).
			/// </remarks>		<return> the list of mime types
			///          </return>
			/// 		<short>    Returns a list of all supported MIME types.</short>
			public static List<string> SupportedMimeTypes() {
				return (List<string>) staticInterceptor.Invoke("supportedMimeTypes", "supportedMimeTypes()", typeof(List<string>));
			}
			protected new IPreviewJobSignals Emit {
				get { return (IPreviewJobSignals) Q_EMIT; }
			}
		}

		public interface IPreviewJobSignals : KIO.IJobSignals {
		/// <remarks>
		///  Emitted when a thumbnail picture for <code>item</code> has been successfully
		///  retrieved.
		/// <param> name="item" the file of the preview
		/// </param><param> name="preview" the preview image
		///          </param></remarks>		<short>    Emitted when a thumbnail picture for <code>item</code> has been successfully  retrieved.</short>
		[Q_SIGNAL("void gotPreview(const KFileItem&, const QPixmap&)")]
		void GotPreview(KFileItem item, QPixmap preview);
		/// <remarks>
		///  Emitted when a thumbnail for <code>item</code> could not be created,
		///  either because a ThumbCreator for its MIME type does not
		///  exist, or because something went wrong.
		/// <param> name="item" the file that failed
		///          </param></remarks>		<short>    Emitted when a thumbnail for <code>item</code> could not be created,  either because a ThumbCreator for its MIME type does not  exist, or because something went wrong.</short>
		[Q_SIGNAL("void failed(const KFileItem&)")]
		void Failed(KFileItem item);
		}

		/// <remarks>
		///  MetaInfoJob is a KIO Job to retrieve meta information from files.
		///  See <see cref="IMetaInfoJobSignals"></see> for signals emitted by MetaInfoJob
		/// </remarks>		<short> KIO Job to retrieve meta information from files.      </short>

		[SmokeClass("KIO::MetaInfoJob")]
		public class MetaInfoJob : KIO.Job, IDisposable {
	 		protected MetaInfoJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(MetaInfoJob), this);
			}
			/// <remarks>
			///  Creates a new MetaInfoJob.
			/// <param> name="items" A list of KFileItems to get the metainfo for
			/// </param><param> name="w" Flags which serve as a preset which can be customized
			///                  with other parameters.
			/// </param><param> name="iocost" The allowed cost in terms of io to retrieve the
			///                  metainfo. The approximate maximum number of bytes to
			///                  be read is 10^iocost. Negative values mean that
			///                  there is no limit on the cost. 0 means that no fields
			///                  other than the required fields will be retrieved.
			///                  The default value of 3 means about 1024 bytes per
			///                  file may be read. This is merely a suggestion and not
			///                  a hard limit.
			/// </param><param> name="cpucost" The allowed cost in terms of cpu to determine the
			///                  information in the fields. The number mean the amount
			///                  of instructions allowed is 10^cpucost and is a suggestion only.
			///                  The default value of 6 means that about a million
			///                  instructions (10^6) are allowed. This is useful for
			///                  expensive fields like md5 or thumbnails.
			/// </param><param> name="requiredfields" The names of fields or groups of fields that should
			///                   be retrieved regardless of cost.
			/// </param><param> name="requestedfields" The names of fields or groups of fields that should
			///                   be retrieved first.
			///          </param></remarks>		<short>    Creates a new MetaInfoJob.</short>
			public MetaInfoJob(List<KFileItem> items, uint w, int iocost, int cpucost, List<string> requiredfields, List<string> requestedfields) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaInfoJob#$$$??", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int, int, const QStringList&, const QStringList&)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost, typeof(int), cpucost, typeof(List<string>), requiredfields, typeof(List<string>), requestedfields);
			}
			public MetaInfoJob(List<KFileItem> items, uint w, int iocost, int cpucost, List<string> requiredfields) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaInfoJob#$$$?", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int, int, const QStringList&)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost, typeof(int), cpucost, typeof(List<string>), requiredfields);
			}
			public MetaInfoJob(List<KFileItem> items, uint w, int iocost, int cpucost) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaInfoJob#$$$", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int, int)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost, typeof(int), cpucost);
			}
			public MetaInfoJob(List<KFileItem> items, uint w, int iocost) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaInfoJob#$$", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags, int)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w, typeof(int), iocost);
			}
			public MetaInfoJob(List<KFileItem> items, uint w) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaInfoJob#$", "MetaInfoJob(const KFileItemList&, KFileMetaInfo::WhatFlags)", typeof(void), typeof(List<KFileItem>), items, typeof(uint), w);
			}
			public MetaInfoJob(List<KFileItem> items) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("MetaInfoJob#", "MetaInfoJob(const KFileItemList&)", typeof(void), typeof(List<KFileItem>), items);
			}
			/// <remarks>
			///  Removes an item from metainfo extraction.
			/// <param> name="item" the item that should be removed from the queue
			///          </param></remarks>		<short>    Removes an item from metainfo extraction.</short>
			public void RemoveItem(KFileItem item) {
				interceptor.Invoke("removeItem#", "removeItem(const KFileItem&)", typeof(void), typeof(KFileItem), item);
			}
			protected void GetMetaInfo() {
				interceptor.Invoke("getMetaInfo", "getMetaInfo()", typeof(void));
			}
			[Q_SLOT("void slotResult(KJob*)")]
			[SmokeMethod("slotResult(KJob*)")]
			protected override void SlotResult(KJob job) {
				interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
			}
			~MetaInfoJob() {
				interceptor.Invoke("~MetaInfoJob", "~MetaInfoJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~MetaInfoJob", "~MetaInfoJob()", typeof(void));
			}
			protected new IMetaInfoJobSignals Emit {
				get { return (IMetaInfoJobSignals) Q_EMIT; }
			}
		}

		public interface IMetaInfoJobSignals : KIO.IJobSignals {
		/// <remarks>
		///  Emitted when the meta info for <code>item</code> has been successfully
		///  retrieved.
		/// <param> name="item" the KFileItem describing the fetched item
		///          </param></remarks>		<short>    Emitted when the meta info for <code>item</code> has been successfully  retrieved.</short>
		[Q_SIGNAL("void gotMetaInfo(const KFileItem&)")]
		void GotMetaInfo(KFileItem item);
		/// <remarks>
		///  Emitted when metainfo for <code>item</code> could not be extracted,
		///  either because a plugin for its MIME type does not
		///  exist, or because something went wrong.
		/// <param> name="item" the KFileItem of the file that failed
		///          </param></remarks>		<short>    Emitted when metainfo for <code>item</code> could not be extracted,  either because a plugin for its MIME type does not  exist, or because something went wrong.</short>
		[Q_SIGNAL("void failed(const KFileItem&)")]
		void Failed(KFileItem item);
		}

		/// <remarks>
		///  The transfer job pumps data into and/or out of a Slave.
		///  Data is sent to the slave on request of the slave ( dataReq).
		///  If data coming from the slave can not be handled, the
		///  reading of data from the slave should be suspended.
		/// </remarks>		<short>    The transfer job pumps data into and/or out of a Slave.</short>
		/// 		<see> davPropFind</see>
		/// 		<see> davPropPatch</see>
		/// 		<see> davSearch</see>

		[SmokeClass("KIO::DavJob")]
		public class DavJob : KIO.TransferJob, IDisposable {
	 		protected DavJob(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(DavJob), this);
			}
			/// <remarks>
			///  Returns the response as a QDomDocument.
			/// </remarks>		<return> the response document
			/// 	 </return>
			/// 		<short>    Returns the response as a QDomDocument.</short>
			public QDomDocument Response() {
				return (QDomDocument) interceptor.Invoke("response", "response()", typeof(QDomDocument));
			}
			[Q_SLOT("void slotFinished()")]
			[SmokeMethod("slotFinished()")]
			protected override void SlotFinished() {
				interceptor.Invoke("slotFinished", "slotFinished()", typeof(void));
			}
			[Q_SLOT("void slotData(const QByteArray&)")]
			[SmokeMethod("slotData(const QByteArray&)")]
			protected override void SlotData(QByteArray data) {
				interceptor.Invoke("slotData#", "slotData(const QByteArray&)", typeof(void), typeof(QByteArray), data);
			}
			~DavJob() {
				interceptor.Invoke("~DavJob", "~DavJob()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~DavJob", "~DavJob()", typeof(void));
			}
			protected new IDavJobSignals Emit {
				get { return (IDavJobSignals) Q_EMIT; }
			}
		}

		public interface IDavJobSignals : KIO.ITransferJobSignals {
		}

		/// <remarks>
		///  A dialog for the options to rename two files.
		/// </remarks>		<short> A dialog for renaming files.  </short>

		[SmokeClass("KIO::RenameDialog")]
		public class RenameDialog : QDialog, IDisposable {
	 		protected RenameDialog(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(RenameDialog), this);
			}
			private static SmokeInvocation staticInterceptor = null;
			static RenameDialog() {
				staticInterceptor = new SmokeInvocation(typeof(RenameDialog), null);
			}
			// KIO::RenameDialog* RenameDialog(QWidget* arg1,const QString& arg2,const KUrl& arg3,const KUrl& arg4,KIO::RenameDialog_Mode arg5,KIO::filesize_t arg6,KIO::filesize_t arg7,time_t arg8,time_t arg9,time_t arg10,time_t arg11); >>>> NOT CONVERTED
			// KIO::RenameDialog* RenameDialog(QWidget* arg1,const QString& arg2,const KUrl& arg3,const KUrl& arg4,KIO::RenameDialog_Mode arg5,KIO::filesize_t arg6,KIO::filesize_t arg7,time_t arg8,time_t arg9,time_t arg10); >>>> NOT CONVERTED
			// KIO::RenameDialog* RenameDialog(QWidget* arg1,const QString& arg2,const KUrl& arg3,const KUrl& arg4,KIO::RenameDialog_Mode arg5,KIO::filesize_t arg6,KIO::filesize_t arg7,time_t arg8,time_t arg9); >>>> NOT CONVERTED
			// KIO::RenameDialog* RenameDialog(QWidget* arg1,const QString& arg2,const KUrl& arg3,const KUrl& arg4,KIO::RenameDialog_Mode arg5,KIO::filesize_t arg6,KIO::filesize_t arg7,time_t arg8); >>>> NOT CONVERTED
			// KIO::RenameDialog* RenameDialog(QWidget* arg1,const QString& arg2,const KUrl& arg3,const KUrl& arg4,KIO::RenameDialog_Mode arg5,KIO::filesize_t arg6,KIO::filesize_t arg7); >>>> NOT CONVERTED
			// KIO::RenameDialog* RenameDialog(QWidget* arg1,const QString& arg2,const KUrl& arg3,const KUrl& arg4,KIO::RenameDialog_Mode arg5,KIO::filesize_t arg6); >>>> NOT CONVERTED
			/// <remarks>
			///  Construct a "rename" dialog.
			/// <param> name="parent" parent widget (often 0)
			/// </param><param> name="caption" the caption for the dialog box
			/// </param><param> name="src" the url to the file/dir we're trying to copy, as it's part of the text message
			/// </param><param> name="dest" the path to destination file/dir, i.e. the one that already exists
			/// </param><param> name="mode" parameters for the dialog (which buttons to show...),
			/// </param><param> name="sizeSrc" size of source file
			/// </param><param> name="sizeDest" size of destination file
			/// </param><param> name="ctimeSrc" creation time of source file
			/// </param><param> name="ctimeDest" creation time of destination file
			/// </param><param> name="mtimeSrc" modification time of source file
			/// </param><param> name="mtimeDest" modification time of destination file
			/// </param></remarks>		<short>    Construct a "rename" dialog.</short>
			/// 		<see> RenameDialog_Mode</see>
			public RenameDialog(QWidget parent, string caption, KUrl src, KUrl dest, KIO.RenameDialog_Mode mode) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("RenameDialog#$##$", "RenameDialog(QWidget*, const QString&, const KUrl&, const KUrl&, KIO::RenameDialog_Mode)", typeof(void), typeof(QWidget), parent, typeof(string), caption, typeof(KUrl), src, typeof(KUrl), dest, typeof(KIO.RenameDialog_Mode), mode);
			}
			/// <remarks>
			/// </remarks>		<return> the new destination
			///  valid only if RENAME was chosen
			///    </return>
			/// 		<short>   </short>
			public KUrl NewDestUrl() {
				return (KUrl) interceptor.Invoke("newDestUrl", "newDestUrl()", typeof(KUrl));
			}
			[Q_SLOT("void cancelPressed()")]
			public void CancelPressed() {
				interceptor.Invoke("cancelPressed", "cancelPressed()", typeof(void));
			}
			[Q_SLOT("void renamePressed()")]
			public void RenamePressed() {
				interceptor.Invoke("renamePressed", "renamePressed()", typeof(void));
			}
			[Q_SLOT("void skipPressed()")]
			public void SkipPressed() {
				interceptor.Invoke("skipPressed", "skipPressed()", typeof(void));
			}
			[Q_SLOT("void autoSkipPressed()")]
			public void AutoSkipPressed() {
				interceptor.Invoke("autoSkipPressed", "autoSkipPressed()", typeof(void));
			}
			[Q_SLOT("void overwritePressed()")]
			public void OverwritePressed() {
				interceptor.Invoke("overwritePressed", "overwritePressed()", typeof(void));
			}
			[Q_SLOT("void overwriteAllPressed()")]
			public void OverwriteAllPressed() {
				interceptor.Invoke("overwriteAllPressed", "overwriteAllPressed()", typeof(void));
			}
			[Q_SLOT("void resumePressed()")]
			public void ResumePressed() {
				interceptor.Invoke("resumePressed", "resumePressed()", typeof(void));
			}
			[Q_SLOT("void resumeAllPressed()")]
			public void ResumeAllPressed() {
				interceptor.Invoke("resumeAllPressed", "resumeAllPressed()", typeof(void));
			}
			[Q_SLOT("void suggestNewNamePressed()")]
			public void SuggestNewNamePressed() {
				interceptor.Invoke("suggestNewNamePressed", "suggestNewNamePressed()", typeof(void));
			}
			[Q_SLOT("void enableRenameButton(const QString&)")]
			protected void EnableRenameButton(string arg1) {
				interceptor.Invoke("enableRenameButton$", "enableRenameButton(const QString&)", typeof(void), typeof(string), arg1);
			}
			~RenameDialog() {
				interceptor.Invoke("~RenameDialog", "~RenameDialog()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~RenameDialog", "~RenameDialog()", typeof(void));
			}
			/// <remarks>
			///  Given a directory path and a filename (which usually exists already),
			///  this function returns a suggested name for a file that doesn't exist
			///  in that directory. The existence is only checked for local urls though.
			///  The suggested file name is of the form foo_1 foo_2 etc.
			///    </remarks>		<short>    Given a directory path and a filename (which usually exists already),  this function returns a suggested name for a file that doesn't exist  in that directory.</short>
			public static string SuggestName(KUrl baseURL, string oldName) {
				return (string) staticInterceptor.Invoke("suggestName#$", "suggestName(const KUrl&, const QString&)", typeof(string), typeof(KUrl), baseURL, typeof(string), oldName);
			}
			protected new IRenameDialogSignals Emit {
				get { return (IRenameDialogSignals) Q_EMIT; }
			}
		}

		public interface IRenameDialogSignals : IQDialogSignals {
		}

		/// <remarks>
		///   See <see cref="ISkipDialogSignals"></see> for signals emitted by SkipDialog
		/// </remarks>		<short>   </short>

		[SmokeClass("KIO::SkipDialog")]
		public class SkipDialog : KDialog, IDisposable {
	 		protected SkipDialog(Type dummy) : base((Type) null) {}
			protected new void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(SkipDialog), this);
			}
			public SkipDialog(QWidget parent, bool _multi, string _error_text) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("SkipDialog#$$", "SkipDialog(QWidget*, bool, const QString&)", typeof(void), typeof(QWidget), parent, typeof(bool), _multi, typeof(string), _error_text);
			}
			[Q_SLOT("void b0Pressed()")]
			public void B0Pressed() {
				interceptor.Invoke("b0Pressed", "b0Pressed()", typeof(void));
			}
			[Q_SLOT("void b1Pressed()")]
			public void B1Pressed() {
				interceptor.Invoke("b1Pressed", "b1Pressed()", typeof(void));
			}
			[Q_SLOT("void b2Pressed()")]
			public void B2Pressed() {
				interceptor.Invoke("b2Pressed", "b2Pressed()", typeof(void));
			}
			~SkipDialog() {
				interceptor.Invoke("~SkipDialog", "~SkipDialog()", typeof(void));
			}
			public new void Dispose() {
				interceptor.Invoke("~SkipDialog", "~SkipDialog()", typeof(void));
			}
			protected new ISkipDialogSignals Emit {
				get { return (ISkipDialogSignals) Q_EMIT; }
			}
		}

		public interface ISkipDialogSignals : IKDialogSignals {
		[Q_SIGNAL("void result(KIO::SkipDialog*, int)")]
		void Result(KIO.SkipDialog _this, int _button);
		}

		/// <remarks>
		///  Universal Directory Service
		///  UDS entry is the data structure representing all the fields about a given URL
		///  (file or directory).
		///  The KIO.ListDir() and KIO:stat() operations use this data structure.
		///  KIO defines a number of standard fields, see the UDS_XXX enums (see StandardFieldTypes).
		///  at the moment UDSEntry only provides fields with numeric indexes,
		///  but there might be named fields with string indexes in the future.
		///  For instance, to retrieve the name of the entry, use:
		///  <pre>
		///  string displayName = entry.stringValue( KIO.UDSEntry.UDS_NAME );
		///  </pre>
		///  To know the modification time of the file/url:
		///  <pre>
		///   time_t mtime = entry.numberValue( KIO.UDSEntry.UDS_MODIFICATION_TIME, -1 );
		///   if ( mtime != -1 )
		///       ...
		///  </pre>
		///      </remarks>		<short>    Universal Directory Service </short>

		[SmokeClass("KIO::UDSEntry")]
		public class UDSEntry : Object, IDisposable {
			protected SmokeInvocation interceptor = null;
			private IntPtr smokeObject;
			protected UDSEntry(Type dummy) {}
			protected void CreateProxy() {
				interceptor = new SmokeInvocation(typeof(UDSEntry), this);
			}
			// long long numberValue(uint arg1,long long arg2); >>>> NOT CONVERTED
			// long long numberValue(uint arg1); >>>> NOT CONVERTED
			// void insert(uint arg1,long long arg2); >>>> NOT CONVERTED
			// QList<uint> listFields(); >>>> NOT CONVERTED
			public UDSEntry() : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("UDSEntry", "UDSEntry()", typeof(void));
			}
			public UDSEntry(KIO.UDSEntry other) : this((Type) null) {
				CreateProxy();
				interceptor.Invoke("UDSEntry#", "UDSEntry(const KIO::UDSEntry&)", typeof(void), typeof(KIO.UDSEntry), other);
			}
			/// <remarks>
			/// </remarks>		<return> value of a textual field
			///          </return>
			/// 		<short>   </short>
			public string StringValue(uint field) {
				return (string) interceptor.Invoke("stringValue$", "stringValue(uint) const", typeof(string), typeof(uint), field);
			}
			/// <remarks>
			/// </remarks>		<return> value of a numeric field
			///          </return>
			/// 		<short>   </short>
			public bool IsDir() {
				return (bool) interceptor.Invoke("isDir", "isDir() const", typeof(bool));
			}
			public bool IsLink() {
				return (bool) interceptor.Invoke("isLink", "isLink() const", typeof(bool));
			}
			/// <remarks>
			///  insert field with numeric value
			/// <param> name="field" numeric field id
			/// </param><param> name="value"          </param></remarks>		<short>    insert field with numeric value </short>
			public void Insert(uint field, string value) {
				interceptor.Invoke("insert$$", "insert(uint, const QString&)", typeof(void), typeof(uint), field, typeof(string), value);
			}
			/// <remarks>
			///  insert field with string value
			/// <param> name="field" numeric tield id
			/// </param><param> name="l" value to set
			///          </param></remarks>		<short>    insert field with string value </short>
			/// <remarks>
			///  count fields
			/// </remarks>		<return> the number of fields
			///          </return>
			/// 		<short>    count fields </short>
			public int Count() {
				return (int) interceptor.Invoke("count", "count() const", typeof(int));
			}
			/// <remarks>
			///  check existence of a field
			/// <param> name="field"          </param></remarks>		<short>    check existence of a field </short>
			public bool Contains(uint field) {
				return (bool) interceptor.Invoke("contains$", "contains(uint) const", typeof(bool), typeof(uint), field);
			}
			/// <remarks>
			///  remove a field with a certain numeric id
			/// <param> name="field" numeric type id
			///          </param></remarks>		<short>    remove a field with a certain numeric id </short>
			public bool Remove(uint field) {
				return (bool) interceptor.Invoke("remove$", "remove(uint)", typeof(bool), typeof(uint), field);
			}
			/// <remarks>
			///  lists all fields
			///          </remarks>		<short>    lists all fields          </short>
			/// <remarks>
			///  remove all fields
			///          </remarks>		<short>    remove all fields          </short>
			public void Clear() {
				interceptor.Invoke("clear", "clear()", typeof(void));
			}
			~UDSEntry() {
				interceptor.Invoke("~UDSEntry", "~UDSEntry()", typeof(void));
			}
			public void Dispose() {
				interceptor.Invoke("~UDSEntry", "~UDSEntry()", typeof(void));
			}
		}
		private static SmokeInvocation staticInterceptor = null;
		static KIO() {
			staticInterceptor = new SmokeInvocation(typeof(KIO), null);
		}
		/// <remarks>
		///  Identifiers for KIO informational messages.
		///   </remarks>		<short>    Identifiers for KIO informational messages.</short>
		public enum Info {
			INF_TOTAL_SIZE = 10,
			INF_PROCESSED_SIZE = 11,
			INF_SPEED = 12,
			INF_REDIRECTION = 20,
			INF_MIME_TYPE = 21,
			INF_ERROR_PAGE = 22,
			INF_WARNING = 23,
			INF_GETTING_FILE = 24,
			INF_UNUSED = 25,
			INF_INFOMESSAGE = 26,
			INF_META_DATA = 27,
			INF_NETWORK_STATUS = 28,
			INF_MESSAGEBOX = 29,
			INF_POSITION = 30,
		}
		/// <remarks>
		///  Identifiers for KIO data messages.
		///   </remarks>		<short>    Identifiers for KIO data messages.</short>
		public enum Message {
			MSG_DATA = 100,
			MSG_DATA_REQ = 101,
			MSG_ERROR = 102,
			MSG_CONNECTED = 103,
			MSG_FINISHED = 104,
			MSG_STAT_ENTRY = 105,
			MSG_LIST_ENTRIES = 106,
			MSG_RENAMED = 107,
			MSG_RESUME = 108,
			MSG_SLAVE_STATUS = 109,
			MSG_SLAVE_ACK = 110,
			MSG_NET_REQUEST = 111,
			MSG_NET_DROP = 112,
			MSG_NEED_SUBURL_DATA = 113,
			MSG_CANRESUME = 114,
			MSG_AUTH_KEY = 115,
			MSG_DEL_AUTH_KEY = 116,
			MSG_OPENED = 117,
			MSG_WRITTEN = 118,
		}
		/// <remarks>
		///  Commands that can be invoked by a job.
		///  (Move this to a non-public header)
		///    </remarks>		<short>   </short>
		public enum Command {
			CMD_HOST = '0',
			CMD_CONNECT = '1',
			CMD_DISCONNECT = '2',
			CMD_SLAVE_STATUS = '3',
			CMD_SLAVE_CONNECT = '4',
			CMD_SLAVE_HOLD = '5',
			CMD_NONE = 'A',
			CMD_TESTDIR = 'B',
			CMD_GET = 'C',
			CMD_PUT = 'D',
			CMD_STAT = 'E',
			CMD_MIMETYPE = 'F',
			CMD_LISTDIR = 'G',
			CMD_MKDIR = 'H',
			CMD_RENAME = 'I',
			CMD_COPY = 'J',
			CMD_DEL = 'K',
			CMD_CHMOD = 'L',
			CMD_SPECIAL = 'M',
			CMD_SETMODIFICATIONTIME = 'N',
			CMD_REPARSECONFIGURATION = 'O',
			CMD_META_DATA = 'P',
			CMD_SYMLINK = 'Q',
			CMD_SUBURL = 'R',
			CMD_MESSAGEBOXANSWER = 'S',
			CMD_RESUMEANSWER = 'T',
			CMD_CONFIG = 'U',
			CMD_MULTI_GET = 'V',
			CMD_SETLINKDEST = 'W',
			CMD_OPEN = 'X',
			CMD_CHOWN = 'Y',
			CMD_READ = 'Z',
			CMD_WRITE = 91,
			CMD_SEEK = 92,
			CMD_CLOSE = 93,
		}
		/// <remarks>
		///  Error codes that can be emitted by KIO.
		///    </remarks>		<short>    Error codes that can be emitted by KIO.</short>
		public enum Error {
			ERR_CANNOT_OPEN_FOR_READING = KJob.UserDefinedError+1,
			ERR_CANNOT_OPEN_FOR_WRITING = KJob.UserDefinedError+2,
			ERR_CANNOT_LAUNCH_PROCESS = KJob.UserDefinedError+3,
			ERR_INTERNAL = KJob.UserDefinedError+4,
			ERR_MALFORMED_URL = KJob.UserDefinedError+5,
			ERR_UNSUPPORTED_PROTOCOL = KJob.UserDefinedError+6,
			ERR_NO_SOURCE_PROTOCOL = KJob.UserDefinedError+7,
			ERR_UNSUPPORTED_ACTION = KJob.UserDefinedError+8,
			ERR_IS_DIRECTORY = KJob.UserDefinedError+9,
			ERR_IS_FILE = KJob.UserDefinedError+10,
			ERR_DOES_NOT_EXIST = KJob.UserDefinedError+11,
			ERR_FILE_ALREADY_EXIST = KJob.UserDefinedError+12,
			ERR_DIR_ALREADY_EXIST = KJob.UserDefinedError+13,
			ERR_UNKNOWN_HOST = KJob.UserDefinedError+14,
			ERR_ACCESS_DENIED = KJob.UserDefinedError+15,
			ERR_WRITE_ACCESS_DENIED = KJob.UserDefinedError+16,
			ERR_CANNOT_ENTER_DIRECTORY = KJob.UserDefinedError+17,
			ERR_PROTOCOL_IS_NOT_A_FILESYSTEM = KJob.UserDefinedError+18,
			ERR_CYCLIC_LINK = KJob.UserDefinedError+19,
			ERR_USER_CANCELED = KJob.KilledJobError,
			ERR_CYCLIC_COPY = KJob.UserDefinedError+21,
			ERR_COULD_NOT_CREATE_SOCKET = KJob.UserDefinedError+22,
			ERR_COULD_NOT_CONNECT = KJob.UserDefinedError+23,
			ERR_CONNECTION_BROKEN = KJob.UserDefinedError+24,
			ERR_NOT_FILTER_PROTOCOL = KJob.UserDefinedError+25,
			ERR_COULD_NOT_MOUNT = KJob.UserDefinedError+26,
			ERR_COULD_NOT_UNMOUNT = KJob.UserDefinedError+27,
			ERR_COULD_NOT_READ = KJob.UserDefinedError+28,
			ERR_COULD_NOT_WRITE = KJob.UserDefinedError+29,
			ERR_COULD_NOT_BIND = KJob.UserDefinedError+30,
			ERR_COULD_NOT_LISTEN = KJob.UserDefinedError+31,
			ERR_COULD_NOT_ACCEPT = KJob.UserDefinedError+32,
			ERR_COULD_NOT_LOGIN = KJob.UserDefinedError+33,
			ERR_COULD_NOT_STAT = KJob.UserDefinedError+34,
			ERR_COULD_NOT_CLOSEDIR = KJob.UserDefinedError+35,
			ERR_COULD_NOT_MKDIR = KJob.UserDefinedError+37,
			ERR_COULD_NOT_RMDIR = KJob.UserDefinedError+38,
			ERR_CANNOT_RESUME = KJob.UserDefinedError+39,
			ERR_CANNOT_RENAME = KJob.UserDefinedError+40,
			ERR_CANNOT_CHMOD = KJob.UserDefinedError+41,
			ERR_CANNOT_DELETE = KJob.UserDefinedError+42,
			ERR_SLAVE_DIED = KJob.UserDefinedError+43,
			ERR_OUT_OF_MEMORY = KJob.UserDefinedError+44,
			ERR_UNKNOWN_PROXY_HOST = KJob.UserDefinedError+45,
			ERR_COULD_NOT_AUTHENTICATE = KJob.UserDefinedError+46,
			ERR_ABORTED = KJob.UserDefinedError+47,
			ERR_INTERNAL_SERVER = KJob.UserDefinedError+48,
			ERR_SERVER_TIMEOUT = KJob.UserDefinedError+49,
			ERR_SERVICE_NOT_AVAILABLE = KJob.UserDefinedError+50,
			ERR_UNKNOWN = KJob.UserDefinedError+51,
			ERR_UNKNOWN_INTERRUPT = KJob.UserDefinedError+53,
			ERR_CANNOT_DELETE_ORIGINAL = KJob.UserDefinedError+54,
			ERR_CANNOT_DELETE_PARTIAL = KJob.UserDefinedError+55,
			ERR_CANNOT_RENAME_ORIGINAL = KJob.UserDefinedError+56,
			ERR_CANNOT_RENAME_PARTIAL = KJob.UserDefinedError+57,
			ERR_NEED_PASSWD = KJob.UserDefinedError+58,
			ERR_CANNOT_SYMLINK = KJob.UserDefinedError+59,
			ERR_NO_CONTENT = KJob.UserDefinedError+60,
			ERR_DISK_FULL = KJob.UserDefinedError+61,
			ERR_IDENTICAL_FILES = KJob.UserDefinedError+62,
			ERR_SLAVE_DEFINED = KJob.UserDefinedError+63,
			ERR_UPGRADE_REQUIRED = KJob.UserDefinedError+64,
			ERR_POST_DENIED = KJob.UserDefinedError+65,
			ERR_COULD_NOT_SEEK = KJob.UserDefinedError+66,
			ERR_CANNOT_SETTIME = KJob.UserDefinedError+67,
			ERR_CANNOT_CHOWN = KJob.UserDefinedError+68,
		}
		/// <remarks>
		///  Specifies how to use the cache.
		/// </remarks>		<short>    Specifies how to use the cache.</short>
		/// 		<see> parseCacheControl</see>
		/// 		<see> getCacheControlString</see>
		public enum CacheControl {
			CC_CacheOnly = 0,
			CC_Cache = 1,
			CC_Verify = 2,
			CC_Refresh = 3,
			CC_Reload = 4,
		}
		public enum LoadType {
			Reload = 0,
			NoReload = 1,
		}
		/// <remarks>
		///  Flags for the job properties.
		///  Not all flags are supported in all cases. Please see documentation of 
		///  the calling function!
		///      </remarks>		<short>    Flags for the job properties.</short>
		public enum JobFlag {
			DefaultFlags = 0,
			HideProgressInfo = 1,
			Resume = 2,
			Overwrite = 4,
		}
		public enum RenameDialog_Mode {
			M_OVERWRITE = 1,
			M_OVERWRITE_ITSELF = 2,
			M_SKIP = 4,
			M_SINGLE = 8,
			M_MULTI = 16,
			M_RESUME = 32,
			M_NORENAME = 64,
		}
		/// <remarks>
		///  The result of open_RenameDialog().
		///  </remarks>		<short>    The result of open_RenameDialog().</short>
		public enum RenameDialog_Result {
			R_RESUME = 6,
			R_RESUME_ALL = 7,
			R_OVERWRITE = 4,
			R_OVERWRITE_ALL = 5,
			R_SKIP = 2,
			R_AUTO_SKIP = 3,
			R_RENAME = 1,
			R_CANCEL = 0,
		}
		public enum SkipDialog_Result {
			S_SKIP = 1,
			S_AUTO_SKIP = 2,
			S_CANCEL = 0,
		}
		/// <remarks> HTTP / DAV method *</remarks>		<short>   HTTP / DAV method  </short>
		public enum HTTP_METHOD {
			HTTP_GET = 0,
			HTTP_PUT = 1,
			HTTP_POST = 2,
			HTTP_HEAD = 3,
			HTTP_DELETE = 4,
			HTTP_OPTIONS = 5,
			DAV_PROPFIND = 6,
			DAV_PROPPATCH = 7,
			DAV_MKCOL = 8,
			DAV_COPY = 9,
			DAV_MOVE = 10,
			DAV_LOCK = 11,
			DAV_UNLOCK = 12,
			DAV_SEARCH = 13,
			DAV_SUBSCRIBE = 14,
			DAV_UNSUBSCRIBE = 15,
			DAV_POLL = 16,
			DAV_NOTIFY = 17,
			HTTP_UNKNOWN = -1,
		}
		// QString convertSize(KIO::filesize_t arg1); >>>> NOT CONVERTED
		// QString number(KIO::filesize_t arg1); >>>> NOT CONVERTED
		// QString convertSizeFromKiB(KIO::filesize_t arg1); >>>> NOT CONVERTED
		// unsigned int calculateRemainingSeconds(KIO::filesize_t arg1,KIO::filesize_t arg2,KIO::filesize_t arg3); >>>> NOT CONVERTED
		// QTime calculateRemaining(KIO::filesize_t arg1,KIO::filesize_t arg2,KIO::filesize_t arg3); >>>> NOT CONVERTED
		// QString itemsSummaryString(uint arg1,uint arg2,uint arg3,KIO::filesize_t arg4,bool arg5); >>>> NOT CONVERTED
		// KJobTrackerInterface* getJobTracker(); >>>> NOT CONVERTED
		// KIO::StatJob* stat(const KUrl& arg1,KIO::StatJob::StatSide arg2,short int arg3,KIO::JobFlags arg4); >>>> NOT CONVERTED
		// KIO::StatJob* stat(const KUrl& arg1,KIO::StatJob::StatSide arg2,short int arg3); >>>> NOT CONVERTED
		/// <remarks>
		///  Converts <code>size</code> from bytes to the string representation.
		/// <param> name="size" size in bytes
		/// </param></remarks>		<return> converted size as a string - e.g. 123.4 KiB , 12.0 MiB
		///    </return>
		/// 		<short>    Converts <code>size</code> from bytes to the string representation.</short>
		/// <remarks>
		///  Converts a size to a string representation
		///  Not unlike string.Number(...)
		/// <param> name="size" size in bytes
		/// </param></remarks>		<return> converted size as a string - e.g. 123456789
		///    </return>
		/// 		<short>    Converts a size to a string representation  Not unlike string.Number(.</short>
		/// <remarks>
		///  Converts size from kibi-bytes (2^10) to the string representation.
		/// <param> name="kibSize" size in kibi-bytes (2^10)
		/// </param></remarks>		<return> converted size as a string - e.g. 123.4 KiB , 12.0 MiB
		///    </return>
		/// 		<short>    Converts size from kibi-bytes (2^10) to the string representation.</short>
		/// <remarks>
		///  Calculates remaining time in seconds from total size, processed size and speed.
		/// <param> name="totalSize" total size in bytes
		/// </param><param> name="processedSize" processed size in bytes
		/// </param><param> name="speed" speed in bytes per second
		/// </param></remarks>		<return> calculated remaining time in seconds
		///    </return>
		/// 		<short>    Calculates remaining time in seconds from total size, processed size and speed.</short>
		/// <remarks>
		///  Convert <code>seconds</code> to a string representing number of days, hours, minutes and seconds
		/// <param> name="seconds" number of seconds to convert
		/// </param></remarks>		<return> string representation in a locale depending format
		///    </return>
		/// 		<short>    Convert <code>seconds</code> to a string representing number of days, hours, minutes and seconds </short>
		public static string ConvertSeconds(uint seconds) {
			return (string) staticInterceptor.Invoke("convertSeconds$", "convertSeconds(unsigned int)", typeof(string), typeof(uint), seconds);
		}
		/// <remarks>
		///  Calculates remaining time from total size, processed size and speed.
		///  Warning: As QTime is limited to 23:59:59, use calculateRemainingSeconds() instead
		/// <param> name="totalSize" total size in bytes
		/// </param><param> name="processedSize" processed size in bytes
		/// </param><param> name="speed" speed in bytes per second
		/// </param></remarks>		<return> calculated remaining time
		///    </return>
		/// 		<short>    Calculates remaining time from total size, processed size and speed.</short>
		/// <remarks>
		///  Helper for showing information about a set of files and directories
		/// <param> name="items" the number of items (= <code>files</code> + <code>dirs</code> + number of symlinks :)
		/// </param><param> name="files" the number of files
		/// </param><param> name="dirs" the number of dirs
		/// </param><param> name="size" the sum of the size of the <code>files</code>
		/// </param><param> name="showSize" whether to show the size in the result
		/// </param></remarks>		<return> the summary string
		///    </return>
		/// 		<short>    Helper for showing information about a set of files and directories </short>
		/// <remarks>
		///  Encodes (from the text displayed to the real filename)
		///  This translates % into %% and / into %2f
		///  Used by KIO.Link, for instance.
		/// <param> name="str" the file name to encode
		/// </param></remarks>		<return> the encoded file name
		///    </return>
		/// 		<short>    Encodes (from the text displayed to the real filename)  This translates % into %% and / into %2f  Used by KIO.Link, for instance.</short>
		public static string EncodeFileName(string str) {
			return (string) staticInterceptor.Invoke("encodeFileName$", "encodeFileName(const QString&)", typeof(string), typeof(string), str);
		}
		/// <remarks>
		///  Decodes (from the filename to the text displayed)
		///  This translates %2[fF] into / and %% into %
		/// <param> name="str" the file name to decode
		/// </param></remarks>		<return> the decoded file name
		///    </return>
		/// 		<short>    Decodes (from the filename to the text displayed)  This translates %2[fF] into / and %% into % </short>
		public static string DecodeFileName(string str) {
			return (string) staticInterceptor.Invoke("decodeFileName$", "decodeFileName(const QString&)", typeof(string), typeof(string), str);
		}
		/// <remarks>
		///  Returns a translated error message for <code>errorCode</code> using the
		///  additional error information provided by <code>errorText.</code>
		/// <param> name="errorCode" the error code
		/// </param><param> name="errorText" the additional error text
		/// </param></remarks>		<return> the created error string
		///    </return>
		/// 		<short>    Returns a translated error message for <code>errorCode</code> using the  additional error information provided by <code>errorText.</code></short>
		public static string BuildErrorString(int errorCode, string errorText) {
			return (string) staticInterceptor.Invoke("buildErrorString$$", "buildErrorString(int, const QString&)", typeof(string), typeof(int), errorCode, typeof(string), errorText);
		}
		/// <remarks>
		///  Returns translated error details for <code>errorCode</code> using the
		///  additional error information provided by <code>errorText</code> , <code>reqUrl</code>
		///  (the request URL), and the ioslave <code>method</code> .
		/// <param> name="errorCode" the error code
		/// </param><param> name="errorText" the additional error text
		/// </param><param> name="reqUrl" the request URL
		/// </param><param> name="method" the ioslave method
		/// </param>
		/// <li>
		/// string errorName - the name of the error
		/// </li>
		/// 
		/// <li>
		/// string techName - if not null, the more technical name of the error
		/// </li>
		/// 
		/// <li>
		/// string description - a description of the error
		/// </li>
		/// 
		/// <li>
		/// List<string> causes - a list of possible causes of the error
		/// </li>
		/// 
		/// <li>
		/// List<string> solutions - a liso of solutions for the error
		///    
		/// </li></remarks>		<return> the following data:
		/// </return>
		/// 		<short>    Returns translated error details for <code>errorCode</code> using the  additional error information provided by <code>errorText</code> , <code>reqUrl</code>  (the request URL), and the ioslave <code>method</code> .</short>
		public static QByteArray RawErrorDetail(int errorCode, string errorText, KUrl reqUrl, int method) {
			return (QByteArray) staticInterceptor.Invoke("rawErrorDetail$$#$", "rawErrorDetail(int, const QString&, const KUrl*, int)", typeof(QByteArray), typeof(int), errorCode, typeof(string), errorText, typeof(KUrl), reqUrl, typeof(int), method);
		}
		public static QByteArray RawErrorDetail(int errorCode, string errorText, KUrl reqUrl) {
			return (QByteArray) staticInterceptor.Invoke("rawErrorDetail$$#", "rawErrorDetail(int, const QString&, const KUrl*)", typeof(QByteArray), typeof(int), errorCode, typeof(string), errorText, typeof(KUrl), reqUrl);
		}
		public static QByteArray RawErrorDetail(int errorCode, string errorText) {
			return (QByteArray) staticInterceptor.Invoke("rawErrorDetail$$", "rawErrorDetail(int, const QString&)", typeof(QByteArray), typeof(int), errorCode, typeof(string), errorText);
		}
		/// <remarks>
		///  Returns an appropriate error message if the given command <code>cmd</code>
		///  is an unsupported action (ERR_UNSUPPORTED_ACTION).
		/// <param> name="protocol" name of the protocol
		/// </param><param> name="cmd" given command
		/// </param></remarks>		<short>    Returns an appropriate error message if the given command <code>cmd</code>  is an unsupported action (ERR_UNSUPPORTED_ACTION).</short>
		/// 		<see> enum</see>
		/// 		<see> Command</see>
		public static string UnsupportedActionErrorString(string protocol, int cmd) {
			return (string) staticInterceptor.Invoke("unsupportedActionErrorString$$", "unsupportedActionErrorString(const QString&, int)", typeof(string), typeof(string), protocol, typeof(int), cmd);
		}
		/// <remarks>
		///  Parses the string representation of the cache control option.
		/// <param> name="cacheControl" the string representation
		/// </param></remarks>		<return> the cache control value
		/// </return>
		/// 		<short>    Parses the string representation of the cache control option.</short>
		/// 		<see> getCacheControlString</see>
		public static KIO.CacheControl ParseCacheControl(string cacheControl) {
			return (KIO.CacheControl) staticInterceptor.Invoke("parseCacheControl$", "parseCacheControl(const QString&)", typeof(KIO.CacheControl), typeof(string), cacheControl);
		}
		/// <remarks>
		///  Returns a string representation of the given cache control method.
		/// <param> name="cacheControl" the cache control method
		/// </param></remarks>		<return> the string representation
		/// </return>
		/// 		<short>    Returns a string representation of the given cache control method.</short>
		/// 		<see> parseCacheControl</see>
		public static string GetCacheControlString(KIO.CacheControl cacheControl) {
			return (string) staticInterceptor.Invoke("getCacheControlString$", "getCacheControlString(KIO::CacheControl)", typeof(string), typeof(KIO.CacheControl), cacheControl);
		}
		/// <remarks>
		///  Convenience method to find the pixmap for a URL.
		///  Call this one when you don't know the mimetype.
		/// <param> name="_url" URL for the file.
		/// </param><param> name="_mode" the mode of the file. The mode may modify the icon
		///               with overlays that show special properties of the
		///               icon. Use 0 for default
		/// </param><param> name="_group" The icon group where the icon is going to be used.
		/// </param><param> name="_force_size" Override globally configured icon size.
		///         Use 0 for the default size
		/// </param><param> name="_state" The icon state, one of: KIconLoader.DefaultState,
		///  KIconLoader.ActiveState or KIconLoader.DisabledState.
		/// </param><param> name="_path" Output parameter to get the full path. Seldom needed.
		///               Ignored if 0
		/// </param></remarks>		<return> the pixmap of the URL, can be a default icon if not found
		///    </return>
		/// 		<short>    Convenience method to find the pixmap for a URL.</short>
		public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group, int _force_size, int _state, StringBuilder _path) {
			return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$$$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group, int, int, QString*)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group, typeof(int), _force_size, typeof(int), _state, typeof(StringBuilder), _path);
		}
		public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group, int _force_size, int _state) {
			return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group, int, int)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group, typeof(int), _force_size, typeof(int), _state);
		}
		public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group, int _force_size) {
			return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group, int)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group, typeof(int), _force_size);
		}
		public static QPixmap PixmapForUrl(KUrl _url, long _mode, KIconLoader.Group _group) {
			return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$$", "pixmapForUrl(const KUrl&, mode_t, KIconLoader::Group)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode, typeof(KIconLoader.Group), _group);
		}
		public static QPixmap PixmapForUrl(KUrl _url, long _mode) {
			return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#$", "pixmapForUrl(const KUrl&, mode_t)", typeof(QPixmap), typeof(KUrl), _url, typeof(long), _mode);
		}
		public static QPixmap PixmapForUrl(KUrl _url) {
			return (QPixmap) staticInterceptor.Invoke("pixmapForUrl#", "pixmapForUrl(const KUrl&)", typeof(QPixmap), typeof(KUrl), _url);
		}
		/// <remarks>
		///  Creates a single directory.
		/// <param> name="url" The URL of the directory to create.
		/// </param><param> name="permissions" The permissions to set after creating the
		///                     directory (unix-style), -1 for default permissions.
		/// </param></remarks>		<return> A pointer to the job handling the operation.
		///      </return>
		/// 		<short>    Creates a single directory.</short>
		public static KIO.SimpleJob Mkdir(KUrl url, int permissions) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("mkdir#$", "mkdir(const KUrl&, int)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(int), permissions);
		}
		public static KIO.SimpleJob Mkdir(KUrl url) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("mkdir#", "mkdir(const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  Removes a single directory.
		///  The directory is assumed to be empty.
		/// <param> name="url" The URL of the directory to remove.
		/// </param></remarks>		<return> A pointer to the job handling the operation.
		///      </return>
		/// 		<short>    Removes a single directory.</short>
		public static KIO.SimpleJob Rmdir(KUrl url) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("rmdir#", "rmdir(const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  Changes permissions on a file or directory.
		///  See the other chmod below for changing many files
		///  or directories.
		/// <param> name="url" The URL of file or directory.
		/// </param><param> name="permissions" The permissions to set.
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Changes permissions on a file or directory.</short>
		public static KIO.SimpleJob Chmod(KUrl url, int permissions) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("chmod#$", "chmod(const KUrl&, int)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(int), permissions);
		}
		/// <remarks>
		///  Changes ownership and group of a file or directory.
		/// <param> name="url" The URL of file or directory.
		/// </param><param> name="owner" the new owner
		/// </param><param> name="group" the new group
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Changes ownership and group of a file or directory.</short>
		public static KIO.SimpleJob Chown(KUrl url, string owner, string group) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("chown#$$", "chown(const KUrl&, const QString&, const QString&)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(string), owner, typeof(string), group);
		}
		/// <remarks>
		///  Changes the modification time on a file or directory.
		/// <param> name="url" The URL of file or directory.
		/// </param><param> name="permissions" The permissions to set.
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Changes the modification time on a file or directory.</short>
		public static KIO.SimpleJob SetModificationTime(KUrl url, QDateTime mtime) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("setModificationTime##", "setModificationTime(const KUrl&, const QDateTime&)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(QDateTime), mtime);
		}
		/// <remarks>
		///  Rename a file or directory.
		///  Warning: this operation fails if a direct renaming is not
		///  possible (like with files or dirs on separate partitions)
		///  Use move or file_move in this case.
		/// <param> name="src" The original URL
		/// </param><param> name="dest" The final URL
		/// </param><param> name="flags" Can be Overwrite here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Rename a file or directory.</short>
		public static KIO.SimpleJob Rename(KUrl src, KUrl dest, uint flags) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("rename##$", "rename(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.SimpleJob Rename(KUrl src, KUrl dest) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("rename##", "rename(const KUrl&, const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Create or move a symlink.
		///  This is the lowlevel operation, similar to file_copy and file_move.
		///  It doesn't do any check (other than those the slave does)
		///  and it doesn't show rename and skip dialogs - use KIO.Link for that.
		/// <param> name="target" The string that will become the "target" of the link (can be relative)
		/// </param><param> name="dest" The symlink to create.
		/// </param><param> name="flags" Can be Overwrite and HideProgressInfo
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Create or move a symlink.</short>
		public static KIO.SimpleJob Symlink(string target, KUrl dest, uint flags) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("symlink$#$", "symlink(const QString&, const KUrl&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(string), target, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.SimpleJob Symlink(string target, KUrl dest) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("symlink$#", "symlink(const QString&, const KUrl&)", typeof(KIO.SimpleJob), typeof(string), target, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Execute any command that is specific to one slave (protocol).
		///  Examples are : HTTP POST, mount and unmount (kio_file)
		/// <param> name="url" The URL isn't passed to the slave, but is used to know
		///         which slave to send it to :-)
		/// </param><param> name="data" Packed data.  The meaning is completely dependent on the
		///         slave, but usually starts with an int for the command number.
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Execute any command that is specific to one slave (protocol).</short>
		public static KIO.SimpleJob Special(KUrl url, QByteArray data, uint flags) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("special##$", "special(const KUrl&, const QByteArray&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(QByteArray), data, typeof(uint), flags);
		}
		public static KIO.SimpleJob Special(KUrl url, QByteArray data) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("special##", "special(const KUrl&, const QByteArray&)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(QByteArray), data);
		}
		/// <remarks>
		///  Mount filesystem.
		///  Special job for <code>kio_file.</code>
		/// <param> name="ro" Mount read-only if <code>true.</code>
		/// </param><param> name="fstype" File system type (e.g. "ext2", can be empty).
		/// </param><param> name="dev" Device (e.g. /dev/sda0).
		/// </param><param> name="point" Mount point, can be <code>null.</code>
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Mount filesystem.</short>
		public static KIO.SimpleJob Mount(bool ro, QByteArray fstype, string dev, string point, uint flags) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("mount$#$$$", "mount(bool, const QByteArray&, const QString&, const QString&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(bool), ro, typeof(QByteArray), fstype, typeof(string), dev, typeof(string), point, typeof(uint), flags);
		}
		public static KIO.SimpleJob Mount(bool ro, QByteArray fstype, string dev, string point) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("mount$#$$", "mount(bool, const QByteArray&, const QString&, const QString&)", typeof(KIO.SimpleJob), typeof(bool), ro, typeof(QByteArray), fstype, typeof(string), dev, typeof(string), point);
		}
		/// <remarks>
		///  Unmount filesystem.
		///  Special job for <code>kio_file.</code>
		/// <param> name="point" Point to unmount.
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Unmount filesystem.</short>
		public static KIO.SimpleJob Unmount(string point, uint flags) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("unmount$$", "unmount(const QString&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(string), point, typeof(uint), flags);
		}
		public static KIO.SimpleJob Unmount(string point) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("unmount$", "unmount(const QString&)", typeof(KIO.SimpleJob), typeof(string), point);
		}
		/// <remarks>
		///  HTTP cache update
		/// <param> name="url" Url to update, protocol must be "http".
		/// </param><param> name="no_cache" If true, cache entry for <code>url</code> is deleted.
		/// </param><param> name="expireDate" Local machine time indicating when the entry is
		///  supposed to expire.
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    HTTP cache update </short>
		public static KIO.SimpleJob Http_update_cache(KUrl url, bool no_cache, int expireDate) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("http_update_cache#$$", "http_update_cache(const KUrl&, bool, time_t)", typeof(KIO.SimpleJob), typeof(KUrl), url, typeof(bool), no_cache, typeof(int), expireDate);
		}
		/// <remarks>
		///  Find all details for one file or directory.
		/// <param> name="url" the URL of the file
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Find all details for one file or directory.</short>
		public static KIO.StatJob Stat(KUrl url, uint flags) {
			return (KIO.StatJob) staticInterceptor.Invoke("stat#$", "stat(const KUrl&, KIO::JobFlags)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(uint), flags);
		}
		public static KIO.StatJob Stat(KUrl url) {
			return (KIO.StatJob) staticInterceptor.Invoke("stat#", "stat(const KUrl&)", typeof(KIO.StatJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  Find all details for one file or directory.
		///  This version of the call includes two additional booleans, <code>sideIsSource</code> and <code>details.</code>
		/// <param> name="url" the URL of the file
		/// </param><param> name="side" is SourceSide when stating a source file (we will do a get on it if
		///  the stat works) and DestinationSide when stating a destination file (target of a copy).
		///  The reason for this parameter is that in some cases the kioslave might not
		///  be able to determine a file's existence (e.g. HTTP doesn't allow it, FTP
		///  has issues with case-sensitivity on some systems).
		///  When the slave can't reliably determine the existence of a file, it will:
		/// </param>
		/// <li>
		/// be optimistic if SourceSide, i.e. it will assume the file exists,
		///  and if it doesn't this will appear when actually trying to download it
		/// </li>
		/// 
		/// <li>
		/// be pessimistic if DestinationSide, i.e. it will assume the file
		///  doesn't exist, to prevent showing "about to overwrite" errors to the user.
		///  If you simply want to check for existence without downloading/uploading afterwards,
		///  then you should use DestinationSide.
		/// </li>
		/// <param> name="details" selects the level of details we want.
		///  By default this is 2 (all details wanted, including modification time, size, etc.),
		///  setDetails(1) is used when deleting: we don't need all the information if it takes
		///  too much time, no need to follow symlinks etc.
		///  setDetails(0) is used for very simple probing: we'll only get the answer
		///  "it's a file or a directory, or it doesn't exist". This is used by KRun.
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Find all details for one file or directory.</short>
		/// <remarks>
		///  Find all details for one file or directory.
		///  This version of the call includes two additional booleans, <code>sideIsSource</code> and <code>details.</code>
		/// <param> name="url" the URL of the file
		/// </param><param> name="sideIsSource" is true when stating a source file (we will do a get on it if
		///  the stat works) and false when stating a destination file (target of a copy).
		///  The reason for this parameter is that in some cases the kioslave might not
		///  be able to determine a file's existence (e.g. HTTP doesn't allow it, FTP
		///  has issues with case-sensitivity on some systems).
		///  When the slave can't reliably determine the existence of a file, it will:
		/// </param>
		/// <li>
		/// be optimistic if sideIsSource=true, i.e. it will assume the file exists,
		///  and if it doesn't this will appear when actually trying to download it
		/// </li>
		/// 
		/// <li>
		/// be pessimistic if sideIsSource=false, i.e. it will assume the file
		///  doesn't exist, to prevent showing "about to overwrite" errors to the user.
		///  If you simply want to check for existence without downloading/uploading afterwards,
		///  then you should use sideIsSource=false.
		/// </li>
		/// <param> name="details" selects the level of details we want.
		///  By default this is 2 (all details wanted, including modification time, size, etc.),
		///  setDetails(1) is used when deleting: we don't need all the information if it takes
		///  too much time, no need to follow symlinks etc.
		///  setDetails(0) is used for very simple probing: we'll only get the answer
		///  "it's a file or a directory, or it doesn't exist". This is used by KRun.
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Find all details for one file or directory.</short>
		public static KIO.StatJob Stat(KUrl url, bool sideIsSource, short details, uint flags) {
			return (KIO.StatJob) staticInterceptor.Invoke("stat#$$$", "stat(const KUrl&, bool, short int, KIO::JobFlags)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(bool), sideIsSource, typeof(short), details, typeof(uint), flags);
		}
		public static KIO.StatJob Stat(KUrl url, bool sideIsSource, short details) {
			return (KIO.StatJob) staticInterceptor.Invoke("stat#$$", "stat(const KUrl&, bool, short int)", typeof(KIO.StatJob), typeof(KUrl), url, typeof(bool), sideIsSource, typeof(short), details);
		}
		/// <remarks>
		///  Get (a.k.a. read).
		///  The slave emits the data through data().
		/// <param> name="url" the URL of the file
		/// </param><param> name="reload" : Reload to reload the file, NoReload if it can be taken from the cache
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Get (a.</short>
		public static KIO.TransferJob Get(KUrl url, KIO.LoadType reload, uint flags) {
			return (KIO.TransferJob) staticInterceptor.Invoke("get#$$", "get(const KUrl&, KIO::LoadType, KIO::JobFlags)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload, typeof(uint), flags);
		}
		public static KIO.TransferJob Get(KUrl url, KIO.LoadType reload) {
			return (KIO.TransferJob) staticInterceptor.Invoke("get#$", "get(const KUrl&, KIO::LoadType)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload);
		}
		public static KIO.TransferJob Get(KUrl url) {
			return (KIO.TransferJob) staticInterceptor.Invoke("get#", "get(const KUrl&)", typeof(KIO.TransferJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  Open ( random access I/O )
		///  The file-job emits open() when opened
		/// <param> name="url" the URL of the file
		/// </param><param> name="mode" the access privileges: see \ref OpenMode
		/// </param></remarks>		<return> The file-handling job. It will never return 0. Errors are handled asynchronously
		///  (emitted as signals).
		///      </return>
		/// 		<short>    Open ( random access I/O ) </short>
		public static KIO.FileJob Open(KUrl url, uint mode) {
			return (KIO.FileJob) staticInterceptor.Invoke("open#$", "open(const KUrl&, QIODevice::OpenMode)", typeof(KIO.FileJob), typeof(KUrl), url, typeof(uint), mode);
		}
		/// <remarks>
		///  Put (a.k.a. write)
		/// <param> name="url" Where to write data.
		/// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
		/// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
		///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
		/// </param></remarks>		<return> the job handling the operation.
		/// </return>
		/// 		<short>    Put (a.</short>
		/// 		<see> multi_get</see>
		public static KIO.TransferJob Put(KUrl url, int permissions, uint flags) {
			return (KIO.TransferJob) staticInterceptor.Invoke("put#$$", "put(const KUrl&, int, KIO::JobFlags)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(int), permissions, typeof(uint), flags);
		}
		public static KIO.TransferJob Put(KUrl url, int permissions) {
			return (KIO.TransferJob) staticInterceptor.Invoke("put#$", "put(const KUrl&, int)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(int), permissions);
		}
		/// <remarks>
		///  HTTP POST (for form data).
		///  Example:
		///  <pre>
		///     job = KIO.Http_post( url, postData, KIO.HideProgressInfo );
		///     job.AddMetaData("content-type", contentType );
		///     job.AddMetaData("referrer", referrerURL);
		///  </pre>
		///  <code>postData</code> is the data that you want to send and
		///  <code>contentType</code> is the complete HTTP header line that
		///  specifies the content's MIME type, for example
		///  "Content-Type: text/xml".
		///  You MUST specify content-type!
		///  Often <code>contentType</code> is
		///  "Content-Type: application/x-www-form-urlencoded" and
		///  the <code>postData</code> is then an ASCII string (without null-termination!)
		///  with characters like space, linefeed and percent escaped like %20,
		///  %0A and %25.
		/// <param> name="url" Where to write the data.
		/// </param><param> name="postData" Encoded data to post.
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    HTTP POST (for form data).</short>
		public static KIO.TransferJob Http_post(KUrl url, QByteArray postData, uint flags) {
			return (KIO.TransferJob) staticInterceptor.Invoke("http_post##$", "http_post(const KUrl&, const QByteArray&, KIO::JobFlags)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(QByteArray), postData, typeof(uint), flags);
		}
		public static KIO.TransferJob Http_post(KUrl url, QByteArray postData) {
			return (KIO.TransferJob) staticInterceptor.Invoke("http_post##", "http_post(const KUrl&, const QByteArray&)", typeof(KIO.TransferJob), typeof(KUrl), url, typeof(QByteArray), postData);
		}
		/// <remarks>
		///  Get (a.k.a. read), into a single QByteArray.
		/// <param> name="url" the URL of the file
		/// </param><param> name="reload" : Reload to reload the file, NoReload if it can be taken from the cache
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Get (a.</short>
		/// 		<see> StoredTransferJob</see>
		public static KIO.StoredTransferJob StoredGet(KUrl url, KIO.LoadType reload, uint flags) {
			return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedGet#$$", "storedGet(const KUrl&, KIO::LoadType, KIO::JobFlags)", typeof(KIO.StoredTransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload, typeof(uint), flags);
		}
		public static KIO.StoredTransferJob StoredGet(KUrl url, KIO.LoadType reload) {
			return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedGet#$", "storedGet(const KUrl&, KIO::LoadType)", typeof(KIO.StoredTransferJob), typeof(KUrl), url, typeof(KIO.LoadType), reload);
		}
		public static KIO.StoredTransferJob StoredGet(KUrl url) {
			return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedGet#", "storedGet(const KUrl&)", typeof(KIO.StoredTransferJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  Put (a.k.a. write) data from a single QByteArray.
		/// <param> name="arr" The data to write
		/// </param><param> name="url" Where to write data.
		/// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
		/// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
		///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Put (a.</short>
		/// 		<see> StoredTransferJob</see>
		public static KIO.StoredTransferJob StoredPut(QByteArray arr, KUrl url, int permissions, uint flags) {
			return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedPut##$$", "storedPut(const QByteArray&, const KUrl&, int, KIO::JobFlags)", typeof(KIO.StoredTransferJob), typeof(QByteArray), arr, typeof(KUrl), url, typeof(int), permissions, typeof(uint), flags);
		}
		public static KIO.StoredTransferJob StoredPut(QByteArray arr, KUrl url, int permissions) {
			return (KIO.StoredTransferJob) staticInterceptor.Invoke("storedPut##$", "storedPut(const QByteArray&, const KUrl&, int)", typeof(KIO.StoredTransferJob), typeof(QByteArray), arr, typeof(KUrl), url, typeof(int), permissions);
		}
		/// <remarks>
		///  Creates a new multiple get job.
		/// <param> name="id" the id of the get operation
		/// </param><param> name="url" the URL of the file
		/// </param><param> name="metaData" the MetaData associated with the file
		/// </param></remarks>		<return> the job handling the operation.
		/// </return>
		/// 		<short>    Creates a new multiple get job.</short>
		/// 		<see> get</see>
		public static KIO.MultiGetJob Multi_get(long id, KUrl url, KIO.MetaData metaData) {
			return (KIO.MultiGetJob) staticInterceptor.Invoke("multi_get$##", "multi_get(long, const KUrl&, const KIO::MetaData&)", typeof(KIO.MultiGetJob), typeof(long), id, typeof(KUrl), url, typeof(KIO.MetaData), metaData);
		}
		/// <remarks>
		///  Find mimetype for one file or directory.
		/// <param> name="url" the URL of the file
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Find mimetype for one file or directory.</short>
		public static KIO.MimetypeJob Mimetype(KUrl url, uint flags) {
			return (KIO.MimetypeJob) staticInterceptor.Invoke("mimetype#$", "mimetype(const KUrl&, KIO::JobFlags)", typeof(KIO.MimetypeJob), typeof(KUrl), url, typeof(uint), flags);
		}
		public static KIO.MimetypeJob Mimetype(KUrl url) {
			return (KIO.MimetypeJob) staticInterceptor.Invoke("mimetype#", "mimetype(const KUrl&)", typeof(KIO.MimetypeJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  Copy a single file.
		///  Uses either SlaveBase.Copy() if the slave supports that
		///  or get() and put() otherwise.
		/// <param> name="src" Where to get the file.
		/// </param><param> name="dest" Where to put the file.
		/// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
		/// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
		///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Copy a single file.</short>
		public static KIO.FileCopyJob File_copy(KUrl src, KUrl dest, int permissions, uint flags) {
			return (KIO.FileCopyJob) staticInterceptor.Invoke("file_copy##$$", "file_copy(const KUrl&, const KUrl&, int, KIO::JobFlags)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions, typeof(uint), flags);
		}
		public static KIO.FileCopyJob File_copy(KUrl src, KUrl dest, int permissions) {
			return (KIO.FileCopyJob) staticInterceptor.Invoke("file_copy##$", "file_copy(const KUrl&, const KUrl&, int)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions);
		}
		public static KIO.FileCopyJob File_copy(KUrl src, KUrl dest) {
			return (KIO.FileCopyJob) staticInterceptor.Invoke("file_copy##", "file_copy(const KUrl&, const KUrl&)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Move a single file.
		///  Use either SlaveBase.Rename() if the slave supports that,
		///  or copy() and del() otherwise, or eventually get() & put() & del()
		/// <param> name="src" Where to get the file.
		/// </param><param> name="dest" Where to put the file.
		/// </param><param> name="permissions" May be -1. In this case no special permission mode is set.
		/// </param><param> name="flags" Can be HideProgressInfo, Overwrite and Resume here. WARNING:
		///  Setting Resume means that the data will be appended to <code>dest</code> if <code>dest</code> exists.
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Move a single file.</short>
		public static KIO.FileCopyJob File_move(KUrl src, KUrl dest, int permissions, uint flags) {
			return (KIO.FileCopyJob) staticInterceptor.Invoke("file_move##$$", "file_move(const KUrl&, const KUrl&, int, KIO::JobFlags)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions, typeof(uint), flags);
		}
		public static KIO.FileCopyJob File_move(KUrl src, KUrl dest, int permissions) {
			return (KIO.FileCopyJob) staticInterceptor.Invoke("file_move##$", "file_move(const KUrl&, const KUrl&, int)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions);
		}
		public static KIO.FileCopyJob File_move(KUrl src, KUrl dest) {
			return (KIO.FileCopyJob) staticInterceptor.Invoke("file_move##", "file_move(const KUrl&, const KUrl&)", typeof(KIO.FileCopyJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Delete a single file.
		/// <param> name="src" File to delete.
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    Delete a single file.</short>
		public static KIO.SimpleJob File_delete(KUrl src, uint flags) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("file_delete#$", "file_delete(const KUrl&, KIO::JobFlags)", typeof(KIO.SimpleJob), typeof(KUrl), src, typeof(uint), flags);
		}
		public static KIO.SimpleJob File_delete(KUrl src) {
			return (KIO.SimpleJob) staticInterceptor.Invoke("file_delete#", "file_delete(const KUrl&)", typeof(KIO.SimpleJob), typeof(KUrl), src);
		}
		/// <remarks>
		///  List the contents of <code>url</code>, which is assumed to be a directory.
		///  "." and ".." are returned, filter them out if you don't want them.
		/// <param> name="url" the url of the directory
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param><param> name="includeHidden" true for all files, false to cull out UNIX hidden
		///                       files/dirs (whose names start with dot)
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    List the contents of <code>url</code>, which is assumed to be a directory.</short>
		public static KIO.ListJob ListDir(KUrl url, uint flags, bool includeHidden) {
			return (KIO.ListJob) staticInterceptor.Invoke("listDir#$$", "listDir(const KUrl&, KIO::JobFlags, bool)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags, typeof(bool), includeHidden);
		}
		public static KIO.ListJob ListDir(KUrl url, uint flags) {
			return (KIO.ListJob) staticInterceptor.Invoke("listDir#$", "listDir(const KUrl&, KIO::JobFlags)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags);
		}
		public static KIO.ListJob ListDir(KUrl url) {
			return (KIO.ListJob) staticInterceptor.Invoke("listDir#", "listDir(const KUrl&)", typeof(KIO.ListJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  The same as the previous method, but recurses subdirectories.
		///  Directory links are not followed.
		///  "." and ".." are returned but only for the toplevel directory.
		///  Filter them out if you don't want them.
		/// <param> name="url" the url of the directory
		/// </param><param> name="flags" Can be HideProgressInfo here
		/// </param><param> name="includeHidden" true for all files, false to cull out UNIX hidden
		///                       files/dirs (whose names start with dot)
		/// </param></remarks>		<return> the job handling the operation.
		///      </return>
		/// 		<short>    The same as the previous method, but recurses subdirectories.</short>
		public static KIO.ListJob ListRecursive(KUrl url, uint flags, bool includeHidden) {
			return (KIO.ListJob) staticInterceptor.Invoke("listRecursive#$$", "listRecursive(const KUrl&, KIO::JobFlags, bool)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags, typeof(bool), includeHidden);
		}
		public static KIO.ListJob ListRecursive(KUrl url, uint flags) {
			return (KIO.ListJob) staticInterceptor.Invoke("listRecursive#$", "listRecursive(const KUrl&, KIO::JobFlags)", typeof(KIO.ListJob), typeof(KUrl), url, typeof(uint), flags);
		}
		public static KIO.ListJob ListRecursive(KUrl url) {
			return (KIO.ListJob) staticInterceptor.Invoke("listRecursive#", "listRecursive(const KUrl&)", typeof(KIO.ListJob), typeof(KUrl), url);
		}
		/// <remarks>
		///  Copy a file or directory <code>src</code> into the destination <code>dest</code>,
		///  which can be a file (including the final filename) or a directory
		///  (into which <code>src</code> will be copied).
		///  This emulates the cp command completely.
		/// <param> name="src" the file or directory to copy
		/// </param><param> name="dest" the destination
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		/// </return>
		/// 		<short>    Copy a file or directory <code>src</code> into the destination <code>dest</code>,  which can be a file (including the final filename) or a directory  (into which <code>src</code> will be copied).</short>
		/// 		<see> copyAs</see>
		public static KIO.CopyJob Copy(KUrl src, KUrl dest, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("copy##$", "copy(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.CopyJob Copy(KUrl src, KUrl dest) {
			return (KIO.CopyJob) staticInterceptor.Invoke("copy##", "copy(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Copy a file or directory <code>src</code> into the destination <code>dest</code>,
		///  which is the destination name in any case, even for a directory.
		///  As opposed to copy(), this doesn't emulate cp, but is the only
		///  way to copy a directory, giving it a new name and getting an error
		///  box if a directory already exists with the same name.
		/// <param> name="src" the file or directory to copy
		/// </param><param> name="dest" the destination
		/// </param><param> name="flags" : We support HideProgressInfo here 
		/// </param></remarks>		<return> the job handling the operation
		///      </return>
		/// 		<short>    Copy a file or directory <code>src</code> into the destination <code>dest</code>,  which is the destination name in any case, even for a directory.</short>
		public static KIO.CopyJob CopyAs(KUrl src, KUrl dest, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("copyAs##$", "copyAs(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.CopyJob CopyAs(KUrl src, KUrl dest) {
			return (KIO.CopyJob) staticInterceptor.Invoke("copyAs##", "copyAs(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code>
		/// <param> name="src" the list of files and/or directories
		/// </param><param> name="dest" the destination
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		///      </return>
		/// 		<short>    Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code></short>
		public static KIO.CopyJob Copy(List<KUrl> src, KUrl dest, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("copy?#$", "copy(const KUrl::List&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.CopyJob Copy(List<KUrl> src, KUrl dest) {
			return (KIO.CopyJob) staticInterceptor.Invoke("copy?#", "copy(const KUrl::List&, const KUrl&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Moves a file or directory <code>src</code> to the given destination <code>dest.</code>
		/// <param> name="src" the file or directory to copy
		/// </param><param> name="dest" the destination
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		/// </return>
		/// 		<short>    Moves a file or directory <code>src</code> to the given destination <code>dest.</code></short>
		/// 		<see> copy</see>
		/// 		<see> moveAs</see>
		public static KIO.CopyJob Move(KUrl src, KUrl dest, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("move##$", "move(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.CopyJob Move(KUrl src, KUrl dest) {
			return (KIO.CopyJob) staticInterceptor.Invoke("move##", "move(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Moves a file or directory <code>src</code> to the given destination <code>dest.</code> Unlike move()
		///  this operation will fail when the directory already exists.
		/// <param> name="src" the file or directory to copy
		/// </param><param> name="dest" the destination
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		/// </return>
		/// 		<short>    Moves a file or directory <code>src</code> to the given destination <code>dest.</code></short>
		/// 		<see> copyAs</see>
		public static KIO.CopyJob MoveAs(KUrl src, KUrl dest, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("moveAs##$", "moveAs(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.CopyJob MoveAs(KUrl src, KUrl dest) {
			return (KIO.CopyJob) staticInterceptor.Invoke("moveAs##", "moveAs(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Moves a list of files or directories <code>src</code> to the given destination <code>dest.</code>
		/// <param> name="src" the list of files or directories to copy
		/// </param><param> name="dest" the destination
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		/// </return>
		/// 		<short>    Moves a list of files or directories <code>src</code> to the given destination <code>dest.</code></short>
		/// 		<see> copy</see>
		public static KIO.CopyJob Move(List<KUrl> src, KUrl dest, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("move?#$", "move(const KUrl::List&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.CopyJob Move(List<KUrl> src, KUrl dest) {
			return (KIO.CopyJob) staticInterceptor.Invoke("move?#", "move(const KUrl::List&, const KUrl&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Create a link.
		///  If the protocols and hosts are the same, a Unix symlink will be created.
		///  Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
		/// <param> name="src" The existing file or directory, 'target' of the link.
		/// </param><param> name="destDir" Destination directory where the link will be created.
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		///      </return>
		/// 		<short>    Create a link.</short>
		public static KIO.CopyJob Link(KUrl src, KUrl destDir, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("link##$", "link(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), destDir, typeof(uint), flags);
		}
		public static KIO.CopyJob Link(KUrl src, KUrl destDir) {
			return (KIO.CopyJob) staticInterceptor.Invoke("link##", "link(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), destDir);
		}
		/// <remarks>
		///  Create several links
		///  If the protocols and hosts are the same, a Unix symlink will be created.
		///  Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
		/// <param> name="src" The existing files or directories, 'targets' of the link.
		/// </param><param> name="destDir" Destination directory where the links will be created.
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		/// </return>
		/// 		<short>    Create several links  If the protocols and hosts are the same, a Unix symlink will be created.</short>
		/// 		<see> link</see>
		public static KIO.CopyJob Link(List<KUrl> src, KUrl destDir, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("link?#$", "link(const KUrl::List&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), destDir, typeof(uint), flags);
		}
		public static KIO.CopyJob Link(List<KUrl> src, KUrl destDir) {
			return (KIO.CopyJob) staticInterceptor.Invoke("link?#", "link(const KUrl::List&, const KUrl&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(KUrl), destDir);
		}
		/// <remarks>
		///  Create a link. Unlike link() this operation will fail when the directory already
		///  exists.
		///  If the protocols and hosts are the same, a Unix symlink will be created.
		///  Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
		/// <param> name="src" The existing file or directory, 'target' of the link.
		/// </param><param> name="dest" Destination directory where the link will be created.
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		/// </return>
		/// 		<short>    Create a link.</short>
		/// 		<see> link</see>
		/// 		<see> copyAs</see>
		public static KIO.CopyJob LinkAs(KUrl src, KUrl dest, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("linkAs##$", "linkAs(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
		}
		public static KIO.CopyJob LinkAs(KUrl src, KUrl dest) {
			return (KIO.CopyJob) staticInterceptor.Invoke("linkAs##", "linkAs(const KUrl&, const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(KUrl), dest);
		}
		/// <remarks>
		///  Trash a file or directory.
		///  This is currently only supported for local files and directories.
		///  Use "KUrl src; src.setPath( path );" to create a URL from a path.
		/// <param> name="src" file to delete
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		///      </return>
		/// 		<short>    Trash a file or directory.</short>
		public static KIO.CopyJob Trash(KUrl src, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("trash#$", "trash(const KUrl&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(KUrl), src, typeof(uint), flags);
		}
		public static KIO.CopyJob Trash(KUrl src) {
			return (KIO.CopyJob) staticInterceptor.Invoke("trash#", "trash(const KUrl&)", typeof(KIO.CopyJob), typeof(KUrl), src);
		}
		/// <remarks>
		///  Trash a list of files or directories.
		///  This is currently only supported for local files and directories.
		/// <param> name="src" the files to delete
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		///      </return>
		/// 		<short>    Trash a list of files or directories.</short>
		public static KIO.CopyJob Trash(List<KUrl> src, uint flags) {
			return (KIO.CopyJob) staticInterceptor.Invoke("trash?$", "trash(const KUrl::List&, KIO::JobFlags)", typeof(KIO.CopyJob), typeof(List<KUrl>), src, typeof(uint), flags);
		}
		public static KIO.CopyJob Trash(List<KUrl> src) {
			return (KIO.CopyJob) staticInterceptor.Invoke("trash?", "trash(const KUrl::List&)", typeof(KIO.CopyJob), typeof(List<KUrl>), src);
		}
		/// <remarks>
		///  Delete a file or directory.
		/// <param> name="src" file to delete
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		///      </return>
		/// 		<short>    Delete a file or directory.</short>
		public static KIO.DeleteJob Del(KUrl src, uint flags) {
			return (KIO.DeleteJob) staticInterceptor.Invoke("del#$", "del(const KUrl&, KIO::JobFlags)", typeof(KIO.DeleteJob), typeof(KUrl), src, typeof(uint), flags);
		}
		public static KIO.DeleteJob Del(KUrl src) {
			return (KIO.DeleteJob) staticInterceptor.Invoke("del#", "del(const KUrl&)", typeof(KIO.DeleteJob), typeof(KUrl), src);
		}
		/// <remarks>
		///  Deletes a list of files or directories.
		/// <param> name="src" the files to delete
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the job handling the operation
		///      </return>
		/// 		<short>    Deletes a list of files or directories.</short>
		public static KIO.DeleteJob Del(List<KUrl> src, uint flags) {
			return (KIO.DeleteJob) staticInterceptor.Invoke("del?$", "del(const KUrl::List&, KIO::JobFlags)", typeof(KIO.DeleteJob), typeof(List<KUrl>), src, typeof(uint), flags);
		}
		public static KIO.DeleteJob Del(List<KUrl> src) {
			return (KIO.DeleteJob) staticInterceptor.Invoke("del?", "del(const KUrl::List&)", typeof(KIO.DeleteJob), typeof(List<KUrl>), src);
		}
		/// <remarks>
		///  Save the given mimesource <code>data</code> to the given destination URL
		///  after offering the user to choose a data format.
		///  This is the method used when handling drops (of anything else than URLs)
		///  onto kdesktop and konqueror.
		/// <param> name="data" the QMimeData (from a QDropEvent or from the clipboard when pasting)
		/// </param><param> name="destURL" the URL of the directory where the data will be pasted.
		///  The filename to use in that directory is prompted by this method.
		/// </param><param> name="dialogText" the text to show in the dialog
		/// </param><param> name="widget" parent widget to use for dialogs
		/// </param><param> name="clipboard" whether the QMimeSource comes from QClipboard. If you
		///  use pasteClipboard for that case, you never have to worry about this parameter.
		/// </param></remarks>		<short>    Save the given mimesource <code>data</code> to the given destination URL  after offering the user to choose a data format.</short>
		/// 		<see> pasteClipboard</see>
		public static KIO.CopyJob PasteMimeSource(QMimeData data, KUrl destURL, string dialogText, QWidget widget, bool clipboard) {
			return (KIO.CopyJob) staticInterceptor.Invoke("pasteMimeSource##$#$", "pasteMimeSource(const QMimeData*, const KUrl&, const QString&, QWidget*, bool)", typeof(KIO.CopyJob), typeof(QMimeData), data, typeof(KUrl), destURL, typeof(string), dialogText, typeof(QWidget), widget, typeof(bool), clipboard);
		}
		public static KIO.CopyJob PasteMimeSource(QMimeData data, KUrl destURL, string dialogText, QWidget widget) {
			return (KIO.CopyJob) staticInterceptor.Invoke("pasteMimeSource##$#", "pasteMimeSource(const QMimeData*, const KUrl&, const QString&, QWidget*)", typeof(KIO.CopyJob), typeof(QMimeData), data, typeof(KUrl), destURL, typeof(string), dialogText, typeof(QWidget), widget);
		}
		/// <remarks>
		///  Returns the text to use for the Paste action, when the application supports
		///  pasting files, urls, and clipboard data, using pasteClipboard().
		/// </remarks>		<return> a string suitable for KAction.SetText, or an empty string if pasting
		///  isn't possible right now.
		///    </return>
		/// 		<short>    Returns the text to use for the Paste action, when the application supports  pasting files, urls, and clipboard data, using pasteClipboard().</short>
		public static string PasteActionText() {
			return (string) staticInterceptor.Invoke("pasteActionText", "pasteActionText()", typeof(string));
		}
		public static QDataStream Write(QDataStream s, KIO.AuthInfo a) {
			return (QDataStream) staticInterceptor.Invoke("operator<<##", "operator<<(QDataStream&, const KIO::AuthInfo&)", typeof(QDataStream), typeof(QDataStream), s, typeof(KIO.AuthInfo), a);
		}
		public static QDataStream Read(QDataStream s, KIO.AuthInfo a) {
			return (QDataStream) staticInterceptor.Invoke("operator>>##", "operator>>(QDataStream&, KIO::AuthInfo&)", typeof(QDataStream), typeof(QDataStream), s, typeof(KIO.AuthInfo), a);
		}
		/// <remarks>
		///  Creates a PreviewJob to generate or retrieve a preview image
		///  for the given URL.
		/// <param> name="items" files to get previews for
		/// </param><param> name="width" the maximum width to use
		/// </param><param> name="height" the maximum height to use, if this is 0, the same
		///  value as width is used.
		/// </param><param> name="iconSize" the size of the mimetype icon to overlay over the
		///  preview or zero to not overlay an icon. This has no effect if the
		///  preview plugin that will be used doesn't use icon overlays.
		/// </param><param> name="iconAlpha" transparency to use for the icon overlay
		/// </param><param> name="scale" if the image is to be scaled to the requested size or
		///  returned in its original size
		/// </param><param> name="save" if the image should be cached for later use
		/// </param><param> name="enabledPlugins" if non-zero, this points to a list containing
		///  the names of the plugins that may be used.
		/// </param></remarks>		<return> the new PreviewJob
		/// </return>
		/// 		<short>    Creates a PreviewJob to generate or retrieve a preview image  for the given URL.</short>
		/// 		<see> PreviewJob.AvailablePlugins</see>
		public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save, List<string> enabledPlugins) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$$$?", "filePreview(const KFileItemList&, int, int, int, int, bool, bool, const QStringList*)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save, typeof(List<string>), enabledPlugins);
		}
		public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$$$", "filePreview(const KFileItemList&, int, int, int, int, bool, bool)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save);
		}
		public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha, bool scale) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$$", "filePreview(const KFileItemList&, int, int, int, int, bool)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale);
		}
		public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize, int iconAlpha) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$$", "filePreview(const KFileItemList&, int, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha);
		}
		public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height, int iconSize) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$$", "filePreview(const KFileItemList&, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize);
		}
		public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width, int height) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$$", "filePreview(const KFileItemList&, int, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width, typeof(int), height);
		}
		public static KIO.PreviewJob FilePreview(List<KFileItem> items, int width) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview#$", "filePreview(const KFileItemList&, int)", typeof(KIO.PreviewJob), typeof(List<KFileItem>), items, typeof(int), width);
		}
		/// <remarks>
		///  Creates a PreviewJob to generate or retrieve a preview image
		///  for the given URL.
		/// <param> name="items" files to get previews for
		/// </param><param> name="width" the maximum width to use
		/// </param><param> name="height" the maximum height to use, if this is 0, the same
		///  value as width is used.
		/// </param><param> name="iconSize" the size of the mimetype icon to overlay over the
		///  preview or zero to not overlay an icon. This has no effect if the
		///  preview plugin that will be used doesn't use icon overlays.
		/// </param><param> name="iconAlpha" transparency to use for the icon overlay
		/// </param><param> name="scale" if the image is to be scaled to the requested size or
		///  returned in its original size
		/// </param><param> name="save" if the image should be cached for later use
		/// </param><param> name="enabledPlugins" if non-zero, this points to a list containing
		///  the names of the plugins that may be used.
		/// </param></remarks>		<return> the new PreviewJob
		/// </return>
		/// 		<short>    Creates a PreviewJob to generate or retrieve a preview image  for the given URL.</short>
		/// 		<see> PreviewJob.AvailablePlugins</see>
		public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save, List<string> enabledPlugins) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$$$?", "filePreview(const KUrl::List&, int, int, int, int, bool, bool, const QStringList*)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save, typeof(List<string>), enabledPlugins);
		}
		public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha, bool scale, bool save) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$$$", "filePreview(const KUrl::List&, int, int, int, int, bool, bool)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale, typeof(bool), save);
		}
		public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha, bool scale) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$$", "filePreview(const KUrl::List&, int, int, int, int, bool)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha, typeof(bool), scale);
		}
		public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize, int iconAlpha) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$$", "filePreview(const KUrl::List&, int, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize, typeof(int), iconAlpha);
		}
		public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height, int iconSize) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$$", "filePreview(const KUrl::List&, int, int, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height, typeof(int), iconSize);
		}
		public static KIO.PreviewJob FilePreview(List<KUrl> items, int width, int height) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$$", "filePreview(const KUrl::List&, int, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width, typeof(int), height);
		}
		public static KIO.PreviewJob FilePreview(List<KUrl> items, int width) {
			return (KIO.PreviewJob) staticInterceptor.Invoke("filePreview?$", "filePreview(const KUrl::List&, int)", typeof(KIO.PreviewJob), typeof(List<KUrl>), items, typeof(int), width);
		}
		/// <remarks>
		///  Retrieves meta information for the given items.
		/// <param> name="items" files to get metainfo for
		/// </param></remarks>		<return> the MetaInfoJob to retrieve the items
		///      </return>
		/// 		<short>    Retrieves meta information for the given items.</short>
		public static KIO.MetaInfoJob FileMetaInfo(List<KFileItem> items) {
			return (KIO.MetaInfoJob) staticInterceptor.Invoke("fileMetaInfo#", "fileMetaInfo(const KFileItemList&)", typeof(KIO.MetaInfoJob), typeof(List<KFileItem>), items);
		}
		/// <remarks>
		///  Retrieves meta information for the given items.
		/// <param> name="items" files to get metainfo for
		/// </param></remarks>		<return> the MetaInfoJob to retrieve the items
		///      </return>
		/// 		<short>    Retrieves meta information for the given items.</short>
		public static KIO.MetaInfoJob FileMetaInfo(List<KUrl> items) {
			return (KIO.MetaInfoJob) staticInterceptor.Invoke("fileMetaInfo?", "fileMetaInfo(const KUrl::List&)", typeof(KIO.MetaInfoJob), typeof(List<KUrl>), items);
		}
		/// <remarks>
		///  Creates a new DavJob that issues a PROPFIND command. PROPFIND retrieves
		///  the properties of the resource identified by the given <code>url.</code>
		/// <param> name="url" the URL of the resource
		/// </param><param> name="properties" a propfind document that describes the properties that
		///         should be retrieved
		/// </param><param> name="depth" the depth of the request. Can be "0", "1" or "infinity"
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the new DavJob
		///     </return>
		/// 		<short>    Creates a new DavJob that issues a PROPFIND command.</short>
		public static KIO.DavJob DavPropFind(KUrl url, QDomDocument properties, string depth, uint flags) {
			return (KIO.DavJob) staticInterceptor.Invoke("davPropFind##$$", "davPropFind(const KUrl&, const QDomDocument&, const QString&, KIO::JobFlags)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties, typeof(string), depth, typeof(uint), flags);
		}
		public static KIO.DavJob DavPropFind(KUrl url, QDomDocument properties, string depth) {
			return (KIO.DavJob) staticInterceptor.Invoke("davPropFind##$", "davPropFind(const KUrl&, const QDomDocument&, const QString&)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties, typeof(string), depth);
		}
		/// <remarks>
		///  Creates a new DavJob that issues a PROPPATCH command. PROPPATCH sets
		///  the properties of the resource identified by the given <code>url.</code>
		/// <param> name="url" the URL of the resource
		/// </param><param> name="properties" a PROPPACTCH document that describes the properties that
		///         should be modified and its new values
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the new DavJob
		///     </return>
		/// 		<short>    Creates a new DavJob that issues a PROPPATCH command.</short>
		public static KIO.DavJob DavPropPatch(KUrl url, QDomDocument properties, uint flags) {
			return (KIO.DavJob) staticInterceptor.Invoke("davPropPatch##$", "davPropPatch(const KUrl&, const QDomDocument&, KIO::JobFlags)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties, typeof(uint), flags);
		}
		public static KIO.DavJob DavPropPatch(KUrl url, QDomDocument properties) {
			return (KIO.DavJob) staticInterceptor.Invoke("davPropPatch##", "davPropPatch(const KUrl&, const QDomDocument&)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(QDomDocument), properties);
		}
		/// <remarks>
		///  Creates a new DavJob that issues a SEARCH command.
		/// <param> name="url" the URL of the resource
		/// </param><param> name="nsURI" the URI of the search method's qualified name
		/// </param><param> name="qName" the local part of the search method's qualified name
		/// </param><param> name="query" the search string
		/// </param><param> name="flags" : We support HideProgressInfo here
		/// </param></remarks>		<return> the new DavJob
		///     </return>
		/// 		<short>    Creates a new DavJob that issues a SEARCH command.</short>
		public static KIO.DavJob DavSearch(KUrl url, string nsURI, string qName, string query, uint flags) {
			return (KIO.DavJob) staticInterceptor.Invoke("davSearch#$$$$", "davSearch(const KUrl&, const QString&, const QString&, const QString&, KIO::JobFlags)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(string), nsURI, typeof(string), qName, typeof(string), query, typeof(uint), flags);
		}
		public static KIO.DavJob DavSearch(KUrl url, string nsURI, string qName, string query) {
			return (KIO.DavJob) staticInterceptor.Invoke("davSearch#$$$", "davSearch(const KUrl&, const QString&, const QString&, const QString&)", typeof(KIO.DavJob), typeof(KUrl), url, typeof(string), nsURI, typeof(string), qName, typeof(string), query);
		}
	}
}
