//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Text;
	using System.Collections.Generic;

	/// <remarks>
	///  This class does completion of URLs including user directories (~user)
	///  and environment variables.  Remote URLs are passed to KIO.
	/// </remarks>		<author> David Smith <dsmith@algonet.se>
	///  </author>
	/// 		<short> Completion of a single URL.</short>

	[SmokeClass("KUrlCompletion")]
	public class KUrlCompletion : KCompletion, IDisposable {
 		protected KUrlCompletion(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KUrlCompletion), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KUrlCompletion() {
			staticInterceptor = new SmokeInvocation(typeof(KUrlCompletion), null);
		}
		/// <remarks>
		///  Determines how completion is done.
		/// 
		/// <li>
		/// ExeCompletion - executables in $PATH or with full path.
		/// </li>
		/// 
		/// <li>
		/// FileCompletion - all files with full path or in dir(), URLs
		///  are listed using KIO.
		/// </li>
		/// 
		/// <li>
		/// DirCompletion - Same as FileCompletion but only returns directories.
		/// 	 
		/// </li></remarks>		<short>    Determines how completion is done.</short>
		public enum Mode {
			ExeCompletion = 1,
			FileCompletion = 2,
			DirCompletion = 3,
		}
		/// <remarks>
		///  Constructs a KUrlCompletion object in FileCompletion mode.
		/// 	 </remarks>		<short>    Constructs a KUrlCompletion object in FileCompletion mode.</short>
		public KUrlCompletion() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KUrlCompletion", "KUrlCompletion()", typeof(void));
		}
		/// <remarks>
		///  This overloaded constructor allows you to set the Mode to ExeCompletion
		///  or FileCompletion without using setMode. Default is FileCompletion.
		/// 	 </remarks>		<short>    This overloaded constructor allows you to set the Mode to ExeCompletion  or FileCompletion without using setMode.</short>
		public KUrlCompletion(KUrlCompletion.Mode arg1) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KUrlCompletion$", "KUrlCompletion(KUrlCompletion::Mode)", typeof(void), typeof(KUrlCompletion.Mode), arg1);
		}
		/// <remarks>
		///  Finds completions to the given text.
		///  Remote URLs are listed with KIO. For performance reasons, local files
		///  are listed with KIO only if KURLCOMPLETION_LOCAL_KIO is set.
		///  The completion is done asyncronously if KIO is used.
		///  Returns the first match for user, environment, and local dir completion
		///  and string() for asynchronous completion (KIO or threaded).
		/// <param> name="text" the text to complete
		/// </param></remarks>		<return> the first match, or string() if not found
		/// 	 </return>
		/// 		<short>    Finds completions to the given text.</short>
		[SmokeMethod("makeCompletion(const QString&)")]
		public override string MakeCompletion(string text) {
			return (string) interceptor.Invoke("makeCompletion$", "makeCompletion(const QString&)", typeof(string), typeof(string), text);
		}
		/// <remarks>
		///  Sets the current directory (used as base for completion).
		///  Default = $HOME.
		/// <param> name="dir" the current directory, either as a path or URL
		/// 	 </param></remarks>		<short>    Sets the current directory (used as base for completion).</short>
		[SmokeMethod("setDir(const QString&)")]
		public virtual void SetDir(string dir) {
			interceptor.Invoke("setDir$", "setDir(const QString&)", typeof(void), typeof(string), dir);
		}
		/// <remarks>
		///  Returns the current directory, as it was given in setDir
		/// </remarks>		<return> the current directory (path or URL)
		/// 	 </return>
		/// 		<short>    Returns the current directory, as it was given in setDir </short>
		[SmokeMethod("dir() const")]
		public virtual string Dir() {
			return (string) interceptor.Invoke("dir", "dir() const", typeof(string));
		}
		/// <remarks>
		///  Check whether asynchronous completion is in progress.
		/// </remarks>		<return> true if asynchronous completion is in progress
		/// 	 </return>
		/// 		<short>    Check whether asynchronous completion is in progress.</short>
		[SmokeMethod("isRunning() const")]
		public virtual bool IsRunning() {
			return (bool) interceptor.Invoke("isRunning", "isRunning() const", typeof(bool));
		}
		/// <remarks>
		///  Stops asynchronous completion.
		/// 	 </remarks>		<short>    Stops asynchronous completion.</short>
		[SmokeMethod("stop()")]
		public virtual void Stop() {
			interceptor.Invoke("stop", "stop()", typeof(void));
		}
		/// <remarks>
		///  Returns the completion mode: exe or file completion (default FileCompletion).
		/// </remarks>		<return> the completion mode
		/// 	 </return>
		/// 		<short>    Returns the completion mode: exe or file completion (default FileCompletion).</short>
		[SmokeMethod("mode() const")]
		public virtual KUrlCompletion.Mode mode() {
			return (KUrlCompletion.Mode) interceptor.Invoke("mode", "mode() const", typeof(KUrlCompletion.Mode));
		}
		/// <remarks>
		///  Changes the completion mode: exe or file completion
		/// <param> name="mode" the new completion mode
		/// 	 </param></remarks>		<short>    Changes the completion mode: exe or file completion </short>
		[SmokeMethod("setMode(KUrlCompletion::Mode)")]
		public virtual void SetMode(KUrlCompletion.Mode mode) {
			interceptor.Invoke("setMode$", "setMode(KUrlCompletion::Mode)", typeof(void), typeof(KUrlCompletion.Mode), mode);
		}
		/// <remarks>
		///  Checks whether environment variables are completed and
		///  whether they are replaced internally while finding completions.
		///  Default is enabled.
		/// </remarks>		<return> true if environment vvariables will be replaced
		/// 	 </return>
		/// 		<short>    Checks whether environment variables are completed and  whether they are replaced internally while finding completions.</short>
		[SmokeMethod("replaceEnv() const")]
		public virtual bool ReplaceEnv() {
			return (bool) interceptor.Invoke("replaceEnv", "replaceEnv() const", typeof(bool));
		}
		/// <remarks>
		///  Enables/disables completion and replacement (internally) of
		///  environment variables in URLs. Default is enabled.
		/// <param> name="replace" true to replace environment variables
		/// 	 </param></remarks>		<short>    Enables/disables completion and replacement (internally) of  environment variables in URLs.</short>
		[SmokeMethod("setReplaceEnv(bool)")]
		public virtual void SetReplaceEnv(bool replace) {
			interceptor.Invoke("setReplaceEnv$", "setReplaceEnv(bool)", typeof(void), typeof(bool), replace);
		}
		/// <remarks>
		///  Returns whether ~username is completed and whether ~username
		///  is replaced internally with the user's home directory while
		///  finding completions. Default is enabled.
		/// </remarks>		<return> true to replace tilde with the home directory
		/// 	 </return>
		/// 		<short>    Returns whether ~username is completed and whether ~username  is replaced internally with the user's home directory while  finding completions.</short>
		[SmokeMethod("replaceHome() const")]
		public virtual bool ReplaceHome() {
			return (bool) interceptor.Invoke("replaceHome", "replaceHome() const", typeof(bool));
		}
		/// <remarks>
		///  Enables/disables completion of ~username and replacement
		///  (internally) of ~username with the user's home directory.
		///  Default is enabled.
		/// <param> name="replace" true to replace tilde with the home directory
		/// 	 </param></remarks>		<short>    Enables/disables completion of ~username and replacement  (internally) of ~username with the user's home directory.</short>
		[SmokeMethod("setReplaceHome(bool)")]
		public virtual void SetReplaceHome(bool replace) {
			interceptor.Invoke("setReplaceHome$", "setReplaceHome(bool)", typeof(void), typeof(bool), replace);
		}
		/// <remarks>
		///  Replaces username and/or environment variables, depending on the
		///  current settings and returns the filtered url. Only works with
		///  local files, i.e. returns back the original string for non-local
		///  urls.
		/// <param> name="text" the text to process
		/// </param></remarks>		<return> the path or URL resulting from this operation. If you
		///  want to convert it to a KUrl, use KUrl.FromPathOrUrl.
		/// 	 </return>
		/// 		<short>    Replaces username and/or environment variables, depending on the  current settings and returns the filtered url.</short>
		public string ReplacedPath(string text) {
			return (string) interceptor.Invoke("replacedPath$", "replacedPath(const QString&) const", typeof(string), typeof(string), text);
		}
		[SmokeMethod("postProcessMatch(QString*) const")]
		protected override void PostProcessMatch(StringBuilder match) {
			interceptor.Invoke("postProcessMatch$", "postProcessMatch(QString*) const", typeof(void), typeof(StringBuilder), match);
		}
		[SmokeMethod("postProcessMatches(QStringList*) const")]
		protected override void PostProcessMatches(List<string> matches) {
			interceptor.Invoke("postProcessMatches?", "postProcessMatches(QStringList*) const", typeof(void), typeof(List<string>), matches);
		}
		[SmokeMethod("customEvent(QEvent*)")]
		protected override void CustomEvent(QEvent e) {
			interceptor.Invoke("customEvent#", "customEvent(QEvent*)", typeof(void), typeof(QEvent), e);
		}
		~KUrlCompletion() {
			interceptor.Invoke("~KUrlCompletion", "~KUrlCompletion()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KUrlCompletion", "~KUrlCompletion()", typeof(void));
		}
		/// <remarks>
		/// 	</remarks>		<short>   </short>
		public static string ReplacedPath(string text, bool replaceHome, bool replaceEnv) {
			return (string) staticInterceptor.Invoke("replacedPath$$$", "replacedPath(const QString&, bool, bool)", typeof(string), typeof(string), text, typeof(bool), replaceHome, typeof(bool), replaceEnv);
		}
		public static string ReplacedPath(string text, bool replaceHome) {
			return (string) staticInterceptor.Invoke("replacedPath$$", "replacedPath(const QString&, bool)", typeof(string), typeof(string), text, typeof(bool), replaceHome);
		}
		protected new IKUrlCompletionSignals Emit {
			get { return (IKUrlCompletionSignals) Q_EMIT; }
		}
	}

	public interface IKUrlCompletionSignals : IKCompletionSignals {
	}
}
